package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.PaisDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Pais;

/**
 *  * PaisServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "paisService")
public  class PaisServiceImpl implements PaisService {

	private static final  Logger logger = LoggerFactory.getLogger(PaisServiceImpl.class);
	@Autowired
	private PaisDao paisDao;

	/**
	 * Inserts a single row in the Pais table.
	 *
	 * @param pais Pais
	 * @return Pais
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Pais add(Pais pais) {
		return this.paisDao.add(pais);
	}

	/**
	 * Updates a single row in the Pais table.
	 *
	 * @param pais Pais
	 * @return Pais
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Pais update(Pais pais) {
		return this.paisDao.update(pais);
	 }

	/**
	 * Finds a single row in the Pais table.
	 *
	 * @param pais Pais
	 * @return Pais
	 */
	public Pais find(Pais pais) {
		return (Pais) this.paisDao.find(pais);
	}

	/**
	 * Finds a List of rows in the Pais table.
	 *
	 * @param pais Pais
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Pais> findAll(Pais pais, Pagination pagination) {
		return (List<Pais>) this.paisDao.findAll(pais, pagination);
	}
    
	/**
	 * Counts rows in the Pais table.
	 *
	 * @param pais Pais
	 * @return Long
	 */
	public Long findAllCount(Pais pais) {        
		return  this.paisDao.findAllCount(pais);
	}

	/**
	 * Finds rows in the Pais table using like.
	 *
	 * @param pais Pais
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Pais> findAllLike(Pais pais, Pagination pagination, Boolean startsWith) {
		return (List<Pais>) this.paisDao.findAllLike(pais, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the Pais table.
	 *
	 * @param pais Pais
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Pais pais) {
		this.paisDao.remove(pais);
	}
	
	/**
	 * Deletes multiple rows in the Pais table.
	 *
	 * @param paisList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Pais> paisList) {
		for (Pais  paisAux:paisList) {
			this.paisDao.remove(paisAux);
		}
	}


	/**
	 * Getter method for PaisDao
	 *
	 * @return PaisDao
	 */
	public PaisDao getPaisDao() {
		return this.paisDao;
	}
    
	/**
	 * Setter method for PaisDao.
	 *
	 * @param  paisDao PaisDao
	 * @return
	 */
	public void setPaisDao(PaisDao paisDao) {
		logger.info("Setting Dependency "+paisDao);
		this.paisDao = paisDao;
	}
}

