package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.OriProdAlertaDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.OriProdAlerta;

/**
 *  * OriProdAlertaServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "oriProdAlertaService")
public  class OriProdAlertaServiceImpl implements OriProdAlertaService {

	private static final  Logger logger = LoggerFactory.getLogger(OriProdAlertaServiceImpl.class);
	@Autowired
	private OriProdAlertaDao oriProdAlertaDao;

	/**
	 * Inserts a single row in the OriProdAlerta table.
	 *
	 * @param oriProdAlerta OriProdAlerta
	 * @return OriProdAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OriProdAlerta add(OriProdAlerta oriProdAlerta) {
		return this.oriProdAlertaDao.add(oriProdAlerta);
	}

	/**
	 * Updates a single row in the OriProdAlerta table.
	 *
	 * @param oriProdAlerta OriProdAlerta
	 * @return OriProdAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OriProdAlerta update(OriProdAlerta oriProdAlerta) {
		return this.oriProdAlertaDao.update(oriProdAlerta);
	 }

	/**
	 * Finds a single row in the OriProdAlerta table.
	 *
	 * @param oriProdAlerta OriProdAlerta
	 * @return OriProdAlerta
	 */
	public OriProdAlerta find(OriProdAlerta oriProdAlerta) {
		return (OriProdAlerta) this.oriProdAlertaDao.find(oriProdAlerta);
	}

	/**
	 * Finds a List of rows in the OriProdAlerta table.
	 *
	 * @param oriProdAlerta OriProdAlerta
	 * @param pagination Pagination
	 * @return List
	 */
	public List<OriProdAlerta> findAll(OriProdAlerta oriProdAlerta, Pagination pagination) {
		return (List<OriProdAlerta>) this.oriProdAlertaDao.findAll(oriProdAlerta, pagination);
	}
    
	/**
	 * Counts rows in the OriProdAlerta table.
	 *
	 * @param oriProdAlerta OriProdAlerta
	 * @return Long
	 */
	public Long findAllCount(OriProdAlerta oriProdAlerta) {        
		return  this.oriProdAlertaDao.findAllCount(oriProdAlerta);
	}

	/**
	 * Finds rows in the OriProdAlerta table using like.
	 *
	 * @param oriProdAlerta OriProdAlerta
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<OriProdAlerta> findAllLike(OriProdAlerta oriProdAlerta, Pagination pagination, Boolean startsWith) {
		return (List<OriProdAlerta>) this.oriProdAlertaDao.findAllLike(oriProdAlerta, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the OriProdAlerta table.
	 *
	 * @param oriProdAlerta OriProdAlerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(OriProdAlerta oriProdAlerta) {
		this.oriProdAlertaDao.remove(oriProdAlerta);
	}
	
	/**
	 * Deletes multiple rows in the OriProdAlerta table.
	 *
	 * @param oriProdAlertaList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<OriProdAlerta> oriProdAlertaList) {
		for (OriProdAlerta  oriProdAlertaAux:oriProdAlertaList) {
			this.oriProdAlertaDao.remove(oriProdAlertaAux);
		}
	}


	/**
	 * Getter method for OriProdAlertaDao
	 *
	 * @return OriProdAlertaDao
	 */
	public OriProdAlertaDao getOriProdAlertaDao() {
		return this.oriProdAlertaDao;
	}
    
	/**
	 * Setter method for OriProdAlertaDao.
	 *
	 * @param  oriProdAlertaDao OriProdAlertaDao
	 * @return
	 */
	public void setOriProdAlertaDao(OriProdAlertaDao oriProdAlertaDao) {
		logger.info("Setting Dependency "+oriProdAlertaDao);
		this.oriProdAlertaDao = oriProdAlertaDao;
	}
}

