package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.OrganismoDao;
import com.ejie.y41a.model.Grupo;
import com.ejie.y41a.model.Organismo;

/**
 * * OrganismoServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

@Service(value = "organismoService")
public class OrganismoServiceImpl implements OrganismoService {

	private static final Logger logger = LoggerFactory
			.getLogger(OrganismoServiceImpl.class);
	@Autowired
	private OrganismoDao organismoDao;

	/**
	 * Inserts a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Organismo add(Organismo organismo) {
		return this.organismoDao.add(organismo);
	}

	/**
	 * Updates a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Organismo update(Organismo organismo) {
		return this.organismoDao.update(organismo);
	}

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo find(Organismo organismo) {
		return (Organismo) this.organismoDao.find(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoKnet(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoKnet(organismo);
	}

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismo(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismo(organismo);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Organismo> findAll(Organismo organismo, Pagination pagination) {
		return (List<Organismo>) this.organismoDao.findAll(organismo,
				pagination);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Long
	 */
	public Long findAllCount(Organismo organismo) {
		return this.organismoDao.findAllCount(organismo);
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLike(Organismo organismo,
			Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLike(organismo,
				pagination, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoKnet(Organismo organismo,
			Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismoKnet(
				organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoKnetCount(Organismo organismo,
			Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoKnetCount(organismo,
				startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismo(Organismo organismo,
			String codOrgConectado, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismo(
				organismo, codOrgConectado, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoCount(Organismo organismo,
			String codOrgConectado, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoCount(organismo,
				codOrgConectado, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return List
	 */
	public List<Grupo> obtenerGruposOrganismo(Organismo organismo) {
		return (List<Grupo>) this.organismoDao
				.obtenerGruposOrganismo(organismo);
	}

	/**
	 * Deletes a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Organismo organismo) {
		this.organismoDao.remove(organismo);
	}

	/**
	 * Deletes multiple rows in the Organismo table.
	 * 
	 * @param organismoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Organismo> organismoList) {
		for (Organismo organismoAux : organismoList) {
			this.organismoDao.remove(organismoAux);
		}
	}

	/**
	 * Getter method for OrganismoDao
	 * 
	 * @return OrganismoDao
	 */
	public OrganismoDao getOrganismoDao() {
		return this.organismoDao;
	}

	/**
	 * Setter method for OrganismoDao.
	 * 
	 * @param organismoDao
	 *            OrganismoDao
	 * @return
	 */
	public void setOrganismoDao(OrganismoDao organismoDao) {
		logger.info("Setting Dependency " + organismoDao);
		this.organismoDao = organismoDao;
	}

	/**
	 * Busca los organismos que estén tanto en la tabla de Organismos como en la
	 * vista de Organismos Solicitudes
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param pagination
	 *            Pagination paginación
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return List<Organismo> lista de organismos que cumplen el filtro
	 */
	public List<Organismo> findAllLikeOrganismoSolicitudes(Organismo organismo,
			String codOrgConectado, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllOrganismoSolicitudes(
				organismo, codOrgConectado, pagination, startsWith);
	}

	/**
	 * Cuenta los organismos que estén tanto en la tabla de Organismos como en
	 * la vista de Organismos Crear Solicitudes
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return Long número de resultados
	 */
	public Long findAllLikeOrganismoSolicitudesCount(Organismo organismo,
			String codOrgConectado, Boolean startsWith) {
		return this.organismoDao.findAllOrganismoSolicitudesCount(organismo,
				codOrgConectado, startsWith);
	}

	/**
	 * Busca los organismos que estén tanto en la tabla de Organismos como en la
	 * vista de Organismos Traslado Consumo
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param pagination
	 *            Pagination paginación
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return List<Organismo> lista de organismos que cumplen el filtro
	 */
	public List<Organismo> findAllLikeOrganismoTraslado(Organismo organismo,
			String codOrgConectado, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllOrganismoTraslado(
				organismo, codOrgConectado, pagination, startsWith);
	}

	/**
	 * Cuenta los organismos que estén tanto en la tabla de Organismos como en
	 * la vista de Organismos Traslado Consumo
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return Long número de resultados
	 */
	public Long findAllLikeOrganismoTrasladoCount(Organismo organismo,
			String codOrgConectado, Boolean startsWith) {
		return this.organismoDao.findAllOrganismoTrasladoCount(organismo,
				codOrgConectado, startsWith);
	}

	/**
	 * Busca los organismos que estén tanto en la tabla de Organismos como en la
	 * vista de Organismos Inhibicion Consumo
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param pagination
	 *            Pagination paginación
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return List<Organismo> lista de organismos que cumplen el filtro
	 */
	public List<Organismo> findAllLikeOrganismoInhibicion(Organismo organismo,
			String codOrgConectado, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllOrganismoInhibicion(
				organismo, codOrgConectado, pagination, startsWith);
	}

	/**
	 * Cuenta los organismos que estén tanto en la tabla de Organismos como en
	 * la vista de Organismos Inhibicion Consumo
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return Long número de resultados
	 */
	public Long findAllLikeOrganismoInhibicionCount(Organismo organismo,
			String codOrgConectado, Boolean startsWith) {
		return this.organismoDao.findAllOrganismoInhibicionCount(organismo,
				codOrgConectado, startsWith);
	}
}
