package com.ejie.y41a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.OoeeDao;
import com.ejie.y41a.dao.OrganismoDao;
import com.ejie.y41a.model.Ooee;
import com.ejie.y41a.model.Organismo;

/**
 * OoeeServiceImpl generated by UDA, 23-nov-2016 12:18:26.
 * 
 *  
 */

@Service(value = "ooeeService")
public class OoeeServiceImpl implements OoeeService {

	@Autowired()
	private OoeeDao ooeeDao;

	@Autowired()
	private OrganismoDao organismoDao;

	/**
	 * Finds a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Ooee
	 */
	public Ooee find(Ooee ooee) {
		Ooee ooeeDetalle = new Ooee();
		try {
			ooeeDetalle = this.ooeeDao.find(ooee);
		} catch (Exception e) {
			// Si no encuentra el detalle se "ahoga" la excepcion
		}
		Organismo organismo = new Organismo();
		organismo.setCodOrg(ooee.getOecodigo());
		try {
			organismo = this.organismoDao.find(organismo);
		} catch (Exception e) {
			// Si no encuentra el organismo, o no puede volcar los datos, se
			// "ahoga" la excepcion
		}
		if (ooeeDetalle != null) {
			ooeeDetalle.setOrganismo(organismo);
		}

		return ooeeDetalle;

	}

	/**
	 * Finds a List of rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Ooee> findAllBusqueda(Ooee ooee, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("organismo.nombreEs")) {
				pagination.setSort("OrganismoNOMBREES");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("organismo.nombreEu")) {
				pagination.setSort("OrganismoNOMBREEU");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("organismo.nombreMunicipio")) {
				pagination.setSort("OrganismoNOMBREMUNICIPIO");
			}
		}
		return (List<Ooee>) this.ooeeDao.findAllBusqueda(ooee, pagination);
	}

	/**
	 * Counts rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Long
	 */
	public Long findAllBusquedaCount(Ooee ooee) {
		return this.ooeeDao.findAllBusquedaCount(ooee);
	}

}
