package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.MotivoDao;
import com.ejie.y41a.model.ProdAgrupado;
import com.ejie.y41a.model.Producto;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Motivo;

/**
 * * MotivoServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

@Service(value = "motivoService")
public class MotivoServiceImpl implements MotivoService {

	private static final Logger logger = LoggerFactory
			.getLogger(MotivoServiceImpl.class);
	@Autowired
	private MotivoDao motivoDao;

	/**
	 * Inserts a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Motivo add(Motivo motivo) {
		return this.motivoDao.add(motivo);
	}

	/**
	 * Updates a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Motivo update(Motivo motivo) {
		return this.motivoDao.update(motivo);
	}

	/**
	 * Finds a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	public Motivo find(Motivo motivo) {
		return (Motivo) this.motivoDao.find(motivo);
	}

	/**
	 * Finds a List of rows in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Motivo> findAll(Motivo motivo, Pagination pagination) {
		return (List<Motivo>) this.motivoDao.findAll(motivo, pagination);
	}

	/**
	 * Counts rows in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Long
	 */
	public Long findAllCount(Motivo motivo) {
		return this.motivoDao.findAllCount(motivo);
	}

	/**
	 * Finds rows in the Motivo table using like.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Motivo> findAllLike(Motivo motivo, Pagination pagination,
			Boolean startsWith) {
		return (List<Motivo>) this.motivoDao.findAllLike(motivo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Motivo table using like.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Motivo motivo, Boolean startsWith) {
		return this.motivoDao.findAllLikeCount(motivo, startsWith);
	}

	/**
	 * Deletes a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Motivo motivo) {
		this.motivoDao.remove(motivo);
	}

	/**
	 * Deletes multiple rows in the Motivo table.
	 * 
	 * @param motivoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Motivo> motivoList) {
		for (Motivo motivoAux : motivoList) {
			this.motivoDao.remove(motivoAux);
		}
	}

	/**
	 * Inserts a single row in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Motivo addProdMotivo(Motivo motivo) {
		return this.motivoDao.addProdMotivo(motivo);
	}

	/**
	 * Deletes a single row in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeProdMotivo(Motivo motivo) {
		this.motivoDao.removeProdMotivo(motivo);
	}

	/**
	 * Find a single row in the findProdMotivo Many To Many relationship.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @param pagination
	 *            Pagination
	 * @return Motivo
	 */
	public Motivo findProdMotivo(Motivo motivo, ProdAgrupado prodAgrupado,
			Pagination pagination) {
		return this.motivoDao.findProdMotivo(motivo, prodAgrupado, pagination);
	}

	/**
	 * Counts rows in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @return List
	 */
	public Long findProdMotivoCount(Motivo motivo, ProdAgrupado prodagrupado) {
		return this.motivoDao.findProdMotivoCount(motivo, prodagrupado);
	}

	/**
	 * Getter method for MotivoDao
	 * 
	 * @return MotivoDao
	 */
	public MotivoDao getMotivoDao() {
		return this.motivoDao;
	}

	/**
	 * Setter method for MotivoDao.
	 * 
	 * @param motivoDao
	 *            MotivoDao
	 * @return
	 */
	public void setMotivoDao(MotivoDao motivoDao) {
		logger.info("Setting Dependency " + motivoDao);
		this.motivoDao = motivoDao;
	}

	/**
	 * Finds a List of rows in the Motivo table of Producto.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Motivo> findAllMotivoProducto(Producto producto,
			Pagination pagination) {
		return (List<Motivo>) this.motivoDao.findAllMotivoProducto(producto,
				pagination);
	}

	/**
	 * Finds a List of rows in the Motivo table of Producto.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Motivo> findAllMotivoProductoAlta(Producto producto,
			Pagination pagination) {
		return (List<Motivo>) this.motivoDao.findAllMotivoProductoAlta(
				producto, pagination);
	}
}
