package com.ejie.y41a.service;


import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41a.model.Inspector;

/**
 *  * InspectorService generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

public interface InspectorService {

	/**
	 * Inserts a single row in the Inspector table.
	 *
	 * @param inspector Inspector
	 * @return Inspector
	 */
    Inspector add(Inspector inspector);

	/**
	 * Updates a single row in the Inspector table.
	 *
	 * @param inspector Inspector
	 * @return Inspector
	 */
	Inspector update(Inspector inspector);

	/**
	 * Finds a single row in the Inspector table.
	 *
	 * @param inspector Inspector
	 * @return Inspector
	 */
	Inspector find(Inspector inspector);

	/**
	 * Finds a List of rows in the Inspector table.
	 *
	 * @param inspector Inspector
	 * @param pagination Pagination
	 * @return List
	 */
	List<Inspector> findAll(Inspector inspector, Pagination pagination);

	/**
	 * Counts rows in the Inspector table.
	 *
	 * @param inspector Inspector
	 * @return Long
	 */
	Long findAllCount(Inspector inspector);
	
	/**
	 * Finds rows in the Inspector table using like.
	 *
	 * @param inspector Inspector
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Inspector> findAllLike(Inspector inspector, Pagination pagination, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Inspector table.
	 *
	 * @param inspector Inspector
	 * @return 
	 */
	void remove(Inspector inspector);
	
	/**
	 * Deletes multiple rows in the Inspector table.
	 *
	 * @param inspectorList  ArrayList
	 * @return 
	 */	
	void removeMultiple(ArrayList<Inspector> inspectorList);
    
}


