package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.InspeccionesDao;
import com.ejie.y41a.dao.PlantillaInsDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Inspecciones;
import com.ejie.y41a.model.PlantillaIns;
import com.ejie.y41a.utils.Y41aUIDGenerator;

/**
 * * InspeccionesServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "inspeccionesService")
public class InspeccionesServiceImpl implements InspeccionesService {

	private static final Logger logger = LoggerFactory
			.getLogger(InspeccionesServiceImpl.class);
	@Autowired
	private InspeccionesDao inspeccionesDao;
	@Autowired
	private PlantillaInsDao plantillaInsDao;

	/**
	 * Inserts a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @return Inspecciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Inspecciones add(Inspecciones inspecciones) {
		return this.inspeccionesDao.add(inspecciones);
	}

	/**
	 * Updates a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @return Inspecciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Inspecciones update(Inspecciones inspecciones) {
		return this.inspeccionesDao.update(inspecciones);
	}

	/**
	 * Updates a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @return Inspecciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Inspecciones updateFecha(Inspecciones inspecciones) {
		return this.inspeccionesDao.updateFecha(inspecciones);
	}

	/**
	 * Finds a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @return Inspecciones
	 */
	public Inspecciones find(Inspecciones inspecciones) {
		return (Inspecciones) this.inspeccionesDao.find(inspecciones);
	}

	/**
	 * Finds a List of rows in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Inspecciones> findAll(Inspecciones inspecciones,
			Pagination pagination) {
		return (List<Inspecciones>) this.inspeccionesDao.findAll(inspecciones,
				pagination);
	}

	/**
	 * Counts rows in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @return Long
	 */
	public Long findAllCount(Inspecciones inspecciones) {
		return this.inspeccionesDao.findAllCount(inspecciones);
	}

	/**
	 * Finds rows in the Inspecciones table using like.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Inspecciones> findAllLike(Inspecciones inspecciones,
			Pagination pagination, Boolean startsWith) {
		return (List<Inspecciones>) this.inspeccionesDao.findAllLike(
				inspecciones, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Inspecciones inspecciones) {
		this.inspeccionesDao.remove(inspecciones);
	}

	/**
	 * Deletes multiple rows in the Inspecciones table.
	 * 
	 * @param inspeccionesList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Inspecciones> inspeccionesList) {
		for (Inspecciones inspeccionesAux : inspeccionesList) {
			this.inspeccionesDao.remove(inspeccionesAux);
		}
	}

	/**
	 * Getter method for InspeccionesDao
	 * 
	 * @return InspeccionesDao
	 */
	public InspeccionesDao getInspeccionesDao() {
		return this.inspeccionesDao;
	}

	/**
	 * Setter method for InspeccionesDao.
	 * 
	 * @param inspeccionesDao
	 *            InspeccionesDao
	 * @return
	 */
	public void setInspeccionesDao(InspeccionesDao inspeccionesDao) {
		logger.info("Setting Dependency " + inspeccionesDao);
		this.inspeccionesDao = inspeccionesDao;
	}

	/**
	 * Inserts a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Inspecciones addInspeccion(Inspecciones inspecciones) {

		inspecciones.setInscodcarta(this.inspeccionesDao.getNewPK().toString());
		this.inspeccionesDao.add(inspecciones);

		// buscar los diferentes codigos de organismo que tienen plantillas
		List<PlantillaIns> listPlantillaIns = this.plantillaInsDao
				.findAllInspecciones();

		for (PlantillaIns plantIns : listPlantillaIns) {

			PlantillaIns plantillaBusquedaIns = new PlantillaIns();
			plantillaBusquedaIns.setPlinscoor(plantIns.getPlinscoor());
			plantillaBusquedaIns.setInspecciones(inspecciones);
			plantillaBusquedaIns.setPlinscodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));

			// por cada organismo insertar una plantilla vacia.
			this.plantillaInsDao.add(plantillaBusquedaIns);
		}

		if (listPlantillaIns.size() == 0) {
			PlantillaIns plantillaBusquedaIns = new PlantillaIns();
			plantillaBusquedaIns
					.setPlinscoor(Y41aConstantes.CODIGO_ORGANISMO_LAKUA);
			plantillaBusquedaIns.setInspecciones(inspecciones);
			plantillaBusquedaIns.setPlinscodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));

			// por cada organismo insertar una plantilla vacia.
			this.plantillaInsDao.add(plantillaBusquedaIns);
		}
		return inspecciones;
	}
}
