package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.InfracAlertaDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.InfracAlerta;

/**
 *  * InfracAlertaServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "infracAlertaService")
public  class InfracAlertaServiceImpl implements InfracAlertaService {

	private static final  Logger logger = LoggerFactory.getLogger(InfracAlertaServiceImpl.class);
	@Autowired
	private InfracAlertaDao infracAlertaDao;

	/**
	 * Inserts a single row in the InfracAlerta table.
	 *
	 * @param infracAlerta InfracAlerta
	 * @return InfracAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InfracAlerta add(InfracAlerta infracAlerta) {
		return this.infracAlertaDao.add(infracAlerta);
	}

	/**
	 * Updates a single row in the InfracAlerta table.
	 *
	 * @param infracAlerta InfracAlerta
	 * @return InfracAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InfracAlerta update(InfracAlerta infracAlerta) {
		return this.infracAlertaDao.update(infracAlerta);
	 }

	/**
	 * Finds a single row in the InfracAlerta table.
	 *
	 * @param infracAlerta InfracAlerta
	 * @return InfracAlerta
	 */
	public InfracAlerta find(InfracAlerta infracAlerta) {
		return (InfracAlerta) this.infracAlertaDao.find(infracAlerta);
	}

	/**
	 * Finds a List of rows in the InfracAlerta table.
	 *
	 * @param infracAlerta InfracAlerta
	 * @param pagination Pagination
	 * @return List
	 */
	public List<InfracAlerta> findAll(InfracAlerta infracAlerta, Pagination pagination) {
		return (List<InfracAlerta>) this.infracAlertaDao.findAll(infracAlerta, pagination);
	}
    
	/**
	 * Counts rows in the InfracAlerta table.
	 *
	 * @param infracAlerta InfracAlerta
	 * @return Long
	 */
	public Long findAllCount(InfracAlerta infracAlerta) {        
		return  this.infracAlertaDao.findAllCount(infracAlerta);
	}

	/**
	 * Finds rows in the InfracAlerta table using like.
	 *
	 * @param infracAlerta InfracAlerta
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<InfracAlerta> findAllLike(InfracAlerta infracAlerta, Pagination pagination, Boolean startsWith) {
		return (List<InfracAlerta>) this.infracAlertaDao.findAllLike(infracAlerta, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the InfracAlerta table.
	 *
	 * @param infracAlerta InfracAlerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(InfracAlerta infracAlerta) {
		this.infracAlertaDao.remove(infracAlerta);
	}
	
	/**
	 * Deletes multiple rows in the InfracAlerta table.
	 *
	 * @param infracAlertaList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<InfracAlerta> infracAlertaList) {
		for (InfracAlerta  infracAlertaAux:infracAlertaList) {
			this.infracAlertaDao.remove(infracAlertaAux);
		}
	}


	/**
	 * Getter method for InfracAlertaDao
	 *
	 * @return InfracAlertaDao
	 */
	public InfracAlertaDao getInfracAlertaDao() {
		return this.infracAlertaDao;
	}
    
	/**
	 * Setter method for InfracAlertaDao.
	 *
	 * @param  infracAlertaDao InfracAlertaDao
	 * @return
	 */
	public void setInfracAlertaDao(InfracAlertaDao infracAlertaDao) {
		logger.info("Setting Dependency "+infracAlertaDao);
		this.infracAlertaDao = infracAlertaDao;
	}
}

