package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.HechoDenunciadoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.HechoDenunciado;

/**
 *  * HechoDenunciadoServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 *  
 */

@Service(value = "hechoDenunciadoService")
public  class HechoDenunciadoServiceImpl implements HechoDenunciadoService {

	private static final  Logger logger = LoggerFactory.getLogger(HechoDenunciadoServiceImpl.class);
	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;

	/**
	 * Inserts a single row in the HechoDenunciado table.
	 *
	 * @param hechoDenunciado HechoDenunciado
	 * @return HechoDenunciado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public HechoDenunciado add(HechoDenunciado hechoDenunciado) {
		return this.hechoDenunciadoDao.add(hechoDenunciado);
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 *
	 * @param hechoDenunciado HechoDenunciado
	 * @return HechoDenunciado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public HechoDenunciado update(HechoDenunciado hechoDenunciado) {
		return this.hechoDenunciadoDao.update(hechoDenunciado);
	 }

	/**
	 * Finds a single row in the HechoDenunciado table.
	 *
	 * @param hechoDenunciado HechoDenunciado
	 * @return HechoDenunciado
	 */
	public HechoDenunciado find(HechoDenunciado hechoDenunciado) {
		return (HechoDenunciado) this.hechoDenunciadoDao.find(hechoDenunciado);
	}

	/**
	 * Finds a List of rows in the HechoDenunciado table.
	 *
	 * @param hechoDenunciado HechoDenunciado
	 * @param pagination Pagination
	 * @return List
	 */
	public List<HechoDenunciado> findAll(HechoDenunciado hechoDenunciado, Pagination pagination) {
		return (List<HechoDenunciado>) this.hechoDenunciadoDao.findAll(hechoDenunciado, pagination);
	}
    
	/**
	 * Counts rows in the HechoDenunciado table.
	 *
	 * @param hechoDenunciado HechoDenunciado
	 * @return Long
	 */
	public Long findAllCount(HechoDenunciado hechoDenunciado) {        
		return  this.hechoDenunciadoDao.findAllCount(hechoDenunciado);
	}

	/**
	 * Finds rows in the HechoDenunciado table using like.
	 *
	 * @param hechoDenunciado HechoDenunciado
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<HechoDenunciado> findAllLike(HechoDenunciado hechoDenunciado, Pagination pagination, Boolean startsWith) {
		return (List<HechoDenunciado>) this.hechoDenunciadoDao.findAllLike(hechoDenunciado, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the HechoDenunciado table.
	 *
	 * @param hechoDenunciado HechoDenunciado
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(HechoDenunciado hechoDenunciado) {
		this.hechoDenunciadoDao.remove(hechoDenunciado);
	}
	
	/**
	 * Deletes multiple rows in the HechoDenunciado table.
	 *
	 * @param hechoDenunciadoList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<HechoDenunciado> hechoDenunciadoList) {
		for (HechoDenunciado  hechoDenunciadoAux:hechoDenunciadoList) {
			this.hechoDenunciadoDao.remove(hechoDenunciadoAux);
		}
	}


	/**
	 * Getter method for HechoDenunciadoDao
	 *
	 * @return HechoDenunciadoDao
	 */
	public HechoDenunciadoDao getHechoDenunciadoDao() {
		return this.hechoDenunciadoDao;
	}
    
	/**
	 * Setter method for HechoDenunciadoDao.
	 *
	 * @param  hechoDenunciadoDao HechoDenunciadoDao
	 * @return
	 */
	public void setHechoDenunciadoDao(HechoDenunciadoDao hechoDenunciadoDao) {
		logger.info("Setting Dependency "+hechoDenunciadoDao);
		this.hechoDenunciadoDao = hechoDenunciadoDao;
	}
}

