package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.FormasVentaDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.FormasVenta;

/**
 *  * FormasVentaServiceImpl generated by UDA, 19-ene-2016 11:45:24.
 *  
 */

@Service(value = "formasVentaService")
public  class FormasVentaServiceImpl implements FormasVentaService {

	private static final  Logger logger = LoggerFactory.getLogger(FormasVentaServiceImpl.class);
	@Autowired
	private FormasVentaDao formasVentaDao;

	/**
	 * Inserts a single row in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return FormasVenta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public FormasVenta add(FormasVenta formasVenta) {
		return this.formasVentaDao.add(formasVenta);
	}

	/**
	 * Updates a single row in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return FormasVenta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public FormasVenta update(FormasVenta formasVenta) {
		return this.formasVentaDao.update(formasVenta);
	 }

	/**
	 * Finds a single row in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return FormasVenta
	 */
	public FormasVenta find(FormasVenta formasVenta) {
		return (FormasVenta) this.formasVentaDao.find(formasVenta);
	}

	/**
	 * Finds a List of rows in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @param pagination Pagination
	 * @return List
	 */
	public List<FormasVenta> findAll(FormasVenta formasVenta, Pagination pagination) {
		return (List<FormasVenta>) this.formasVentaDao.findAll(formasVenta, pagination);
	}
    
	/**
	 * Counts rows in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return Long
	 */
	public Long findAllCount(FormasVenta formasVenta) {        
		return  this.formasVentaDao.findAllCount(formasVenta);
	}

	/**
	 * Finds rows in the FormasVenta table using like.
	 *
	 * @param formasVenta FormasVenta
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<FormasVenta> findAllLike(FormasVenta formasVenta, Pagination pagination, Boolean startsWith) {
		return (List<FormasVenta>) this.formasVentaDao.findAllLike(formasVenta, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(FormasVenta formasVenta) {
		this.formasVentaDao.remove(formasVenta);
	}
	
	/**
	 * Deletes multiple rows in the FormasVenta table.
	 *
	 * @param formasVentaList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<FormasVenta> formasVentaList) {
		for (FormasVenta  formasVentaAux:formasVentaList) {
			this.formasVentaDao.remove(formasVentaAux);
		}
	}


	/**
	 * Getter method for FormasVentaDao
	 *
	 * @return FormasVentaDao
	 */
	public FormasVentaDao getFormasVentaDao() {
		return this.formasVentaDao;
	}
    
	/**
	 * Setter method for FormasVentaDao.
	 *
	 * @param  formasVentaDao FormasVentaDao
	 * @return
	 */
	public void setFormasVentaDao(FormasVentaDao formasVentaDao) {
		logger.info("Setting Dependency "+formasVentaDao);
		this.formasVentaDao = formasVentaDao;
	}
}

