package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.FormaPresentacionDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.FormaPresentacion;

/**
 *  * FormaPresentacionServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 *  
 */

@Service(value = "formaPresentacionService")
public  class FormaPresentacionServiceImpl implements FormaPresentacionService {

	private static final  Logger logger = LoggerFactory.getLogger(FormaPresentacionServiceImpl.class);
	@Autowired
	private FormaPresentacionDao formaPresentacionDao;

	/**
	 * Inserts a single row in the FormaPresentacion table.
	 *
	 * @param formaPresentacion FormaPresentacion
	 * @return FormaPresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public FormaPresentacion add(FormaPresentacion formaPresentacion) {
		return this.formaPresentacionDao.add(formaPresentacion);
	}

	/**
	 * Updates a single row in the FormaPresentacion table.
	 *
	 * @param formaPresentacion FormaPresentacion
	 * @return FormaPresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public FormaPresentacion update(FormaPresentacion formaPresentacion) {
		return this.formaPresentacionDao.update(formaPresentacion);
	 }

	/**
	 * Finds a single row in the FormaPresentacion table.
	 *
	 * @param formaPresentacion FormaPresentacion
	 * @return FormaPresentacion
	 */
	public FormaPresentacion find(FormaPresentacion formaPresentacion) {
		return (FormaPresentacion) this.formaPresentacionDao.find(formaPresentacion);
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 *
	 * @param formaPresentacion FormaPresentacion
	 * @param pagination Pagination
	 * @return List
	 */
	public List<FormaPresentacion> findAll(FormaPresentacion formaPresentacion, Pagination pagination) {
		return (List<FormaPresentacion>) this.formaPresentacionDao.findAll(formaPresentacion, pagination);
	}
    
	/**
	 * Counts rows in the FormaPresentacion table.
	 *
	 * @param formaPresentacion FormaPresentacion
	 * @return Long
	 */
	public Long findAllCount(FormaPresentacion formaPresentacion) {        
		return  this.formaPresentacionDao.findAllCount(formaPresentacion);
	}

	/**
	 * Finds rows in the FormaPresentacion table using like.
	 *
	 * @param formaPresentacion FormaPresentacion
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<FormaPresentacion> findAllLike(FormaPresentacion formaPresentacion, Pagination pagination, Boolean startsWith) {
		return (List<FormaPresentacion>) this.formaPresentacionDao.findAllLike(formaPresentacion, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the FormaPresentacion table.
	 *
	 * @param formaPresentacion FormaPresentacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(FormaPresentacion formaPresentacion) {
		this.formaPresentacionDao.remove(formaPresentacion);
	}
	
	/**
	 * Deletes multiple rows in the FormaPresentacion table.
	 *
	 * @param formaPresentacionList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<FormaPresentacion> formaPresentacionList) {
		for (FormaPresentacion  formaPresentacionAux:formaPresentacionList) {
			this.formaPresentacionDao.remove(formaPresentacionAux);
		}
	}


	/**
	 * Getter method for FormaPresentacionDao
	 *
	 * @return FormaPresentacionDao
	 */
	public FormaPresentacionDao getFormaPresentacionDao() {
		return this.formaPresentacionDao;
	}
    
	/**
	 * Setter method for FormaPresentacionDao.
	 *
	 * @param  formaPresentacionDao FormaPresentacionDao
	 * @return
	 */
	public void setFormaPresentacionDao(FormaPresentacionDao formaPresentacionDao) {
		logger.info("Setting Dependency "+formaPresentacionDao);
		this.formaPresentacionDao = formaPresentacionDao;
	}
}

