package com.ejie.y41a.service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.EstadisticasSolicitudesResultado;
import com.ejie.y41a.model.ListadoSolicitudResultado;
import com.ejie.y41a.model.SolicitudBusqueda;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * EstadisticasSolicitudesServiceImpl generated by UDA 1.0, 08-jun-2011
 * 12:15:13.
 * 
 *  
 */
@Service(value = "estadisticasSolicitudesService")
public class EstadisticasSolicitudesServiceImpl implements
		EstadisticasSolicitudesService {

	@Autowired
	private DenunciaService denunciaService;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	private int numCriteriosBusqueda = 0;

	/**
	 * Generar excel de las estadisticas de solicitudes
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @param indEstadistica
	 *            String
	 * 
	 * @return String
	 */
	public String getEstadisticaSolicitudesExcel(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta, String indEstadistica) {

		StringBuffer xslString = new StringBuffer();

		if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_DECISIONES_LOCALIDAD_ESTABLECIMIENTO)) {
			xslString
					.append(this
							.getEstadisticaDecisionMunicipioEstablecimiento(
									solicitudesBusqueda, defedeDesde,
									defedeHasta, defereDesde, defereHasta,
									hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_DECISIONES_LOCALIDAD_CONSUMIDOR)) {
			xslString.append(this.getEstadisticaDecisionMunicipioConsumidor(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_SECTORES_LOCALIDAD_ESTABLECIMIENTO)) {
			xslString.append(this.getEstadisticaSectorMunicipioEstablecimiento(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_MOTIVOS)) {
			xslString.append(this.getEstadisticaMotivos(solicitudesBusqueda,
					defedeDesde, defedeHasta, defereDesde, defereHasta,
					hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_DECISIONES)) {
			xslString.append(this.getEstadisticaDecisiones(solicitudesBusqueda,
					defedeDesde, defedeHasta, defereDesde, defereHasta,
					hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_FORMA_PRESENTACION_LOCALIDAD_CONSUMIDOR)) {
			xslString
					.append(this
							.getEstadisticaFormaPresentacionMunicipioConsumidor(
									solicitudesBusqueda, defedeDesde,
									defedeHasta, defereDesde, defereHasta,
									hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_SECTORES_LOCALIDAD_CONSUMIDOR)) {
			xslString.append(this.getEstadisticaSectorMunicipioConsumidor(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_SEXO_EDAD)) {
			xslString.append(this.getEstadisticaSexoEdad(solicitudesBusqueda,
					defedeDesde, defedeHasta, defereDesde, defereHasta,
					hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_PROMEDIO_TIEMPO_RESOLVER_SOLICITUD)) {
			xslString
					.append(this.getEstadisticaPromedioTiempoResolverSolicitud(
							solicitudesBusqueda, defedeDesde, defedeHasta,
							defereDesde, defereHasta, hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_PRODUCTOS_LOCALIDAD_ESTABLECIMIENTO)) {
			xslString
					.append(this
							.getEstadisticaProductoMunicipioEstablecimiento(
									solicitudesBusqueda, defedeDesde,
									defedeHasta, defereDesde, defereHasta,
									hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_PRODUCTOS_LOCALIDAD_CONSUMIDOR)) {
			xslString.append(this.getEstadisticaProductoMunicipioConsumidor(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_SOLICITUDES_RELACION_SOLICITUDES_PRODUCTO_MOTIVO)) {
			xslString.append(this.getListadoRelacionSolicitudesProductoMotivo(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_SOLICITUDES_RELACION_ESTABLECIMIENTOS)) {
			xslString.append(this.getListadoRelacionEstablecimientos(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_SOLICITUDES_RELACION_PRODUCTOS)) {
			xslString.append(this.getListadoRelacionProductos(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_SOLICITUDES_RELACION_SOLICITUDES_SIN_DECISION)) {
			xslString.append(this.getListadoRelacionSolicitudesSinDecision(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_SOLICITUDES_RELACION_SOLICITUDES_CON_DECISION)) {
			xslString.append(this.getListadoRelacionSolicitudesConDecision(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_SOLICITUDES_RELACION_ESTADO_EXPEDIENTES_CURSO)) {
			xslString
					.append(this
							.getListadoRelacionSolicitudesEstadoExpedientesCurso(
									solicitudesBusqueda, defedeDesde,
									defedeHasta, defereDesde, defereHasta,
									hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_SOLICITUDES_RELACION_TIEMPO_TRAMITACION)) {
			xslString
					.append(this
							.getListadoRelacionSolicitudesTiempoTramitacion(
									solicitudesBusqueda, defedeDesde,
									defedeHasta, defereDesde, defereHasta,
									hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_SOLICITUDES_RELACION_TIEMPO_REALIZACION_PRIMER_TRAMITE)) {
			xslString
					.append(this
							.getListadoRelacionTiempoRealizacionPrimerTramite(
									solicitudesBusqueda, defedeDesde,
									defedeHasta, defereDesde, defereHasta,
									hcfedeDesde, hcfedeHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_SOLICITUDES_FORMA_VENTA_MUNICIPIO_CONSUMIDOR)) {

			xslString.append(this.getEstadisticaFormaVentaMunicipioConsumidor(
					solicitudesBusqueda, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_SOLICITUDES_GENERAL)) {

			xslString.append(this.getListadoGeneral(solicitudesBusqueda,
					defedeDesde, defedeHasta, defereDesde, defereHasta,
					hcfedeDesde, hcfedeHasta));

		}

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por decision.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaDecisionMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaDecisionMunicipioEstablecimiento(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaDecisionMunicipioEstablecimientoCriteriosBusquedaRow(
						solicitudesBusqueda,
						listEstadisticasSolicitudesResultado, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta));

		String[][] datos = getEstadisticaDecisionMunicipioEstablecimientoDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por decision.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaDecisionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaDecisionMunicipioConsumidor(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaDecisionMunicipioConsumidorCriteriosBusquedaRow(
						solicitudesBusqueda,
						listEstadisticasSolicitudesResultado, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta));

		String[][] datos = getEstadisticaDecisionMunicipioConsumidorDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por sector.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaSectorMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaSectoresMunicipioEstablecimiento(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaSectorMunicipioEstablecimientoCriteriosBusquedaRow(
						solicitudesBusqueda,
						listEstadisticasSolicitudesResultado, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta));

		String[][] datos = getEstadisticaSectorMunicipioEstablecimientoDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por motivo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaMotivos(SolicitudBusqueda solicitudesBusqueda,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaMotivos(solicitudesBusqueda, null,
						false, defedeDesde, defedeHasta, defereDesde,
						defereHasta, hcfedeDesde, hcfedeHasta);

		// add criterios busqueda
		xslString.append(getEstadisticaMotivosCriteriosBusquedaRow(
				solicitudesBusqueda, listEstadisticasSolicitudesResultado,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaMotivosHeaderRow());

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String elementoAnterior = "";
		BigDecimal totalProducto = new BigDecimal(0);

		// Calcular total registros
		BigDecimal total = new BigDecimal(0);

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {
			total = total.add(estadisticasSolicitudesResultado.getTotal());
		}

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			if (!elementoAnterior.equals("")) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (!estadisticasSolicitudesResultado.getFilas().equals(
							elementoAnterior)) {
						// calcular porcentaje total producto
						Float porcentaje = new Float(0);

						porcentaje = (new Float(totalProducto.toString()
								.toString()) / new Float(total.toString())) * 100;

						// Pintar la linea total producto
						xslString
								.append(getEstadisticaMotivosProductoServicioTotalRow(
										totalProducto, porcentaje));

					}
				} else {
					if (!estadisticasSolicitudesResultado.getFilase().equals(
							elementoAnterior)) {
						// calcular porcentaje total producto
						Float porcentaje = new Float(0);

						porcentaje = (new Float(totalProducto.toString()
								.toString()) / new Float(total.toString())) * 100;

						// Pintar la linea total producto
						xslString
								.append(getEstadisticaMotivosProductoServicioTotalRow(
										totalProducto, porcentaje));
					}
				}
			}

			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (!estadisticasSolicitudesResultado.getFilas().equals(
						elementoAnterior)) {
					totalProducto = new BigDecimal(0);
					// Se calcula el total por producto
					for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
						if (estadisticasSolicitudesResultado.getFilas().equals(
								estadisticasSolicitudesResultadoAux.getFilas())) {
							totalProducto = totalProducto
									.add(estadisticasSolicitudesResultadoAux
											.getTotal());
						}
					}
				}
			} else {
				if (!estadisticasSolicitudesResultado.getFilase().equals(
						elementoAnterior)) {
					totalProducto = new BigDecimal(0);
					// Se calcula el total por producto
					for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
						if (estadisticasSolicitudesResultado.getFilase()
								.equals(estadisticasSolicitudesResultadoAux
										.getFilase())) {
							totalProducto = totalProducto
									.add(estadisticasSolicitudesResultadoAux
											.getTotal());
						}
					}
				}
			}

			// calcular porcentaje de la linea
			Float porcentaje = new Float(0);

			porcentaje = (new Float(estadisticasSolicitudesResultado.getTotal()
					.toString()) / new Float(totalProducto.toString())) * 100;

			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultado.getFilas().equals(
						elementoAnterior)) {
					estadisticasSolicitudesResultado.setFilas("");
				} else {
					elementoAnterior = estadisticasSolicitudesResultado
							.getFilas();
				}
			} else {
				if (estadisticasSolicitudesResultado.getFilase().equals(
						elementoAnterior)) {
					estadisticasSolicitudesResultado.setFilase("");
				} else {
					elementoAnterior = estadisticasSolicitudesResultado
							.getFilase();
				}
			}

			xslString.append(getEstadisticaMotivosRow(
					estadisticasSolicitudesResultado, porcentaje));
		}

		if (!elementoAnterior.equals("")) {

			// calcular porcentaje total producto
			Float porcentaje = new Float(0);

			porcentaje = (new Float(totalProducto.toString().toString()) / new Float(
					total.toString())) * 100;

			// Pintar la linea total producto
			xslString.append(getEstadisticaMotivosProductoServicioTotalRow(
					totalProducto, porcentaje));
		}

		xslString.append(getEstadisticaMotivosTotalRow(total));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por decision.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaDecisiones(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaDecisiones(solicitudesBusqueda,
						null, false, defedeDesde, defedeHasta, defereDesde,
						defereHasta, hcfedeDesde, hcfedeHasta);

		// add criterios busqueda
		xslString.append(getEstadisticaDecisionesCriteriosBusquedaRow(
				solicitudesBusqueda, listEstadisticasSolicitudesResultado,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaDecisionesHeaderRow());

		// Calcular total registros
		BigDecimal total = new BigDecimal(0);

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {
			total = total.add(estadisticasSolicitudesResultado.getTotal());
		}

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			// calcular porcentaje de la linea
			Float porcentaje = new Float(0);

			porcentaje = (new Float(estadisticasSolicitudesResultado.getTotal()
					.toString()) / new Float(total.toString())) * 100;

			xslString.append(getEstadisticaDecisionesRow(
					estadisticasSolicitudesResultado, porcentaje));
		}

		xslString.append(getEstadisticaDecisionesTotalRow(total));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por forma presentacion.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaFormaPresentacionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaFormaPresentacionMunicipioConsumidor(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaFormaPresentacionMunicipioConsumidorCriteriosBusquedaRow(
						solicitudesBusqueda,
						listEstadisticasSolicitudesResultado, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta));

		String[][] datos = getEstadisticaFormaPresentacionMunicipioConsumidorDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * 0132627 Obtiene la estadisticas de solicitudes por forma venta.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaFormaVentaMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaFormaVentaMunicipioConsumidor(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaFormaVentaMunicipioConsumidorCriteriosBusquedaRow(
						solicitudesBusqueda,
						listEstadisticasSolicitudesResultado, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta));

		String[][] datos = getEstadisticaFormaVentaMunicipioConsumidorDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por sector.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaSectorMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaSectoresMunicipioConsumidor(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaSectorMunicipioConsumidorCriteriosBusquedaRow(
						solicitudesBusqueda,
						listEstadisticasSolicitudesResultado, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta));

		String[][] datos = getEstadisticaSectorMunicipioConsumidorDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por sexo y edad.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaSexoEdad(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaSexoEdad(solicitudesBusqueda, null,
						false, defedeDesde, defedeHasta, defereDesde,
						defereHasta, hcfedeDesde, hcfedeHasta);

		// add criterios busqueda
		xslString.append(getEstadisticaSexoEdadCriteriosBusquedaRow(
				solicitudesBusqueda, listEstadisticasSolicitudesResultado,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		String[][] datos = getEstadisticaSexoEdadDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por promedio tiempo resolver
	 * solicitud.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaPromedioTiempoResolverSolicitud(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaPromedioTiempoResolverSolicitud(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaPromedioTiempoResolverSolicitudCriteriosBusquedaRow(
						solicitudesBusqueda,
						listEstadisticasSolicitudesResultado, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta));

		String[][] datos = getEstadisticaPromedioTiempoResolverSolicitudDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por producto.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaProductoMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaProductoServicioMunicipioEstablecimiento(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaProductoMunicipioEstablecimientoCriteriosBusquedaRow(
						solicitudesBusqueda,
						listEstadisticasSolicitudesResultado, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta));

		String[][] datos = getEstadisticaProductoMunicipioEstablecimientoDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de solicitudes por producto.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaProductoMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado = this.denunciaService
				.findAllSolicitudEstadisticaProductoServicioMunicipioConsumidor(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaProductoMunicipioConsumidorCriteriosBusquedaRow(
						solicitudesBusqueda,
						listEstadisticasSolicitudesResultado, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta));

		String[][] datos = getEstadisticaProductoMunicipioConsumidorDataVector(listEstadisticasSolicitudesResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene el listado de solicitudes por producto y motivo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesProductoMotivo(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.denunciaService
				.findAllSolicitudListadoSolicitudesProductoServicioMotivo(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionSolicitudesProductoMotivoCriteriosBusquedaRow(
						solicitudesBusqueda, listListadoSolicitudResultado,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString
				.append(getListadoRelacionSolicitudesProductoMotivoHeaderRow());

		String elementoAnterior = "";

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {

			if (listadoSolicitudResultado.getNumSolicitud().equals(
					elementoAnterior)) {
				listadoSolicitudResultado.setNumSolicitud("");
				listadoSolicitudResultado.setDefede(null);
				listadoSolicitudResultado.setTfpnombre("");
				listadoSolicitudResultado.setTfpnombree("");
				listadoSolicitudResultado.setDtnombre("");
			} else {
				elementoAnterior = listadoSolicitudResultado.getNumSolicitud();
			}

			xslString
					.append(getListadoRelacionSolicitudesProductoMotivoRow(listadoSolicitudResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene el listado de solicitudes por establecimiento.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionEstablecimientos(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.denunciaService
				.findAllSolicitudListadoSolicitudesEstablecimientos(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionEstablecimientosCriteriosBusquedaRow(
						solicitudesBusqueda, listListadoSolicitudResultado,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getListadoRelacionEstablecimientosHeaderRow());

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {

			xslString
					.append(getListadoRelacionEstablecimientosRow(listadoSolicitudResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene el listado de solicitudes por producto.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionProductos(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.denunciaService
				.findAllSolicitudListadoSolicitudesProductoServicios(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString.append(getListadoRelacionProductosCriteriosBusquedaRow(
				solicitudesBusqueda, listListadoSolicitudResultado,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getListadoRelacionProductosHeaderRow());

		String elementoAnterior = "";

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {

			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (listadoSolicitudResultado.getPsnombre().equals(
						elementoAnterior)) {
					listadoSolicitudResultado.setPsnombre("");
				} else {
					elementoAnterior = listadoSolicitudResultado.getPsnombre();
				}
			} else {
				if (listadoSolicitudResultado.getPsnombree().equals(
						elementoAnterior)) {
					listadoSolicitudResultado.setPsnombree("");
				} else {
					elementoAnterior = listadoSolicitudResultado.getPsnombree();
				}
			}

			xslString
					.append(getListadoRelacionProductosRow(listadoSolicitudResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene el listado de solicitudes sin decision.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesSinDecision(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.denunciaService
				.findAllSolicitudListadoSolicitudesSinDecision(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// construye el un listado con toda la info para editar el listado
		List<HashMap<String, Object>> lstDiferente = this
				.getListadoRelacionSolicitudesSinDecisionElementosDiferentes(listListadoSolicitudResultado);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionSolicitudesSinDecisionCriteriosBusquedaRow(
						solicitudesBusqueda, listListadoSolicitudResultado,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getListadoRelacionSolicitudesSinDecisionHeaderRow());

		xslString.append(this
				.getListadoRelacionSolicitudesSinDecisionRowResumen(
						lstDiferente.size(),
						listListadoSolicitudResultado.size()));

		for (HashMap<String, Object> mapa : lstDiferente) {
			xslString.append(this
					.getListadoRelacionSolicitudesSinDecisionRow(mapa));
		}// end for

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene el listado de solicitudes con decision.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesConDecision(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.denunciaService
				.findAllSolicitudListadoSolicitudesConDecision(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionSolicitudesConDecisionCriteriosBusquedaRow(
						solicitudesBusqueda, listListadoSolicitudResultado,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getListadoRelacionSolicitudesConDecisionHeaderRow());

		String elementoAnterior = "";

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {

			if (listadoSolicitudResultado.getNumSolicitud().equals(
					elementoAnterior)) {
				listadoSolicitudResultado.setNumSolicitud("");
				listadoSolicitudResultado.setDefede(null);
			} else {
				elementoAnterior = listadoSolicitudResultado.getNumSolicitud();
			}

			xslString
					.append(getListadoRelacionSolicitudesConDecisionRow(listadoSolicitudResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene el listado de solicitudes con estado expedientes en curso.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesEstadoExpedientesCurso(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.denunciaService
				.findAllSolicitudListadoEstadoExpedientesCurso(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionSolicitudesEstadoExpedientesCursoCriteriosBusquedaRow(
						solicitudesBusqueda, listListadoSolicitudResultado,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString
				.append(getListadoRelacionSolicitudesEstadoExpedientesCursoHeaderRow());

		String elementoAnterior = "";

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {

			if (listadoSolicitudResultado.getNumSolicitud().equals(
					elementoAnterior)) {
				listadoSolicitudResultado.setNumSolicitud("");
				listadoSolicitudResultado.setDefede(null);
				listadoSolicitudResultado.setTsrnombre("");
				listadoSolicitudResultado.setTsrnombree("");
				listadoSolicitudResultado.setMonombreDenuncia("");
				listadoSolicitudResultado.setDtnombre("");
				listadoSolicitudResultado.setEsdireccion_nocapv("");
				listadoSolicitudResultado.setEsdireccionCompleta("");
				listadoSolicitudResultado.setEsnoco("");
				listadoSolicitudResultado.setEsnodir("");
				listadoSolicitudResultado.setEsnombre("");
				listadoSolicitudResultado.setEsnombreCalle("");
				listadoSolicitudResultado.setEsnombreMunicipio("");
				listadoSolicitudResultado.setEsnombrePortal("");
				listadoSolicitudResultado.setEsnombreProvincia("");
			} else {
				elementoAnterior = listadoSolicitudResultado.getNumSolicitud();
			}

			xslString
					.append(getListadoRelacionSolicitudesEstadoExpedientesCursoRow(listadoSolicitudResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene el listado de solicitudes con el tiempo de tramitacion de cada
	 * tramite.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesTiempoTramitacion(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.denunciaService
				.findAllSolicitudListadoTiempoTramitacion(solicitudesBusqueda,
						null, false, defedeDesde, defedeHasta, defereDesde,
						defereHasta, hcfedeDesde, hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionSolicitudesTiempoTramitacionCriteriosBusquedaRow(
						solicitudesBusqueda, listListadoSolicitudResultado,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString
				.append(getListadoRelacionSolicitudesTiempoTramitacionHeaderRow());

		String elementoAnterior = "";

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {

			if (listadoSolicitudResultado.getNumSolicitud().equals(
					elementoAnterior)) {
				listadoSolicitudResultado.setNumSolicitud("");
				listadoSolicitudResultado.setDefede(null);
				listadoSolicitudResultado.setDtnombre("");
			} else {
				elementoAnterior = listadoSolicitudResultado.getNumSolicitud();
			}

			xslString
					.append(getListadoRelacionSolicitudesTiempoTramitacionRow(listadoSolicitudResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	// //////////

	/**
	 * Obtiene el listado de solicitudes por producto y motivo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoGeneral(SolicitudBusqueda solicitudesBusqueda,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.denunciaService
				.findAllSolicitudListadoSolicitudesGeneral(solicitudesBusqueda,
						null, false, defedeDesde, defedeHasta, defereDesde,
						defereHasta, hcfedeDesde, hcfedeHasta);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionSolicitudesGeneralCriteriosBusquedaRow(
						solicitudesBusqueda, listListadoSolicitudResultado,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getListadoRelacionSolicitudesGeneralHeaderRow());

		String elementoAnterior = "";

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {

			if (listadoSolicitudResultado.getNumSolicitud().equals(
					elementoAnterior)) {
				listadoSolicitudResultado.setNumSolicitud("");
				listadoSolicitudResultado.setDefede(null);
				listadoSolicitudResultado.setTfpnombre("");
				listadoSolicitudResultado.setTfpnombree("");
				listadoSolicitudResultado.setDtnombre("");
			} else {
				elementoAnterior = listadoSolicitudResultado.getNumSolicitud();
			}

			xslString
					.append(getListadoRelacionSolicitudesGeneralRow(listadoSolicitudResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	// ///////////////

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaDecisionMunicipioEstablecimientoCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource
				.getMessage("excel.solicituddecisionmunicipioestablecimiento",
						null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaDecisionMunicipioConsumidorCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.solicituddecisionmunicipioconsumidor", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaSectorMunicipioEstablecimientoCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.solicitudsectormunicipioestablecimiento", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaMotivosCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage("excel.solicitudmotivo",
				null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaDecisionesCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage("excel.solicituddecision",
				null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaFormaPresentacionMunicipioConsumidorCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.solicitudformapresentacionmunicipioconsumidor", null,
				locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * 0132627 Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaFormaVentaMunicipioConsumidorCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.solicitudformaventamunicipioconsumidor", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaSectorMunicipioConsumidorCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.solicitudsectormunicipioconsumidor", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaSexoEdadCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage("excel.solicitudsexoedad",
				null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaPromedioTiempoResolverSolicitudCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage(
						"excel.solicitudpromediotiemporesolversolicitud", null,
						locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getNumReg()
					.intValue();
		}

		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaProductoMunicipioEstablecimientoCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource
				.getMessage("excel.solicitudproductomunicipioestablecimiento",
						null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaProductoMunicipioConsumidorCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.solicitudproductomunicipioconsumidor", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultado : listEstadisticasSolicitudesResultado) {

			numRegistros += estadisticasSolicitudesResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado>
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesProductoMotivoCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<ListadoSolicitudResultado> listListadoSolicitudResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadosolicitudproductomotivo", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listListadoSolicitudResultado.size());
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado>
	 * 
	 * @return String
	 */
	private String getListadoRelacionProductosCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<ListadoSolicitudResultado> listListadoSolicitudResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadosolicitudproducto", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listListadoSolicitudResultado.size());
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado>
	 * 
	 * @return String
	 */
	private String getListadoRelacionEstablecimientosCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<ListadoSolicitudResultado> listListadoSolicitudResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadosolicitudestablecimiento", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listListadoSolicitudResultado.size());
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado>
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesSinDecisionCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<ListadoSolicitudResultado> listListadoSolicitudResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadosolicitudsindecision", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");

		xslString.append(listListadoSolicitudResultado.size());
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado>
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesConDecisionCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<ListadoSolicitudResultado> listListadoSolicitudResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadosolicitudcondecision", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// xslString.append("<b>");
		// xslString.append(appMessageSource
		// .getMessage("excel.anyo", null, locale));
		// xslString.append(": ").append(solicitudesBusqueda.getDenran());
		// xslString.append("</b><br/>");

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listListadoSolicitudResultado.size());
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado>
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesEstadoExpedientesCursoCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<ListadoSolicitudResultado> listListadoSolicitudResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadosolicitudestadoexpedientescurso", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// Calculo el numero de solicitudes (no de registros) - Ini
		int numSolicitudes = 0;
		String elementoAnterior = "";
		if (listListadoSolicitudResultado != null
				&& listListadoSolicitudResultado.size() > 0) {
			for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
				if (!listadoSolicitudResultado.getNumSolicitud().equals(
						elementoAnterior)) {
					numSolicitudes++;
					elementoAnterior = listadoSolicitudResultado
							.getNumSolicitud();
				}
			}
		}
		// Calculo el numero de solicitudes (no de registros) - Fin

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numSolicitudes);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado>
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesTiempoTramitacionCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<ListadoSolicitudResultado> listListadoSolicitudResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadosolicitudtiempotramitacion", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// Calculo el numero de solicitudes (no de registros) - Ini
		int numSolicitudes = 0;
		String elementoAnterior = "";
		if (listListadoSolicitudResultado != null
				&& listListadoSolicitudResultado.size() > 0) {
			for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
				if (!listadoSolicitudResultado.getNumSolicitud().equals(
						elementoAnterior)) {
					numSolicitudes++;
					elementoAnterior = listadoSolicitudResultado
							.getNumSolicitud();
				}
			}
		}
		// Calculo el numero de solicitudes (no de registros) - Fin

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numSolicitudes);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado>
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesGeneralCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<ListadoSolicitudResultado> listListadoSolicitudResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadosolicitudgeneral", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// Calculo el numero de solicitudes (no de registros) - Ini
		int numSolicitudes = 0;
		String elementoAnterior = "";
		if (listListadoSolicitudResultado != null
				&& listListadoSolicitudResultado.size() > 0) {
			for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
				if (!listadoSolicitudResultado.getNumSolicitud().equals(
						elementoAnterior)) {
					numSolicitudes++;
					elementoAnterior = listadoSolicitudResultado
							.getNumSolicitud();
				}
			}
		}
		// Calculo el numero de solicitudes (no de registros) - Fin

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numSolicitudes);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado>
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesTiempoRealizacionPrimerTramiteCriteriosBusquedaRow(
			SolicitudBusqueda solicitudesBusqueda,
			List<ListadoSolicitudResultado> listListadoSolicitudResultado,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadosolicitudtiemporealizacionprimertramite", null,
				locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(solicitudesBusqueda,
				defedeDesde, defedeHasta, defereDesde, defereHasta,
				hcfedeDesde, hcfedeHasta));

		// Calculo el numero de solicitudes (no de registros) - Ini
		int numSolicitudes = 0;
		String elementoAnterior = "";
		if (listListadoSolicitudResultado != null
				&& listListadoSolicitudResultado.size() > 0) {
			for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
				if (!listadoSolicitudResultado.getNumSolicitud().equals(
						elementoAnterior)) {
					numSolicitudes++;
					elementoAnterior = listadoSolicitudResultado
							.getNumSolicitud();
				}
			}
		}
		// Calculo el numero de solicitudes (no de registros) - Fin

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numSolicitudes);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEstadisticaMotivosHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(
				appMessageSource.getMessage("excel.productoservicio", null,
						locale)).toUpperCase());
		header.append(getHeaderField(
				appMessageSource.getMessage("excel.motivo", null, locale))
				.toUpperCase());
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitudes", null, locale)));
		header.append(getHeaderField("%"));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEstadisticaDecisionesHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(
				appMessageSource.getMessage("excel.decision", null, locale))
				.toUpperCase());
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitudes", null, locale)));
		header.append(getHeaderField("%"));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesProductoMotivoHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechapresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.formaspresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.personaconsumidora", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numhecho", null, locale)));
		// header.append(getHeaderField(appMessageSource.getMessage(
		// "excel.establecimiento", null, locale)));

		// new 0132621
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.nbcomercial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.provincia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cp",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.direccionpostal", null, locale)));
		// fin new

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.productoservicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.motivo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.sector", null, locale)));

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.formaventa", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionEstablecimientosHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		// header.append(getHeaderField(appMessageSource.getMessage(
		// "excel.establecimiento", null, locale)));

		// new 0132621
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.nbcomercial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.provincia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cp",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.direccionpostal", null, locale)));
		// fin new

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numhecho", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.decision", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechapresentacion", null, locale)));

		StringBuffer actividadSector = new StringBuffer();
		actividadSector.append(appMessageSource.getMessage("excel.sector",
				null, locale));
		header.append(getHeaderField(actividadSector.toString()));

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.motivo", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionProductosHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.productoservicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numhecho", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechapresentacion", null, locale)));
		// header.append(getHeaderField(appMessageSource.getMessage(
		// "excel.establecimiento", null, locale)));
		// new 0132621
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.nbcomercial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.provincia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cp",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.direccionpostal", null, locale)));
		// fin new

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.decision", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.motivo", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesSinDecisionHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.monitor", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fecha.presentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numhecho", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.nifConsumidor", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.nombreApConsumidor", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.establecimiento", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.diasDesdeFecPresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.indUltimoTramite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.diaHoraUltimoTramite", null, locale)));
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesConDecisionHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechapresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numhecho", null, locale)));

		// header.append(getHeaderField(appMessageSource.getMessage(
		// "excel.establecimiento", null, locale)));
		//
		//
		// new 0132621
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.nbcomercial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.provincia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cp",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.direccionpostal", null, locale)));
		// fin new

		StringBuffer actividadSector = new StringBuffer();
		actividadSector.append(appMessageSource.getMessage("excel.sector",
				null, locale));
		header.append(getHeaderField(actividadSector.toString()));

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.decision", null, locale)));

		header.append(getHeaderField(appMessageSource.getMessage("excel.dias",
				null, locale)));

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.formaventa", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesEstadoExpedientesCursoHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechapresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.tiposolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.recogidopor", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.reclamante", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.reclamado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.tramite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechatramite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.realizadopor", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesTiempoTramitacionHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.reclamante", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechapresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.tramite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechatramite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.dias",
				null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesGeneralHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.monitor", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.tipoSolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fecha.presentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fecha.registro", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.idioma", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.hojasreclamacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.formaspresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.codexporigen", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.tipoident", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.dni",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.nombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.apellido1", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.apellido2", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.telefono1", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.telefono2", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.email",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.edad",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.sexo",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.idioma", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.extranjero", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cp",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.pais",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.direccionpostal", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.provincia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.localidad", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.calle",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.portal", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.compledirec", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cif",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.nbcomercial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.razonsocial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.idioma", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.web",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.sector", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.descripcion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.comentarios", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.contacto", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fecha.cierre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.email",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.telefono1", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.telefono2", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.extranjero", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cp",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.pais",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.direccionpostal", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.provincia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.localidad", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.calle",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.portal", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.compledirec", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fecha.hecho", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.deschecho", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.productoservicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.descripcion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.motivo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.formaventa", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.reclamacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.importe.pretension", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.comentarios", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.ultimotramite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fecha.ulttramite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.decision", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fecha.decision", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesTiempoRealizacionPrimerTramiteHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.organismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numsolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.anyo",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numhecho", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechapresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechaprimertramite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.diasdiferencia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.alarma", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de total de producto.
	 * 
	 * @param totalProducto
	 *            BigDecimal
	 * @param porcentaje
	 *            Float
	 * 
	 * @return String
	 */
	private String getEstadisticaMotivosProductoServicioTotalRow(
			BigDecimal totalProducto, Float porcentaje) {

		StringBuffer row = new StringBuffer();

		row.append("<tr>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");
		row.append("");
		row.append("</td>");
		row.append("<td style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");
		row.append(totalProducto);
		row.append("</td>");
		row.append("<td style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");

		DecimalFormat df = new DecimalFormat("0.00");
		row.append(df.format(porcentaje).toString());

		row.append("</td>");
		row.append("</tr>");

		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param estadisticasSolicitudesResultado
	 *            EstadisticasSolicitudesResultado
	 * @param porcentaje
	 *            Float
	 * @return String
	 */
	private String getEstadisticaMotivosRow(
			EstadisticasSolicitudesResultado estadisticasSolicitudesResultado,
			Float porcentaje) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		String producto = "";
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			if (estadisticasSolicitudesResultado.getFilas().equals("INDEF")) {
				producto = appMessageSource.getMessage("excel.indefinido",
						null, locale).toUpperCase();
			} else {
				producto = estadisticasSolicitudesResultado.getFilas();
			}
			row.append(getField(Y41aUtils.normalizarVacio(producto)));
		} else {
			if (estadisticasSolicitudesResultado.getFilase().equals("INDEF")) {
				producto = appMessageSource.getMessage("excel.indefinido",
						null, locale).toUpperCase();
			} else {
				producto = estadisticasSolicitudesResultado.getFilase();
			}
			row.append(getField(Y41aUtils.normalizarVacio(producto)));
		}

		String motivo = "";
		if (estadisticasSolicitudesResultado.getFilas2().equals("INDEF")) {
			motivo = appMessageSource.getMessage("excel.indefinido", null,
					locale).toUpperCase();
		} else {
			motivo = estadisticasSolicitudesResultado.getFilas2();
		}

		row.append(getField(Y41aUtils.normalizarVacio(motivo)));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(estadisticasSolicitudesResultado
						.getTotal()))));

		DecimalFormat df = new DecimalFormat("0.00");
		row.append(getField(df.format(porcentaje).toString()));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param estadisticasSolicitudesResultado
	 *            EstadisticasSolicitudesResultado
	 * @param porcentaje
	 *            Float
	 * @return String
	 */
	private String getEstadisticaDecisionesRow(
			EstadisticasSolicitudesResultado estadisticasSolicitudesResultado,
			Float porcentaje) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		String decision = "";
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			if (estadisticasSolicitudesResultado.getFilas().equals("INDEF")) {
				decision = appMessageSource.getMessage("excel.indefinido",
						null, locale).toUpperCase();
			} else {
				decision = estadisticasSolicitudesResultado.getFilas();
			}
			row.append(getField(Y41aUtils.normalizarVacio(decision)));
		} else {
			if (estadisticasSolicitudesResultado.getFilase().equals("INDEF")) {
				decision = appMessageSource.getMessage("excel.indefinido",
						null, locale).toUpperCase();
			} else {
				decision = estadisticasSolicitudesResultado.getFilase();
			}
			row.append(getField(Y41aUtils.normalizarVacio(decision)));
		}

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(estadisticasSolicitudesResultado
						.getTotal()))));

		DecimalFormat df = new DecimalFormat("0.00");
		row.append(getField(df.format(porcentaje).toString()));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoSolicitudResultado
	 *            ListadoSolicitudResultado
	 * @return String
	 */
	private String getListadoRelacionSolicitudesProductoMotivoRow(
			ListadoSolicitudResultado listadoSolicitudResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getNumSolicitud())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getDefede(),
						locale.getLanguage()))));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTfpnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTfpnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdnror().toString())));

		/*
		 * StringBuffer establecimiento = new StringBuffer();
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado.getEsnoco()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado
		 * .getEsdireccionCompleta())); establecimiento.append("<br />"); //
		 * salto de linea establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnombreMunicipio()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnombreProvincia()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnorapaisnombre()));
		 * 
		 * row.append(getField(Y41aUtils.normalizarVacio(establecimiento
		 * .toString())));
		 */
		// new 0132621
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnoco())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreProvincia())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreMunicipio())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombrecp())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsdireccionCompleta())));

		// fin new

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getPsnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getPsnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getTirnombre())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombree())));
		}

		StringBuffer formaVenta = new StringBuffer();
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			formaVenta.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getFvnombre()));
		} else {
			formaVenta.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getFvnombree()));
		}
		row.append(getFieldSombreado(formaVenta.toString()));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoSolicitudResultado
	 *            ListadoSolicitudResultado
	 * @return String
	 */
	private String getListadoRelacionEstablecimientosRow(
			ListadoSolicitudResultado listadoSolicitudResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// new 0132621
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnoco())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreProvincia())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreMunicipio())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombrecp())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsdireccionCompleta())));

		// fin new

		/*
		 * StringBuffer establecimiento = new StringBuffer();
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado.getEsnoco()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado
		 * .getEsdireccionCompleta())); establecimiento.append("<br />"); //
		 * salto de linea establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnombreMunicipio()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnombreProvincia()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnorapaisnombre()));
		 * 
		 * row.append(getField(Y41aUtils.normalizarVacio(establecimiento
		 * .toString())));
		 */
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getNumSolicitud())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdnror().toString())));

		StringBuffer decision = new StringBuffer();
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			decision.append(Y41aUtils.normalizarVacio(listadoSolicitudResultado
					.getDenombre()));
		} else {
			decision.append(Y41aUtils.normalizarVacio(listadoSolicitudResultado
					.getDenombree()));
		}
		decision.append("<br />"); // salto de linea
		decision.append("=T(\"");
		decision.append(Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
				listadoSolicitudResultado.getHcfede(), locale.getLanguage())));
		decision.append("\")");

		row.append(getFieldSombreado(decision.toString()));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getDefede(),
						locale.getLanguage()))));

		StringBuffer actividadSector = new StringBuffer();
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getAvnombre()));
			actividadSector.append("<br />"); // salto de linea
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombre()));
		} else {
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getAvnombree()));
			actividadSector.append("<br />"); // salto de linea
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombree()));
		}
		row.append(getField(actividadSector.toString()));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getTirnombre())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoSolicitudResultado
	 *            ListadoSolicitudResultado
	 * @return String
	 */
	private String getListadoRelacionProductosRow(
			ListadoSolicitudResultado listadoSolicitudResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		String producto = "";

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			if (listadoSolicitudResultado.getPsnombre().equals("INDEF")) {
				producto = appMessageSource.getMessage("excel.indefinido",
						null, locale).toUpperCase();
			} else {
				producto = listadoSolicitudResultado.getPsnombre();
			}
			row.append(getField(Y41aUtils.normalizarVacio(producto)));
		} else {
			if (listadoSolicitudResultado.getPsnombree().equals("INDEF")) {
				producto = appMessageSource.getMessage("excel.indefinido",
						null, locale).toUpperCase();
			} else {
				producto = listadoSolicitudResultado.getPsnombree();
			}
			row.append(getField(Y41aUtils.normalizarVacio(producto)));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getNumSolicitud())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdnror().toString())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getDefede(),
						locale.getLanguage()))));

		// new 0132621
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnoco())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreProvincia())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreMunicipio())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombrecp())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsdireccionCompleta())));
		// fin new
		/*
		 * StringBuffer establecimiento = new StringBuffer();
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado.getEsnoco()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado
		 * .getEsdireccionCompleta())); establecimiento.append("<br />"); //
		 * salto de linea establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnombreMunicipio()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnombreProvincia()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnorapaisnombre()));
		 * 
		 * row.append(getField(Y41aUtils.normalizarVacio(establecimiento
		 * .toString())));
		 */
		StringBuffer decision = new StringBuffer();
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			decision.append(Y41aUtils.normalizarVacio(listadoSolicitudResultado
					.getDenombre()));
		} else {
			decision.append(Y41aUtils.normalizarVacio(listadoSolicitudResultado
					.getDenombree()));
		}
		decision.append("<br />"); // salto de linea
		decision.append("=T(\"");
		decision.append(Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
				listadoSolicitudResultado.getHcfede(), locale.getLanguage())));
		decision.append("\")");

		row.append(getFieldSombreado(decision.toString()));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getTirnombre())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoSolicitudResultado
	 *            ListadoSolicitudResultado
	 * @return String
	 */
	private String getListadoRelacionSolicitudesSinDecisionRow(
			ListadoSolicitudResultado listadoSolicitudResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getNumSolicitud())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getDefede(),
						locale.getLanguage()))));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdnror().toString())));

		StringBuffer establecimiento = new StringBuffer();
		establecimiento.append(Y41aUtils
				.normalizarVacio(listadoSolicitudResultado.getEsnoco()));
		establecimiento.append("<br />"); // salto de linea
		establecimiento.append(Y41aUtils
				.normalizarVacio(listadoSolicitudResultado
						.getEsdireccionCompleta()));
		establecimiento.append("<br />"); // salto de linea
		establecimiento.append(Y41aUtils
				.normalizarVacio(listadoSolicitudResultado
						.getEsnombreMunicipio()));
		establecimiento.append("<br />"); // salto de linea
		establecimiento.append(Y41aUtils
				.normalizarVacio(listadoSolicitudResultado
						.getEsnombreProvincia()));

		row.append(getField(Y41aUtils.normalizarVacio(establecimiento
				.toString())));

		StringBuffer actividadSector = new StringBuffer();
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getAvnombre()));
			actividadSector.append("<br />"); // salto de linea
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombre()));
		} else {
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getAvnombree()));
			actividadSector.append("<br />"); // salto de linea
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombree()));
		}
		row.append(getField(actividadSector.toString()));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(listadoSolicitudResultado.getDias()))));

		row.append("</tr>");
		return row.toString();
	}

	private String getListadoRelacionSolicitudesSinDecisionRow(
			HashMap<String, Object> hSolicitud) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		List<ListadoSolicitudResultado> lstSolicitud = (List<ListadoSolicitudResultado>) hSolicitud
				.get("elementos");
		row.append("<tr>");
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(hSolicitud.get(
				"nombre").toString())));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(hSolicitud.get(
				"contador").toString())));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append("</tr>");

		String aux = "";
		for (ListadoSolicitudResultado bean : lstSolicitud) {
			row.append("<tr>");
			row.append(getField(Y41aUtils.normalizarVacio(bean
					.getMonombreDenuncia())));
			row.append(getField(Y41aUtils.normalizarVacio(bean
					.getNumSolicitud())));
			row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
					.parseDateToString(bean.getDefede(), locale.getLanguage()))));
			row.append(getField(Y41aUtils.normalizarVacio(bean.getHdnror()
					.toString())));
			row.append(getField(Y41aUtils.normalizarVacio(bean.getDtnif())));
			row.append(getField(Y41aUtils.normalizarVacio(bean.getDtnombre())));
			row.append(getField(Y41aUtils.normalizarVacio(bean
					.getEsnombreMunicipio())));
			row.append(getField(Y41aUtils.normalizarVacio(bean.getEsnoco())));
			row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
					.convertBigDecimal2String(bean.getDias()))));
			if (locale.getLanguage()
					.equalsIgnoreCase(Y41aConstantes.CASTELLANO)) {
				row.append(getField(Y41aUtils.normalizarVacio(bean
						.getTrnombre())));
			} else {
				row.append(getField(Y41aUtils.normalizarVacio(bean
						.getTrnombree())));
			}
			aux = Y41aUtils.parseDateToString(bean.getEhfecha(),
					locale.getLanguage())
					+ bean.getEhhora();
			row.append(getField(Y41aUtils.normalizarVacio(aux)));
			row.append("</tr>");
		}// end for

		return row.toString();
	}// end getListadoRelacionSolicitudesSinDecisionRow

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoSolicitudResultado
	 *            ListadoSolicitudResultado
	 * @return String
	 */
	private String getListadoRelacionSolicitudesConDecisionRow(
			ListadoSolicitudResultado listadoSolicitudResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getNumSolicitud())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getDefede(),
						locale.getLanguage()))));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdnror().toString())));
		/*
		 * StringBuffer establecimiento = new StringBuffer();
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado.getEsnoco()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado
		 * .getEsdireccionCompleta())); establecimiento.append("<br />"); //
		 * salto de linea establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnombreMunicipio()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnombreProvincia()));
		 * establecimiento.append("<br />"); // salto de linea
		 * establecimiento.append(Y41aUtils
		 * .normalizarVacio(listadoSolicitudResultado .getEsnorapaisnombre()));
		 * 
		 * row.append(getField(Y41aUtils.normalizarVacio(establecimiento
		 * .toString())));
		 */

		// new 0132621
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnoco())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreProvincia())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreMunicipio())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombrecp())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsdireccionCompleta())));

		// fin new

		StringBuffer actividadSector = new StringBuffer();
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getAvnombre()));
			actividadSector.append("<br />"); // salto de linea
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombre()));
		} else {
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getAvnombree()));
			actividadSector.append("<br />"); // salto de linea
			actividadSector.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombree()));
		}
		row.append(getField(actividadSector.toString()));

		StringBuffer decision = new StringBuffer();
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			decision.append(Y41aUtils.normalizarVacio(listadoSolicitudResultado
					.getDenombre()));
		} else {
			decision.append(Y41aUtils.normalizarVacio(listadoSolicitudResultado
					.getDenombree()));
		}
		decision.append("<br />"); // salto de linea
		decision.append("=T(\"");
		decision.append(Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
				listadoSolicitudResultado.getHcfede(), locale.getLanguage())));
		decision.append("\")");

		row.append(getFieldSombreado(decision.toString()));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(listadoSolicitudResultado.getDias()))));

		StringBuffer formaVenta = new StringBuffer();
		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			formaVenta.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getFvnombre()));
		} else {
			formaVenta.append(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getFvnombree()));
		}
		row.append(getFieldSombreado(formaVenta.toString()));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoSolicitudResultado
	 *            ListadoSolicitudResultado
	 * @return String
	 */
	private String getListadoRelacionSolicitudesEstadoExpedientesCursoRow(
			ListadoSolicitudResultado listadoSolicitudResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getNumSolicitud())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getDefede(),
						locale.getLanguage()))));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTsrnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTsrnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getMonombreDenuncia())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnoco())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTrnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTrnombree())));
		}

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getEhfecha(),
						locale.getLanguage()))));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getMonombreTramite())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoSolicitudResultado
	 *            ListadoSolicitudResultado
	 * @return String
	 */
	private String getListadoRelacionSolicitudesTiempoTramitacionRow(
			ListadoSolicitudResultado listadoSolicitudResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getNumSolicitud())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getDefede(),
						locale.getLanguage()))));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTrnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTrnombree())));
		}

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getEhfecha(),
						locale.getLanguage()))));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(listadoSolicitudResultado.getDias()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoSolicitudResultado
	 *            ListadoSolicitudResultado
	 * @return String
	 */
	private String getListadoRelacionSolicitudesGeneralRow(
			ListadoSolicitudResultado listadoSolicitudResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getNumSolicitud())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getMonombreDenuncia())));

		String hdcosc = Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdcosc());

		if (hdcosc.equalsIgnoreCase(Y41aConstantes.TIPO_SOLICITUD_DENUNCIA)) {
			hdcosc = appMessageSource
					.getMessage("excel.denuncia", null, locale);
		} else if (hdcosc.equalsIgnoreCase(Y41aConstantes.TIPO_SOLICITUD_QUEJA)) {
			hdcosc = appMessageSource.getMessage("excel.queja", null, locale);
		} else if (hdcosc
				.equalsIgnoreCase(Y41aConstantes.TIPO_SOLICITUD_RECLAMACION)) {
			hdcosc = appMessageSource.getMessage("excel.reclamacion", null,
					locale);
		}
		row.append(getField(hdcosc));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getDefede(),
						locale.getLanguage()))));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getDefere(),
						locale.getLanguage()))));

		String hdidioma = Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdidioma());
		if (hdidioma.equalsIgnoreCase(Y41aConstantes.CASTELLANO)) {
			hdidioma = appMessageSource.getMessage("excel.castellano", null,
					locale);
		} else if (hdcosc.equalsIgnoreCase(Y41aConstantes.EUSKERA)) {
			hdidioma = appMessageSource.getMessage("excel.euskera", null,
					locale);
		}
		row.append(getField(hdidioma));

		String dehojareclamacion = Y41aUtils
				.normalizarVacio(listadoSolicitudResultado
						.getDehojareclamacion());

		if (dehojareclamacion.equalsIgnoreCase(Y41aConstantes.SI)) {
			dehojareclamacion = appMessageSource.getMessage("excel.si", null,
					locale);
		} else if (dehojareclamacion.equalsIgnoreCase(Y41aConstantes.NO)) {
			dehojareclamacion = appMessageSource.getMessage("excel.no", null,
					locale);
		}
		row.append(getField(dehojareclamacion));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTfpnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTfpnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdcodexpedienteorigen())));

		String dtintipid = Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtintipid());

		if (dtintipid.equalsIgnoreCase(Y41aConstantes.TIPO_IDENTIFICACION_NIF)) {
			dtintipid = appMessageSource.getMessage("excel.nif", null, locale);
		} else if (dtintipid
				.equalsIgnoreCase(Y41aConstantes.TIPO_IDENTIFICACION_NIE)) {
			dtintipid = appMessageSource.getMessage("excel.nie", null, locale);
		} else if (dtintipid
				.equalsIgnoreCase(Y41aConstantes.TIPO_IDENTIFICACION_IDEXTR)) {
			dtintipid = appMessageSource.getMessage("excel.idextr", null,
					locale);
		}
		row.append(getField(dtintipid));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnif())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtapellido1())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtapellido2())));

		row.append(getFieldTexto(Y41aUtils
				.normalizarVacio(listadoSolicitudResultado.getDtnrtel())));

		row.append(getFieldTexto(Y41aUtils
				.normalizarVacio(listadoSolicitudResultado.getDtnrtel2())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDttecoem())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnran())));

		String dtcosx = Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtcosx());

		if (dtcosx.equalsIgnoreCase(Y41aConstantes.SEXO_HOMBRE)) {
			dtcosx = appMessageSource.getMessage("excel.hombre", null, locale);
		} else if (dtcosx.equalsIgnoreCase(Y41aConstantes.SEXO_MUJER)) {
			dtcosx = appMessageSource.getMessage("excel.mujer", null, locale);
		}
		row.append(getField(dtcosx));

		String dtcoidco = Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtcoidco());

		if (dtcoidco.equalsIgnoreCase(Y41aConstantes.VC_CASTELLANO)) {
			dtcoidco = appMessageSource.getMessage("excel.castellano", null,
					locale);
		} else if (dtcoidco.equalsIgnoreCase(Y41aConstantes.VC_EUSKERA)) {
			dtcoidco = appMessageSource.getMessage("excel.euskera", null,
					locale);
		}
		row.append(getField(dtcoidco));

		String dtextranjero = Y41aUtils
				.normalizarVacio(listadoSolicitudResultado.getDtextranjero());

		if (dtextranjero.equalsIgnoreCase(Y41aConstantes.SI)) {
			dtextranjero = appMessageSource
					.getMessage("excel.si", null, locale);
		} else if (dtextranjero.equalsIgnoreCase(Y41aConstantes.NO)) {
			dtextranjero = appMessageSource
					.getMessage("excel.no", null, locale);
		}
		row.append(getField(dtextranjero));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre_cp())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnora_pais_nombre())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtdireccion_nocapv())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre_provincia())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre_municipio())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre_localidad())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre_calle())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre_portal())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDtnombre_piso())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnif())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnoco())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombre())));

		String escoidco = Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEscoidco());

		if (escoidco.equalsIgnoreCase(Y41aConstantes.VC_CASTELLANO)) {
			escoidco = appMessageSource.getMessage("excel.castellano", null,
					locale);
		} else if (escoidco.equalsIgnoreCase(Y41aConstantes.VC_EUSKERA)) {
			escoidco = appMessageSource.getMessage("excel.euskera", null,
					locale);
		}
		row.append(getField(escoidco));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsteurl())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getSecodigo())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getSenombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsteco())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnopeco())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getEsfeba(),
						locale.getLanguage()))));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEscoem())));

		row.append(getFieldTexto(Y41aUtils
				.normalizarVacio(listadoSolicitudResultado.getEsnrtel())));

		row.append(getFieldTexto(Y41aUtils
				.normalizarVacio(listadoSolicitudResultado.getEsnrtel2())));

		String esextranjero = Y41aUtils
				.normalizarVacio(listadoSolicitudResultado.getEsextranjero());

		if (esextranjero.equalsIgnoreCase(Y41aConstantes.SI)) {
			esextranjero = appMessageSource
					.getMessage("excel.si", null, locale);
		} else if (esextranjero.equalsIgnoreCase(Y41aConstantes.NO)) {
			esextranjero = appMessageSource
					.getMessage("excel.no", null, locale);
		}
		row.append(getField(esextranjero));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombrecp())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnorapaisnombre())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsdireccion_nocapv())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreProvincia())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreMunicipio())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreLocalidad())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombreCalle())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombrePortal())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getEsnombrePiso())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getHdfehd(),
						locale.getLanguage()))));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdte())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getPscodigo())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getPsnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getPsnombree())));
		}

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTrnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTrnombree())));
		}

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getFvnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getFvnombree())));
		}

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTsrnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTsrnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdcaptso())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdteso())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTrnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getTrnombree())));
		}

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getEhfecha(),
						locale.getLanguage()))));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getDenombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoSolicitudResultado.getDenombree())));
		}

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getHcfede(),
						locale.getLanguage()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoSolicitudResultado
	 *            ListadoSolicitudResultado
	 * @return String
	 */
	private String getListadoRelacionSolicitudesTiempoRealizacionPrimerTramiteRow(
			ListadoSolicitudResultado listadoSolicitudResultado,
			int registroActual) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getFieldFecha(Y41aUtils
				.normalizarVacio(listadoSolicitudResultado.getDecoor())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDenror().toString())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getDenran().toString())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoSolicitudResultado
				.getHdnror().toString())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getHcfede(),
						locale.getLanguage()))));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoSolicitudResultado.getEhfecha(),
						locale.getLanguage()))));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(listadoSolicitudResultado.getDias()))));

		// TODO Escribir la formula en el campo alarma SI($F$8<=F14;"!!!";"")
		StringBuffer alarmaTxt = new StringBuffer();
		alarmaTxt.append("=SI($F$").append(numCriteriosBusqueda + 6)
				.append("<=G")
				.append(registroActual + numCriteriosBusqueda + 8)
				.append(";\"!!!\";\"\")");
		row.append(getField(alarmaTxt.toString()));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @param total
	 *            BigDecimal
	 * @return String
	 */
	private String getEstadisticaMotivosTotalRow(BigDecimal total) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();

		row.append("<tr>");

		row.append(getField(""));

		row.append(getField(""));

		row.append(getField(""));

		row.append(getField(""));

		row.append("</tr>");

		row.append("<tr style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");

		row.append(getField(appMessageSource.getMessage("excel.total", null,
				locale)));

		row.append(getField(""));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(total))));

		row.append(getField("100"));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @param total
	 *            BigDecimal
	 * @return String
	 */
	private String getEstadisticaDecisionesTotalRow(BigDecimal total) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();

		row.append("<tr style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");

		row.append(getField(appMessageSource.getMessage("excel.total", null,
				locale)));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(total))));

		row.append(getField("100"));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @return String
	 */
	private String getListadoRelacionSolicitudesTiempoRealizacionPrimerTramiteMiddleRow() {

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();

		row.append("<table>");
		row.append("<tr>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td style='BACKGROUND-COLOR: #808080;'>");
		row.append(appMessageSource.getMessage("excel.mensajealarmanumdias",
				null, locale));
		row.append("</td>");

		row.append("<td style='BACKGROUND-COLOR: #808080;COLOR: black'>");
		row.append("1");
		row.append("</td>");

		row.append("</tr>");
		row.append("<tr>");
		row.append("</tr>");

		row.append("</table>");

		return row.toString();
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaDecisionMunicipioEstablecimientoDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {
		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (estadisticasSolicitudesResultadoAux.getColumnas().equals(
					"INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasSolicitudesResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de decision
		List<String> listDecision = new ArrayList<String>();

		String decision = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultadoAux.getFilas().equals(
						"INDEF")) {
					decision = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					decision = estadisticasSolicitudesResultadoAux.getFilas();
				}

				if (!listDecision.contains(decision)) {
					listDecision.add(decision);
				}
			} else {
				if (estadisticasSolicitudesResultadoAux.getFilase().equals(
						"INDEF")) {
					decision = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					decision = estadisticasSolicitudesResultadoAux.getFilase();
				}

				if (!listDecision.contains(decision)) {
					listDecision.add(decision);
				}
			}
		}

		Collections.sort(listDecision);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 1; // el doble de
																// localidades +
																// 2 para los
																// totales + 1
																// porque A1 es
																// blanca
		int intFilas = (listDecision.size()) + 1 + 1; // el nº de
														// formas
														// presentacion
														// + 1 para los
														// totales + 1
														// porque A1 es
														// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.decision", null,
				locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String decisionAux : listDecision) {
			datos[intFilas][1] = decisionAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						decision = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						decision = estadisticasSolicitudesResultadoAux
								.getFilas();
					}

					if ((datos[intFilas][1]).equals(decision)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasSolicitudesResultadoAux.getFilase().equals(
							"INDEF")) {
						decision = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						decision = estadisticasSolicitudesResultadoAux
								.getFilase();
					}

					if ((datos[intFilas][1]).equals(decision)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaDecisionMunicipioConsumidorDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {

		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (estadisticasSolicitudesResultadoAux.getColumnas().equals(
					"INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasSolicitudesResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de decision
		List<String> listDecision = new ArrayList<String>();

		String decision = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultadoAux.getFilas().equals(
						"INDEF")) {
					decision = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					decision = estadisticasSolicitudesResultadoAux.getFilas();
				}

				if (!listDecision.contains(decision)) {
					listDecision.add(decision);
				}
			} else {
				if (estadisticasSolicitudesResultadoAux.getFilase().equals(
						"INDEF")) {
					decision = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					decision = estadisticasSolicitudesResultadoAux.getFilase();
				}

				if (!listDecision.contains(decision)) {
					listDecision.add(decision);
				}
			}
		}

		Collections.sort(listDecision);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 1; // el doble de
																// localidades +
																// 2 para los
																// totales + 1
																// porque A1 es
																// blanca
		int intFilas = (listDecision.size()) + 1 + 1; // el nº de
														// formas
														// presentacion
														// + 1 para los
														// totales + 1
														// porque A1 es
														// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.decision", null,
				locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String decisionAux : listDecision) {
			datos[intFilas][1] = decisionAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						decision = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						decision = estadisticasSolicitudesResultadoAux
								.getFilas();
					}

					if ((datos[intFilas][1]).equals(decision)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasSolicitudesResultadoAux.getFilase().equals(
							"INDEF")) {
						decision = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						decision = estadisticasSolicitudesResultadoAux
								.getFilase();
					}

					if ((datos[intFilas][1]).equals(decision)) {

						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaSectorMunicipioEstablecimientoDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {

		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (estadisticasSolicitudesResultadoAux.getColumnas().equals(
					"INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasSolicitudesResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de sector
		List<String> listSector = new ArrayList<String>();

		String sector = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultadoAux.getFilas().equals(
						"INDEF")) {
					sector = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					sector = estadisticasSolicitudesResultadoAux.getFilas();
				}

				if (!listSector.contains(sector)) {
					listSector.add(sector);
				}

			} else {
				if (estadisticasSolicitudesResultadoAux.getFilase().equals(
						"INDEF")) {
					sector = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					sector = estadisticasSolicitudesResultadoAux.getFilase();
				}

				if (!listSector.contains(sector)) {
					listSector.add(sector);
				}
			}
		}

		Collections.sort(listSector);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 1; // el doble de
																// localidades +
																// 2 para los
																// totales + 1
																// porque A1 es
																// blanca
		int intFilas = (listSector.size()) + 1 + 1; // el nº de
													// formas
													// presentacion
													// + 1 para los
													// totales + 1
													// porque A1 es
													// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.sector", null, locale)
				.toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String decisionAux : listSector) {
			datos[intFilas][1] = decisionAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						sector = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						sector = estadisticasSolicitudesResultadoAux.getFilas();
					}
					if ((datos[intFilas][1]).equals(sector)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasSolicitudesResultadoAux.getFilase().equals(
							"INDEF")) {
						sector = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						sector = estadisticasSolicitudesResultadoAux
								.getFilase();
					}
					if ((datos[intFilas][1]).equals(sector)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaFormaPresentacionMunicipioConsumidorDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {

		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (estadisticasSolicitudesResultadoAux.getFilas().equals("INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasSolicitudesResultadoAux.getFilas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de forma presentacion
		List<String> listFormaPresentacion = new ArrayList<String>();

		String formaPresentacion = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultadoAux.getColumnas().equals(
						"INDEF")) {
					formaPresentacion = appMessageSource.getMessage(
							"excel.indefinido", null, locale).toUpperCase();
				} else {
					formaPresentacion = estadisticasSolicitudesResultadoAux
							.getColumnas();
				}

				if (!listFormaPresentacion.contains(formaPresentacion)) {
					listFormaPresentacion.add(formaPresentacion);
				}
			} else {
				if (estadisticasSolicitudesResultadoAux.getColumnase().equals(
						"INDEF")) {
					formaPresentacion = appMessageSource.getMessage(
							"excel.indefinido", null, locale).toUpperCase();
				} else {
					formaPresentacion = estadisticasSolicitudesResultadoAux
							.getColumnase();
				}

				if (!listFormaPresentacion.contains(formaPresentacion)) {
					listFormaPresentacion.add(formaPresentacion);
				}
			}
		}

		Collections.sort(listFormaPresentacion);

		// 3.- Inicializamos en el array general
		int intColumnas = (listFormaPresentacion.size() * 2) + 2 + 1; // el
																		// doble
																		// de
		// localidades +
		// 2 para los
		// totales + 1
		// porque A1 es
		// blanca
		int intFilas = (listMunicipios.size()) + 1 + 1; // el nº de
														// formas
														// presentacion
														// + 1 para los
														// totales + 1
														// porque A1 es
														// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String formaPresentacionAux : listFormaPresentacion) {
			datos[1][intColumnas] = formaPresentacionAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.municipio", null,
				locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String municipioAux : listMunicipios) {
			datos[intFilas][1] = municipioAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						municipio = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						municipio = estadisticasSolicitudesResultadoAux
								.getFilas();
					}
					if ((datos[intFilas][1]).equals(municipio)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								formaPresentacion = appMessageSource
										.getMessage("excel.indefinido", null,
												locale).toUpperCase();
							} else {
								formaPresentacion = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas])
									.equals(formaPresentacion)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						municipio = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						municipio = estadisticasSolicitudesResultadoAux
								.getFilas();
					}
					if ((datos[intFilas][1]).equals(municipio)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnase().equals("INDEF")) {
								formaPresentacion = appMessageSource
										.getMessage("excel.indefinido", null,
												locale).toUpperCase();
							} else {
								formaPresentacion = estadisticasSolicitudesResultadoAux
										.getColumnase();
							}
							if ((datos[1][intColumnas])
									.equals(formaPresentacion)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaFormaVentaMunicipioConsumidorDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {

		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (estadisticasSolicitudesResultadoAux.getFilas().equals("INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasSolicitudesResultadoAux.getFilas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de forma venta
		List<String> listFormaVenta = new ArrayList<String>();

		String formaVenta = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultadoAux.getColumnas().equals(
						"INDEF")) {
					formaVenta = appMessageSource.getMessage(
							"excel.indefinido", null, locale).toUpperCase();
				} else {
					formaVenta = estadisticasSolicitudesResultadoAux
							.getColumnas();
				}

				if (!listFormaVenta.contains(formaVenta)) {
					listFormaVenta.add(formaVenta);
				}
			} else {
				if (estadisticasSolicitudesResultadoAux.getColumnase().equals(
						"INDEF")) {
					formaVenta = appMessageSource.getMessage(
							"excel.indefinido", null, locale).toUpperCase();
				} else {
					formaVenta = estadisticasSolicitudesResultadoAux
							.getColumnase();
				}

				if (!listFormaVenta.contains(formaVenta)) {
					listFormaVenta.add(formaVenta);
				}
			}
		}

		Collections.sort(listFormaVenta);

		// 3.- Inicializamos en el array general
		int intColumnas = (listFormaVenta.size() * 2) + 2 + 1; // el
																// doble
																// de
		// localidades +
		// 2 para los
		// totales + 1
		// porque A1 es
		// blanca
		int intFilas = (listMunicipios.size()) + 1 + 1; // el nº de
														// formas
														// presentacion
														// + 1 para los
														// totales + 1
														// porque A1 es
														// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String formaPresentacionAux : listFormaVenta) {
			datos[1][intColumnas] = formaPresentacionAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.municipio", null,
				locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String municipioAux : listMunicipios) {
			datos[intFilas][1] = municipioAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						municipio = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						municipio = estadisticasSolicitudesResultadoAux
								.getFilas();
					}
					if ((datos[intFilas][1]).equals(municipio)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								formaVenta = appMessageSource.getMessage(
										"excel.indefinido", null, locale)
										.toUpperCase();
							} else {
								formaVenta = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(formaVenta)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						municipio = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						municipio = estadisticasSolicitudesResultadoAux
								.getFilas();
					}
					if ((datos[intFilas][1]).equals(municipio)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnase().equals("INDEF")) {
								formaVenta = appMessageSource.getMessage(
										"excel.indefinido", null, locale)
										.toUpperCase();
							} else {
								formaVenta = estadisticasSolicitudesResultadoAux
										.getColumnase();
							}
							if ((datos[1][intColumnas]).equals(formaVenta)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaSectorMunicipioConsumidorDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {

		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (estadisticasSolicitudesResultadoAux.getColumnas().equals(
					"INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasSolicitudesResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de sector
		List<String> listSector = new ArrayList<String>();

		String sector = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultadoAux.getFilas().equals(
						"INDEF")) {
					sector = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					sector = estadisticasSolicitudesResultadoAux.getFilas();
				}

				if (!listSector.contains(sector)) {
					listSector.add(sector);
				}
			} else {
				if (estadisticasSolicitudesResultadoAux.getFilase().equals(
						"INDEF")) {
					sector = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					sector = estadisticasSolicitudesResultadoAux.getFilase();
				}

				if (!listSector.contains(sector)) {
					listSector.add(sector);
				}
			}
		}

		Collections.sort(listSector);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 1; // el doble de
																// localidades +
																// 2 para los
																// totales + 1
																// porque A1 es
																// blanca
		int intFilas = (listSector.size()) + 1 + 1; // el nº de
													// formas
													// presentacion
													// + 1 para los
													// totales + 1
													// porque A1 es
													// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.sector", null, locale)
				.toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String decisionAux : listSector) {
			datos[intFilas][1] = decisionAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						sector = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						sector = estadisticasSolicitudesResultadoAux.getFilas();
					}
					if ((datos[intFilas][1]).equals(sector)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasSolicitudesResultadoAux.getFilase().equals(
							"INDEF")) {
						sector = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						sector = estadisticasSolicitudesResultadoAux
								.getFilase();
					}
					if ((datos[intFilas][1]).equals(sector)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaSexoEdadDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {

		// 1.- Inicializamos el array de sexo
		List<String> listSexo = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String sexo = "";
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {

			if (estadisticasSolicitudesResultadoAux.getColumnas().equals("H")) {
				sexo = appMessageSource.getMessage("excel.sexohombre", null,
						locale);
			} else if (estadisticasSolicitudesResultadoAux.getColumnas()
					.equals("M")) {
				sexo = appMessageSource.getMessage("excel.sexomujer", null,
						locale);
			} else {
				sexo = appMessageSource.getMessage("excel.sexoindefinido",
						null, locale);
			}

			if (!listSexo.contains(sexo)) {
				listSexo.add(sexo);
			}
		}

		Collections.sort(listSexo);

		// 2.- Inicializamos el array de rango edad
		List<String> listRangoEdad = new ArrayList<String>();

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (!listRangoEdad.contains(estadisticasSolicitudesResultadoAux
					.getFilas())) {
				listRangoEdad.add(estadisticasSolicitudesResultadoAux
						.getFilas());
			}
		}

		Collections.sort(listRangoEdad);

		// 3.- Inicializamos en el array general
		int intColumnas = (listSexo.size() * 2) + 2 + 1; // el doble de
															// localidades +
															// 2 para los
															// totales + 1
															// porque A1 es
															// blanca
		int intFilas = (listRangoEdad.size()) + 1 + 1; // el nº de
														// formas
														// presentacion
														// + 1 para los
														// totales + 1
														// porque A1 es
														// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// Columnas
		intColumnas = 2;

		for (String sexoAux : listSexo) {
			datos[1][intColumnas] = sexoAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.rangoedad", null,
				locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String rangoEdadAux : listRangoEdad) {
			datos[intFilas][1] = rangoEdadAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if ((datos[intFilas][1])
						.equals(estadisticasSolicitudesResultadoAux.getFilas())) {
					for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
						if (estadisticasSolicitudesResultadoAux.getColumnas()
								.equals("H")) {
							sexo = appMessageSource.getMessage(
									"excel.sexohombre", null, locale);
						} else if (estadisticasSolicitudesResultadoAux
								.getColumnas().equals("M")) {
							sexo = appMessageSource.getMessage(
									"excel.sexomujer", null, locale);
						} else {
							sexo = appMessageSource.getMessage(
									"excel.sexoindefinido", null, locale);
						}
						if ((datos[1][intColumnas]).equals(sexo)) {
							if (datos[intFilas][intColumnas] == null) {
								datos[intFilas][intColumnas] = "0";
							}
							datos[intFilas][intColumnas] = new BigDecimal(
									datos[intFilas][intColumnas]).add(
									estadisticasSolicitudesResultadoAux
											.getTotal()).toString();
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaPromedioTiempoResolverSolicitudDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {

		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (estadisticasSolicitudesResultadoAux.getColumnas().equals(
					"INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasSolicitudesResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de decision
		List<String> listDecision = new ArrayList<String>();
		String decision = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultadoAux.getFilas().equals(
						"INDEF")) {
					decision = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					decision = estadisticasSolicitudesResultadoAux.getFilas();
				}

				if (!listDecision.contains(decision)) {
					listDecision.add(decision);
				}
			} else {
				if (estadisticasSolicitudesResultadoAux.getFilase().equals(
						"INDEF")) {
					decision = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					decision = estadisticasSolicitudesResultadoAux.getFilase();
				}

				if (!listDecision.contains(decision)) {
					listDecision.add(decision);
				}
			}

		}

		Collections.sort(listDecision);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 1; // el doble de
																// localidades +
																// 2 para los
																// totales + 1
																// porque A1 es
																// blanca
		int intFilas = (listDecision.size()) + 1 + 1; // el nº de
														// formas
														// presentacion
														// + 1 para los
														// totales + 1
														// porque A1 es
														// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.decision", null,
				locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String decisionAux : listDecision) {
			datos[intFilas][1] = decisionAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						decision = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						decision = estadisticasSolicitudesResultadoAux
								.getFilas();
					}

					if ((datos[intFilas][1]).equals(decision)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasSolicitudesResultadoAux.getFilase().equals(
							"INDEF")) {
						decision = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						decision = estadisticasSolicitudesResultadoAux
								.getFilase();
					}

					if ((datos[intFilas][1]).equals(decision)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaProductoMunicipioEstablecimientoDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {
		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (estadisticasSolicitudesResultadoAux.getColumnas().equals(
					"INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasSolicitudesResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de producto
		List<String> listProducto = new ArrayList<String>();
		String producto = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultadoAux.getFilas().equals(
						"INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					producto = estadisticasSolicitudesResultadoAux.getFilas();
				}

				if (!listProducto.contains(producto)) {
					listProducto.add(producto);
				}
			} else {
				if (estadisticasSolicitudesResultadoAux.getFilase().equals(
						"INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					producto = estadisticasSolicitudesResultadoAux.getFilase();
				}

				if (!listProducto.contains(producto)) {
					listProducto.add(producto);
				}
			}
		}

		Collections.sort(listProducto);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 1; // el doble de
																// localidades +
																// 2 para los
																// totales + 1
																// porque A1 es
																// blanca
		int intFilas = (listProducto.size()) + 1 + 1; // el nº de
														// formas
														// presentacion
														// + 1 para los
														// totales + 1
														// porque A1 es
														// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.productoservicio",
				null, locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String productoAux : listProducto) {
			datos[intFilas][1] = productoAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						producto = estadisticasSolicitudesResultadoAux
								.getFilas();
					}
					if ((datos[intFilas][1]).equals(producto)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasSolicitudesResultadoAux.getFilase().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						producto = estadisticasSolicitudesResultadoAux
								.getFilase();
					}
					if ((datos[intFilas][1]).equals(producto)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasSolicitudesResultado
	 *            List<EstadisticasSolicitudesResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaProductoMunicipioConsumidorDataVector(
			List<EstadisticasSolicitudesResultado> listEstadisticasSolicitudesResultado) {
		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (estadisticasSolicitudesResultadoAux.getColumnas().equals(
					"INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasSolicitudesResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de producto
		List<String> listProducto = new ArrayList<String>();
		String producto = "";

		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasSolicitudesResultadoAux.getFilas().equals(
						"INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					producto = estadisticasSolicitudesResultadoAux.getFilas();
				}

				if (!listProducto.contains(producto)) {
					listProducto.add(producto);
				}
			} else {
				if (estadisticasSolicitudesResultadoAux.getFilase().equals(
						"INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale).toUpperCase();
				} else {
					producto = estadisticasSolicitudesResultadoAux.getFilase();
				}

				if (!listProducto.contains(producto)) {
					listProducto.add(producto);
				}
			}
		}

		Collections.sort(listProducto);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 1; // el doble de
																// localidades +
																// 2 para los
																// totales + 1
																// porque A1 es
																// blanca
		int intFilas = (listProducto.size()) + 1 + 1; // el nº de
														// formas
														// presentacion
														// + 1 para los
														// totales + 1
														// porque A1 es
														// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.productoservicio",
				null, locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String productoAux : listProducto) {
			datos[intFilas][1] = productoAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -
		for (EstadisticasSolicitudesResultado estadisticasSolicitudesResultadoAux : listEstadisticasSolicitudesResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasSolicitudesResultadoAux.getFilas().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						producto = estadisticasSolicitudesResultadoAux
								.getFilas();
					}
					if ((datos[intFilas][1]).equals(producto)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasSolicitudesResultadoAux.getFilase().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						producto = estadisticasSolicitudesResultadoAux
								.getFilase();
					}
					if ((datos[intFilas][1]).equals(producto)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasSolicitudesResultadoAux
									.getColumnas().equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasSolicitudesResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasSolicitudesResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar cabecera.
	 * 
	 * @param datos
	 *            String[][]
	 * 
	 * @return String
	 */
	private String getEstadisticaHeaderRow(String[][] datos) {
		StringBuffer header = new StringBuffer();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		for (int intColumnas = 1; intColumnas < datos[1].length; intColumnas++) {
			header.append(getHeaderField(datos[1][intColumnas]));
		}

		header.append("</tr>");

		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param datos
	 *            String[][]
	 * 
	 * @return String
	 */
	private String getEstadisticaRows(String[][] datos) {

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();

		String elementoAnterior = "";
		for (int intFilas = 2; intFilas < datos.length; intFilas++) {
			if ((datos[intFilas][1]).equals(appMessageSource.getMessage(
					"excel.total", null, locale))) {
				row.append("<tr style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");
			} else {
				row.append("<tr>");
			}
			for (int intColumnas = 1; intColumnas < datos[intFilas].length; intColumnas++) {
				if (intColumnas == 1) {
					if ((datos[intFilas][intColumnas]).equals(elementoAnterior)) {
						row.append(getField(""));
					} else {
						elementoAnterior = datos[intFilas][intColumnas];
						row.append(getField(datos[intFilas][intColumnas]));
					}
				} else {
					row.append(getField(datos[intFilas][intColumnas]));
				}
			}
			row.append("</tr>");
		}

		return row.toString();
	}

	/**
	 * Generar cabeceras.
	 * 
	 * @param fieldName
	 *            String
	 * @return String
	 */
	private static String getHeaderField(String fieldName) {
		StringBuffer field = new StringBuffer();
		field.append("<th>");
		field.append(Y41aUtils.normalizarVacio(fieldName));
		field.append("</th>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getField(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>");
		field.append(Y41aUtils.normalizarVacio(fieldValue));
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldSombreado(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td style='BACKGROUND-COLOR: #D8D8D8;'>");
		field.append(Y41aUtils.normalizarVacio(fieldValue));
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldTexto(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>=ESPACIOS(\"");
		field.append(Y41aUtils.normalizarVacio(fieldValue));
		field.append("\")</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldFecha(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>");
		field.append("=T(\"");
		field.append(Y41aUtils.normalizarVacio(fieldValue));
		field.append("\")");
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return StringBuffer
	 * 
	 */
	private StringBuffer crearCriteriosBusqueda(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {

		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer xslStringCriterios = new StringBuffer();

		// Código organismo
		if (solicitudesBusqueda.getDecoor() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.codorganismo", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getDecoor());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// NUMERO REGISTRO
		if (solicitudesBusqueda.getDenror() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.numregistro", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getDenror());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Año
		if (solicitudesBusqueda.getDenran() != null) {

			xslStringCriterios.append(appMessageSource.getMessage("excel.anyo",
					null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getDenran());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Ind. Gestion

		if (solicitudesBusqueda.getIndGestion() != null) {
			String strIndGestion = "";
			if (solicitudesBusqueda.getIndGestion().equalsIgnoreCase(
					Y41aConstantes.SOLICITUDES_MIGESTION)) {
				strIndGestion = appMessageSource.getMessage(
						"excel.estado.miGestion", null, locale);
			} else if (solicitudesBusqueda.getIndGestion().equalsIgnoreCase(
					Y41aConstantes.SOLICITUDES_TODAS)) {
				strIndGestion = appMessageSource.getMessage(
						"excel.estado.todas", null, locale);
			} else if (solicitudesBusqueda.getIndGestion().equalsIgnoreCase(
					Y41aConstantes.SOLICITUDES_RECIBIDAS)) {
				strIndGestion = appMessageSource.getMessage(
						"excel.estado.recibidas", null, locale);
			} else if (solicitudesBusqueda.getIndGestion().equalsIgnoreCase(
					Y41aConstantes.SOLICITUDES_TRASLADADAS)) {
				strIndGestion = appMessageSource.getMessage(
						"excel.estado.trasladadas", null, locale);
			} else if (solicitudesBusqueda.getIndGestion().equalsIgnoreCase(
					Y41aConstantes.SOLICITUDES_ARBITRAJE)) {
				strIndGestion = appMessageSource.getMessage(
						"excel.estado.arbitraje", null, locale);
			}

			if (strIndGestion.length() != 0) {

				xslStringCriterios.append(appMessageSource.getMessage(
						"excel.indgestion", null, locale));
				xslStringCriterios.append(": ").append(strIndGestion);
				xslStringCriterios.append("<br/>");
				numCriteriosBusqueda++;
			}
		}

		// FECHA PRESENTACION DESDE - HASTA
		String strFechaPresentacionDesde = "";
		String strFechaPresentacionHasta = "";

		String idioma = locale.getLanguage();

		if (defedeDesde != null) {
			strFechaPresentacionDesde = appMessageSource.getMessage(
					"excel.fechadesde", null, locale)
					+ ": "
					+ Y41aUtils.parseDateToString(defedeDesde, idioma);
		}
		if (defedeHasta != null) {
			strFechaPresentacionHasta = appMessageSource.getMessage(
					"excel.fechahasta", null, locale)
					+ ": "
					+ Y41aUtils.parseDateToString(defedeHasta, idioma);
		}
		String strFechaPresentacion = "";

		if (strFechaPresentacionDesde.length() != 0
				|| strFechaPresentacionHasta.length() != 0) {
			strFechaPresentacion = strFechaPresentacionDesde + " "
					+ strFechaPresentacionHasta;

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.fecha.presentacion", null, locale));
			xslStringCriterios.append(", ").append(strFechaPresentacion);
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Tipo de solicitud
		if (solicitudesBusqueda.getHdcosc() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.tipoSolicitud", null, locale));
			xslStringCriterios.append(": ");
			if (solicitudesBusqueda.getHdcosc().equalsIgnoreCase(
					Y41aConstantes.TIPO_SOLICITUD_DENUNCIA)) {
				xslStringCriterios.append(appMessageSource.getMessage(
						"excel.tipoSolicitud.denuncia", null, locale));

			} else if (solicitudesBusqueda.getHdcosc().equalsIgnoreCase(
					Y41aConstantes.TIPO_SOLICITUD_QUEJA)) {
				xslStringCriterios.append(appMessageSource.getMessage(
						"excel.tipoSolicitud.queja", null, locale));

			} else if (solicitudesBusqueda.getHdcosc().equalsIgnoreCase(
					Y41aConstantes.TIPO_SOLICITUD_RECLAMACION)) {
				xslStringCriterios.append(appMessageSource.getMessage(
						"excel.tipoSolicitud.reclamacion", null, locale));
			}
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// FECHA Registro DESDE - HASTA
		String strFechaRegistroDesde = "";
		String strFechaRegistroHasta = "";

		if (defereDesde != null) {
			strFechaRegistroDesde = appMessageSource.getMessage(
					"excel.fechadesde", null, locale)
					+ ": "
					+ Y41aUtils.parseDateToString(defereDesde, idioma);
		}
		if (defereHasta != null) {
			strFechaRegistroHasta = appMessageSource.getMessage(
					"excel.fechahasta", null, locale)
					+ ": "
					+ Y41aUtils.parseDateToString(defereHasta, idioma);
		}
		String strFechaRegistro = "";

		if (strFechaRegistroDesde.length() != 0
				|| strFechaRegistroHasta.length() != 0) {
			strFechaRegistro = strFechaRegistroDesde + " "
					+ strFechaRegistroHasta;

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.fecha.registro", null, locale));
			xslStringCriterios.append(", ").append(strFechaRegistro);
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// FORMA DE PRESENTACION
		if (solicitudesBusqueda.getTfpcodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.formaspresentacion", null, locale));
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getTfpnombre()));
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getTfpnombree()));
			}
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// CLASIFICACION
		// Sector
		if (solicitudesBusqueda.getSecodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.sector", null, locale));
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getSenombre()));
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getSenombree()));
			}
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// producto/servicio
		if (solicitudesBusqueda.getPscodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.productoservicio", null, locale));
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getPsnombre()));
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getPsnombree()));
			}
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// motivo
		if (solicitudesBusqueda.getTircodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.motivo", null, locale));
			xslStringCriterios.append(": ").append(
					Y41aUtils.normalizarVacio(solicitudesBusqueda
							.getTirnombre()));
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// TRAMITACION
		// Tramite
		if (solicitudesBusqueda.getTrcodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.tramite", null, locale));
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getTrnombre()));
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getTrnombree()));
			}
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Ultimo tramite
		if (solicitudesBusqueda.getIndUltimoTramite() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.indUltimoTramite", null, locale));
			if (Y41aConstantes.SI.equals(solicitudesBusqueda
					.getIndUltimoTramite())) {
				xslStringCriterios.append(": ").append(
						Y41aConstantes.SI_COMPLETO);
			} else {
				xslStringCriterios.append(": ").append(
						Y41aConstantes.NO_COMPLETO);
			}
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// decision
		if (solicitudesBusqueda.getDecodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.decision", null, locale));
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getDenombre()));
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(solicitudesBusqueda
								.getDenombree()));
			}
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// FECHA Decision DESDE - HASTA
		String strFechaDecisionDesde = "";
		String strFechaDecisionHasta = "";

		if (hcfedeDesde != null) {
			strFechaDecisionDesde = appMessageSource.getMessage(
					"excel.fechadesde", null, locale)
					+ ": "
					+ Y41aUtils.parseDateToString(hcfedeDesde, idioma);
		}
		if (hcfedeHasta != null) {
			strFechaDecisionHasta = appMessageSource.getMessage(
					"excel.fechahasta", null, locale)
					+ ": "
					+ Y41aUtils.parseDateToString(hcfedeHasta, idioma);
		}
		String strFechaDecision = "";

		if (strFechaDecisionDesde.length() != 0
				|| strFechaDecisionHasta.length() != 0) {
			strFechaDecision = strFechaDecisionDesde + " "
					+ strFechaDecisionHasta;

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.fecha.decision", null, locale));
			xslStringCriterios.append(", ").append(strFechaDecision);
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// PERSONA CONSUMIDORA
		// DNI
		if (solicitudesBusqueda.getDtnif() != null) {

			xslStringCriterios.append(appMessageSource.getMessage("excel.dni",
					null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getDtnif());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Nombre
		if (solicitudesBusqueda.getDtnombre() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.nombre", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getDtnombre());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Provincia
		if (solicitudesBusqueda.getDtnoraProvinciaId() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.provincia", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getDtnombreProvincia());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Municipio
		if (solicitudesBusqueda.getDtnoraMunicipioId() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.municipio", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getDtnombreMunicipio());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Localidad
		if (solicitudesBusqueda.getDtnoraLocalidadId() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.localidad", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getDtnombreLocalidad());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// ESTABLECIMIENTO
		// CIF
		if (solicitudesBusqueda.getEsnif() != null) {

			xslStringCriterios.append(appMessageSource.getMessage("excel.cif",
					null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getEsnif());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Nombre
		if (solicitudesBusqueda.getEsnombre() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.nombre", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getEsnombre());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Provincia
		if (solicitudesBusqueda.getEsnoraProvinciaId() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.provincia", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getEsnombreProvincia());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Municipio
		if (solicitudesBusqueda.getEsnoraMunicipioId() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.municipio", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getEsnombreMunicipio());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Localidad
		if (solicitudesBusqueda.getEsnoraLocalidadId() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.localidad", null, locale));
			xslStringCriterios.append(": ").append(
					solicitudesBusqueda.getEsnombreLocalidad());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		return xslStringCriterios;
	}

	/**
	 * Obtiene el listado de solicitudes con tiempo de realizaci�n primer
	 * tramite.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionTiempoRealizacionPrimerTramite(
			SolicitudBusqueda solicitudesBusqueda, Date defedeDesde,
			Date defedeHasta, Date defereDesde, Date defereHasta,
			Date hcfedeDesde, Date hcfedeHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.denunciaService
				.findAllSolicitudListadoRelacionTiempoRealizacionPrimerTramite(
						solicitudesBusqueda, null, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);

		numCriteriosBusqueda = 0;

		// add criterios busqueda
		xslString
				.append(getListadoRelacionSolicitudesTiempoRealizacionPrimerTramiteCriteriosBusquedaRow(
						solicitudesBusqueda, listListadoSolicitudResultado,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta));

		// add row dinamica
		xslString
				.append(getListadoRelacionSolicitudesTiempoRealizacionPrimerTramiteMiddleRow());

		xslString.append("<table border='1'>");

		// add header
		xslString
				.append(getListadoRelacionSolicitudesTiempoRealizacionPrimerTramiteHeaderRow());

		String elementoAnterior = "";
		int registroActual = 1;
		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {

			if (listadoSolicitudResultado.getNumSolicitud().equals(
					elementoAnterior)) {
				listadoSolicitudResultado.setNumSolicitud("");
				listadoSolicitudResultado.setDefede(null);
				listadoSolicitudResultado.setDtnombre("");
			} else {
				elementoAnterior = listadoSolicitudResultado.getNumSolicitud();
			}

			xslString
					.append(getListadoRelacionSolicitudesTiempoRealizacionPrimerTramiteRow(
							listadoSolicitudResultado, registroActual));
			registroActual++;
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	private List<HashMap<String, Object>> getListadoRelacionSolicitudesSinDecisionElementosDiferentes(
			List<ListadoSolicitudResultado> listListadoSolicitudResultado) {

		List<HashMap<String, Object>> resultado = new ArrayList<HashMap<String, Object>>();
		String nombAnterior = "";
		// int contador = 0;
		HashMap<String, Object> mapa = new HashMap<String, Object>();
		for (int j = 0; j < listListadoSolicitudResultado.size(); j++) {
			ListadoSolicitudResultado bean = listListadoSolicitudResultado
					.get(j);
			List<ListadoSolicitudResultado> listaResultadoMonitor = this
					.getElementosListado(listListadoSolicitudResultado,
							bean.getMonombreDenuncia());
			if (bean.getMonombreDenuncia().equalsIgnoreCase(nombAnterior)) {
				// contador++;
				nombAnterior = bean.getMonombreDenuncia();
			} else {
				mapa.put("nombre", bean.getMonombreDenuncia());
				mapa.put("contador", listaResultadoMonitor.size());
				mapa.put("elementos", listaResultadoMonitor);

				resultado.add(mapa);
				mapa = new HashMap<String, Object>();
				nombAnterior = bean.getMonombreDenuncia();
				// contador = 1;
			}// end else
		}// end for

		return resultado;
	}// end getListadoRelacionSolicitudesSinDecisionElementosDiferentes

	private List<ListadoSolicitudResultado> getElementosListado(
			List<ListadoSolicitudResultado> lstSolicitudes, String nombre) {

		List<ListadoSolicitudResultado> resultado = new ArrayList<ListadoSolicitudResultado>();

		for (ListadoSolicitudResultado bean : lstSolicitudes) {
			if (bean.getMonombreDenuncia().equalsIgnoreCase(nombre)) {
				resultado.add(bean);
			}
		}// end for

		return resultado;
	}// end getElementosListado

	private String getListadoRelacionSolicitudesSinDecisionRowResumen(
			int numMonitor, int numSolicitudes) {

		StringBuffer row = new StringBuffer();

		row.append("<tr>");
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(String
				.valueOf(numMonitor))));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(String
				.valueOf(numSolicitudes))));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append(getFieldSombreado(Y41aUtils.normalizarVacio(null)));
		row.append("</tr>");

		return row.toString();
	}// end getListadoRelacionSolicitudesSinDecisionRowResumen

}
