package com.ejie.y41a.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41a.model.EstadisticasKontsumonetResultado;
import com.ejie.y41a.model.Grupo;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * EstadisticasKontsumonetServiceImpl generated by UDA 1.0, 08-jun-2011
 * 12:15:13.
 * 
 *  
 */
@Service(value = "estadisticasKontsumonetService")
public class EstadisticasKontsumonetServiceImpl implements
		EstadisticasKontsumonetService {

	@Autowired
	private ConsultaService consultaService;

	@Autowired
	private OrganismoService organismoService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private ComunicacionService comunicacionService;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Generar excel de las estadisticas de kontsumonet
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @return String
	 */
	public String getEstadisticaKontsumonetExcel(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda) {

		StringBuffer xslString = new StringBuffer();

		if (estadisticasKontsumonetBusqueda.getIndEstadistica() != null
				&& estadisticasKontsumonetBusqueda.getIndEstadistica().equals(
						Y41aConstantes.ESTADISTICAS_KONTSUMONET_CONSULTAS)) {
			xslString
					.append(this
							.getEstadisticaKontsumonetConsultas(estadisticasKontsumonetBusqueda));
		} else if (estadisticasKontsumonetBusqueda.getIndEstadistica() != null
				&& estadisticasKontsumonetBusqueda.getIndEstadistica().equals(
						Y41aConstantes.ESTADISTICAS_KONTSUMONET_SOLICITUDES)) {
			xslString
					.append(this
							.getEstadisticaKontsumonetSolicitudes(estadisticasKontsumonetBusqueda));
		} else if (estadisticasKontsumonetBusqueda.getIndEstadistica() != null
				&& estadisticasKontsumonetBusqueda.getIndEstadistica().equals(
						Y41aConstantes.ESTADISTICAS_KONTSUMONET_COMUNICACIONES)) {
			xslString
					.append(this
							.getEstadisticaKontsumonetComunicaciones(estadisticasKontsumonetBusqueda));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene las estadisticas de Kontsumonet de consultas.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @return String
	 */
	private String getEstadisticaKontsumonetConsultas(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasKontsumonetResultado> listEstadisticasKontsumonetResultado = this.consultaService
				.findAllConsultaEstadisticasKontsumonet(
						estadisticasKontsumonetBusqueda, null);

		// add header
		xslString
				.append(getEstadisticaKontsumonetConsultasCriteriosBusquedaRow(
						estadisticasKontsumonetBusqueda,
						listEstadisticasKontsumonetResultado));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaKontsumonetConsultasHeaderRow());

		BigDecimal total = new BigDecimal(0);

		for (EstadisticasKontsumonetResultado estadisticasKontsumonetResultado : listEstadisticasKontsumonetResultado) {
			total = total.add(estadisticasKontsumonetResultado
					.getNumReclamaciones());

			Organismo organismo = new Organismo();
			organismo.setCodOrg(estadisticasKontsumonetResultado.getCodOrg());

			estadisticasKontsumonetResultado
					.setTipoOrganismo(obtenerTiposOrganismo(organismo));

			xslString
					.append(getEstadisticaKontsumonetConsultasRow(estadisticasKontsumonetResultado));
		}

		xslString.append(getEstadisticaKontsumonetConsultasTotalRow(total));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene las estadisticas de Kontsumonet de solicitudes.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @return String
	 */
	private String getEstadisticaKontsumonetSolicitudes(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasKontsumonetResultado> listEstadisticasKontsumonetResultado = this.denunciaService
				.findAllSolicitudEstadisticasKontsumonet(
						estadisticasKontsumonetBusqueda, null);

		// add header
		xslString
				.append(getEstadisticaKontsumonetSolicitudesCriteriosBusquedaRow(
						estadisticasKontsumonetBusqueda,
						listEstadisticasKontsumonetResultado));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaKontsumonetSolicitudesHeaderRow());

		BigDecimal total = new BigDecimal(0);

		for (EstadisticasKontsumonetResultado estadisticasKontsumonetResultado : listEstadisticasKontsumonetResultado) {
			total = total.add(estadisticasKontsumonetResultado
					.getNumReclamaciones());

			Organismo organismo = new Organismo();
			organismo.setCodOrg(estadisticasKontsumonetResultado.getCodOrg());

			estadisticasKontsumonetResultado
					.setTipoOrganismo(obtenerTiposOrganismo(organismo));

			xslString
					.append(getEstadisticaKontsumonetSolicitudesRow(estadisticasKontsumonetResultado));
		}

		xslString.append(getEstadisticaKontsumonetSolicitudesTotalRow(total));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene las estadisticas de Kontsumonet de solicitudes.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @return String
	 */
	private String getEstadisticaKontsumonetComunicaciones(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasKontsumonetResultado> listEstadisticasKontsumonetResultado = this.comunicacionService
				.findAllComunicacionEstadisticasKontsumonet(
						estadisticasKontsumonetBusqueda, null);

		// add header
		xslString
				.append(getEstadisticaKontsumonetComunicacionesCriteriosBusquedaRow(
						estadisticasKontsumonetBusqueda,
						listEstadisticasKontsumonetResultado));

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaKontsumonetComunicacionesHeaderRow());

		BigDecimal totalLeidos = new BigDecimal(0);
		BigDecimal totalNoLeidos = new BigDecimal(0);

		for (EstadisticasKontsumonetResultado estadisticasKontsumonetResultado : listEstadisticasKontsumonetResultado) {
			totalLeidos = totalLeidos.add(estadisticasKontsumonetResultado
					.getNumLeidas());
			totalNoLeidos = totalNoLeidos.add(estadisticasKontsumonetResultado
					.getNumNoLeidas());

			Organismo organismo = new Organismo();
			organismo.setCodOrg(estadisticasKontsumonetResultado.getCodOrg());

			estadisticasKontsumonetResultado
					.setTipoOrganismo(obtenerTiposOrganismo(organismo));

			xslString
					.append(getEstadisticaKontsumonetComunicacionesRow(estadisticasKontsumonetResultado));
		}

		xslString.append(getEstadisticaKontsumonetComunicacionesTotalRow(
				totalLeidos, totalNoLeidos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtener grupos organismo.
	 * 
	 * @param organismo
	 *            Organismo
	 * 
	 * @return String
	 */
	private String obtenerTiposOrganismo(Organismo organismo) {
		StringBuffer gruposOrganismo = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		List<Grupo> listGrupo = this.organismoService
				.obtenerGruposOrganismo(organismo);

		boolean firstElement = true;

		for (Grupo grupoResultado : listGrupo) {
			if (firstElement) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					gruposOrganismo.append(grupoResultado.getNombreEs());
				} else {
					gruposOrganismo.append(grupoResultado.getNombreEu());
				}

				firstElement = false;
			} else {

				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					gruposOrganismo.append(";").append(
							grupoResultado.getNombreEs());
				} else {
					gruposOrganismo.append(";").append(
							grupoResultado.getNombreEu());
				}
			}
		}

		return gruposOrganismo.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * 
	 * @param listEstadisticasKontsumonetResultado
	 *            List<EstadisticasKontsumonetResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaKontsumonetConsultasCriteriosBusquedaRow(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			List<EstadisticasKontsumonetResultado> listEstadisticasKontsumonetResultado) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.tipoestadistica", null,
						locale)).append(": ");
		xslString.append(appMessageSource.getMessage("excel.consultas", null,
				locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		;
		xslString.append("<br/>");

		xslString.append(appMessageSource
				.getMessage("excel.anyo", null, locale));
		xslString.append(": ")
				.append(estadisticasKontsumonetBusqueda.getAnyo());
		xslString.append("<br/>");

		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listEstadisticasKontsumonetResultado.size());
		xslString.append("<br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * 
	 * @param listEstadisticasKontsumonetResultado
	 *            List<EstadisticasKontsumonetResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaKontsumonetSolicitudesCriteriosBusquedaRow(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			List<EstadisticasKontsumonetResultado> listEstadisticasKontsumonetResultado) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.tipoestadistica", null,
						locale)).append(": ");
		xslString.append(appMessageSource.getMessage("excel.solicitudes", null,
				locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		;
		xslString.append("<br/>");

		xslString.append(appMessageSource
				.getMessage("excel.anyo", null, locale));
		xslString.append(": ")
				.append(estadisticasKontsumonetBusqueda.getAnyo());
		xslString.append("<br/>");

		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listEstadisticasKontsumonetResultado.size());
		xslString.append("<br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * 
	 * @param listEstadisticasKontsumonetResultado
	 *            List<EstadisticasKontsumonetResultado>
	 * 
	 * @return String
	 */
	private String getEstadisticaKontsumonetComunicacionesCriteriosBusquedaRow(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			List<EstadisticasKontsumonetResultado> listEstadisticasKontsumonetResultado) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.tipoestadistica", null,
						locale)).append(": ");
		xslString.append(appMessageSource.getMessage("excel.comunicaciones",
				null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		;
		xslString.append("<br/>");

		xslString.append(appMessageSource
				.getMessage("excel.anyo", null, locale));
		xslString.append(": ")
				.append(estadisticasKontsumonetBusqueda.getAnyo());
		xslString.append("<br/>");

		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listEstadisticasKontsumonetResultado.size());
		xslString.append("<br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEstadisticaKontsumonetConsultasHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.tipoorganismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.codorganismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.organismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numreclamaciones", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEstadisticaKontsumonetSolicitudesHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.tipoorganismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.codorganismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.organismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numreclamaciones", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEstadisticaKontsumonetComunicacionesHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.tipoorganismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.codorganismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.organismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numleidas", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numnoleidas", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param estadisticasKontsumonetResultado
	 *            EstadisticasKontsumonetResultado
	 * @return String
	 */
	private String getEstadisticaKontsumonetConsultasRow(
			EstadisticasKontsumonetResultado estadisticasKontsumonetResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils
				.normalizarVacio(estadisticasKontsumonetResultado
						.getTipoOrganismo())));

		row.append(getFieldFormatoTexto(Y41aUtils
				.normalizarVacio(estadisticasKontsumonetResultado.getCodOrg())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasKontsumonetResultado
							.getNombreEs())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasKontsumonetResultado
							.getNombreEu())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(estadisticasKontsumonetResultado
						.getNumReclamaciones()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param estadisticasKontsumonetResultado
	 *            EstadisticasKontsumonetResultado
	 * @return String
	 */
	private String getEstadisticaKontsumonetSolicitudesRow(
			EstadisticasKontsumonetResultado estadisticasKontsumonetResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils
				.normalizarVacio(estadisticasKontsumonetResultado
						.getTipoOrganismo())));

		row.append(getFieldFormatoTexto(Y41aUtils
				.normalizarVacio(estadisticasKontsumonetResultado.getCodOrg())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasKontsumonetResultado
							.getNombreEs())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasKontsumonetResultado
							.getNombreEu())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(estadisticasKontsumonetResultado
						.getNumReclamaciones()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param estadisticasKontsumonetResultado
	 *            EstadisticasKontsumonetResultado
	 * @return String
	 */
	private String getEstadisticaKontsumonetComunicacionesRow(
			EstadisticasKontsumonetResultado estadisticasKontsumonetResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils
				.normalizarVacio(estadisticasKontsumonetResultado
						.getTipoOrganismo())));

		row.append(getFieldFormatoTexto(Y41aUtils
				.normalizarVacio(estadisticasKontsumonetResultado.getCodOrg())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasKontsumonetResultado
							.getNombreEs())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasKontsumonetResultado
							.getNombreEu())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(estadisticasKontsumonetResultado
						.getNumLeidas()))));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(estadisticasKontsumonetResultado
						.getNumNoLeidas()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @param total
	 *            BigDecimal
	 * @return String
	 */
	private String getEstadisticaKontsumonetConsultasTotalRow(BigDecimal total) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");

		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getHeaderField(appMessageSource.getMessage("excel.total",
				null, locale)));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(total))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @param total
	 *            BigDecimal
	 * @return String
	 */
	private String getEstadisticaKontsumonetSolicitudesTotalRow(BigDecimal total) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");

		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getHeaderField(appMessageSource.getMessage("excel.total",
				null, locale)));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(total))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @param totalLeidos
	 *            BigDecimal
	 * @param totalNoLeidos
	 *            BigDecimal
	 * @return String
	 */
	private String getEstadisticaKontsumonetComunicacionesTotalRow(
			BigDecimal totalLeidos, BigDecimal totalNoLeidos) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");

		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getHeaderField(appMessageSource.getMessage("excel.total",
				null, locale)));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(totalLeidos))));

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(totalNoLeidos))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar cabeceras.
	 * 
	 * @param fieldName
	 *            String
	 * @return String
	 */
	private static String getHeaderField(String fieldName) {
		StringBuffer field = new StringBuffer();
		field.append("<th>");
		field.append(Y41aUtils.normalizarVacio(fieldName));
		field.append("</th>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getField(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>");
		field.append(Y41aUtils.normalizarVacio(fieldValue));
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldFormatoTexto(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td align='center' width='75'>");
		field.append("=T(\"");
		field.append(Y41aUtils.normalizarVacio(fieldValue));
		field.append("\")");
		field.append("</td>");
		return field.toString();
	}

}
