package com.ejie.y41a.service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.EstadisticasConsultasProductosMotivos;
import com.ejie.y41a.model.EstadisticasConsultasResultado;
import com.ejie.y41a.model.EstadisticasConsultasTiempoAtencion;
import com.ejie.y41a.model.ListadoConsultaResultado;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * EstadisticasConsultasServiceImpl generated by UDA 1.0, 08-jun-2011 12:15:13.
 * 
 *  
 */
@Service(value = "estadisticasConsultasService")
public class EstadisticasConsultasServiceImpl implements
		EstadisticasConsultasService {

	@Autowired
	private ConsultaService consultaService;

	private int numCriteriosBusqueda = 0;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Generar excel de las estadisticas de consultas
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @param indEstadistica
	 *            String
	 * 
	 * @return String
	 */
	public String getEstadisticaConsultasExcel(Consulta consulta,
			Date fechaDesde, Date fechaHasta, String indEstadistica) {

		StringBuffer xslString = new StringBuffer();

		if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_CONSULTAS_FORMA_PRESENTACION)) {
			xslString.append(this.getEstadisticaFormaPresentacion(consulta,
					fechaDesde, fechaHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_CONSULTAS_MOTIVOS_PRODUCTOS)) {
			xslString.append(this.getEstadisticaMotivosProductos(consulta,
					fechaDesde, fechaHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_CONSULTAS_PRODUCTOS)) {
			xslString.append(this.getEstadisticaProductoServicio(consulta,
					fechaDesde, fechaHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_CONSULTAS_SEXO_EDAD)) {
			xslString.append(this.getEstadisticaSexoEdad(consulta, fechaDesde,
					fechaHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_CONSULTAS_PROMEDIO_TIEMPO_RESPONDER_CONSULTA)) {
			xslString.append(this.getEstadisticaPromedioMedioResponderConsulta(
					consulta, fechaDesde, fechaHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_CONSULTAS_TIEMPO_ATENCION_CONSULTAS_PRESENCIALES)) {
			xslString.append(this
					.getEstadisticaTiempoAtencionConsultasPresenciales(
							consulta, fechaDesde, fechaHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.ESTADISTICAS_CONSULTAS_TIEMPO_RESPUESTA_CONSULTAS_WEB_FAX)) {
			xslString.append(this.getEstadisticaTiempoRespuestaConsultasWebFax(
					consulta, fechaDesde, fechaHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_CONSULTAS_RELACION_CONSULTAS)) {
			xslString.append(this.getListadoRelacionConsultas(consulta,
					fechaDesde, fechaHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_CONSULTAS_RELACION_CONSULTAS_ABREVIADA)) {
			xslString.append(this.getListadoRelacionConsultasAbreviada(
					consulta, fechaDesde, fechaHasta));
		} else if (indEstadistica != null
				&& indEstadistica
						.equals(Y41aConstantes.LISTADOS_CONSULTAS_GENERAL)) {

			xslString.append(this.getListadoGeneral(consulta, fechaDesde,
					fechaHasta));

		}

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de consultas por forma de presentacion.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaFormaPresentacion(Consulta consulta,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado = this.consultaService
				.findAllConsultaEstadisticaFormaPresentacion(consulta, null,
						false, fechaDesde, fechaHasta);

		// add criterios busqueda
		xslString.append(getEstadisticaFormaPresentacionCriteriosBusquedaRow(
				consulta, listEstadisticasConsultasResultado, fechaDesde,
				fechaHasta));

		String[][] datos = getEstadisticaFormaPresentacionDataVector(listEstadisticasConsultasResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de consultas por producto servicio.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaProductoServicio(Consulta consulta,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado = this.consultaService
				.findAllConsultaEstadisticaProductoServicio(consulta, null,
						false, fechaDesde, fechaHasta);

		// add criterios busqueda
		xslString.append(getEstadisticaProductoServicioCriteriosBusquedaRow(
				consulta, listEstadisticasConsultasResultado, fechaDesde,
				fechaHasta));

		String[][] datos = getEstadisticaProductoServicioDataVector(listEstadisticasConsultasResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de consultas por sexo y edad.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaSexoEdad(Consulta consulta, Date fechaDesde,
			Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado = this.consultaService
				.findAllConsultaEstadisticaSexoEdad(consulta, null, false,
						fechaDesde, fechaHasta);

		// add criterios busqueda
		xslString.append(getEstadisticaSexoEdadCriteriosBusquedaRow(consulta,
				listEstadisticasConsultasResultado, fechaDesde, fechaHasta));

		String[][] datos = getEstadisticaSexoEdadDataVector(listEstadisticasConsultasResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de consultas promedio medio en responder
	 * consulta.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaPromedioMedioResponderConsulta(
			Consulta consulta, Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado = this.consultaService
				.findAllConsultaEstadisticaPromedioMedioResponderConsulta(
						consulta, null, false, fechaDesde, fechaHasta);

		// add criterios busqueda
		xslString
				.append(getEstadisticaPromedioMedioResponderConsultaCriteriosBusquedaRow(
						consulta, listEstadisticasConsultasResultado,
						fechaDesde, fechaHasta));

		String[][] datos = getEstadisticaPromedioMedioResponderConsultaDataVector(listEstadisticasConsultasResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de consultas por motivos y productos.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaMotivosProductos(Consulta consulta,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado = this.consultaService
				.findAllConsultaEstadisticaMotivosProductos(consulta, null,
						false, fechaDesde, fechaHasta);

		// add criterios busqueda
		xslString.append(getEstadisticaMotivosProductosCriteriosBusquedaRow(
				consulta, listEstadisticasConsultasResultado, fechaDesde,
				fechaHasta));

		String[][] datos = getEstadisticaMotivosProductosDataVector(listEstadisticasConsultasResultado);

		xslString.append("<table border='1'>");

		// add header
		xslString.append(getEstadisticaHeaderRow(datos));

		// Datos
		xslString.append(getEstadisticaRows(datos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de consultas por tiempo atencion en consultas
	 * presenciales.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaTiempoAtencionConsultasPresenciales(
			Consulta consulta, Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasConsultasTiempoAtencion> listEstadisticasConsultasTiempoAtencion = this.consultaService
				.findAllConsultaEstadisticaConsultasPresencialesTiempoAtencion(
						consulta, null, false, fechaDesde, fechaHasta);

		numCriteriosBusqueda = 0;

		// add criterios busqueda
		xslString
				.append(getEstadisticaTiempoAtencionConsultasPresencialesCriteriosBusquedaRow(
						consulta, listEstadisticasConsultasTiempoAtencion,
						fechaDesde, fechaHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString
				.append(getEstadisticaTiempoAtencionConsultasPresencialesHeaderRow());

		int registroActual = 1;
		BigDecimal total = new BigDecimal(0);

		for (EstadisticasConsultasTiempoAtencion estadisticasConsultasTiempoAtencion : listEstadisticasConsultasTiempoAtencion) {

			xslString
					.append(getEstadisticaTiempoAtencionConsultasPresencialesRow(
							estadisticasConsultasTiempoAtencion,
							registroActual,
							listEstadisticasConsultasTiempoAtencion.size()));
			total = total.add(estadisticasConsultasTiempoAtencion
					.getDemoraMinutos());
			registroActual++;
		}

		xslString
				.append(getEstadisticaTiempoAtencionConsultasPresencialesTotalRow(
						listEstadisticasConsultasTiempoAtencion.size(), total));

		xslString.append("</table>");

		xslString
				.append(getEstadisticaTiempoAtencionConsultasPresencialesFinalRow());

		return xslString.toString();
	}

	/**
	 * Obtiene la estadisticas de consultas por tiempo respuesta en consultas
	 * web/fax.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaTiempoRespuestaConsultasWebFax(
			Consulta consulta, Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<EstadisticasConsultasTiempoAtencion> listEstadisticasConsultasTiempoAtencion = this.consultaService
				.findAllConsultaEstadisticaConsultasWebFaxTiempoRespuesta(
						consulta, null, false, fechaDesde, fechaHasta);

		numCriteriosBusqueda = 0;

		// add criterios busqueda
		xslString
				.append(getEstadisticaTiempoRespuestaConsultasWebFaxCriteriosBusquedaRow(
						consulta, listEstadisticasConsultasTiempoAtencion,
						fechaDesde, fechaHasta));

		xslString.append("<table border='1'>");

		// add header
		xslString
				.append(getEstadisticaTiempoRespuestaConsultasWebFaxHeaderRow());

		int registroActual = 1;
		BigDecimal total = new BigDecimal(0);

		for (EstadisticasConsultasTiempoAtencion estadisticasConsultasTiempoAtencion : listEstadisticasConsultasTiempoAtencion) {

			xslString.append(getEstadisticaTiempoRespuestaConsultasWebFaxRow(
					estadisticasConsultasTiempoAtencion, registroActual,
					listEstadisticasConsultasTiempoAtencion.size()));

			if (estadisticasConsultasTiempoAtencion.getDiasResponder() != null) {
				total = total.add(estadisticasConsultasTiempoAtencion
						.getDiasResponder());
			}
			registroActual++;
		}

		xslString.append(getEstadisticaTiempoRespuestaConsultasWebFaxTotalRow(
				listEstadisticasConsultasTiempoAtencion.size(), total));

		xslString.append("</table>");

		xslString
				.append(getEstadisticaTiempoRespuestaConsultasWebFaxFinalRow());

		return xslString.toString();
	}

	/**
	 * Obtiene el listado de consultas.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionConsultas(Consulta consulta,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoConsultaResultado> listListadoConsultaResultado = this.consultaService
				.findAllConsultaListadoRelacionConsultas(consulta, null, false,
						fechaDesde, fechaHasta);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionConsultasCriteriosBusquedaRow(
						consulta, listListadoConsultaResultado, fechaDesde,
						fechaHasta));

		xslString.append("<table border='1'>");

		for (ListadoConsultaResultado listadoConsultaResultado : listListadoConsultaResultado) {

			xslString.append(getListadoRelacionConsultasHeaderRow());

			xslString
					.append(getListadoRelacionConsultasRow(listadoConsultaResultado));

			xslString.append(getListadoRelacionConsultasTextoHeaderRow());

			xslString
					.append(getListadoRelacionConsultasTextoRow(listadoConsultaResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene el listado de consultas abreviada.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoGeneral(Consulta consulta, Date fechaDesde,
			Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoConsultaResultado> listListadoConsultaResultado = this.consultaService
				.findAllConsultaListadoRelacionConsultasGeneral(consulta, null,
						false, fechaDesde, fechaHasta);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionConsultasGeneralCriteriosBusquedaRow(
						consulta, listListadoConsultaResultado, fechaDesde,
						fechaHasta));

		xslString.append("<table border='1'>");

		xslString.append(getListadoRelacionConsultasGeneralHeaderRow());

		for (ListadoConsultaResultado listadoConsultaResultado : listListadoConsultaResultado) {

			xslString
					.append(getListadoRelacionConsultasGeneralRow(listadoConsultaResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	// //////
	/**
	 * Obtiene el listado de consultas abreviada.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionConsultasAbreviada(Consulta consulta,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		List<ListadoConsultaResultado> listListadoConsultaResultado = this.consultaService
				.findAllConsultaListadoRelacionConsultasAbreviada(consulta,
						null, false, fechaDesde, fechaHasta);

		// add criterios busqueda
		xslString
				.append(getListadoRelacionConsultasAbreviadaCriteriosBusquedaRow(
						consulta, listListadoConsultaResultado, fechaDesde,
						fechaHasta));

		xslString.append("<table border='1'>");

		xslString.append(getListadoRelacionConsultasAbreviadaHeaderRow());

		for (ListadoConsultaResultado listadoConsultaResultado : listListadoConsultaResultado) {

			xslString
					.append(getListadoRelacionConsultasAbreviadaRow(listadoConsultaResultado));
		}

		xslString.append("</table>");

		return xslString.toString();
	}

	// //////

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionConsultasHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.organismo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numregistro", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.monitor", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechapresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.sexo",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.rangoedad", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.productoservicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.motivo", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionConsultasAbreviadaHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numconsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.monitor", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechapresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.productoservicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.motivo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.textoconsulta", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	//
	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionConsultasGeneralHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numconsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechaconsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.horallegada", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.horaatencion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.monitor", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.formaspresentacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.textoconsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.productoservicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.productoservicio.desc", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.motivo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fecharespuesta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.modoresp", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.textorespuesta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.nombre.consumidor", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.edad",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.sexo",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.email",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.telefono1", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.telefono2", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.extranjero", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cp",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.pais",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.direccionpostal", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.provincia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.localidad", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.calle",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.portal", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.compledirec", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	//

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getListadoRelacionConsultasTextoHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append("<th colspan='8'>");
		header.append(Y41aUtils.normalizarVacio(appMessageSource.getMessage(
				"excel.textoconsulta", null, locale)));
		header.append("</th>");

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEstadisticaTiempoAtencionConsultasPresencialesHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numconsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechaconsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.horallegada", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.horaatencion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.sexo",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.productoservicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.espera", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.excedido10min", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.excedido30min", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEstadisticaTiempoRespuestaConsultasWebFaxHeaderRow() {
		StringBuffer header = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.numconsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fechaconsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.fecharespuesta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.sexo",
				null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.productoservicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.diasenresponder", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage(
				"excel.excedido6dias", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param estadisticasConsultasTiempoAtencion
	 *            EstadisticasConsultasTiempoAtencion
	 * @param registroActual
	 *            int
	 * @param numRegistros
	 *            int
	 * @return String
	 */
	private String getEstadisticaTiempoAtencionConsultasPresencialesRow(
			EstadisticasConsultasTiempoAtencion estadisticasConsultasTiempoAtencion,
			int registroActual, int numRegistros) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils
				.normalizarVacio(estadisticasConsultasTiempoAtencion
						.getNumeroConsulta())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(
						estadisticasConsultasTiempoAtencion.getCofecha(),
						locale.getLanguage()))));

		row.append(getField(Y41aUtils
				.normalizarVacio(estadisticasConsultasTiempoAtencion
						.getHoraconsumidor())));

		row.append(getField(Y41aUtils
				.normalizarVacio(estadisticasConsultasTiempoAtencion
						.getCohora())));

		if (Y41aConstantes.SEXO_HOMBRE
				.equals(estadisticasConsultasTiempoAtencion.getCocosx())) {
			row.append(getField(appMessageSource.getMessage("excel.sexohombre",
					null, locale)));

		} else if (Y41aConstantes.SEXO_MUJER
				.equals(estadisticasConsultasTiempoAtencion.getCocosx())) {
			row.append(getField(appMessageSource.getMessage("excel.sexomujer",
					null, locale)));
		} else {
			row.append(getField(""));
		}

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasConsultasTiempoAtencion
							.getPsnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasConsultasTiempoAtencion
							.getPsnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(estadisticasConsultasTiempoAtencion
						.getDemoraMinutos()))));

		StringBuffer excedido10min = new StringBuffer();
		excedido10min.append("=G")
				.append(registroActual + numCriteriosBusqueda + 1).append("-G")
				.append(numRegistros + 7 + numCriteriosBusqueda + 1);
		row.append(getField(excedido10min.toString()));

		StringBuffer excedido30min = new StringBuffer();
		excedido30min.append("=G")
				.append(registroActual + numCriteriosBusqueda + 1).append("-G")
				.append(numRegistros + 8 + numCriteriosBusqueda + 1);
		row.append(getField(excedido30min.toString()));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param estadisticasConsultasTiempoAtencion
	 *            EstadisticasConsultasTiempoAtencion
	 * @param registroActual
	 *            int
	 * @param numRegistros
	 *            int
	 * @return String
	 */
	private String getEstadisticaTiempoRespuestaConsultasWebFaxRow(
			EstadisticasConsultasTiempoAtencion estadisticasConsultasTiempoAtencion,
			int registroActual, int numRegistros) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils
				.normalizarVacio(estadisticasConsultasTiempoAtencion
						.getNumeroConsulta())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(
						estadisticasConsultasTiempoAtencion.getCofecha(),
						locale.getLanguage()))));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(
						estadisticasConsultasTiempoAtencion.getCoferes(),
						locale.getLanguage()))));

		if (Y41aConstantes.SEXO_HOMBRE
				.equals(estadisticasConsultasTiempoAtencion.getCocosx())) {
			row.append(getField(appMessageSource.getMessage("excel.sexohombre",
					null, locale)));

		} else if (Y41aConstantes.SEXO_MUJER
				.equals(estadisticasConsultasTiempoAtencion.getCocosx())) {
			row.append(getField(appMessageSource.getMessage("excel.sexomujer",
					null, locale)));
		} else {
			row.append(getField(""));
		}

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasConsultasTiempoAtencion
							.getPsnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(estadisticasConsultasTiempoAtencion
							.getPsnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(Y41aUtils
				.convertBigDecimal2String(estadisticasConsultasTiempoAtencion
						.getDiasResponder()))));

		StringBuffer excedido6dias = new StringBuffer();
		excedido6dias.append("=F")
				.append(registroActual + numCriteriosBusqueda + 1).append("-F")
				.append(numRegistros + 7 + numCriteriosBusqueda + 1);
		row.append(getField(excedido6dias.toString()));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoConsultaResultado
	 *            ListadoConsultaResultado
	 * @return String
	 */
	private String getListadoRelacionConsultasRow(
			ListadoConsultaResultado listadoConsultaResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getCocoor())));

		String conrreg = "";
		if (listadoConsultaResultado.getConrreg() != null) {
			conrreg = listadoConsultaResultado.getConrreg().toString();
		}
		row.append(getField(Y41aUtils.normalizarVacio(conrreg)));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getMonombre())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoConsultaResultado.getCofecha(),
						locale.getLanguage()))));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getCocosx())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getRandesc())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getPsnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getPsnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getTirnombre())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoConsultaResultado
	 *            ListadoConsultaResultado
	 * @return String
	 */
	private String getListadoRelacionConsultasAbreviadaRow(
			ListadoConsultaResultado listadoConsultaResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNumeroConsulta())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getMonombre())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoConsultaResultado.getCofecha(),
						locale.getLanguage()))));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getPsnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getPsnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getTirnombre())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getCotexto())));

		row.append("</tr>");
		return row.toString();
	}

	//
	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoConsultaResultado
	 *            ListadoConsultaResultado
	 * @return String
	 */
	private String getListadoRelacionConsultasGeneralRow(
			ListadoConsultaResultado listadoConsultaResultado) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNumeroConsulta())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoConsultaResultado.getCofecha(),
						locale.getLanguage()))));

		// row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
		// .getCofechaconshora())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getCofechaconshora())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getCohora())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getMonombre())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getTfpnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getTfpnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getCotexto())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getPscodigo())));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getPsnombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getPsnombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getTirnombre())));

		row.append(getFieldFecha(Y41aUtils.normalizarVacio(Y41aUtils
				.parseDateToString(listadoConsultaResultado.getP9feresp(),
						locale.getLanguage()))));

		if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getP8nombre())));
		} else {
			row.append(getField(Y41aUtils
					.normalizarVacio(listadoConsultaResultado.getP8nombree())));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getP9teres())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getConoco())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getRandesc())));

		if (Y41aConstantes.SEXO_HOMBRE.equals(listadoConsultaResultado
				.getCocosx())) {
			row.append(getField(appMessageSource.getMessage("excel.sexohombre",
					null, locale)));

		} else if (Y41aConstantes.SEXO_MUJER.equals(listadoConsultaResultado
				.getCocosx())) {
			row.append(getField(appMessageSource.getMessage("excel.sexomujer",
					null, locale)));
		} else {
			row.append(getField(""));
		}

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getCocoemco())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getConrtelco())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getConrfaxco())));

		String coextranjero = Y41aUtils
				.normalizarVacio(listadoConsultaResultado.getCoextranjero());

		if (coextranjero.equalsIgnoreCase(Y41aConstantes.SI)) {
			coextranjero = appMessageSource
					.getMessage("excel.si", null, locale);
		} else if (coextranjero.equalsIgnoreCase(Y41aConstantes.NO)) {
			coextranjero = appMessageSource
					.getMessage("excel.no", null, locale);
		}
		row.append(getField(coextranjero));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNombrecp())));
		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNombrepais())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getDireccion_nocapv())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNombreprovincia())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNombremunicipio())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNombrelocalidad())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNombrecalle())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNombreportal())));

		row.append(getField(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getNombrepiso())));

		row.append("</tr>");
		return row.toString();
	}

	//

	/**
	 * Generar fila de datos.
	 * 
	 * @param listadoConsultaResultado
	 *            ListadoConsultaResultado
	 * @return String
	 */
	private String getListadoRelacionConsultasTextoRow(
			ListadoConsultaResultado listadoConsultaResultado) {

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append("<td colspan='8'>");
		row.append(Y41aUtils.normalizarVacio(listadoConsultaResultado
				.getCotexto()));
		row.append("</td>");

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @param numregistros
	 *            int
	 * @param total
	 *            BigDecimal
	 * @return String
	 */
	private String getEstadisticaTiempoAtencionConsultasPresencialesTotalRow(
			int numregistros, BigDecimal total) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");
		row.append("</tr>");

		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getField(appMessageSource.getMessage("excel.total", null,
				locale)));

		StringBuffer totalexcedido10min = new StringBuffer();
		int totaldesde = numCriteriosBusqueda + 1 + 1;

		int totalhasta = 0;
		if (numregistros == 0) {
			totalhasta = numCriteriosBusqueda + 1 + 1;
		} else {
			totalhasta = numregistros + 1 + numCriteriosBusqueda;
		}

		totalexcedido10min.append("=+SUMA(H").append(totaldesde).append(":H")
				.append(totalhasta).append(")");
		row.append(getField(totalexcedido10min.toString()));

		StringBuffer totalexcedido30min = new StringBuffer();
		totalexcedido30min.append("=+SUMA(I").append(totaldesde).append(":I")
				.append(totalhasta).append(")");
		row.append(getField(totalexcedido30min.toString()));

		row.append("</tr>");

		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));

		StringBuffer totalporcentaje = new StringBuffer();
		totalporcentaje.append(
				appMessageSource.getMessage("excel.total", null, locale))
				.append("(%)");

		row.append(getField(totalporcentaje.toString()));

		StringBuffer totalporcentajeexcedido10min = new StringBuffer();
		int totalporcentajedesde = numregistros + numCriteriosBusqueda + 1 + 1
				+ 1;

		totalporcentajeexcedido10min.append("=+REDONDEAR((H")
				.append(totalporcentajedesde).append("/").append(numregistros)
				.append(")*100;0)");

		if (numregistros == 0) {
			totalporcentajeexcedido10min = new StringBuffer();
			totalporcentajeexcedido10min.append("0");
		}

		row.append(getField(totalporcentajeexcedido10min.toString()));

		StringBuffer totalporcentajeexcedido30min = new StringBuffer();
		totalporcentajeexcedido30min.append("=+REDONDEAR((I")
				.append(totalporcentajedesde).append("/").append(numregistros)
				.append(")*100;0)");

		if (numregistros == 0) {
			totalporcentajeexcedido30min = new StringBuffer();
			totalporcentajeexcedido30min.append("0");
		}

		row.append(getField(totalporcentajeexcedido30min.toString()));

		row.append("</tr>");

		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getField(appMessageSource.getMessage("excel.media", null,
				locale)));

		StringBuffer media10min = new StringBuffer();

		media10min.append("=+REDONDEAR((H").append(totalporcentajedesde)
				.append("/").append(numregistros).append(");0)");

		if (numregistros == 0) {
			media10min = new StringBuffer();
			media10min.append("0");
		}

		row.append(getField(media10min.toString()));

		StringBuffer media30min = new StringBuffer();
		media30min.append("=+REDONDEAR((I").append(totalporcentajedesde)
				.append("/").append(numregistros).append(");0)");

		if (numregistros == 0) {
			media30min = new StringBuffer();
			media30min.append("0");
		}

		row.append(getField(media30min.toString()));

		row.append("</tr>");

		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getField("%"));

		StringBuffer porcentaje10min = new StringBuffer();

		porcentaje10min.append("=+REDONDEAR((H").append(totalporcentajedesde)
				.append("/").append(total).append(")*100;0)");

		if (total.intValue() == 0) {
			porcentaje10min = new StringBuffer();
			porcentaje10min.append("0");
		}

		row.append(getField(porcentaje10min.toString()));

		StringBuffer porcentaje30min = new StringBuffer();
		porcentaje30min.append("=+REDONDEAR((I").append(totalporcentajedesde)
				.append("/").append(total).append(")*100;0)");

		if (total.intValue() == 0) {
			porcentaje30min = new StringBuffer();
			porcentaje30min.append("0");
		}

		row.append(getField(porcentaje30min.toString()));

		row.append("</tr>");

		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @param numregistros
	 *            int
	 * @param total
	 *            BigDecimal
	 * @return String
	 */
	private String getEstadisticaTiempoRespuestaConsultasWebFaxTotalRow(
			int numregistros, BigDecimal total) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");
		row.append("</tr>");

		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getField(appMessageSource.getMessage("excel.total", null,
				locale)));

		StringBuffer totalexcedido6dias = new StringBuffer();
		int totaldesde = numCriteriosBusqueda + 1 + 1;

		int totalhasta = 0;
		if (numregistros == 0) {
			totalhasta = numCriteriosBusqueda + 1 + 1;
		} else {
			totalhasta = numregistros + numCriteriosBusqueda + 1;
		}

		totalexcedido6dias.append("=+SUMA(G").append(totaldesde).append(":G")
				.append(totalhasta).append(")");
		row.append(getField(totalexcedido6dias.toString()));

		row.append("</tr>");

		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));

		StringBuffer totalporcentaje = new StringBuffer();
		totalporcentaje.append(
				appMessageSource.getMessage("excel.total", null, locale))
				.append("(%)");

		row.append(getField(totalporcentaje.toString()));

		StringBuffer totalporcentajeexcedido6dias = new StringBuffer();
		int totalporcentajedesde = numregistros + numCriteriosBusqueda + 1 + 1
				+ 1;

		totalporcentajeexcedido6dias.append("=+REDONDEAR((G")
				.append(totalporcentajedesde).append("/").append(numregistros)
				.append(")*100;0)");

		if (numregistros == 0) {
			totalporcentajeexcedido6dias = new StringBuffer();
			totalporcentajeexcedido6dias.append("0");
		}

		row.append(getField(totalporcentajeexcedido6dias.toString()));

		row.append("</tr>");

		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getField(appMessageSource.getMessage("excel.media", null,
				locale)));

		StringBuffer media6dias = new StringBuffer();

		media6dias.append("=+REDONDEAR((G").append(totalporcentajedesde)
				.append("/").append(numregistros).append(");0)");

		if (numregistros == 0) {
			media6dias = new StringBuffer();
			media6dias.append("0");
		}

		row.append(getField(media6dias.toString()));

		row.append("</tr>");

		row.append("<tr>");

		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));
		row.append(getField(Y41aUtils.normalizarVacio("")));

		row.append(getField("%"));

		StringBuffer porcentaje6dias = new StringBuffer();

		porcentaje6dias.append("=+REDONDEAR((G").append(totalporcentajedesde)
				.append("/").append(total).append(")*100;0)");

		if (total.intValue() == 0) {
			porcentaje6dias = new StringBuffer();
			porcentaje6dias.append("0");
		}

		row.append(getField(porcentaje6dias.toString()));

		row.append("</tr>");

		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @return String
	 */
	private String getEstadisticaTiempoAtencionConsultasPresencialesFinalRow() {

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();

		row.append("<table>");
		row.append("<tr>");
		row.append("</tr>");

		row.append("<tr>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td style='BACKGROUND-COLOR: #808080;'>");
		row.append(appMessageSource.getMessage("excel.modificar10min", null,
				locale));
		row.append("</td>");

		row.append("<td style='BACKGROUND-COLOR: #808080;'>");
		row.append("10");
		row.append("</td>");

		row.append("</tr>");

		row.append("<tr>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td style='BACKGROUND-COLOR: #808080;'>");
		row.append(appMessageSource.getMessage("excel.modificar30min", null,
				locale));
		row.append("</td>");
		row.append("<td style='BACKGROUND-COLOR: #808080;'>");
		row.append("30");
		row.append("</td>");

		row.append("</tr>");

		row.append("</table>");

		return row.toString();
	}

	/**
	 * Generar fila de total.
	 * 
	 * @return String
	 */
	private String getEstadisticaTiempoRespuestaConsultasWebFaxFinalRow() {

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();

		row.append("<table>");
		row.append("<tr>");
		row.append("</tr>");

		row.append("<tr>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td>");
		row.append("</td>");
		row.append("<td style='BACKGROUND-COLOR: #808080;'>");
		row.append(appMessageSource.getMessage("excel.modificarplazorespuesta",
				null, locale));
		row.append("</td>");
		row.append("<td style='BACKGROUND-COLOR: #808080;'>");
		row.append("6");
		row.append("</td>");

		row.append("</tr>");

		row.append("</table>");

		return row.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaFormaPresentacionCriteriosBusquedaRow(
			Consulta consulta,
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.consultaformapresentacion", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasConsultasResultado estadisticasConsultasResultado : listEstadisticasConsultasResultado) {

			numRegistros += estadisticasConsultasResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaProductoServicioCriteriosBusquedaRow(
			Consulta consulta,
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.consultaproductoservicio", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasConsultasResultado estadisticasConsultasResultado : listEstadisticasConsultasResultado) {

			numRegistros += estadisticasConsultasResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaSexoEdadCriteriosBusquedaRow(
			Consulta consulta,
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado,
			Date fechaDesde, Date fechaHasta) {

		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage("excel.consultasexoedad",
				null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasConsultasResultado estadisticasConsultasResultado : listEstadisticasConsultasResultado) {

			numRegistros += estadisticasConsultasResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaMotivosProductosCriteriosBusquedaRow(
			Consulta consulta,
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.consultamotivosproductos", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasConsultasResultado estadisticasConsultasResultado : listEstadisticasConsultasResultado) {

			numRegistros += estadisticasConsultasResultado.getTotal()
					.intValue();
		}

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaPromedioMedioResponderConsultaCriteriosBusquedaRow(
			Consulta consulta,
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.consultapromediomedioresponderconsulta", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");

		// Calcular total registros
		int numRegistros = 0;
		for (EstadisticasConsultasResultado estadisticasConsultasResultado : listEstadisticasConsultasResultado) {

			numRegistros += estadisticasConsultasResultado.getNumReg()
					.intValue();
		}

		xslString.append(numRegistros);
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listEstadisticasConsultasTiempoAtencion
	 *            List<EstadisticasConsultasTiempoAtencion>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaTiempoAtencionConsultasPresencialesCriteriosBusquedaRow(
			Consulta consulta,
			List<EstadisticasConsultasTiempoAtencion> listEstadisticasConsultasTiempoAtencion,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.consultatiempoatencionconsultaspresenciales", null,
				locale));
		xslString.append("</b><br/>");
		numCriteriosBusqueda++;

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");
		numCriteriosBusqueda++;

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");
		numCriteriosBusqueda++;

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listEstadisticasConsultasTiempoAtencion.size());
		xslString.append("</b><br/>");
		numCriteriosBusqueda++;

		xslString.append("<p>");
		xslString.append("</p>");
		numCriteriosBusqueda++;

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listEstadisticasConsultasTiempoAtencion
	 *            List<EstadisticasConsultasTiempoAtencion>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getEstadisticaTiempoRespuestaConsultasWebFaxCriteriosBusquedaRow(
			Consulta consulta,
			List<EstadisticasConsultasTiempoAtencion> listEstadisticasConsultasTiempoAtencion,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.consultatiemporespuestaconsultaswebfax", null, locale));
		xslString.append("</b><br/>");
		numCriteriosBusqueda++;

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");
		numCriteriosBusqueda++;

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");
		numCriteriosBusqueda++;

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listEstadisticasConsultasTiempoAtencion.size());
		xslString.append("</b><br/>");
		numCriteriosBusqueda++;

		xslString.append("<p>");
		xslString.append("</p>");
		numCriteriosBusqueda++;

		return xslString.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listListadoConsultaResultado
	 *            List<ListadoConsultaResultado>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionConsultasCriteriosBusquedaRow(
			Consulta consulta,
			List<ListadoConsultaResultado> listListadoConsultaResultado,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage("excel.listadoconsultas",
				null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listListadoConsultaResultado.size());
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	//
	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listListadoConsultaResultado
	 *            List<ListadoConsultaResultado>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionConsultasGeneralCriteriosBusquedaRow(
			Consulta consulta,
			List<ListadoConsultaResultado> listListadoConsultaResultado,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage("excel.listadoconsultas",
				null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listListadoConsultaResultado.size());
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	//

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param listListadoConsultaResultado
	 *            List<ListadoConsultaResultado>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getListadoRelacionConsultasAbreviadaCriteriosBusquedaRow(
			Consulta consulta,
			List<ListadoConsultaResultado> listListadoConsultaResultado,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		xslString.append("<b>");
		xslString.append(appMessageSource.getMessage(
				"excel.listadoconsultasabreviada", null, locale));
		xslString.append("</b><br/>");

		xslString.append(appMessageSource.getMessage("excel.fechaemision",
				null, locale));
		xslString.append(": ").append(
				Y41aUtils.normalizarVacio(Y41aUtils.parseDateToString(
						new Date(), locale.getLanguage())));
		xslString.append("<br/>");

		xslString.append("<b>");
		xslString.append(
				appMessageSource.getMessage("excel.criteriosbusqueda", null,
						locale)).append(": ");
		xslString.append("</b><br/>");

		xslString.append(crearCriteriosBusqueda(consulta, fechaDesde,
				fechaHasta));

		xslString.append("<b>");
		xslString
				.append(appMessageSource.getMessage("excel.numregistros", null,
						locale)).append(": ");
		xslString.append(listListadoConsultaResultado.size());
		xslString.append("</b><br/>");

		xslString.append("<p>");
		xslString.append("</p>");

		return xslString.toString();
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaFormaPresentacionDataVector(
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado) {
		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";
		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {

			if (estadisticasConsultasResultadoAux.getColumnas().equals("INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasConsultasResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de formas de presentacion
		List<String> listFormaPresentacion = new ArrayList<String>();

		String formaPresentacion = "";

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasConsultasResultadoAux.getFilas()
						.equals("INDEF")) {
					formaPresentacion = appMessageSource.getMessage(
							"excel.indefinido", null, locale).toUpperCase();
				} else {
					formaPresentacion = estadisticasConsultasResultadoAux
							.getFilas();
				}

				if (!listFormaPresentacion.contains(formaPresentacion)) {
					listFormaPresentacion.add(formaPresentacion);
				}
			} else {
				if (estadisticasConsultasResultadoAux.getFilase().equals(
						"INDEF")) {
					formaPresentacion = appMessageSource.getMessage(
							"excel.indefinido", null, locale).toUpperCase();
				} else {
					formaPresentacion = estadisticasConsultasResultadoAux
							.getFilase();
				}

				if (!listFormaPresentacion.contains(formaPresentacion)) {
					listFormaPresentacion.add(formaPresentacion);
				}
			}

		}

		Collections.sort(listFormaPresentacion);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 1; // el doble de
																// localidades +
																// 2 para los
																// totales + 1
																// porque A1 es
																// blanca
		int intFilas = (listFormaPresentacion.size()) + 1 + 1; // el nº de
																// formas
																// presentacion
																// + 1 para los
																// totales + 1
																// porque A1 es
																// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.formaspresentacion",
				null, locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String formaPresentacionAux : listFormaPresentacion) {
			datos[intFilas][1] = formaPresentacionAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasConsultasResultadoAux.getFilas().equals(
							"INDEF")) {
						formaPresentacion = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						formaPresentacion = estadisticasConsultasResultadoAux
								.getFilas();
					}
					if ((datos[intFilas][1]).equals(formaPresentacion)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {

							if (estadisticasConsultasResultadoAux.getColumnas()
									.equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasConsultasResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasConsultasResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasConsultasResultadoAux.getFilase().equals(
							"INDEF")) {
						formaPresentacion = appMessageSource.getMessage(
								"excel.indefinido", null, locale).toUpperCase();
					} else {
						formaPresentacion = estadisticasConsultasResultadoAux
								.getFilase();
					}

					if ((datos[intFilas][1]).equals(formaPresentacion)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasConsultasResultadoAux.getColumnas()
									.equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasConsultasResultadoAux
										.getColumnas();
							}

							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasConsultasResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaProductoServicioDataVector(
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado) {
		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			if (estadisticasConsultasResultadoAux.getColumnas().equals("INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasConsultasResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de formas de presentacion
		List<String> listFormaPresentacion = new ArrayList<String>();

		String producto = "";
		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasConsultasResultadoAux.getFilas()
						.equals("INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale);
				} else {
					producto = estadisticasConsultasResultadoAux.getFilas();
				}
				if (!listFormaPresentacion.contains(producto)) {
					listFormaPresentacion.add(producto);
				}
			} else {
				if (estadisticasConsultasResultadoAux.getFilase().equals(
						"INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale);
				} else {
					producto = estadisticasConsultasResultadoAux.getFilase();
				}
				if (!listFormaPresentacion.contains(producto)) {
					listFormaPresentacion.add(producto);
				}
			}

		}

		Collections.sort(listFormaPresentacion);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 1; // el doble de
																// localidades +
																// 2 para los
																// totales + 1
																// porque A1 es
																// blanca
		int intFilas = (listFormaPresentacion.size()) + 1 + 1; // el nº de
																// formas
																// presentacion
																// + 1 para los
																// totales + 1
																// porque A1 es
																// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.productoservicio",
				null, locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String formaPresentacionAux : listFormaPresentacion) {
			datos[intFilas][1] = formaPresentacionAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasConsultasResultadoAux.getFilas().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale);
					} else {
						producto = estadisticasConsultasResultadoAux.getFilas();
					}
					if ((datos[intFilas][1]).equals(producto)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasConsultasResultadoAux.getColumnas()
									.equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasConsultasResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasConsultasResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasConsultasResultadoAux.getFilase().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale);
					} else {
						producto = estadisticasConsultasResultadoAux
								.getFilase();
					}
					if ((datos[intFilas][1]).equals(producto)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasConsultasResultadoAux.getColumnas()
									.equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasConsultasResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasConsultasResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaSexoEdadDataVector(
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado) {
		// 1.- Inicializamos el array de sexo
		List<String> listSexo = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String sexo = "";
		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {

			if (estadisticasConsultasResultadoAux.getColumnas().equals("H")) {
				sexo = appMessageSource.getMessage("excel.sexohombre", null,
						locale);
			} else if (estadisticasConsultasResultadoAux.getColumnas().equals(
					"M")) {
				sexo = appMessageSource.getMessage("excel.sexomujer", null,
						locale);
			} else {
				sexo = appMessageSource.getMessage("excel.sexoindefinido",
						null, locale);
			}

			if (!listSexo.contains(sexo)) {
				listSexo.add(sexo);
			}
		}

		Collections.sort(listSexo);

		// 2.- Inicializamos el array de formas de presentacion
		List<String> listFormaPresentacion = new ArrayList<String>();

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			if (!listFormaPresentacion
					.contains(estadisticasConsultasResultadoAux.getFilas())) {
				listFormaPresentacion.add(estadisticasConsultasResultadoAux
						.getFilas());
			}
		}

		Collections.sort(listFormaPresentacion);

		// 3.- Inicializamos en el array general
		int intColumnas = (listSexo.size() * 2) + 2 + 1; // el doble de
															// localidades +
															// 2 para los
															// totales + 1
															// porque A1 es
															// blanca
		int intFilas = (listFormaPresentacion.size()) + 1 + 1; // el nº de
																// formas
																// presentacion
																// + 1 para los
																// totales + 1
																// porque A1 es
																// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String sexoAux : listSexo) {
			datos[1][intColumnas] = sexoAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.rangoedad", null,
				locale).toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (String formaPresentacionAux : listFormaPresentacion) {
			datos[intFilas][1] = formaPresentacionAux;
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);

		// 5.- Cargamos en el array general - VALORES -

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if ((datos[intFilas][1])
						.equals(estadisticasConsultasResultadoAux.getFilas())) {
					for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
						if (estadisticasConsultasResultadoAux.getColumnas()
								.equals("H")) {
							sexo = appMessageSource.getMessage(
									"excel.sexohombre", null, locale);
						} else if (estadisticasConsultasResultadoAux
								.getColumnas().equals("M")) {
							sexo = appMessageSource.getMessage(
									"excel.sexomujer", null, locale);
						} else {
							sexo = appMessageSource.getMessage(
									"excel.sexoindefinido", null, locale);
						}
						if ((datos[1][intColumnas]).equals(sexo)) {
							if (datos[intFilas][intColumnas] == null) {
								datos[intFilas][intColumnas] = "0";
							}
							datos[intFilas][intColumnas] = new BigDecimal(
									datos[intFilas][intColumnas]).add(
									estadisticasConsultasResultadoAux
											.getTotal()).toString();
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 2; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 2; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}

				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaMotivosProductosDataVector(
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado) {
		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			if (estadisticasConsultasResultadoAux.getColumnas().equals("INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasConsultasResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		// 2.- Inicializamos el array de productos y motivos
		List<EstadisticasConsultasProductosMotivos> listProductosMotivos = new ArrayList<EstadisticasConsultasProductosMotivos>();

		String motivo = "";
		String producto = "";

		EstadisticasConsultasProductosMotivos aux = null;
		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			if (estadisticasConsultasResultadoAux.getFilas2().equals("INDEF")) {
				motivo = appMessageSource.getMessage("excel.indefinido", null,
						locale);
			} else {
				motivo = estadisticasConsultasResultadoAux.getFilas2();
			}

			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasConsultasResultadoAux.getFilas()
						.equals("INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale);
				} else {
					producto = estadisticasConsultasResultadoAux.getFilas();
				}
				aux = new EstadisticasConsultasProductosMotivos(producto,
						motivo);

				int id = EstadisticasConsultasProductosMotivos.find(
						listProductosMotivos, aux);
				if (id == -1) {
					listProductosMotivos.add(aux);
				}

			} else {
				if (estadisticasConsultasResultadoAux.getFilase().equals(
						"INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale);
				} else {
					producto = estadisticasConsultasResultadoAux.getFilase();
				}
				aux = new EstadisticasConsultasProductosMotivos(producto,
						motivo);

				int id = EstadisticasConsultasProductosMotivos.find(
						listProductosMotivos, aux);
				if (id == -1) {
					listProductosMotivos.add(aux);
				}

			}
		}

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size() * 2) + 2 + 2; // el doble de
																// localidades +
																// 2 para los
																// totales + 2
																// porque A1 y
																// A2 son las
																// clumnas de
																// producto y
																// motivo
		int intFilas = (listProductosMotivos.size()) + 1 + 1; // el nº de
		// formas
		// presentacion
		// + 1 para los
		// totales + 1
		// porque A1 es
		// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 3;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
			datos[1][intColumnas] = "%";
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.productoservicio",
				null, locale).toUpperCase();
		datos[1][2] = appMessageSource.getMessage("excel.motivo", null, locale)
				.toUpperCase();
		datos[1][intColumnas] = appMessageSource.getMessage("excel.total",
				null, locale);
		intColumnas = intColumnas + 1;
		datos[1][intColumnas] = "%";

		// Filas
		intFilas = 2;

		for (EstadisticasConsultasProductosMotivos estadisticasConsultasProductosMotivosAux : listProductosMotivos) {
			datos[intFilas][1] = estadisticasConsultasProductosMotivosAux
					.getFilas();
			datos[intFilas][2] = estadisticasConsultasProductosMotivosAux
					.getFilas2();
			intFilas = intFilas + 1;
		}

		datos[intFilas][1] = appMessageSource.getMessage("excel.total", null,
				locale);
		datos[intFilas][2] = "";

		// 5.- Cargamos en el array general - VALORES -

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (estadisticasConsultasResultadoAux.getFilas2().equals(
						"INDEF")) {
					motivo = appMessageSource.getMessage("excel.indefinido",
							null, locale);
				} else {
					motivo = estadisticasConsultasResultadoAux.getFilas2();
				}
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasConsultasResultadoAux.getFilas().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale);
					} else {
						producto = estadisticasConsultasResultadoAux.getFilas();
					}
					if ((datos[intFilas][1]).equals(producto)
							&& (datos[intFilas][2]).equals(motivo)) {
						for (intColumnas = 3; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasConsultasResultadoAux.getColumnas()
									.equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasConsultasResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasConsultasResultadoAux
												.getTotal()).toString();
							}
						}
					}
				} else {
					if (estadisticasConsultasResultadoAux.getFilase().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale);
					} else {
						producto = estadisticasConsultasResultadoAux
								.getFilase();
					}
					if ((datos[intFilas][1]).equals(producto)
							&& (datos[intFilas][2]).equals(motivo)) {
						for (intColumnas = 3; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasConsultasResultadoAux.getColumnas()
									.equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasConsultasResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasConsultasResultadoAux
												.getTotal()).toString();
							}
						}
					}
				}
			}
		}

		// 6.- Cargamos en el array general - TOTALES CONCEPTO -
		BigDecimal total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			total = new BigDecimal(0);
			for (intColumnas = 3; intColumnas < datos[intFilas].length - 2; intColumnas += 2) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas][intColumnas] = total.toString();
		}

		// 7.- Cargamos en el array general - TOTALES LOCALIDAD -
		total = new BigDecimal(0);
		for (intColumnas = 3; intColumnas < datos[intFilas - 1].length - 2; intColumnas += 2) {
			total = new BigDecimal(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
			}
			datos[intFilas - 1][intColumnas] = total.toString();
		}

		// 8.- Cargamos en el array general - TOTAL GENERAL - se puede realizar
		// o por filas o por columnas
		total = new BigDecimal(0);
		for (intFilas = 2; intFilas < datos.length; intFilas++) {
			if (datos[intFilas][intColumnas] == null) {
				datos[intFilas][intColumnas] = "0";
			}
			total = total.add(new BigDecimal(datos[intFilas][intColumnas]));
		}
		datos[intFilas - 1][intColumnas] = total.toString();

		// 9.- Cargamos en el array general - PORCENTAJES -
		Float porcentaje = new Float(0);
		for (intColumnas = 3; intColumnas < datos[intFilas - 1].length; intColumnas += 2) {
			porcentaje = new Float(0);
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (datos[intFilas][intColumnas] == null) {
					datos[intFilas][intColumnas] = "0";
				}
				if (datos[datos.length - 1][intColumnas] != null
						&& !datos[datos.length - 1][intColumnas].equals("0")) {
					porcentaje = (new Float(datos[intFilas][intColumnas]) / new Float(
							datos[datos.length - 1][intColumnas])) * 100;
				}

				DecimalFormat df = new DecimalFormat("0.00");
				datos[intFilas][intColumnas + 1] = df.format(porcentaje)
						.toString();
			}
		}

		return datos;
	}

	/**
	 * Generar vector con los datos.
	 * 
	 * 
	 * @param listEstadisticasConsultasResultado
	 *            List<EstadisticasConsultasResultado>
	 * 
	 * @return String[][]
	 */
	private String[][] getEstadisticaPromedioMedioResponderConsultaDataVector(
			List<EstadisticasConsultasResultado> listEstadisticasConsultasResultado) {
		// 1.- Inicializamos el array de municipios
		List<String> listMunicipios = new ArrayList<String>();

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		String municipio = "";

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			if (estadisticasConsultasResultadoAux.getColumnas().equals("INDEF")) {
				municipio = appMessageSource.getMessage("excel.desconocido",
						null, locale);
			} else {
				municipio = estadisticasConsultasResultadoAux.getColumnas();
			}

			if (!listMunicipios.contains(municipio)) {
				listMunicipios.add(municipio);
			}
		}

		Collections.sort(listMunicipios);

		String producto = "";

		// 2.- Inicializamos el array de productos
		List<String> listProductos = new ArrayList<String>();

		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (estadisticasConsultasResultadoAux.getFilas()
						.equals("INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale);
				} else {
					producto = estadisticasConsultasResultadoAux.getFilas();
				}
				if (!listProductos.contains(producto)) {
					listProductos.add(producto);
				}
			} else {
				if (estadisticasConsultasResultadoAux.getFilase().equals(
						"INDEF")) {
					producto = appMessageSource.getMessage("excel.indefinido",
							null, locale);
				} else {
					producto = estadisticasConsultasResultadoAux.getFilase();
				}
				if (!listProductos.contains(producto)) {
					listProductos.add(producto);
				}
			}
		}

		Collections.sort(listProductos);

		// 3.- Inicializamos en el array general
		int intColumnas = (listMunicipios.size()) + 1; // el numero de
														// localidades +
														// 1 porque A1 es
														// blanca
		int intFilas = (listProductos.size()) + 1; // el nº de
													// formas
													// presentacion
													// + 1
													// porque A1 es
													// blanca

		String[][] datos = new String[intFilas + 1][intColumnas + 1];

		// 4.- Cargamos en el array general - CABECERAS -

		// Columnas
		intColumnas = 2;

		for (String municipioAux : listMunicipios) {
			datos[1][intColumnas] = municipioAux;
			intColumnas = intColumnas + 1;
		}

		datos[1][1] = appMessageSource.getMessage("excel.productoservicio",
				null, locale).toUpperCase();

		// Filas
		intFilas = 2;

		for (String productoAux : listProductos) {
			datos[intFilas][1] = productoAux;
			intFilas = intFilas + 1;
		}

		// 5.- Cargamos en el array general - VALORES -
		for (EstadisticasConsultasResultado estadisticasConsultasResultadoAux : listEstadisticasConsultasResultado) {
			for (intFilas = 2; intFilas < datos.length; intFilas++) {
				if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					if (estadisticasConsultasResultadoAux.getFilas().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale);
					} else {
						producto = estadisticasConsultasResultadoAux.getFilas();
					}
					if ((datos[intFilas][1]).equals(producto)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasConsultasResultadoAux.getColumnas()
									.equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasConsultasResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasConsultasResultadoAux
												.getTotal()).toString();
							} else {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										new BigDecimal("0")).toString();
							}
						}
					}
				} else {
					if (estadisticasConsultasResultadoAux.getFilase().equals(
							"INDEF")) {
						producto = appMessageSource.getMessage(
								"excel.indefinido", null, locale);
					} else {
						producto = estadisticasConsultasResultadoAux
								.getFilase();
					}
					if ((datos[intFilas][1]).equals(producto)) {
						for (intColumnas = 2; intColumnas < datos[intFilas].length; intColumnas++) {
							if (estadisticasConsultasResultadoAux.getColumnas()
									.equals("INDEF")) {
								municipio = appMessageSource.getMessage(
										"excel.desconocido", null, locale);
							} else {
								municipio = estadisticasConsultasResultadoAux
										.getColumnas();
							}
							if ((datos[1][intColumnas]).equals(municipio)) {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										estadisticasConsultasResultadoAux
												.getTotal()).toString();
							} else {
								if (datos[intFilas][intColumnas] == null) {
									datos[intFilas][intColumnas] = "0";
								}
								datos[intFilas][intColumnas] = new BigDecimal(
										datos[intFilas][intColumnas]).add(
										new BigDecimal("0")).toString();
							}
						}
					}
				}
			}
		}

		return datos;
	}

	/**
	 * Generar cabecera.
	 * 
	 * @param datos
	 *            String[][]
	 * 
	 * @return String
	 */
	private String getEstadisticaHeaderRow(String[][] datos) {
		StringBuffer header = new StringBuffer();

		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		for (int intColumnas = 1; intColumnas < datos[1].length; intColumnas++) {
			header.append(getHeaderField(datos[1][intColumnas]));
		}

		header.append("</tr>");

		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param datos
	 *            String[][]
	 * 
	 * @return String
	 */
	private String getEstadisticaRows(String[][] datos) {

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();

		String elementoAnterior = "";
		for (int intFilas = 2; intFilas < datos.length; intFilas++) {
			if ((datos[intFilas][1]).equals(appMessageSource.getMessage(
					"excel.total", null, locale))) {
				row.append("<tr style='BACKGROUND-COLOR: #D8D8D8;FONT-WEIGHT: bold;'>");
			} else {
				row.append("<tr>");
			}
			for (int intColumnas = 1; intColumnas < datos[intFilas].length; intColumnas++) {
				if (intColumnas == 1) {
					if ((datos[intFilas][intColumnas]).equals(elementoAnterior)) {
						row.append(getField(""));
					} else {
						elementoAnterior = datos[intFilas][intColumnas];
						row.append(getField(datos[intFilas][intColumnas]));
					}
				} else {
					row.append(getField(datos[intFilas][intColumnas]));
				}
			}
			row.append("</tr>");
		}

		return row.toString();
	}

	/**
	 * Generar cabeceras.
	 * 
	 * @param fieldName
	 *            String
	 * @return String
	 */
	private static String getHeaderField(String fieldName) {
		StringBuffer field = new StringBuffer();
		field.append("<th>");
		field.append(Y41aUtils.normalizarVacio(fieldName));
		field.append("</th>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getField(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>");
		field.append(Y41aUtils.normalizarVacio(fieldValue));
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldFecha(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>");
		field.append("=T(\"");
		field.append(Y41aUtils.normalizarVacio(fieldValue));
		field.append("\")");
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Generar criterios busqueda.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * 
	 * @return StringBuffer
	 * 
	 */
	private StringBuffer crearCriteriosBusqueda(Consulta consulta,
			Date fechaDesde, Date fechaHasta) {

		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer xslStringCriterios = new StringBuffer();

		// Situacion
		String strSituacion = "";

		if (consulta.getCosituacion() == null) {
			strSituacion = appMessageSource.getMessage("excel.situacionTodas",
					null, locale);
		} else if (consulta.getCosituacion().equalsIgnoreCase(
				Y41aConstantes.SITUACION_PENDIENTES)) {
			strSituacion = appMessageSource.getMessage("excel.pendientes",
					null, locale);
		} else if (consulta.getCosituacion().equalsIgnoreCase(
				Y41aConstantes.SOLICITUDES_RECIBIDAS)) {
			strSituacion = appMessageSource.getMessage("excel.resueltas", null,
					locale);
		}
		if (strSituacion.length() != 0) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.situacion", null, locale));
			xslStringCriterios.append(": ").append(strSituacion);
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Código organismo

		xslStringCriterios.append(appMessageSource.getMessage(
				"excel.codorganismo", null, locale));
		xslStringCriterios.append(": ").append(
				consulta.getOrganismo().getCodOrg());
		xslStringCriterios.append("<br/>");
		numCriteriosBusqueda++;

		// NUMERO REGISTRO CONSULTA
		if (consulta.getConrreg() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.numregistro", null, locale));
			xslStringCriterios.append(": ").append(consulta.getConrreg());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// Año

		xslStringCriterios.append(appMessageSource.getMessage("excel.anyo",
				null, locale));
		xslStringCriterios.append(": ").append(consulta.getConranrg());
		xslStringCriterios.append("<br/>");
		numCriteriosBusqueda++;

		// ORIGEN OFICINA coinl21 WEB coinl37
		String strOrigenOficina = "";
		String strOrigenWeb = "";

		if (consulta.getCoinl21() != null
				&& consulta.getCoinl21().equalsIgnoreCase(
						Y41aConstantes.VALOR_SI)) {
			strOrigenOficina = appMessageSource.getMessage("excel.oficina",
					null, locale);
		}

		if (consulta.getCoinl37() != null
				&& consulta.getCoinl37().equalsIgnoreCase(
						Y41aConstantes.VALOR_SI)) {
			strOrigenWeb = appMessageSource.getMessage("excel.web", null,
					locale);
		}

		if (strOrigenOficina.length() != 0 || strOrigenWeb.length() != 0) {
			String strOrigen = strOrigenOficina + " " + strOrigenWeb;

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.origen", null, locale));
			xslStringCriterios.append(": ").append(strOrigen);
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// FECHA DESDE HASTA
		String strFechaDesde = "";
		String strFechaHasta = "";

		String idioma = locale.getLanguage();

		if (fechaDesde != null) {
			strFechaDesde = appMessageSource.getMessage("excel.fechadesde",
					null, locale)
					+ ": "
					+ Y41aUtils.parseDateToString(fechaDesde, idioma);
		}
		if (fechaHasta != null) {
			strFechaHasta = appMessageSource.getMessage("excel.fechahasta",
					null, locale)
					+ ": "
					+ Y41aUtils.parseDateToString(fechaHasta, idioma);
		}
		String strFecha = "";

		if (strFechaDesde.length() != 0 || strFechaHasta.length() != 0) {
			strFecha = strFechaDesde + " " + strFechaHasta;

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.fecha", null, locale));
			xslStringCriterios.append(", ").append(strFecha);
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// MONITOR
		if (consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMocodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.monitor", null, locale));
			xslStringCriterios.append(": ").append(
					consulta.getCensoMonitor().getMonombre());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// FORMA DE PRESENTACION
		if (consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpcodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.formaspresentacion", null, locale));
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(consulta
								.getFormaPresentacion().getTfpnombre()));
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				xslStringCriterios.append(": ").append(
						Y41aUtils.normalizarVacio(consulta
								.getFormaPresentacion().getTfpnombree()));
			}
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// TEXTO
		if (consulta.getCotexto() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.textoconsulta", null, locale));
			xslStringCriterios.append(": ").append(consulta.getCotexto());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// /PERSONA CONSUMIDORA
		if (consulta.getCocodigo() != null) {

			xslStringCriterios.append((appMessageSource.getMessage(
					"excel.personaconsumidora", null, locale)).toUpperCase());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// NOMBRE
		if (consulta.getConoco() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.nombre", null, locale));
			xslStringCriterios.append(": ").append(consulta.getConoco());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// PROVINCIA
		if (consulta.getNoraProvinciaId() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.provincia", null, locale));
			xslStringCriterios.append(": ").append(
					consulta.getNombreProvincia());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// MUNICIPIO
		if (consulta.getNoraMunicipioId() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.municipio", null, locale));
			xslStringCriterios.append(": ").append(
					consulta.getNombreMunicipio());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// LOCALIDAD
		if (consulta.getNoraLocalidadId() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.localidad", null, locale));
			xslStringCriterios.append(": ").append(
					consulta.getNombreLocalidad());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// EDAD
		if (consulta.getRangoEdad() != null
				&& consulta.getRangoEdad().getRancod() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.rangoedad", null, locale));
			xslStringCriterios.append(": ").append(
					consulta.getRangoEdad().getRandesc());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// SEXO
		if (consulta.getCocosx() != null) {

			xslStringCriterios.append(appMessageSource.getMessage("excel.sexo",
					null, locale));
			xslStringCriterios.append(": ").append(consulta.getCocosx());
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// PRODUCTO SERVICIO
		if (consulta.getProducto() != null
				&& consulta.getProducto().getPscodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.productoservicio", null, locale));
			xslStringCriterios.append(": ").append(
					consulta.getProducto().getPscodigo());
			xslStringCriterios.append(" ");
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				xslStringCriterios.append(Y41aUtils.normalizarVacio(consulta
						.getProducto().getPsnombre()));
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				xslStringCriterios.append(Y41aUtils.normalizarVacio(consulta
						.getProducto().getPsnombree()));
			}
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		// MOTIVO
		if (consulta.getMotivo() != null
				&& consulta.getMotivo().getTircodigo() != null) {

			xslStringCriterios.append(appMessageSource.getMessage(
					"excel.motivo", null, locale));
			xslStringCriterios.append(": ").append(
					consulta.getMotivo().getTircodigo());
			xslStringCriterios.append(" ");
			xslStringCriterios.append(Y41aUtils.normalizarVacio(consulta
					.getMotivo().getTirnombre()));
			xslStringCriterios.append("<br/>");
			numCriteriosBusqueda++;
		}

		return xslStringCriterios;
	}

}
