package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ActaDao;
import com.ejie.y41a.dao.ActuacionDao;
import com.ejie.y41a.dao.AlertaDao;
import com.ejie.y41a.dao.DatosMailEstablecimientoDao;
import com.ejie.y41a.dao.DatosMailSedeDao;
import com.ejie.y41a.dao.EstablecimArbitraDao;
import com.ejie.y41a.dao.EstablecimSectorDao;
import com.ejie.y41a.dao.EstablecimientoDao;
import com.ejie.y41a.dao.ExpedienDao;
import com.ejie.y41a.dao.HechoDenunciadoDao;
import com.ejie.y41a.dao.HistoricoDao;
import com.ejie.y41a.dao.PagosDao;
import com.ejie.y41a.dao.SedeDao;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.Actividad;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.AlertaDetalle;
import com.ejie.y41a.model.EstablecimArbitra;
import com.ejie.y41a.model.EstablecimSector;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.EstablecimientoDecisionAnyo;
import com.ejie.y41a.model.EstablecimientoDetalle;
import com.ejie.y41a.model.EstablecimientoReclamacionesAnyo;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.Sector;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.exception.Y41aUDAException;
import com.ejie.y41a.dao.IntervinientesDao;
import com.ejie.y41a.dao.SanintervDao;
import com.ejie.y41a.dao.SanpropbandejaDao;

/**
 * * EstablecimientoServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

@Service(value = "establecimientoService")
public class EstablecimientoServiceImpl implements EstablecimientoService {

	private static final Logger logger = LoggerFactory
			.getLogger(EstablecimientoServiceImpl.class);
	@Autowired
	private EstablecimientoDao establecimientoDao;
	@Autowired
	private EstablecimSectorDao establecimSectorDao;
	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private ActaDao actaDao;
	@Autowired
	private AlertaDao alertaDao;
	@Autowired
	private EstablecimArbitraDao establecimArbitraDao;
	@Autowired
	private IntervinientesDao intervinientesDao;
	@Autowired
	private SanintervDao sanintervDao;
	@Autowired
	private SanpropbandejaDao sanpropbandejaDao;
	@Autowired
	private ExpedienDao expedienDao;
	@Autowired
	private PagosDao pagosDao;
	@Autowired
	private HistoricoDao historicoDao;
	@Autowired
	private SedeDao sedeDao;
	@Autowired
	private DatosMailEstablecimientoDao datosMailEstablecimientoDao;
	@Autowired
	private DatosMailSedeDao datosMailSedeDao;

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Establecimiento add(Establecimiento establecimiento) {
		establecimiento.setEscodigo(Y41aUIDGenerator.getInstance().generateId(
				Y41aConstantes.PK_SIZE));
		return this.establecimientoDao.add(establecimiento);
	}

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return Establecimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Establecimiento addEstablecimiento(Establecimiento establecimiento,
			EstablecimSector establecimSector) {

		Establecimiento establecimientoAux = new Establecimiento();
		establecimientoAux.setEsnif(establecimiento.getEsnif());

		// List<Establecimiento> listEstablecimiento = this.establecimientoDao
		// .findAllLikeEstablecimiento(establecimientoAux, null, null,
		// false);
		// if (listEstablecimiento.size() > 0) {
		// throw new Y41aUDAException("error.establecimientos.NifDuplicado",
		// true, new Exception());
		// } else {
		establecimiento.setEscodigo(Y41aUIDGenerator.getInstance().generateId(
				Y41aConstantes.PK_SIZE));
		this.establecimientoDao.add(establecimiento);
		establecimSector.getEstablecimiento().setEscodigo(
				establecimiento.getEscodigo());
		establecimSector.setEacodigo(Y41aUIDGenerator.getInstance().generateId(
				Y41aConstantes.PK_SIZE));

		this.establecimSectorDao.add(establecimSector);

		return establecimiento;
		// }
	}

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimientosListABorrar
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void fusionEstablecimientos(Establecimiento establecimientoBueno,
			ArrayList<Establecimiento> establecimientosListABorrar) {
		for (Establecimiento establecimientoAux : establecimientosListABorrar) {

			// Hechos Denunciados
			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setEstablecimiento(establecimientoAux);

			List<HechoDenunciado> listHechoDenunciado = this.hechoDenunciadoDao
					.findAllHechosEstablecimiento(hechodenunciado, null);

			for (HechoDenunciado hechoDenunciadoAux : listHechoDenunciado) {

				hechoDenunciadoAux.getEstablecimiento().setEscodigo(
						establecimientoBueno.getEscodigo());
				this.hechoDenunciadoDao
						.updateEstablecimiento(hechoDenunciadoAux);
			}

			// Intervinientes Solicitudes
			this.intervinientesDao.updateEstablecimiento(
					establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Expediente sanciones
			this.expedienDao.updateEstablecimiento(
					establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Intervinientes Sanciones
			this.sanintervDao.updateEstablecimiento(
					establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Bandeja Sanciones
			this.sanpropbandejaDao.updateEstablecimiento(
					establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Pagos
			this.pagosDao.updateEstablecimiento(
					establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Historico
			this.historicoDao.updateEstablecimiento(
					establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Actas
			Acta acta = new Acta();
			acta.setEstablecimiento(establecimientoAux);

			List<Acta> listActa = this.actaDao.findAllActaEstablecimiento(acta,
					null);

			for (Acta actaAux : listActa) {

				actaAux.getEstablecimiento().setEscodigo(
						establecimientoBueno.getEscodigo());
				this.actaDao.updateEstablecimiento(actaAux);
			}

			// Visitas
			Actuacion actuacion = new Actuacion();
			actuacion.setEstablecimiento(establecimientoAux);

			List<Actuacion> listActuacion = this.actuacionDao
					.findAllActuacionEstablecimiento(actuacion, null);

			for (Actuacion actuacionAux : listActuacion) {

				actuacionAux.getEstablecimiento().setEscodigo(
						establecimientoBueno.getEscodigo());
				this.actuacionDao.updateEstablecimiento(actuacionAux);
			}

			// Alertas
			Alerta alerta = new Alerta();
			Establecimiento establecimientoAlerta = new Establecimiento();
			establecimientoAlerta.setEscodigo(establecimientoAux.getEscodigo());
			alerta.setEstablecimiento(establecimientoAlerta);

			List<AlertaDetalle> listAlertaDetalle = this.alertaDao
					.findAllAlertaEstablecimiento(alerta, null);

			for (AlertaDetalle alertaDetalleAux : listAlertaDetalle) {

				alertaDetalleAux
						.setEscodigo(establecimientoBueno.getEscodigo());
				this.alertaDao.updateEstablecimiento(alertaDetalleAux);
			}

			EstablecimSector establecimsector = new EstablecimSector();
			establecimsector.setEstablecimiento(establecimientoAux);

			// Solicitud Arbitraje
			this.establecimArbitraDao.updateEstablecimiento(
					establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			this.datosMailEstablecimientoDao
					.removeAllDatosMailEstablec(establecimientoAux);
			this.datosMailSedeDao.removeAllDatosMailSede(establecimientoAux);

			this.sedeDao.removeAllSedes(establecimientoAux);
			this.establecimientoDao
					.removeAllEstablecimientoDescriptor(establecimientoAux);

			this.establecimSectorDao
					.removeSectorEstablecimiento(establecimsector);
			this.establecimientoDao.remove(establecimientoAux);
		}
	}

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Establecimiento update(Establecimiento establecimiento) {
		return this.establecimientoDao.update(establecimiento);
	}

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return Establecimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Establecimiento updateEstablecimiento(
			Establecimiento establecimiento, EstablecimSector establecimSector) {
		this.establecimientoDao.update(establecimiento);

		EstablecimSector establecSectorAux = (EstablecimSector) this.establecimSectorDao
				.findSectorEstablecimiento(establecimSector);

		if (Y41aUtils.isFilled(establecSectorAux.getEacodigo())) {
			this.establecimSectorDao.update(establecimSector);
		} else {
			establecimSector.setEacodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));

			this.establecimSectorDao.add(establecimSector);
		}

		return establecimiento;
	}

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	public Establecimiento find(Establecimiento establecimiento) {
		Establecimiento estableci = (Establecimiento) this.establecimientoDao
				.find(establecimiento);

		return estableci;
	}

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findEstablecimiento(
			Establecimiento establecimiento) {
		Establecimiento estableci = (Establecimiento) this.establecimientoDao
				.find(establecimiento);

		EstablecimSector establecimSector = new EstablecimSector();
		establecimSector.setEstablecimiento(estableci);
		// establecimSector.getEstablecimiento().setEscodigo(
		// estableci.getEscodigo());

		EstablecimSector establecSector = new EstablecimSector();
		Actividad actividad = new Actividad();
		Sector sector = new Sector();
		establecSector.setActividad(actividad);
		establecSector.setSector(sector);

		establecSector = (EstablecimSector) this.establecimSectorDao
				.findSectorEstablecimiento(establecimSector);

		EstablecimientoDetalle establecidetalle = new EstablecimientoDetalle(
				estableci.getEscodigo(), estableci.getCensoMonitor()
						.getMocodigo(), estableci.getCensoMonitor()
						.getMonombre(), estableci.getCensoMonitor().getMousu(),
				estableci.getEsnombre(), estableci.getEsnif(),
				estableci.getEsnoan(), estableci.getEsnoco(),
				estableci.getEsnodir(), estableci.getEscolo(),
				estableci.getEsnrcopo(), estableci.getEsnrtel(),
				estableci.getEsnrfax(), estableci.getEscopa(),
				estableci.getEsincapr(), estableci.getEsindemp(),
				estableci.getEsteco(), estableci.getEsinadar(),
				estableci.getEsfeadar(), estableci.getEscoem(),
				estableci.getEsinempr(), estableci.getEsnrtel2(),
				estableci.getEsinfeba(), estableci.getEsfeba(),
				estableci.getEsnoap1(), estableci.getEsnoap2(),
				estableci.getEsnolo(), estableci.getEscomapv(),
				estableci.getEscoca(), estableci.getEsnopeco(),
				estableci.getEscoidco(), estableci.getEsinreco(),
				estableci.getEsfemod(), estableci.getEsinesco(),
				estableci.getEsnomu(), estableci.getEsnorep(),
				estableci.getEsnifrep(), estableci.getDtteemr(),
				estableci.getEscarep(), estableci.getEsteurl(),
				estableci.getEscooe(), estableci.getEsnodeco(),
				estableci.getEsintiar(), estableci.getEsfeplad(),
				estableci.getEsindeme(), estableci.getEsnoraPaisId(),
				estableci.getEsnoraPaisNombre(),
				estableci.getEsnoraProvinciaId(),
				estableci.getEsnombreProvincia(),
				estableci.getEsnoraMunicipioId(),
				estableci.getEsnombreMunicipio(),
				estableci.getEsnoraLocalidadId(),
				estableci.getEsnombreLocalidad(), estableci.getEsnoraCalleId(),
				estableci.getEsnombreCalle(), estableci.getEsnoraCpId(),
				estableci.getEsnombreCp(), estableci.getEsnoraPortalId(),
				estableci.getEsnombrePortal(), estableci.getEsnombrePiso(),
				estableci.getEsdireccion_nocapv(),
				estableci.getEsdireccionCompleta(),
				estableci.getEsexpedientesAbiertos(),
				establecSector.getEacodigo(), establecSector.getActividad()
						.getAvcodigo(), establecSector.getActividad()
						.getAvnombre(), establecSector.getActividad()
						.getAvnombree(), establecSector.getSector()
						.getSecodigo(), establecSector.getSector()
						.getSenombre(), establecSector.getSector()
						.getSenombree(), establecSector.getEainprse(),
				estableci.getEsextranjero());

		HechoDenunciado hechodenunciado = new HechoDenunciado();
		Establecimiento establecimientoAux = new Establecimiento();
		establecimientoAux.setEscodigo(establecimiento.getEscodigo());
		hechodenunciado.setEstablecimiento(establecimientoAux);

		Long numExpedientesAbiertos = this.hechoDenunciadoDao
				.findAllExpedientesAbiertosCount(hechodenunciado);

		if (numExpedientesAbiertos > 0) {
			establecidetalle.setEsexpedientesAbiertos(Y41aConstantes.VALOR_SI);
		} else {
			establecidetalle.setEsexpedientesAbiertos(Y41aConstantes.VALOR_NO);
		}

		Long numReclamaciones = this.hechoDenunciadoDao
				.findAllCount(hechodenunciado);

		establecidetalle.setEsnumReclamaciones(numReclamaciones.toString());

		StringBuffer direccionAntiguaCompleta = new StringBuffer();

		String escomapv = (estableci.getEscomapv() == null) ? "" : estableci
				.getEscomapv();
		String esnomu = (estableci.getEsnomu() == null) ? "" : estableci
				.getEsnomu();
		String esnolo = (estableci.getEsnolo() == null) ? "" : estableci
				.getEsnolo();
		String esnodir = (estableci.getEsnodir() == null) ? "" : estableci
				.getEsnodir();
		String esnrcopo = (estableci.getEsnrcopo() == null) ? "" : estableci
				.getEsnrcopo();

		direccionAntiguaCompleta.append(escomapv).append(" ").append(esnomu)
				.append(" ").append(esnolo).append(" ").append(esnodir)
				.append(" ").append(esnrcopo);

		establecidetalle.setDireccionAntiguaCompleta(direccionAntiguaCompleta
				.toString());

		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(
					estableci.getEscodigo());
			establecimArbitra = this.establecimArbitraDao
					.findArbitraje(establecimArbitra);

			establecidetalle.setAhfeba(establecimArbitra.getAhfeba());
			establecidetalle.setAhtelimi(establecimArbitra.getAhtelimi());

			if ("A".equals(estableci.getEsinadar())) {
				if (!Y41aUtils.esNullOCadenaVacia(establecimArbitra
						.getAhtelimi())) {
					establecidetalle.setEsinadar("L");
				}
			}

		} catch (Exception e) {

		}

		return establecidetalle;
	}

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Establecimiento> findAll(Establecimiento establecimiento,
			Pagination pagination) {
		return (List<Establecimiento>) this.establecimientoDao.findAll(
				establecimiento, pagination);
	}

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	public Long findAllCount(Establecimiento establecimiento) {
		return this.establecimientoDao.findAllCount(establecimiento);
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Establecimiento> findAllLike(Establecimiento establecimiento,
			Pagination pagination, Boolean startsWith) {
		return (List<Establecimiento>) this.establecimientoDao.findAllLike(
				establecimiento, pagination, startsWith);
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Establecimiento> findAllLikeEstablecimiento(
			Establecimiento establecimiento, EstablecimSector establecimSector,
			Pagination pagination, Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("esdireccionCompleta")) {
				pagination.setSort("ESNOMBRE_CALLE, ESNOMBRE_PORTAL, ESNODIR ");
			}
		}

		List<Establecimiento> listEstablecimiento = this.establecimientoDao
				.findAllLikeEstablecimiento(establecimiento, establecimSector,
						pagination, startsWith);

		for (Establecimiento establec : listEstablecimiento) {
			StringBuffer direccionCompleta = new StringBuffer();

			if (establec.getEsnombreCalle() != null
					&& !establec.getEsnombreCalle().equals("")) {
				direccionCompleta.append(establec.getEsnombreCalle());

				if (establec.getEsnombrePortal() != null
						&& !establec.getEsnombrePortal().equals("")) {
					direccionCompleta.append(", ").append(
							establec.getEsnombrePortal());
				}
			} else if (establec.getEsdireccion_nocapv() != null
					&& !establec.getEsdireccion_nocapv().equals("")) {
				direccionCompleta.append(establec.getEsdireccion_nocapv());
			} else if (establec.getEsnodir() != null
					&& !establec.getEsnodir().equals("")) {
				direccionCompleta.append(establec.getEsnodir());
			}

			establec.setEsdireccionCompleta(direccionCompleta.toString());
			// A�adir si se tiene direcci�n completa o no
			if (establec.getEsextranjero() == "S") {
				if (establec.getEsnoraPaisNombre() != null
						&& establec.getEsnoraPaisNombre() != ""
						&& establec.getEsdireccion_nocapv() != null
						&& establec.getEsdireccion_nocapv() != "") {
					establec.setEsdirCompleta(true);
				} else {
					establec.setEsdirCompleta(false);
				}
			} else {// si no es extranjero
					// si es de capv
				if (establec.getEsnombreProvincia() != null
						&& establec.getEsnombreProvincia() != ""
						&& establec.getEsnombreMunicipio() != null
						&& establec.getEsnombreMunicipio() != ""
						&& establec.getEsnombreCalle() != null
						&& establec.getEsnombreCalle() != "") {
					// && data.dtnombrePortal!=null && data.dtnombrePortal!=''
					establec.setEsdirCompleta(true);
					// si NO es de capv
				} else if (establec.getEsdireccion_nocapv() != null
						&& establec.getEsdireccion_nocapv() != "") {
					establec.setEsdirCompleta(true);
				} else {
					establec.setEsdirCompleta(false);
				}
			}

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(
						establec.getEscodigo());
				establecimArbitra = this.establecimArbitraDao
						.findArbitraje(establecimArbitra);

				if ("A".equals(establec.getEsinadar())) {
					if (!Y41aUtils.esNullOCadenaVacia(establecimArbitra
							.getAhtelimi())) {
						establec.setEsinadar("L");
					}
				}

			} catch (Exception e) {

			}
		}

		return listEstablecimiento;
	}

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeEstablecimientoCount(
			Establecimiento establecimiento, EstablecimSector establecimSector,
			Boolean startsWith) {
		return this.establecimientoDao.findAllLikeEstablecimientoCount(
				establecimiento, establecimSector, startsWith);
	}

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Establecimiento establecimiento) {
		this.establecimientoDao.remove(establecimiento);
	}

	/**
	 * Deletes multiple rows in the Establecimiento table.
	 * 
	 * @param establecimientoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Establecimiento> establecimientoList) {
		for (Establecimiento establecimientoAux : establecimientoList) {
			this.establecimientoDao.remove(establecimientoAux);
		}
	}

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeEstablecimiento(Establecimiento establecimiento,
			EstablecimSector establecimSector) {

		try {
			this.establecimSectorDao
					.removeSectorEstablecimiento(establecimSector);
			this.establecimientoDao.remove(establecimiento);
		} catch (DataIntegrityViolationException e) {
			throw new Y41aUDAException(
					"error.establecimientos.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por año.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstablecimientoReclamacionesAnyo> findAllEstablecimientoReclamacionesAnyo(
			Establecimiento establecimiento, Pagination pagination) {
		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setEstablecimiento(establecimiento);
		return (List<EstablecimientoReclamacionesAnyo>) this.hechoDenunciadoDao
				.findAllEstablecimientoReclamacionesAnyo(hechoDenunciado,
						pagination);
	}

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	public Long findAllEstablecimientoReclamacionesAnyoCount(
			Establecimiento establecimiento) {
		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setEstablecimiento(establecimiento);
		return this.hechoDenunciadoDao
				.findAllEstablecimientoReclamacionesAnyoCount(hechoDenunciado);
	}

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por decision y por año.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstablecimientoDecisionAnyo> findAllEstablecimientoDecisionAnyo(
			Establecimiento establecimiento, Pagination pagination) {
		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setEstablecimiento(establecimiento);
		return (List<EstablecimientoDecisionAnyo>) this.hechoDenunciadoDao
				.findAllEstablecimientoDecisionAnyo(hechoDenunciado, pagination);
	}

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	public Long findAllEstablecimientoDecisionAnyoCount(
			Establecimiento establecimiento) {
		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setEstablecimiento(establecimiento);
		return this.hechoDenunciadoDao
				.findAllEstablecimientoDecisionAnyoCount(hechoDenunciado);
	}

	/**
	 * Getter method for EstablecimientoDao
	 * 
	 * @return EstablecimientoDao
	 */
	public EstablecimientoDao getEstablecimientoDao() {
		return this.establecimientoDao;
	}

	/**
	 * Setter method for EstablecimientoDao.
	 * 
	 * @param establecimientoDao
	 *            EstablecimientoDao
	 * @return
	 */
	public void setEstablecimientoDao(EstablecimientoDao establecimientoDao) {
		logger.info("Setting Dependency " + establecimientoDao);
		this.establecimientoDao = establecimientoDao;
	}
}
