package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.EstablecimSector;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.EstablecimientoDecisionAnyo;
import com.ejie.y41a.model.EstablecimientoDetalle;
import com.ejie.y41a.model.EstablecimientoReclamacionesAnyo;

/**
 * * EstablecimientoService generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

public interface EstablecimientoService {

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento add(Establecimiento establecimiento);

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return Establecimiento
	 */
	Establecimiento addEstablecimiento(Establecimiento establecimiento,
			EstablecimSector establecimSector);

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimientosListABorrar
	 *            ArrayList
	 * @return
	 */
	void fusionEstablecimientos(Establecimiento establecimientoBueno,
			ArrayList<Establecimiento> establecimientosListABorrar);

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento update(Establecimiento establecimiento);

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return Establecimiento
	 */
	Establecimiento updateEstablecimiento(Establecimiento establecimiento,
			EstablecimSector establecimSector);

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento find(Establecimiento establecimiento);

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return EstablecimientoDetalle
	 */
	EstablecimientoDetalle findEstablecimiento(Establecimiento establecimiento);

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Establecimiento> findAll(Establecimiento establecimiento,
			Pagination pagination);

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	Long findAllCount(Establecimiento establecimiento);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLike(Establecimiento establecimiento,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLikeEstablecimiento(
			Establecimiento establecimiento, EstablecimSector establecimSector,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeEstablecimientoCount(Establecimiento establecimiento,
			EstablecimSector establecimSector, Boolean startsWith);

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	void remove(Establecimiento establecimiento);

	/**
	 * Deletes multiple rows in the Establecimiento table.
	 * 
	 * @param establecimientoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Establecimiento> establecimientoList);

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return
	 */
	void removeEstablecimiento(Establecimiento establecimiento,
			EstablecimSector establecimSector);

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por año.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimientoReclamacionesAnyo> findAllEstablecimientoReclamacionesAnyo(
			Establecimiento establecimiento, Pagination pagination);

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	Long findAllEstablecimientoReclamacionesAnyoCount(
			Establecimiento establecimiento);

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por decision y por año.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimientoDecisionAnyo> findAllEstablecimientoDecisionAnyo(
			Establecimiento establecimiento, Pagination pagination);

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	Long findAllEstablecimientoDecisionAnyoCount(Establecimiento establecimiento);
}
