package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.EstablecimSectorDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.ejie.y41a.model.EstablecimSector;

/**
 * * EstablecimSectorServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

@Service(value = "establecimSectorService")
public class EstablecimSectorServiceImpl implements EstablecimSectorService {

	private static final Logger logger = LoggerFactory
			.getLogger(EstablecimSectorServiceImpl.class);
	@Autowired
	private EstablecimSectorDao establecimSectorDao;

	/**
	 * Inserts a single row in the EstablecimSector table.
	 * 
	 * @param establecimSector
	 *            EstablecimSector
	 * @return EstablecimSector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstablecimSector add(EstablecimSector establecimSector) {
		return this.establecimSectorDao.add(establecimSector);
	}

	/**
	 * Updates a single row in the EstablecimSector table.
	 * 
	 * @param establecimSector
	 *            EstablecimSector
	 * @return EstablecimSector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstablecimSector update(EstablecimSector establecimSector) {
		return this.establecimSectorDao.update(establecimSector);
	}

	/**
	 * Finds a single row in the EstablecimSector table.
	 * 
	 * @param establecimSector
	 *            EstablecimSector
	 * @return EstablecimSector
	 */
	public EstablecimSector find(EstablecimSector establecimSector) {
		return (EstablecimSector) this.establecimSectorDao
				.find(establecimSector);
	}

	/**
	 * Finds a List of rows in the EstablecimSector table.
	 * 
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstablecimSector> findAll(EstablecimSector establecimSector,
			Pagination pagination) {
		return (List<EstablecimSector>) this.establecimSectorDao.findAll(
				establecimSector, pagination);
	}

	/**
	 * Counts rows in the EstablecimSector table.
	 * 
	 * @param establecimSector
	 *            EstablecimSector
	 * @return Long
	 */
	public Long findAllCount(EstablecimSector establecimSector) {
		return this.establecimSectorDao.findAllCount(establecimSector);
	}

	/**
	 * Finds rows in the EstablecimSector table using like.
	 * 
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<EstablecimSector> findAllLike(
			EstablecimSector establecimSector, Pagination pagination,
			Boolean startsWith) {
		return (List<EstablecimSector>) this.establecimSectorDao.findAllLike(
				establecimSector, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the EstablecimSector table.
	 * 
	 * @param establecimSector
	 *            EstablecimSector
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EstablecimSector establecimSector) {

		this.establecimSectorDao.remove(establecimSector);

	}

	/**
	 * Deletes multiple rows in the EstablecimSector table.
	 * 
	 * @param establecimSectorList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<EstablecimSector> establecimSectorList) {
		for (EstablecimSector establecimSectorAux : establecimSectorList) {
			this.establecimSectorDao.remove(establecimSectorAux);
		}
	}

	/**
	 * Getter method for EstablecimSectorDao
	 * 
	 * @return EstablecimSectorDao
	 */
	public EstablecimSectorDao getEstablecimSectorDao() {
		return this.establecimSectorDao;
	}

	/**
	 * Setter method for EstablecimSectorDao.
	 * 
	 * @param establecimSectorDao
	 *            EstablecimSectorDao
	 * @return
	 */
	public void setEstablecimSectorDao(EstablecimSectorDao establecimSectorDao) {
		logger.info("Setting Dependency " + establecimSectorDao);
		this.establecimSectorDao = establecimSectorDao;
	}
}
