package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.DocumentoHechoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.DocumentoHecho;
import com.ejie.y41a.model.TramiteComun;

/**
 * * DocumentoHechoServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

@Service(value = "documentoHechoService")
public class DocumentoHechoServiceImpl implements DocumentoHechoService {

	private static final Logger logger = LoggerFactory
			.getLogger(DocumentoHechoServiceImpl.class);
	@Autowired
	private DocumentoHechoDao documentoHechoDao;

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentoHecho add(DocumentoHecho documentoHecho) {
		return this.documentoHechoDao.add(documentoHecho);
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentoHecho update(DocumentoHecho documentoHecho) {
		return this.documentoHechoDao.update(documentoHecho);
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	public DocumentoHecho find(DocumentoHecho documentoHecho) {
		return (DocumentoHecho) this.documentoHechoDao.find(documentoHecho);
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoHecho> findAll(DocumentoHecho documentoHecho,
			Pagination pagination) {
		return (List<DocumentoHecho>) this.documentoHechoDao.findAll(
				documentoHecho, pagination);
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	public Long findAllCount(DocumentoHecho documentoHecho) {
		return this.documentoHechoDao.findAllCount(documentoHecho);
	}

	/**
	 * Finds rows in the DocumentoHecho table using like.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<DocumentoHecho> findAllLike(DocumentoHecho documentoHecho,
			Pagination pagination, Boolean startsWith) {
		return (List<DocumentoHecho>) this.documentoHechoDao.findAllLike(
				documentoHecho, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DocumentoHecho documentoHecho) {
		this.documentoHechoDao.remove(documentoHecho);
	}

	/**
	 * Deletes multiple rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<DocumentoHecho> documentoHechoList) {
		for (DocumentoHecho documentoHechoAux : documentoHechoList) {
			this.documentoHechoDao.remove(documentoHechoAux);
		}
	}

	/**
	 * Getter method for DocumentoHechoDao
	 * 
	 * @return DocumentoHechoDao
	 */
	public DocumentoHechoDao getDocumentoHechoDao() {
		return this.documentoHechoDao;
	}

	/**
	 * Setter method for DocumentoHechoDao.
	 * 
	 * @param documentoHechoDao
	 *            DocumentoHechoDao
	 * @return
	 */
	public void setDocumentoHechoDao(DocumentoHechoDao documentoHechoDao) {
		logger.info("Setting Dependency " + documentoHechoDao);
		this.documentoHechoDao = documentoHechoDao;
	}

	/**
	 * Obtiene todos los documentos asociados a un trámite
	 * 
	 * @param tramiteComun
	 *            TramiteComun filtro de trámite
	 * @param pagination
	 *            Pagination paginación
	 * @return List<DocumentoHecho> lista de documentos
	 */
	public List<DocumentoHecho> findAllDocumentosByTramite(
			TramiteComun tramiteComun, Pagination pagination) {
		return this.documentoHechoDao.findAllDocumentosByTramite(tramiteComun,
				pagination);
	}

	/**
	 * Cuenta los documentos asociados a un trámite
	 * 
	 * @param tramiteComun
	 *            TramiteComun filtro de trámite
	 * @return Long número de resultados
	 */
	public Long findAllDocumentosTramiteByCount(TramiteComun tramiteComun) {
		return this.documentoHechoDao
				.findAllDocumentosByTramiteCount(tramiteComun);
	}
}
