package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41a.model.DocumentoHecho;
import com.ejie.y41a.model.TramiteComun;

/**
 * * DocumentoHechoService generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

public interface DocumentoHechoService {

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	DocumentoHecho add(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	DocumentoHecho update(DocumentoHecho documentoHecho);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	DocumentoHecho find(DocumentoHecho documentoHecho);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoHecho> findAll(DocumentoHecho documentoHecho,
			Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	Long findAllCount(DocumentoHecho documentoHecho);

	/**
	 * Finds rows in the DocumentoHecho table using like.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DocumentoHecho> findAllLike(DocumentoHecho documentoHecho,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return
	 */
	void remove(DocumentoHecho documentoHecho);

	/**
	 * Deletes multiple rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<DocumentoHecho> documentoHechoList);

	/**
	 * Obtiene todos los documentos asociados a un trámite
	 * 
	 * @param tramiteComun
	 *            TramiteComun filtro de trámite
	 * @param pagination
	 *            Pagination paginación
	 * @return List<DocumentoHecho> lista de documentos
	 */
	public List<DocumentoHecho> findAllDocumentosByTramite(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Cuenta los documentos asociados a un trámite
	 * 
	 * @param tramiteComun
	 *            TramiteComun filtro de trámite
	 * @return Long número de resultados
	 */
	public Long findAllDocumentosTramiteByCount(TramiteComun tramiteComun);

}
