package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.DestComunicacionDao;
import com.ejie.y41a.model.DestComunicacion;
import com.ejie.y41a.model.DestComunicacionBusqueda;

/**
 * * DestComunicacionServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

@Service(value = "destComunicacionService")
public class DestComunicacionServiceImpl implements DestComunicacionService {

	private static final Logger logger = LoggerFactory
			.getLogger(DestComunicacionServiceImpl.class);
	@Autowired
	private DestComunicacionDao destComunicacionDao;

	/**
	 * Inserts a single row in the DestComunicacion table.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @return DestComunicacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DestComunicacion add(DestComunicacion destComunicacion) {
		return this.destComunicacionDao.add(destComunicacion);
	}

	/**
	 * Updates a single row in the DestComunicacion table.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @return DestComunicacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DestComunicacion update(DestComunicacion destComunicacion) {
		return this.destComunicacionDao.update(destComunicacion);
	}

	/**
	 * Finds a single row in the DestComunicacion table.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @return DestComunicacion
	 */
	public DestComunicacion find(DestComunicacion destComunicacion) {
		return (DestComunicacion) this.destComunicacionDao
				.find(destComunicacion);
	}

	/**
	 * Finds a List of rows in the DestComunicacion table.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DestComunicacion> findAll(DestComunicacion destComunicacion,
			Pagination pagination) {
		return (List<DestComunicacion>) this.destComunicacionDao.findAll(
				destComunicacion, pagination);
	}

	/**
	 * Finds a List of rows in the DestComunicacion table.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DestComunicacionBusqueda> findAllDestinatario(
			DestComunicacion destComunicacion, Pagination pagination) {

		List<DestComunicacionBusqueda> listDestComunicacionBusqueda = new ArrayList<DestComunicacionBusqueda>();

		List<DestComunicacion> listDestComunicacion = this.destComunicacionDao
				.findAll(destComunicacion, pagination);

		String leido = null;

		for (DestComunicacion destCom : listDestComunicacion) {

			if (destCom.getM5feleido() != null) {
				leido = Y41aConstantes.VALOR_SI;
			} else {
				leido = Y41aConstantes.VALOR_NO;
			}

			listDestComunicacionBusqueda.add(new DestComunicacionBusqueda(
					destCom.getOrganismo().getCodOrg(), destCom
							.getComunicacion().getM4cocomu(), destCom
							.getOrganismo().getEntidadId(), destCom
							.getOrganismo().getNombreEs(), destCom
							.getOrganismo().getNombreEu(), destCom
							.getM5feleido(), leido));
		}

		return listDestComunicacionBusqueda;

	}

	/**
	 * Counts rows in the DestComunicacion table.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @return Long
	 */
	public Long findAllCount(DestComunicacion destComunicacion) {
		return this.destComunicacionDao.findAllCount(destComunicacion);
	}

	/**
	 * Finds rows in the DestComunicacion table using like.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<DestComunicacion> findAllLike(
			DestComunicacion destComunicacion, Pagination pagination,
			Boolean startsWith) {
		return (List<DestComunicacion>) this.destComunicacionDao.findAllLike(
				destComunicacion, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the DestComunicacion table.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DestComunicacion destComunicacion) {
		this.destComunicacionDao.remove(destComunicacion);
	}

	/**
	 * Deletes multiple rows in the DestComunicacion table.
	 * 
	 * @param destComunicacionList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<DestComunicacion> destComunicacionList) {
		for (DestComunicacion destComunicacionAux : destComunicacionList) {
			this.destComunicacionDao.remove(destComunicacionAux);
		}
	}

	/**
	 * Getter method for DestComunicacionDao
	 * 
	 * @return DestComunicacionDao
	 */
	public DestComunicacionDao getDestComunicacionDao() {
		return this.destComunicacionDao;
	}

	/**
	 * Setter method for DestComunicacionDao.
	 * 
	 * @param destComunicacionDao
	 *            DestComunicacionDao
	 * @return
	 */
	public void setDestComunicacionDao(DestComunicacionDao destComunicacionDao) {
		logger.info("Setting Dependency " + destComunicacionDao);
		this.destComunicacionDao = destComunicacionDao;
	}
}
