package com.ejie.y41a.service;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ArbpropbandejaDao;
import com.ejie.y41a.dao.BandejaSolicitudesDao;
import com.ejie.y41a.dao.CensoMonitorDao;
import com.ejie.y41a.dao.ConsumidorDao;
import com.ejie.y41a.dao.DecisionDao;
import com.ejie.y41a.dao.DecisionHechoDao;
import com.ejie.y41a.dao.DenunciaDao;
import com.ejie.y41a.dao.DenunciaRecibDao;
import com.ejie.y41a.dao.DocumentoHechoDao;
import com.ejie.y41a.dao.EstablecimArbitraDao;
import com.ejie.y41a.dao.EstablecimSectorDao;
import com.ejie.y41a.dao.EstablecimientoDao;
import com.ejie.y41a.dao.EstadisticasListadosKontsumonetDao;
import com.ejie.y41a.dao.EstadisticasListadosSolicitudesDao;
import com.ejie.y41a.dao.HechoDenunciadoDao;
import com.ejie.y41a.dao.IntervinientesDao;
import com.ejie.y41a.dao.NumSolicitudDao;
import com.ejie.y41a.dao.OrganismoDao;
import com.ejie.y41a.dao.PlantillaDecisionDao;
import com.ejie.y41a.dao.PlantillaTramiteDao;
import com.ejie.y41a.dao.SanexprelDao;
import com.ejie.y41a.dao.SolarbDao;
import com.ejie.y41a.dao.SolicitudArbitrajeDao;
import com.ejie.y41a.dao.TramiteHechoDao;
import com.ejie.y41a.dao.TrasladoDao;
import com.ejie.y41a.model.Actividad;
import com.ejie.y41a.model.Arbpropbandeja;
import com.ejie.y41a.model.AttachFile;
import com.ejie.y41a.model.BandejaSolicitudesKonbide;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Consumidor;
import com.ejie.y41a.model.Decision;
import com.ejie.y41a.model.DecisionHecho;
import com.ejie.y41a.model.DecisionHechoDetalle;
import com.ejie.y41a.model.Denuncia;
import com.ejie.y41a.model.DenunciaRecib;
import com.ejie.y41a.model.DocumentoHecho;
import com.ejie.y41a.model.DocumentoHechoDetalle;
import com.ejie.y41a.model.EstablecimArbitra;
import com.ejie.y41a.model.EstablecimSector;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41a.model.EstadisticasKontsumonetResultado;
import com.ejie.y41a.model.EstadisticasSolicitudesResultado;
import com.ejie.y41a.model.FormaPresentacion;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.Intervinientes;
import com.ejie.y41a.model.ListadoSolicitudResultado;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.model.PlantillaDecision;
import com.ejie.y41a.model.PlantillaSolicitudDetalle;
import com.ejie.y41a.model.PlantillaTramite;
import com.ejie.y41a.model.PlantillaTramiteDecisionDetalle;
import com.ejie.y41a.model.PlantillaTramiteHechoDetalle;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.Sanexprel;
import com.ejie.y41a.model.Sector;
import com.ejie.y41a.model.Solarb;
import com.ejie.y41a.model.SolicitudArbitrajeDetalle;
import com.ejie.y41a.model.SolicitudBusqueda;
import com.ejie.y41a.model.SolicitudDetalle;
import com.ejie.y41a.model.TipoReclamacion;
import com.ejie.y41a.model.Tramite;
import com.ejie.y41a.model.TramiteComun;
import com.ejie.y41a.model.TramiteHecho;
import com.ejie.y41a.model.TramiteHechoDetalle;
import com.ejie.y41a.model.TramiteHechoDetalleMail;
import com.ejie.y41a.model.TramiteHechoKonbide;
import com.ejie.y41a.model.Traslado;
import com.ejie.y41a.model.TrasladoBusqueda;
import com.ejie.y41a.utils.Y41aStringUtils;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.config.Y41aConfig;
import com.ejie.y41a.utils.documentos.Y41aGenerarDocumento;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * DenunciaServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

@Service(value = "denunciaService")
public class DenunciaServiceImpl implements DenunciaService {

	private static final Logger logger = LoggerFactory
			.getLogger(DenunciaServiceImpl.class);
	@Autowired
	private DenunciaDao denunciaDao;
	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;
	@Autowired
	private EstadisticasListadosSolicitudesDao estadisticasListadosSolicitudesDao;
	@Autowired
	private EstadisticasListadosKontsumonetDao estadisticasListadosKontsumonetDao;
	@Autowired
	private TramiteHechoDao tramiteHechoDao;
	@Autowired
	private DecisionHechoDao decisionHechoDao;
	@Autowired
	private DocumentoHechoDao documentoHechoDao;
	@Autowired
	private PlantillaTramiteDao plantillaTramiteDao;
	@Autowired
	private PlantillaDecisionDao plantillaDecisionDao;
	@Autowired
	private TrasladoDao trasladoDao;
	@Autowired
	private OrganismoDao organismoDao;
	@Autowired
	private SolicitudArbitrajeDao solicitudArbitrajeDao;
	@Autowired
	private DenunciaRecibDao denunciaRecibDao;
	@Autowired
	private BandejaSolicitudesDao bandejaSolicitudesDao;
	@Autowired
	private IntervinientesDao intervinientesDao;
	@Autowired
	private ConsumidorDao consumidorDao;
	@Autowired
	private EstablecimientoDao establecimientoDao;
	@Autowired
	private EstablecimSectorDao establecimSectorDao;
	@Autowired
	private NumSolicitudDao numSolicitudDao;
	@Autowired
	private DecisionDao decisionDao;
	@Autowired
	private CensoMonitorDao censoMonitorDao;
	@Autowired
	private ArbpropbandejaDao arbpropbandejaDao;
	@Autowired
	private SanexprelDao sanexprelDao;
	@Autowired
	private SolarbDao solarbDao;
	@Autowired
	private EstablecimArbitraDao establecimArbitraDao;

	// @Autowired
	// private TramiteDao tramiteDao;
	//
	// @Autowired
	// private ParametrosDao parametrosDao;
	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Denuncia add(Denuncia denuncia) {
		return this.denunciaDao.add(denuncia);
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle addSolicitud(SolicitudDetalle solicitudDetalle) {

		try {
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(solicitudDetalle.getTfpcodigo());

			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(solicitudDetalle.getDtcodigo());

			Denuncia denuncia = new Denuncia(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE), null,
					solicitudDetalle.getDecoor(), solicitudDetalle.getDenran(),
					solicitudDetalle.getDenror(), solicitudDetalle.getDefede(),
					solicitudDetalle.getDefere(), null, null,
					Y41aConstantes.VALOR_NO, null, formaPresentacion,
					consumidor);

			Denuncia denunciaAux = this.numSolicitudDao
					.findNumSolicitud(denuncia);

			denuncia.setDenror(denunciaAux.getDenror());

			denuncia.setDehojareclamacion(solicitudDetalle
					.getDehojareclamacion());

			this.numSolicitudDao.add(denuncia);

			solicitudDetalle.setDecodigo(denuncia.getDecodigo());

			// Da de alta denuncia
			this.denunciaDao.addDenuncia(denuncia);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(solicitudDetalle.getEscodigo());

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(solicitudDetalle.getMocodigo());

			Producto producto = new Producto();
			producto.setPscodigo(solicitudDetalle.getPscodigo());

			TipoReclamacion tipoReclamacion = new TipoReclamacion();
			tipoReclamacion.setTsrcodigo(solicitudDetalle.getTsrcodigo());

			Motivo motivo = new Motivo();
			motivo.setTircodigo(solicitudDetalle.getTircodigo());

			HechoDenunciado hechoDenunciado = new HechoDenunciado(
					Y41aUIDGenerator.getInstance().generateId(
							Y41aConstantes.PK_SIZE),
					solicitudDetalle.getHdnror(), solicitudDetalle.getHdte(),
					null, null, null, null, null, null, null, null,
					Y41aConstantes.SOLICITUD_MEDIACION,
					solicitudDetalle.getHdcaptso(),
					solicitudDetalle.getHdteso(), null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, solicitudDetalle.getHdcosc(), null, null, null,
					null, null, null, solicitudDetalle.getHdfehd(), null, null,
					null, null, null, null, null, null, null,
					solicitudDetalle.getHdcodexpedienteorigen(), denuncia,
					establecimiento, null, censoMonitor, producto,
					tipoReclamacion, motivo, solicitudDetalle.getFvcodigo());
			hechoDenunciado.setHdidioma(solicitudDetalle.getHdidioma());

			solicitudDetalle.setHdcodigo(hechoDenunciado.getHdcodigo());

			// Da de alta hecho denuncia
			this.hechoDenunciadoDao.addHechoDenunciado(hechoDenunciado);

			// como calcular la hora
			String ehhora = null;

			try {
				ehhora = Y41aUtils.formatearDateToString(new Date(),
						Y41aConstantes.FORMATO_HORA);
			} catch (ParseException e) {
				ehhora = null;
			}

			Tramite tramite = new Tramite();
			tramite.setTrcodigo(Y41aConstantes.TRAMITE_SOLICITUD_REGISTRO_SOLICITUD);

			// Evita problemas con las fechas desde hasta
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41aUtils.parseDate(today, locale);

			TramiteHecho tramiteHecho = new TramiteHecho(Y41aUIDGenerator
					.getInstance().generateId(Y41aConstantes.PK_SIZE),
					todayWithZeroTime, ehhora, null, null, null, null, null,
					null, null, null, null, null, tramite, censoMonitor,
					hechoDenunciado);

			// Da de alta un tramite de hecho
			this.tramiteHechoDao.add(tramiteHecho);

			DecisionHecho decisionHecho = new DecisionHecho(Y41aUIDGenerator
					.getInstance().generateId(Y41aConstantes.PK_SIZE),
					solicitudDetalle.getDecoor(), null, null, null, null,
					hechoDenunciado, null);

			// Da de alta una decision vacia
			this.decisionHechoDao.add(decisionHecho);

		} catch (DataIntegrityViolationException e) {
			String causa = e.getCause().toString();
			int i = causa.indexOf("L21.FK_L2114T00_03");
			int j = causa.indexOf("L21.FK_L2124T00_03");
			if (i != -1) {
				throw new Y41aUDAException("error.solicitud.consumidor", true,
						e);
			} else if (j != -1) {
				throw new Y41aUDAException("error.solicitud.establecimiento",
						true, e);
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41aUDAException("error.solicitud.addSolicitud", true, e);
		}

		return solicitudDetalle;
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle addNuevoHecho(SolicitudDetalle solicitudDetalle) {

		try {
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(solicitudDetalle.getTfpcodigo());

			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(solicitudDetalle.getDtcodigo());

			Denuncia denuncia = new Denuncia(solicitudDetalle.getDecodigo(),
					null, solicitudDetalle.getDecoor(),
					solicitudDetalle.getDenran(), solicitudDetalle.getDenror(),
					solicitudDetalle.getDefede(), solicitudDetalle.getDefere(),
					null, null, Y41aConstantes.VALOR_NO, null,
					formaPresentacion, consumidor);
			if (solicitudDetalle.getDehojareclamacion() != null) {
				denuncia.setDehojareclamacion(solicitudDetalle
						.getDehojareclamacion());
			}

			// Modifica una denuncia
			this.denunciaDao.update(denuncia);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(solicitudDetalle.getEscodigo());

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(solicitudDetalle.getMocodigo());

			Producto producto = new Producto();
			producto.setPscodigo(solicitudDetalle.getPscodigo());

			TipoReclamacion tipoReclamacion = new TipoReclamacion();
			tipoReclamacion.setTsrcodigo(solicitudDetalle.getTsrcodigo());

			Motivo motivo = new Motivo();
			motivo.setTircodigo(solicitudDetalle.getTircodigo());

			HechoDenunciado hechoDenunciado = new HechoDenunciado(
					Y41aUIDGenerator.getInstance().generateId(
							Y41aConstantes.PK_SIZE),
					solicitudDetalle.getHdnror(), solicitudDetalle.getHdte(),
					null, null, null, null, null, null, null, null,
					Y41aConstantes.SOLICITUD_MEDIACION,
					solicitudDetalle.getHdcaptso(),
					solicitudDetalle.getHdteso(), null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, solicitudDetalle.getHdcosc(), null, null, null,
					null, null, null, solicitudDetalle.getHdfehd(), null, null,
					null, null, null, null, null, null, null,
					solicitudDetalle.getHdcodexpedienteorigen(), denuncia,
					establecimiento, null, censoMonitor, producto,
					tipoReclamacion, motivo, solicitudDetalle.getFvcodigo());
			if (solicitudDetalle.getHdidioma() != null) {
				hechoDenunciado.setHdidioma(solicitudDetalle.getHdidioma());
			}

			// Da de alta hecho denuncia
			this.hechoDenunciadoDao.addHechoDenunciado(hechoDenunciado);

			// como calcular la hora
			String ehhora = null;

			try {
				ehhora = Y41aUtils.formatearDateToString(new Date(),
						Y41aConstantes.FORMATO_HORA);
			} catch (ParseException e) {
				ehhora = null;
			}

			Tramite tramite = new Tramite();
			tramite.setTrcodigo(Y41aConstantes.TRAMITE_SOLICITUD_REGISTRO_SOLICITUD);

			// Evita problemas con las fechas desde hasta
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41aUtils.parseDate(today, locale);

			TramiteHecho tramiteHecho = new TramiteHecho(Y41aUIDGenerator
					.getInstance().generateId(Y41aConstantes.PK_SIZE),
					todayWithZeroTime, ehhora, null, null, null, null, null,
					null, null, null, null, null, tramite, censoMonitor,
					hechoDenunciado);

			// Da de alta un tramite de hecho
			this.tramiteHechoDao.add(tramiteHecho);

			DecisionHecho decisionHecho = new DecisionHecho(Y41aUIDGenerator
					.getInstance().generateId(Y41aConstantes.PK_SIZE),
					solicitudDetalle.getDecoor(), null, null, null, null,
					hechoDenunciado, null);

			// Da de alta una decision vacia
			this.decisionHechoDao.add(decisionHecho);

			solicitudDetalle.setHdcodigo(hechoDenunciado.getHdcodigo());

			return solicitudDetalle;
		} catch (Exception e) {
			throw new Y41aUDAException("error.solicitud.addNuevoHecho", true, e);
		}
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Denuncia update(Denuncia denuncia) {
		return this.denunciaDao.update(denuncia);
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle updateSolicitud(SolicitudDetalle solicitudDetalle) {

		try {
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(solicitudDetalle.getTfpcodigo());

			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(solicitudDetalle.getDtcodigo());

			Denuncia denuncia = new Denuncia(solicitudDetalle.getDecodigo(),
					null, solicitudDetalle.getDecoor(),
					solicitudDetalle.getDenran(), solicitudDetalle.getDenror(),
					solicitudDetalle.getDefede(), solicitudDetalle.getDefere(),
					null, null, Y41aConstantes.VALOR_NO, null,
					formaPresentacion, consumidor);
			if (solicitudDetalle.getDehojareclamacion() != null) {
				denuncia.setDehojareclamacion(solicitudDetalle
						.getDehojareclamacion());
			}
			// Modifica una denuncia
			this.denunciaDao.update(denuncia);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(solicitudDetalle.getEscodigo());

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(solicitudDetalle.getMocodigo());

			Producto producto = new Producto();
			producto.setPscodigo(solicitudDetalle.getPscodigo());

			TipoReclamacion tipoReclamacion = new TipoReclamacion();
			tipoReclamacion.setTsrcodigo(solicitudDetalle.getTsrcodigo());

			Motivo motivo = new Motivo();
			motivo.setTircodigo(solicitudDetalle.getTircodigo());

			HechoDenunciado hechoDenunciado = new HechoDenunciado(
					solicitudDetalle.getHdcodigo(),
					solicitudDetalle.getHdnror(), solicitudDetalle.getHdte(),
					null, null, null, null, null, null, null, null,
					Y41aConstantes.SOLICITUD_MEDIACION,
					solicitudDetalle.getHdcaptso(),
					solicitudDetalle.getHdteso(), null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, solicitudDetalle.getHdcosc(), null, null, null,
					null, null, null, solicitudDetalle.getHdfehd(), null, null,
					null, null, null, null, null, null, null,
					solicitudDetalle.getHdcodexpedienteorigen(), denuncia,
					establecimiento, null, censoMonitor, producto,
					tipoReclamacion, motivo, solicitudDetalle.getFvcodigo());
			if (solicitudDetalle.getHdidioma() != null) {
				hechoDenunciado.setHdidioma(solicitudDetalle.getHdidioma());
			}

			// Da de alta hecho denuncia
			this.hechoDenunciadoDao.update(hechoDenunciado);

		} catch (DataIntegrityViolationException e) {
			String causa = e.getCause().toString();
			int i = causa.indexOf("L21.FK_L2114T00_03");
			int j = causa.indexOf("L21.FK_L2124T00_03");
			if (i != -1) {
				throw new Y41aUDAException("error.solicitud.consumidor", true,
						e);
			} else if (j != -1) {
				throw new Y41aUDAException("error.solicitud.establecimiento",
						true, e);
			}
		}
		return solicitudDetalle;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	public Denuncia find(Denuncia denuncia) {
		return (Denuncia) this.denunciaDao.find(denuncia);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitud(SolicitudDetalle solicitudDetalle) {
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao
				.findSolicitud(solicitudDetalle);

		if (solDetalle != null && solDetalle.getSecodigo() == null) {
			solDetalle.setSecodigo("");
			solDetalle.setSenombre("");
			solDetalle.setSenombree("");
		}

		SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao
				.findLobTablaTemporal(solicitudDetalle);
		solDetalle.setHdte(solDetalleAux.getHdte());

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(solDetalle.getDecoor()).append("-")
				.append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		solDetalle.setNumExpediente(numeroExpediente.toString());

		SolicitudBusqueda solBusqueda = new SolicitudBusqueda();
		solBusqueda.setHdcodigo(solDetalle.getHdcodigo());

		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();

		try {
			tramiteHechoDetalle = this.hechoDenunciadoDao
					.findUltimoTramite(solBusqueda);
		} catch (EmptyResultDataAccessException e) {
		}

		if (tramiteHechoDetalle.getTrcodigo() != null
				&& (tramiteHechoDetalle.getTrcodigo().equals(
						Y41aConstantes.TRAMITE_SOLICITUD_TRASLADO_SOLICITUD) || tramiteHechoDetalle
						.getTrcodigo()
						.equals(Y41aConstantes.TRAMITE_SOLICITUD_RECEPCION_TRASLADO_KONBIDE))) {
			TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
			tramiteHechoDet.setEhcodigo(tramiteHechoDetalle.getEhcodigo());

			TrasladoBusqueda trasladoBusqueda = new TrasladoBusqueda(); // j
			try { // j
				trasladoBusqueda = this.trasladoDao
						.findTrasladoTramite(tramiteHechoDet);
			} catch (EmptyResultDataAccessException e) { // j
			} // j

			solDetalle.setIhcoordt(trasladoBusqueda.getIhcoordt());
			solDetalle.setIhfereen(trasladoBusqueda.getIhfereen());

		} else if (tramiteHechoDetalle.getTrcodigo() != null
				&& tramiteHechoDetalle.getTrcodigo().equals(
						Y41aConstantes.TRAMITE_COMUNICACION)) {

			// Se busca el tramite de traslado de knotsumobide
			TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
			tramiteHechoDetalleAux
					.setTrcodigo(Y41aConstantes.TRAMITE_TRASLADO_RED_CIAC);
			tramiteHechoDetalleAux.setHdcodigo(solDetalle.getHdcodigo());
			try {
				tramiteHechoDetalleAux = this.tramiteHechoDao
						.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);
			} catch (Exception e) {
			}

			if (tramiteHechoDetalleAux.getEhcodigo() != null) {
				TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
				tramiteHechoDet.setEhcodigo(tramiteHechoDetalleAux
						.getEhcodigo());

				TrasladoBusqueda trasladoBusqueda = new TrasladoBusqueda(); // j
				try { // j
					trasladoBusqueda = this.trasladoDao
							.findTrasladoTramite(tramiteHechoDet);
				} catch (EmptyResultDataAccessException e) { // j
				} // j

				solDetalle.setIhcoordt(trasladoBusqueda.getIhcoordt());
				solDetalle.setIhfereen(trasladoBusqueda.getIhfereen());
			}
		}

		// obtener el estado
		if (solDetalle.getHdinsoma() != null
				&& solDetalle.getHdinsoma().equals(
						Y41aConstantes.SOLICITUDES_ARBITRAJE)) {
			solDetalle.setEstado(Y41aConstantes.SOLICITUD_ESTADO_ARBITRAJE); // A
		} else if (solDetalle.getHccoor() != null
				&& !solDetalle.getHccoor().equals(
						solicitudDetalle.getCodOrgConectado())
				&& solDetalle.getOrgiskontsumonet().equals(
						Y41aConstantes.VALOR_SI)) {
			solDetalle.setEstado(Y41aConstantes.SOLICITUD_ESTADO_TRASLADADO); // T
		} else if (solDetalle.getHccoor() != null
				&& !solDetalle.getHccoor().equals(
						solicitudDetalle.getCodOrgConectado())
				&& solDetalle.getOrgiskontsumonet().equals(
						Y41aConstantes.VALOR_NO)) {
			solDetalle.setEstado(Y41aConstantes.SOLICITUD_ESTADO_COMUNICADO); // C
		} else if (solDetalle.getHccoor() != null
				&& solDetalle.getHccoor().equals(
						solicitudDetalle.getCodOrgConectado())) {

			if (solDetalle.getIhcoordt() != null
					&& solDetalle.getIhcoordt().equals(
							solicitudDetalle.getCodOrgConectado())
					&& solDetalle.getIhfereen() == null) {
				solDetalle
						.setEstado(Y41aConstantes.SOLICITUD_ESTADO_TRASLADADO); // T
			} else {
				solDetalle.setEstado(Y41aConstantes.SOLICITUD_ESTADO_MIGESTION); // PR
			}
		}

		try {
			Establecimiento establecimientoAux = new Establecimiento();
			establecimientoAux.setEscodigo(solDetalle.getEscodigo());
			establecimientoAux = this.establecimientoDao
					.find(establecimientoAux);
			solDetalle.setEsinadar(establecimientoAux.getEsinadar());

			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(
					solDetalle.getEscodigo());
			establecimArbitra = this.establecimArbitraDao
					.findArbitraje(establecimArbitra);

			if ("A".equals(solDetalle.getEsinadar())) {
				if (!Y41aUtils.esNullOCadenaVacia(establecimArbitra
						.getAhtelimi())) {
					solDetalle.setEsinadar("L");
				}
			}

		} catch (Exception e) {

		}

		return solDetalle;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return PlantillaSolicitudDetalle
	 */
	public PlantillaSolicitudDetalle findPlantillaSolicitudDetalle(
			SolicitudDetalle solicitudDetalle) {

		// Obtenemos los datos de la consulta de PlantillaSolicitudDetalle
		PlantillaSolicitudDetalle plantillaSolicitudDetalle = this.hechoDenunciadoDao
				.findPlantillaSolicitudDetalle(solicitudDetalle);

		SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao
				.findLobTablaTemporal(solicitudDetalle);

		// plantillaSolicitudDetalle.setHdte(Y41aStringUtils.unescapeHTML(
		// solDetalleAux.getHdte(), 0));
		StringBuffer htde = new StringBuffer();
		try {

			List<String> lines = IOUtils.readLines(new StringReader(
					solDetalleAux.getHdte()));
			for (String string : lines) {
				htde.append(string).append(" \\\\par\\\\pard   ");
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		plantillaSolicitudDetalle.setHdte(htde.toString());

		// plantillaSolicitudDetalle.plantillaSolicitudDetalle.setHdteso(Y41aStringUtils.unescapeHTML(
		// plantillaSolicitudDetalle.getHdteso(), 0));

		if (plantillaSolicitudDetalle.getHdteso() != null) {
			StringBuffer hdteso = new StringBuffer();
			try {

				List<String> lines = IOUtils.readLines(new StringReader(
						plantillaSolicitudDetalle.getHdteso()));
				for (String string : lines) {
					hdteso.append(string).append(" \\\\par\\\\pard   ");
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			plantillaSolicitudDetalle.setHdteso(hdteso.toString());
		} else {
			plantillaSolicitudDetalle.setHdteso("");
		}

		DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
		documentoHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

		// Obtenemos los documentos de la solicitud
		List<DocumentoHechoDetalle> listDocumentoHechoDetalle = this.documentoHechoDao
				.findAllDocumentoHecho(documentoHechoDetalle, null);

		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

		Pagination pagination = new Pagination();
		pagination.setSort("EHFECHA ASC, EHHORA");
		pagination.setAscDsc(Y41aConstantes.ORDENACION_ASC);

		// Obtenemos los tramites de la solicitud
		List<TramiteHechoDetalle> listTramiteHechoDetalle = this.tramiteHechoDao
				.findAllTramiteHecho(tramiteHechoDetalle, pagination);

		// Creamos la tabla de documentos
		String tablaDocumentos = this
				.generarTablaDocumentos(listDocumentoHechoDetalle);
		plantillaSolicitudDetalle.setTablaDocumentacion(tablaDocumentos);

		// Creamos la tabla de tramites
		String tablaTramites = this
				.generarTablaTramites(listTramiteHechoDetalle);
		plantillaSolicitudDetalle.setTablaTramites(tablaTramites);

		// Completamos el objetos con las fechas en formato texto
		plantillaSolicitudDetalle = this
				.completeInfoPlantillaSolicitudDetalle(plantillaSolicitudDetalle);

		// Devolvemos el objeto
		return plantillaSolicitudDetalle;

	}

	/**
	 * Complete information of the object PlantillaSolicitudDetalle.
	 * 
	 * @param plantillaSolicitudDetalle
	 *            PlantillaSolicitudDetalle
	 * @return PlantillaSolicitudDetalle
	 */
	private PlantillaSolicitudDetalle completeInfoPlantillaSolicitudDetalle(
			PlantillaSolicitudDetalle plantillaSolicitudDetalle) {

		try {
			if (plantillaSolicitudDetalle.getDtcalleId_label() == null
					|| plantillaSolicitudDetalle.getDtcalleId_label()
							.equals("")) {
				if (plantillaSolicitudDetalle.getDtdireccion_nocapv() == null
						|| plantillaSolicitudDetalle.getDtdireccion_nocapv()
								.equals("")) {
					plantillaSolicitudDetalle
							.setDtcalleId_label(plantillaSolicitudDetalle
									.getDtnodir());
				} else {
					plantillaSolicitudDetalle
							.setDtcalleId_label(plantillaSolicitudDetalle
									.getDtdireccion_nocapv());
				}
			} else {
				StringBuffer domicilio = new StringBuffer();
				domicilio
						.append(plantillaSolicitudDetalle.getDtcalleId_label());

				if (plantillaSolicitudDetalle.getDtnombrePortal() != null) {
					domicilio.append(", ").append(
							plantillaSolicitudDetalle.getDtnombrePortal());
				}
				if (plantillaSolicitudDetalle.getDtnombrePiso() != null) {
					domicilio.append(" ").append(
							plantillaSolicitudDetalle.getDtnombrePiso());
				}
				plantillaSolicitudDetalle.setDtcalleId_label(domicilio
						.toString());
			}

			if (plantillaSolicitudDetalle.getEscalleId_label() == null
					|| plantillaSolicitudDetalle.getEscalleId_label()
							.equals("")) {
				if (plantillaSolicitudDetalle.getEsdireccion_nocapv() == null
						|| plantillaSolicitudDetalle.getEsdireccion_nocapv()
								.equals("")) {

					plantillaSolicitudDetalle
							.setEscalleId_label(plantillaSolicitudDetalle
									.getEsnodir());
				} else {
					plantillaSolicitudDetalle
							.setEscalleId_label(plantillaSolicitudDetalle
									.getEsdireccion_nocapv());
				}
			} else {
				StringBuffer domicilio = new StringBuffer();
				domicilio
						.append(plantillaSolicitudDetalle.getEscalleId_label());

				if (plantillaSolicitudDetalle.getEsnombrePortal() != null) {
					domicilio.append(", ").append(
							plantillaSolicitudDetalle.getEsnombrePortal());
				}
				if (plantillaSolicitudDetalle.getEsnombrePiso() != null) {
					domicilio.append(" ").append(
							plantillaSolicitudDetalle.getEsnombrePiso());
				}
				plantillaSolicitudDetalle.setEscalleId_label(domicilio
						.toString());
			}

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(plantillaSolicitudDetalle.getDecoor())
					.append("-").append(plantillaSolicitudDetalle.getDenror())
					.append("-").append(plantillaSolicitudDetalle.getDenran())
					.append("-").append(plantillaSolicitudDetalle.getHdnror());

			plantillaSolicitudDetalle.setNumExpediente(numeroExpediente
					.toString());

			// Formateamos las fecha a castellano e euskera
			plantillaSolicitudDetalle.setFechaActualTextoCas(Y41aUtils
					.formatearDateToString(new Date(),
							Y41aConstantes.FORMATO_FULL_FECHA_ES,
							Y41aConstantes.CASTELLANO));
			plantillaSolicitudDetalle.setFechaActualTextoEus(Y41aUtils
					.formatearDateToStringEuskera(new Date(),
							Y41aConstantes.FORMATO_FULL_FECHA_EU,
							Y41aConstantes.EUSKERA));

			return plantillaSolicitudDetalle;

		} catch (ParseException e) {
			throw new Y41aUDAException("error.solicitud.plantill", true, e);
		}
	}

	/**
	 * Genera la tabla de documentos que estara en la plantilla de la solicitud
	 * 
	 * @param documentoHechoDetalleList
	 *            List
	 * @return String
	 */
	private String generarTablaDocumentos(
			List<DocumentoHechoDetalle> documentoHechoDetalleList) {

		/*** Insertar TABLA ***/
		StringBuffer stablaDoc = new StringBuffer(120);
		stablaDoc.append("{ ");
		// stablaDoc.append(" \\\\pard\\\\par");

		// Tabla: línea inicial
		stablaDoc.append(" \\\\trowd ");
		stablaDoc.append(" \\\\trgaph0 ");
		stablaDoc.append(" \\\\trrh-500 ");

		// Bordes de la fila
		stablaDoc.append(" \\\\trbrdrt\\\\brdrs\\\\brdrw10 ");
		stablaDoc.append(" \\\\trbrdrl\\\\brdrs\\\\brdrw10 ");
		stablaDoc.append(" \\\\trbrdrb\\\\brdrs\\\\brdrw10 ");
		stablaDoc.append(" \\\\trbrdrr\\\\brdrs\\\\brdrw10 ");

		// // Bordes de la primera celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx8500");

		// Fin de la definición de fila
		stablaDoc.append(" \\\\pard ");

		if (documentoHechoDetalleList != null) {
			for (DocumentoHechoDetalle documentoHechoDetalleAux : documentoHechoDetalleList) {
				stablaDoc.append(documentoHechoDetalleAux.getQ5nofile());
				stablaDoc.append("\\\\cell");
				stablaDoc.append(" \\\\row ");
			}
		}

		stablaDoc.append(" \\\\pard ");
		// Cierre final
		stablaDoc.append("}");

		return stablaDoc.toString();
	}

	/**
	 * Genera la tabla de tramites que estara en la plantilla de la solicitud
	 * 
	 * @param tramiteHechoDetalleList
	 *            List
	 * @return String
	 */
	private String generarTablaTramites( /*********************************************/
	List<TramiteHechoDetalle> tramiteHechoDetalleList) {

		StringBuffer stablaDoc = new StringBuffer(120);
		stablaDoc.append("{ ");
		// stablaDoc.append(" \\\\pard\\\\par");
		// Tabla: línea inicial
		stablaDoc.append(" \\\\trowd ");
		stablaDoc.append(" \\\\trgaph0 ");
		stablaDoc.append(" \\\\trrh500 ");// stablaDoc.append(" \\\\trrh-500 ");

		// Bordes de la fila
		stablaDoc.append("\\\\trbrdrt\\\\brdrs\\\\brdrw10");
		stablaDoc.append("\\\\trbrdrl\\\\brdrs\\\\brdrw10");
		stablaDoc.append("\\\\trbrdrb\\\\brdrs\\\\brdrw10");
		stablaDoc.append("\\\\trbrdrr\\\\brdrs\\\\brdrw10");

		// Bordes de la primera celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx2055");

		// Bordes de la segunda celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx3402");

		// Bordes de la tercera celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx4750");

		// Bordes de la cuarta celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx6663");

		// Bordes de la quinta celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx8612");

		// Fin de la definición de fila
		stablaDoc.append(" \\\\pard ");

		// Trazado de la filas

		// inicio cabecera *****************
		// stablaDoc.append(" \\\\intbl ");

		// c1
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("MONITOREA");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  MONITOR");
		stablaDoc.append(" \\\\cell ");
		// c2
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("DATA");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  FECHA");
		stablaDoc.append(" \\\\cell ");
		// c3
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("ORDU");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  HORA");
		stablaDoc.append(" \\\\cell ");
		// c4
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("IZAPIDEA");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  TRAMITE");
		stablaDoc.append(" \\\\cell ");
		// c5
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("DATA");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  COMENTARIO");
		stablaDoc.append(" \\\\cell  ");

		stablaDoc.append(" \\\\row  ");
		// fin cabecera **********************

		// Inicio Resto filas

		if (tramiteHechoDetalleList != null) {
			for (TramiteHechoDetalle tramiteHechoDetalleAux : tramiteHechoDetalleList) {
				// stablaDoc.append(" \\\\intbl ");

				if (Y41aUtils.isFilled(tramiteHechoDetalleAux.getMonombre())) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(tramiteHechoDetalleAux.getMonombre());
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				if (tramiteHechoDetalleAux.getEhfecha() != null) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(Y41aUtils.parseDateToString(
							tramiteHechoDetalleAux.getEhfecha(),
							Y41aConstantes.CASTELLANO));
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				if (Y41aUtils.isFilled(tramiteHechoDetalleAux.getEhhora())) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(tramiteHechoDetalleAux.getEhhora());
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				if (Y41aUtils.isFilled(tramiteHechoDetalleAux.getTrnombre())) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(tramiteHechoDetalleAux.getTrnombree());
					stablaDoc.append(" / ");
					stablaDoc.append(tramiteHechoDetalleAux.getTrnombre());
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				TramiteHechoDetalle tramHechoDetalle = this.tramiteHechoDao
						.findLobTablaTemporal(tramiteHechoDetalleAux);
				if (Y41aUtils.isFilled(tramHechoDetalle.getEhtexto())) {
					tramiteHechoDetalleAux.setEhtexto(Y41aStringUtils
							.unescapeHTML(
									Y41aUtils.eliminarTags(tramHechoDetalle
											.getEhtexto()), 0));
				}

				if (Y41aUtils.isFilled(tramiteHechoDetalleAux.getEhtexto())) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(tramiteHechoDetalleAux.getEhtexto());
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				stablaDoc.append("  \\\\row  ");
			}
		}

		// Fin resto filas
		stablaDoc.append(" \\\\pard\\\\par ");
		// Cierre final
		stablaDoc.append("}");

		// /*** Insertar TABLA ***/
		// StringBuffer stablaDoc = new StringBuffer(120);
		// stablaDoc.append("{"); // <-- Inicio de la tabla
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append("\\\\trowd");
		// stablaDoc.append("\\\\trqc");
		//
		// stablaDoc.append("\\\\trgaph0");// <--márgenes izquierdo y derecho
		// de
		// // las celdas=70
		//
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx2055");//
		// stablaDoc.append("\\\\cellx1985");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx3402");//
		// stablaDoc.append("\\\\cellx3402");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx4750");//
		// stablaDoc.append("\\\\cellx4820");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx6663");//
		// stablaDoc.append("\\\\cellx6663");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx8612");//
		// stablaDoc.append("\\\\cellx8612");
		//
		// // Cabecera
		// //
		// ******************************************************************************
		//
		// stablaDoc.append("{");
		//
		// // Columna 1
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc  ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("MONITOREA");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" / MONITOR");
		// stablaDoc.append(" \\\\cell ");
		//
		// // Columna 2
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc  ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("DATA");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" /  FECHA");
		// stablaDoc.append(" \\\\cell ");
		//
		// // Columna 3
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc  ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("ORDU");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" /  HORA");
		// stablaDoc.append(" \\\\cell ");
		//
		// // Columna 4
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc  ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("IZAPIDEA");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" /  TRAMITE");
		// stablaDoc.append(" \\\\cell ");
		//
		// // Columna 5
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc  ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("DATA");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" /  COMENTARIO");
		// stablaDoc.append(" \\\\cell }");
		//
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" \\\\ql ");
		// stablaDoc.append(" \\\\row");
		//
		// // Hasta aquí generación de cabecera
		// // *************************************************************
		//
		// if (tramiteHechoDetalleList != null) {
		// for (TramiteHechoDetalle tramiteHechoDetalleAux :
		// tramiteHechoDetalleList) {
		//
		// // TABLA
		// stablaDoc.append("\\\\trowd");
		// stablaDoc.append("\\\\trgaph00");// <--márgenes izquierdo y
		// // derecho
		// // de las celdas=70
		// stablaDoc.append("\\\\trqc");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx2055");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx3402");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx4750");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx6663");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx8612");
		//
		// if (Y41aUtils.isFilled(tramiteHechoDetalleAux.getMonombre())) {
		// stablaDoc.append(tramiteHechoDetalleAux.getMonombre());
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// if (tramiteHechoDetalleAux.getEhfecha() != null) {
		// stablaDoc.append(Y41aUtils.parseDateToString(
		// tramiteHechoDetalleAux.getEhfecha(),
		// Y41aConstantes.CASTELLANO));
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// if (Y41aUtils.isFilled(tramiteHechoDetalleAux.getEhhora())) {
		// stablaDoc.append(tramiteHechoDetalleAux.getEhhora());
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// if (Y41aUtils.isFilled(tramiteHechoDetalleAux.getTrnombre())) {
		// stablaDoc.append(tramiteHechoDetalleAux.getTrnombree());
		// stablaDoc.append(" / ");
		// stablaDoc.append(tramiteHechoDetalleAux.getTrnombre());
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// if (Y41aUtils.isFilled(tramiteHechoDetalleAux.getEhtexto())) {
		// stablaDoc.append(tramiteHechoDetalleAux.getEhtexto());
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// stablaDoc.append(" \\\\row");
		// }
		// }
		//
		// // Cierre final
		// stablaDoc.append("}");

		return stablaDoc.toString();
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Denuncia> findAll(Denuncia denuncia, Pagination pagination) {
		return (List<Denuncia>) this.denunciaDao.findAll(denuncia, pagination);
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Long
	 */
	public Long findAllCount(Denuncia denuncia) {
		return this.denunciaDao.findAllCount(denuncia);
	}

	/**
	 * Finds rows in the Denuncia table using like.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Denuncia> findAllLike(Denuncia denuncia, Pagination pagination,
			Boolean startsWith) {
		return (List<Denuncia>) this.denunciaDao.findAllLike(denuncia,
				pagination, startsWith);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllLikeSolicitudes(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		// Control para poder paginar por un campo calculado - numeroExpediente
		// //ASCENDENTE
		if (pagination.getSort() != null
				&& pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("numExpediente")) {
			pagination.setSort("decoor, denror, denran");
		}

		if (pagination.getSort() != null
				&& pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("numExpediente")) {
			pagination.setSort("decoor DESC, denror DESC, denran");
		}

		if (pagination.getSort() != null
				&& pagination.getSort().equals("dtnombreMunicipio")) {
			pagination.setSort("DTNOMBRE_MUNICIPIO");
		}

		try {
			List<SolicitudBusqueda> listSolicitudesBusqueda = this.hechoDenunciadoDao
					.findAllLikeSolicitudes(solicitudesBusqueda, pagination,
							startsWith, defedeDesde, defedeHasta, defereDesde,
							defereHasta, hcfedeDesde, hcfedeHasta);

			for (SolicitudBusqueda sol : listSolicitudesBusqueda) {
				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(sol.getDecoor()).append("-")
						.append(sol.getDenror()).append("-")
						.append(sol.getDenran()).append("-")
						.append(sol.getHdnror());

				sol.setNumExpediente(numeroExpediente.toString());

				TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();

				try {
					// obtener el ultimo tramite tramiteHechoDetalle =
					tramiteHechoDetalle = this.hechoDenunciadoDao
							.findUltimoTramite(sol);
				} catch (EmptyResultDataAccessException e) {
				}

				sol.setTrcodigo(tramiteHechoDetalle.getTrcodigo());
				sol.setTrnombre(tramiteHechoDetalle.getTrnombre());
				sol.setTrnombree(tramiteHechoDetalle.getTrnombree());

				Organismo organismo = new Organismo();
				organismo.setCodOrg(sol.getHccoor());

				organismo = this.organismoDao.findOrganismo(organismo);
				sol.setOrgiskontsumonet(organismo.getIskontsumonet());

				if (tramiteHechoDetalle.getTrcodigo() != null
						&& (tramiteHechoDetalle
								.getTrcodigo()
								.equals(Y41aConstantes.TRAMITE_SOLICITUD_TRASLADO_SOLICITUD) || tramiteHechoDetalle
								.getTrcodigo()
								.equals(Y41aConstantes.TRAMITE_SOLICITUD_RECEPCION_TRASLADO_KONBIDE))) {
					TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
					tramiteHechoDet.setEhcodigo(tramiteHechoDetalle
							.getEhcodigo());

					TrasladoBusqueda trasladoBusqueda = new TrasladoBusqueda(); // j
					try { // j
						trasladoBusqueda = this.trasladoDao
								.findTrasladoTramite(tramiteHechoDet);
					} catch (EmptyResultDataAccessException e) { // j
					} // j

					sol.setIhcoordt(trasladoBusqueda.getIhcoordt());
					sol.setIhfereen(trasladoBusqueda.getIhfereen());
				} else if (tramiteHechoDetalle.getTrcodigo() != null
						&& tramiteHechoDetalle.getTrcodigo().equals(
								Y41aConstantes.TRAMITE_COMUNICACION)) {

					// Se busca el tramite de traslado de knotsumobide
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					tramiteHechoDetalleAux
							.setTrcodigo(Y41aConstantes.TRAMITE_TRASLADO_RED_CIAC);
					tramiteHechoDetalleAux.setHdcodigo(sol.getHdcodigo());
					try {
						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux.getEhcodigo() != null) {
						TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
						tramiteHechoDet.setEhcodigo(tramiteHechoDetalleAux
								.getEhcodigo());

						TrasladoBusqueda trasladoBusqueda = new TrasladoBusqueda(); // j
						try { // j
							trasladoBusqueda = this.trasladoDao
									.findTrasladoTramite(tramiteHechoDet);
						} catch (EmptyResultDataAccessException e) { // j
						} // j

						sol.setIhcoordt(trasladoBusqueda.getIhcoordt());
						sol.setIhfereen(trasladoBusqueda.getIhfereen());
					}
				}

				// obtener el estado
				if (sol.getHdinsoma() != null
						&& sol.getHdinsoma().equals(
								Y41aConstantes.SOLICITUDES_ARBITRAJE)) {
					sol.setEstado(Y41aConstantes.SOLICITUD_ESTADO_ARBITRAJE); // A
				} else if (sol.getHccoor() != null
						&& !sol.getHccoor().equals(
								solicitudesBusqueda.getCodOrgConectado())
						&& sol.getOrgiskontsumonet().equals(
								Y41aConstantes.VALOR_SI)) {
					sol.setEstado(Y41aConstantes.SOLICITUD_ESTADO_TRASLADADO); // T
				} else if (sol.getHccoor() != null
						&& !sol.getHccoor().equals(
								solicitudesBusqueda.getCodOrgConectado())
						&& sol.getOrgiskontsumonet().equals(
								Y41aConstantes.VALOR_NO)) {
					sol.setEstado(Y41aConstantes.SOLICITUD_ESTADO_COMUNICADO); // C
				} else if (sol.getHccoor() != null
						&& sol.getHccoor().equals(
								solicitudesBusqueda.getCodOrgConectado())) {

					if (sol.getIhcoordt() != null
							&& sol.getIhcoordt().equals(
									solicitudesBusqueda.getCodOrgConectado())
							&& sol.getIhfereen() == null) {
						sol.setEstado(Y41aConstantes.SOLICITUD_ESTADO_TRASLADADO); // T
					} else {
						sol.setEstado(Y41aConstantes.SOLICITUD_ESTADO_MIGESTION); // PR
					}
				}
			}

			return listSolicitudesBusqueda;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return Long
	 */
	public Long findAllLikeSolicitudesCount(
			SolicitudBusqueda solicitudesBusqueda, Boolean startsWith,
			Date defedeDesde, Date defedeHasta, Date defereDesde,
			Date defereHasta, Date hcfedeDesde, Date hcfedeHasta) {
		return this.hechoDenunciadoDao.findAllLikeSolicitudesCount(
				solicitudesBusqueda, startsWith, defedeDesde, defedeHasta,
				defereDesde, defereHasta, hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Busca los datos de los trámites asociados al hecho y los documentos de
	 * cada trámite. Si El trámite tiene un único documento se obtiene el
	 * documento para su descarga y si tiene mas de uno se marca como trámite
	 * multidocumento para abrir una ventana modal.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteHechoDetalle> findAllTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle, Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() == null
					|| pagination.getSort().equals("null")) {
				pagination.setSort("EHFECHA DESC, EHHORA");
				pagination.setAscDsc(Y41aConstantes.ORDENACION_DESC);
			}
		}

		List<TramiteHechoDetalle> detallesTramite = this.tramiteHechoDao
				.findAllTramiteHechoCountDoc(tramiteHechoDetalle, pagination);

		Long numDocumentos;
		for (TramiteHechoDetalle tramite : detallesTramite) {
			numDocumentos = Long.valueOf(tramite.getMultiDocumento());
			if (numDocumentos > 1) {
				tramite.setMultiDocumento(Y41aConstantes.SI);
			} else if (numDocumentos == 1) {
				tramite.setMultiDocumento(Y41aConstantes.NO);
			} else {
				tramite.setMultiDocumento(null);
			}

			if (numDocumentos == 1) {
				List<DocumentoHecho> listaDocumentos = this.documentoHechoDao
						.findAllDocumentosByTramite(
								new TramiteComun(tramite.getEhcodigo(), null,
										null), null);
				if (!listaDocumentos.isEmpty()) {
					tramite.setQ5codocumento(Integer.valueOf(listaDocumentos
							.get(0).getQ5codocumento().toString()));
					tramite.setQ5nofile(listaDocumentos.get(0).getQ5nofile());
					tramite.setQ5sizefile(listaDocumentos.get(0)
							.getQ5sizefile());
					tramite.setQ5contenttypefile(listaDocumentos.get(0)
							.getQ5contenttypefile());
					tramite.setQ5tedesfile(listaDocumentos.get(0)
							.getQ5tedesfile());
				}

			}
		}

		// List<TramiteHechoDetalle> listTramiteHechoDetalle =
		// this.tramiteHechoDao
		// .findAllTramiteHecho(tramiteHechoDetalle, pagination);
		// if (listTramiteHechoDetalle != null
		// && listTramiteHechoDetalle.size() > 0) {
		// ListIterator iter = listTramiteHechoDetalle
		// .listIterator(listTramiteHechoDetalle.size());
		//
		// TramiteHechoDetalle tramiteHechoDetalleAux = null;
		// String fnombre = null;
		// String fnombree = null;
		// String trnombre = null;
		// String trnombree = null;
		//
		// while (iter.hasPrevious()) {
		// tramiteHechoDetalleAux = (TramiteHechoDetalle) iter.previous();
		//
		// // buscar los documentos del tramite
		// TramiteComun tramiteComun = new TramiteComun();
		// tramiteComun.setIdTramite(tramiteHechoDetalleAux.getEhcodigo());
		//
		// List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao
		// .findAllDocumentosTramite(tramiteComun, null);
		//
		// // si tiene un solo documento uno meterlo en el objeto
		// if (listDocumentoHecho != null
		// && listDocumentoHecho.size() == 1) {
		// tramiteHechoDetalleAux.setMultiDocumento(Y41aConstantes.NO);
		//
		// tramiteHechoDetalleAux.setQ5codocumento(Integer
		// .valueOf(listDocumentoHecho.get(0)
		// .getQ5codocumento().toString()));
		// tramiteHechoDetalleAux.setQ5nofile(listDocumentoHecho
		// .get(0).getQ5nofile());
		// tramiteHechoDetalleAux.setQ5sizefile(listDocumentoHecho
		// .get(0).getQ5sizefile());
		// tramiteHechoDetalleAux
		// .setQ5contenttypefile(listDocumentoHecho.get(0)
		// .getQ5contenttypefile());
		// tramiteHechoDetalleAux.setQ5tedesfile(listDocumentoHecho
		// .get(0).getQ5tedesfile());
		// } else {
		// if (listDocumentoHecho != null
		// && listDocumentoHecho.size() > 1) {
		// // si tiene mas de un documento
		// tramiteHechoDetalleAux
		// .setMultiDocumento(Y41aConstantes.SI);
		// ;
		// }
		//
		// }
		// if (listDocumentoHecho != null) {
		// Parametros parametros = new Parametros();
		//
		// parametros
		// .setParametro(Y41aConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		// parametros = this.parametrosDao.find(parametros);
		//
		// for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
		// if (documentoHechoAux.getQ5fechasollocalizador() != null
		// && !tramiteHechoDetalleAux
		// .getEhestadotramite()
		// .equals(Y41aConstantes.EstadoTramite.TRAMITADO
		// .getCodigo())
		// && !tramiteHechoDetalleAux
		// .getEhestadotramite()
		// .equals(Y41aConstantes.EstadoTramite.ERRORLOCALIZACION
		// .getCodigo())
		// && !tramiteHechoDetalleAux
		// .getEhestadotramite()
		// .equals(Y41aConstantes.EstadoTramite.FIRMADENEGADA
		// .getCodigo())) {
		// if (documentoHechoAux != null
		// && documentoHechoAux.getQ5nofile() != null
		// && !com.ejie.y41a.utils.Y41aUtils
		// .getExtensionFile(
		// documentoHechoAux
		// .getQ5nofile())
		// .equals(Y41aConstantes.PDF)) {
		//
		// int minutos = 0;
		// if (parametros != null
		// && parametros.getValor() != null
		// && Y41aUtils.isNumeric(parametros
		// .getValor())) {
		// minutos = Integer.parseInt(parametros
		// .getValor());
		// }
		//
		// SimpleDateFormat format = new SimpleDateFormat(
		// "MM/dd/yyyy HH:mm:ss");
		//
		// Date d1 = null;
		// Date d2 = null;
		// long diffMinutes = 0;
		// try {
		// d1 = format
		// .parse(format.format(documentoHechoAux
		// .getQ5fechasollocalizador()));
		//
		// d2 = format
		// .parse(format.format(new Date()));
		//
		// long diff = d2.getTime() - d1.getTime();
		//
		// diffMinutes = diff / (60 * 1000);
		// } catch (ParseException e) {
		// diffMinutes = 0;
		// }
		//
		// if (diffMinutes > minutos) {
		// tramiteHechoDetalleAux
		// .setEhestadotramite(Y41aConstantes.EstadoTramite.ERRORLOCALIZACION
		// .getCodigo());
		// } else {
		// tramiteHechoDetalleAux
		// .setEhestadotramite(Y41aConstantes.EstadoTramite.ENTRAMITACION
		// .getCodigo());
		// }
		// } else {
		// if (tramiteHechoDetalleAux
		// .getEhestadotramite()
		// .equals(Y41aConstantes.EstadoTramite.FIRMADO
		// .getCodigo())) {
		// tramiteHechoDetalleAux
		// .setEhestadotramite(Y41aConstantes.EstadoTramite.FIRMADO
		// .getCodigo());
		// } else if (!tramiteHechoDetalleAux
		// .getEhestadotramite()
		// .equals(Y41aConstantes.EstadoTramite.PENDIENTE_FIRMA
		// .getCodigo())
		// && !tramiteHechoDetalleAux
		// .getEhestadotramite()
		// .equals(Y41aConstantes.EstadoTramite.FIRMADENEGADA
		// .getCodigo())
		// && !tramiteHechoDetalleAux
		// .getEhestadotramite()
		// .equals(Y41aConstantes.EstadoTramite.ERRORLOCALIZACION
		// .getCodigo())
		// && !tramiteHechoDetalleAux
		// .getEhestadotramite()
		// .equals(Y41aConstantes.EstadoTramite.PENDIENTE_LOCALIZACION
		// .getCodigo())
		// && !tramiteHechoDetalleAux
		// .getEhestadotramite()
		// .equals(Y41aConstantes.EstadoTramite.TRAMITADO
		// .getCodigo())) {
		// tramiteHechoDetalleAux
		// .setEhestadotramite(Y41aConstantes.EstadoTramite.LOCALIZADO
		// .getCodigo());
		// }
		// }
		// }
		// }
		// }
		//
		// if (tramiteHechoDetalleAux.getFnombre() == null
		// || tramiteHechoDetalleAux.getFnombre().equals("")) {
		//
		// if (fnombre == null || fnombre.equals("")) {
		// try {
		// TramiteHechoDetalle tramHechoDetalleAux = new TramiteHechoDetalle();
		// tramHechoDetalleAux
		// .setEhcodigo(tramiteHechoDetalleAux
		// .getEhcodigo());
		// tramHechoDetalleAux
		// .setHdcodigo(tramiteHechoDetalleAux
		// .getHdcodigo());
		//
		// tramHechoDetalleAux = this.tramiteHechoDao
		// .findUltimaFase(tramHechoDetalleAux);
		// fnombre = tramHechoDetalleAux.getFnombre();
		// fnombree = tramHechoDetalleAux.getFnombree();
		//
		// tramiteHechoDetalleAux.setFnombre(fnombre);
		// tramiteHechoDetalleAux.setFnombree(fnombree);
		// } catch (Exception e) {
		// }
		// } else {
		// tramiteHechoDetalleAux.setFnombre(fnombre);
		// tramiteHechoDetalleAux.setFnombree(fnombree);
		// }
		// } else {
		// fnombre = tramiteHechoDetalleAux.getFnombre();
		// fnombree = tramiteHechoDetalleAux.getFnombree();
		// }
		//
		// if (tramiteHechoDetalleAux.getTrnombre() == null
		// || tramiteHechoDetalleAux.getTrnombre().equals("")) {
		// try {
		// Tramite tramiteAux = new Tramite();
		// tramiteAux.setTrcodigo(tramiteHechoDetalleAux
		// .getTrcodigo());
		// tramiteAux = this.tramiteDao
		// .findTramiteKontsumoGest(tramiteAux);
		// trnombre = tramiteAux.getTrnombre();
		// trnombree = tramiteAux.getTrnombree();
		//
		// tramiteHechoDetalleAux.setTrnombre(trnombre);
		// tramiteHechoDetalleAux.setTrnombree(trnombree);
		// } catch (Exception e) {
		// }
		// }
		// }
		// }

		// return listTramiteHechoDetalle;
		return detallesTramite;
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteHechoCount(TramiteHechoDetalle tramiteHechoDetalle) {
		return this.tramiteHechoDao
				.findAllTramiteHechoCount(tramiteHechoDetalle);
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHechoDetalle addTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle) {

		try {
			Properties prop = Y41aConfig
					.loadProperties(Y41aConstantes.CONFIG_PATH);

			Tramite tramite = new Tramite();
			tramite.setTrcodigo(tramiteHechoDetalle.getTrcodigo());

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(tramiteHechoDetalle.getMocodigo());

			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(tramiteHechoDetalle.getHdcodigo());

			TramiteHecho tramitehecho = new TramiteHecho(Y41aUIDGenerator
					.getInstance().generateId(Y41aConstantes.PK_SIZE),
					tramiteHechoDetalle.getEhfecha(),
					tramiteHechoDetalle.getEhhora(),
					tramiteHechoDetalle.getEhcodpor(),
					tramiteHechoDetalle.getEhcodpde(),
					tramiteHechoDetalle.getEhtexto(),
					tramiteHechoDetalle.getEhcozs(),
					tramiteHechoDetalle.getEhcivihe(),
					tramiteHechoDetalle.getEhacuse(),
					tramiteHechoDetalle.getEhenviomail(),
					tramiteHechoDetalle.getEhdiremail(),
					tramiteHechoDetalle.getCodOrgTraslado(), null, tramite,
					censoMonitor, hechoDenunciado);

			// Alta de tramite hecho
			this.tramiteHechoDao.add(tramitehecho);

			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setTramite(tramite);
			plantillaTramite.setPtcoor(tramiteHechoDetalle.getCodOrg());

			try {
				// Obtener la plantilla del tramite
				plantillaTramite = this.plantillaTramiteDao
						.findPlantillaTramite(plantillaTramite);
			} catch (Exception e) {
				throw new Y41aUDAException(
						"error.decisionhecho.organismonoinicializado", true, e);
			}

			// Obtener los datos de la solicitud
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle = new PlantillaTramiteHechoDetalle();
			plantillaTramiteHechoDetalle
					.setEhcodigo(tramitehecho.getEhcodigo());

			plantillaTramiteHechoDetalle = this.tramiteHechoDao
					.findPlantillaTramiteHecho(plantillaTramiteHechoDetalle);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteHechoDetalle.getHdcodigo());

			SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao
					.findLobTablaTemporal(solicitudDetalle);
			plantillaTramiteHechoDetalle.setHdte(solDetalleAux.getHdte());

			if (plantillaTramite.getPtplantilla() != null) {
				plantillaTramiteHechoDetalle = this
						.completeInfoPlantillaTramiteHechoDetalle(
								plantillaTramiteHechoDetalle,
								tramiteHechoDetalle);

				String q5nofile = null;
				Integer q5sizefile = null;
				String q5tedesfile = null;
				String q5contenttypefile = null;
				Blob q5datafile = null;

				q5nofile = plantillaTramite.getPtnofile();
				q5sizefile = plantillaTramite.getPtsizefile();
				q5tedesfile = plantillaTramite.getPtnombre();
				q5contenttypefile = plantillaTramite.getPtcontenttypefile();

				// Transformar el documento en castellano
				String plantilla = Y41aUtils.blobToString(plantillaTramite
						.getPtplantilla());

				StringBuffer rutaPlantilla = new StringBuffer(
						prop.getProperty("y41aVistaWar.rutaxml.plantillas.word"));

				rutaPlantilla
						.append(Y41aConstantes.NOMBRE_PLANTILLA_XML_TRAMITE_CASTELLANO);

				String ficheroGenerado = Y41aGenerarDocumento
						.generarDocumentoWord(rutaPlantilla.toString(),
								plantillaTramiteHechoDetalle, plantilla);

				q5datafile = new SerialBlob(ficheroGenerado.getBytes());

				DocumentoHecho documentoHecho = new DocumentoHecho(
						String.valueOf(this.documentoHechoDao.getNewPK()),
						q5nofile, q5datafile, q5sizefile, q5tedesfile,
						Y41aConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION,
						new Date(), null, q5contenttypefile, null,
						tramitehecho, hechoDenunciado);

				// Guardarlo en la tabla de documentos hecho
				this.documentoHechoDao.add(documentoHecho);
			}

			if (tramiteHechoDetalle.getTrcodigo().equals(
					Y41aConstantes.TRAMITE_SOLICITUD_TRASLADO_SOLICITUD)) {
				// Update de HCCOOR con el codigo de organismo al que se
				// traslada la solicitud de la tabla L2125T00 DECISION HECHO
				DecisionHechoDetalle decisionHechoDetalle = new DecisionHechoDetalle();
				decisionHechoDetalle.setHdcodigo(tramiteHechoDetalle
						.getHdcodigo());

				decisionHechoDetalle = this.decisionHechoDao
						.findDecisionHecho(decisionHechoDetalle);

				DecisionHecho decisionHecho = new DecisionHecho();
				decisionHecho
						.setHccoor(tramiteHechoDetalle.getCodOrgTraslado());
				decisionHecho.setHccodigo(decisionHechoDetalle.getHccodigo());

				this.decisionHechoDao.updateOrganismoTraslado(decisionHecho);

				// modificar el responsable del expediente, ponemos el
				// coordinador
				CensoMonitor censoMonitorCoordinador = new CensoMonitor();
				try {
					Organismo organismo = new Organismo();
					organismo
							.setCodOrg(tramiteHechoDetalle.getCodOrgTraslado());

					censoMonitorCoordinador.setOrganismo(organismo);

					censoMonitorCoordinador = this.censoMonitorDao
							.findCoordinadorSolicitudes(censoMonitorCoordinador);
				} catch (Exception e) {
					censoMonitorCoordinador = new CensoMonitor();
				}

				// Actualizamos el instructor del hecho denunciado
				HechoDenunciado hechodenunciado = new HechoDenunciado();
				hechodenunciado.setHdcodigo(tramiteHechoDetalle.getHdcodigo());
				hechodenunciado.setCensoMonitor(censoMonitorCoordinador);

				this.hechoDenunciadoDao.updateInstructor(hechodenunciado);

				Organismo organismo = new Organismo();
				organismo.setCodOrg(tramiteHechoDetalle.getCodOrgTraslado());

				organismo = this.organismoDao.find(organismo);

				// Se graba un registro en TRASLADO
				Traslado traslado = new Traslado();
				traslado.setIhcodigo(Y41aUIDGenerator.getInstance().generateId(
						Y41aConstantes.PK_SIZE));
				traslado.setIhcoortr(tramiteHechoDetalle.getCodOrg());
				traslado.setIhnrantr(new BigDecimal(Y41aUtils
						.formatearDateToString(new Date(),
								Y41aConstantes.FORMATO_ANYO)));

				if (organismo.getIskontsumonet()
						.equals(Y41aConstantes.VALOR_SI)) {
					traslado.setIhinintr(Y41aConstantes.TIPO_TRANSMISION_TRASLADO);
				} else {
					traslado.setIhinintr(Y41aConstantes.TIPO_TRANSMISION_COMUNICACION);
				}

				StringBuffer textoTraslado = new StringBuffer();
				// Si el texto es mayor de 255 lo truncamos
				if (tramiteHechoDetalle.getEhtexto() != null
						&& tramiteHechoDetalle.getEhtexto().length() > Y41aConstantes.MAXLENGTH_OBJECT_NAME) {
					textoTraslado.append(tramiteHechoDetalle.getEhtexto()
							.subSequence(Y41aConstantes.MINLENGTH_OBJECT_NAME,
									Y41aConstantes.MAXLENGTH_OBJECT_NAME));
				} else {
					textoTraslado.append(tramiteHechoDetalle.getEhtexto());
				}
				traslado.setIhtedoad(textoTraslado.toString());
				traslado.setIhfereor(tramiteHechoDetalle.getEhfecha());
				traslado.setIhcooror(tramiteHechoDetalle.getCodOrg()); // cod
																		// org
																		// de
																		// la
				// denuncia
				traslado.setIhcoordt(tramiteHechoDetalle.getCodOrgTraslado());

				DecisionHecho decisiontraslado = new DecisionHecho();
				decisiontraslado
						.setHccodigo(decisionHechoDetalle.getHccodigo());
				traslado.setDecisionHecho(decisiontraslado); // codigo
																// de
																// la
																// decision

				// Codigo del tramite hecho
				traslado.setIhcoeh(tramitehecho.getEhcodigo());

				// alta traslado
				this.trasladoDao.addTraslado(traslado);

				String organismosKontsumobide = prop
						.getProperty("y41aVistaWar.organismos.kontsumobide");

				if (organismo != null
						&& organismosKontsumobide != null
						&& organismosKontsumobide
								.indexOf(organismo.getCodOrg()) != -1) {
					// incluir tramite de recepcion
					generarTramiteRecepcionTrasladoKonbide(tramiteHechoDetalle);

					// Tratamiento de la bandeja
					hechodenunciado = new HechoDenunciado();
					hechodenunciado.setHdcodigo(tramiteHechoDetalle
							.getHdcodigo());

					// alta intervinientes
					// buscar el interviniente interesado
					Intervinientes intervinientes = new Intervinientes();
					intervinientes.setIdExpediente(tramiteHechoDetalle
							.getHdcodigo());
					intervinientes
							.setTipoInterviniente(Y41aConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

					List<Intervinientes> listIntervinientes = this.intervinientesDao
							.findAll(intervinientes, null);

					solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle.setHdcodigo(tramiteHechoDetalle
							.getHdcodigo());

					SolicitudDetalle solDetalle = this.hechoDenunciadoDao
							.findSolicitud(solicitudDetalle);

					// Interviniente consumidor
					Consumidor consumidor = new Consumidor();
					consumidor.setDtcodigo(solDetalle.getDtcodigo());

					consumidor = this.consumidorDao.find(consumidor);

					Intervinientes intervinientesAux = new Intervinientes(
							Y41aUIDGenerator.getInstance().generateId(
									Y41aConstantes.PK_SIZE),
							consumidor.getDtcodigo(), null, null,
							consumidor.getDtnombre(),
							consumidor.getDtapellido1(),
							consumidor.getDtapellido2(), null,
							consumidor.getDtintipid(), consumidor.getDtnif(),
							consumidor.getRangoEdad().getRancod(),
							consumidor.getDtcosx(), consumidor.getDtcoidco(),
							null, null, null, consumidor.getDtnrtel(),
							consumidor.getDtnrtel2(), consumidor.getDttecoem(),
							consumidor.getDtextranjero(),
							consumidor.getDtnoraProvinciaId(),
							consumidor.getDtnombreProvincia(),
							consumidor.getDtnoraMunicipioId(),
							consumidor.getDtnombreMunicipio(),
							consumidor.getDtnoraLocalidadId(),
							consumidor.getDtnombreLocalidad(),
							consumidor.getDtnoraCalleId(),
							consumidor.getDtnombreCalle(),
							consumidor.getDtnoraCpId(),
							consumidor.getDtnombreCp(),
							consumidor.getDtnoraPortalId(),
							consumidor.getDtnombrePortal(),
							consumidor.getDtnombrePiso(),
							consumidor.getDtnoraPaisId(),
							consumidor.getDtnoraPaisNombre(),
							consumidor.getDtdireccion_nocapv(), null, null,
							null, null, null,
							Y41aConstantes.TIPO_INTERVINIENTESOL_INTERESADO,
							tramiteHechoDetalle.getHdcodigo(), null);

					// Comprobamos si existe, si existe lo modificamos, si no
					// existe lo
					// insertamos
					if (listIntervinientes != null
							&& listIntervinientes.size() > 0) {
						intervinientesAux.setIdinterviniente(listIntervinientes
								.get(0).getIdinterviniente());
						this.intervinientesDao.update(intervinientesAux);
					} else {
						this.intervinientesDao.add(intervinientesAux);
					}

					// buscar el interviniente demandado
					intervinientes = new Intervinientes();
					intervinientes.setIdExpediente(solicitudDetalle
							.getHdcodigo());
					intervinientes
							.setTipoInterviniente(Y41aConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

					listIntervinientes = this.intervinientesDao.findAll(
							intervinientes, null);

					// Interviniente establecimiento
					Establecimiento establecimiento = new Establecimiento();
					establecimiento.setEscodigo(solDetalle.getEscodigo());

					establecimiento = this.establecimientoDao
							.find(establecimiento);

					EstablecimSector establecimSector = new EstablecimSector();
					establecimSector.setEstablecimiento(establecimiento);

					EstablecimSector establecSector = new EstablecimSector();
					Actividad actividad = new Actividad();
					Sector sector = new Sector();
					establecSector.setActividad(actividad);
					establecSector.setSector(sector);

					establecSector = (EstablecimSector) this.establecimSectorDao
							.findSectorEstablecimiento(establecimSector);

					Intervinientes intervinientesAux2 = new Intervinientes(
							Y41aUIDGenerator.getInstance().generateId(
									Y41aConstantes.PK_SIZE), null,
							establecimiento.getEscodigo(), null,
							establecimiento.getEsnombre(), null, null,
							establecimiento.getEsnoco(), null,
							establecimiento.getEsnif(), null, null,
							establecimiento.getEscoidco(),
							establecimiento.getEsteurl(),
							establecimiento.getEsnopeco(),
							establecimiento.getEsfeba(),
							establecimiento.getEsnrtel(),
							establecimiento.getEsnrtel2(),
							establecimiento.getEscoem(),
							establecimiento.getEsextranjero(),
							establecimiento.getEsnoraProvinciaId(),
							establecimiento.getEsnombreProvincia(),
							establecimiento.getEsnoraMunicipioId(),
							establecimiento.getEsnombreMunicipio(),
							establecimiento.getEsnoraLocalidadId(),
							establecimiento.getEsnombreLocalidad(),
							establecimiento.getEsnoraCalleId(),
							establecimiento.getEsnombreCalle(),
							establecimiento.getEsnoraCpId(),
							establecimiento.getEsnombreCp(),
							establecimiento.getEsnoraPortalId(),
							establecimiento.getEsnombrePortal(),
							establecimiento.getEsnombrePiso(),
							establecimiento.getEsnombrePiso(),
							establecimiento.getEsnoraPaisId(),
							establecimiento.getEsdireccion_nocapv(), null,
							establecimiento.getEsinadar(), establecSector
									.getSector().getSecodigo(), establecSector
									.getSector().getSenombre(), establecSector
									.getSector().getSenombree(),
							Y41aConstantes.TIPO_INTERVINIENTESOL_DEMANDADO,
							tramiteHechoDetalle.getHdcodigo(), null);

					// Comprobamos si existe, si existe lo modificamos, si no
					// existe lo
					// insertamos
					if (listIntervinientes != null
							&& listIntervinientes.size() > 0) {
						intervinientesAux2
								.setIdinterviniente(listIntervinientes.get(0)
										.getIdinterviniente());
						this.intervinientesDao.update(intervinientesAux2);
					} else {
						this.intervinientesDao.add(intervinientesAux2);
					}

					// Interviniente establecimiento
					organismo = new Organismo();
					organismo
							.setCodOrg(tramiteHechoDetalle.getCodOrgTraslado());

					organismo = this.organismoDao
							.findOrganismoByCodOrg(organismo);

					// buscar el interviniente administracion
					intervinientes = new Intervinientes();
					intervinientes.setIdExpediente(solicitudDetalle
							.getHdcodigo());
					intervinientes.setEntidadId(organismo.getEntidadId());
					intervinientes
							.setTipoInterviniente(Y41aConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION);

					listIntervinientes = this.intervinientesDao.findAll(
							intervinientes, null);

					Intervinientes intervinientesAux3 = new Intervinientes(
							Y41aUIDGenerator.getInstance().generateId(
									Y41aConstantes.PK_SIZE),
							null,
							null,
							organismo.getEntidadId(),
							organismo.getNombreEs(),
							null,
							null,
							null,
							null,
							null,
							null,
							null,
							null,
							organismo.getUrl(),
							null,
							null,
							organismo.getTelefono(),
							null,
							organismo.getEmail(),
							null,
							organismo.getNoraProvinciaId(),
							organismo.getNombreProvincia(),
							organismo.getNoraMunicipioId(),
							organismo.getNombreMunicipio(),
							organismo.getNoraLocalidadId(),
							organismo.getNombreLocalidad(),
							organismo.getNoraCalleId(),
							organismo.getNombreCalle(),
							organismo.getNoraCpId(),
							organismo.getNombreCp(),
							organismo.getNoraPortalId(),
							organismo.getNombrePortal(),
							organismo.getCompleDirec(),
							organismo.getNoraPaisId(),
							organismo.getNombrePais(),
							organismo.getNombreCalle(),
							null,
							null,
							null,
							null,
							null,
							Y41aConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION,
							tramiteHechoDetalle.getHdcodigo(), null);

					// Comprobamos si existe, si existe lo modificamos, si no
					// existe lo
					// insertamos
					if (listIntervinientes != null
							&& listIntervinientes.size() > 0) {
						intervinientesAux3
								.setIdinterviniente(listIntervinientes.get(0)
										.getIdinterviniente());
						this.intervinientesDao.update(intervinientesAux3);
					} else {
						this.intervinientesDao.add(intervinientesAux3);
					}

					organismo = new Organismo();
					organismo.setCodOrg(tramiteHechoDetalle.getCodOrg());

					organismo = this.organismoDao
							.findOrganismoByCodOrg(organismo);

					// buscar el interviniente administracion
					intervinientes = new Intervinientes();
					intervinientes.setIdExpediente(solicitudDetalle
							.getHdcodigo());
					intervinientes.setEntidadId(organismo.getEntidadId());
					intervinientes
							.setTipoInterviniente(Y41aConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION);

					listIntervinientes = this.intervinientesDao.findAll(
							intervinientes, null);

					Intervinientes intervinientesAux4 = new Intervinientes(
							Y41aUIDGenerator.getInstance().generateId(
									Y41aConstantes.PK_SIZE),
							null,
							null,
							organismo.getEntidadId(),
							organismo.getNombreEs(),
							null,
							null,
							null,
							null,
							null,
							null,
							null,
							null,
							organismo.getUrl(),
							null,
							null,
							organismo.getTelefono(),
							null,
							organismo.getEmail(),
							null,
							organismo.getNoraProvinciaId(),
							organismo.getNombreProvincia(),
							organismo.getNoraMunicipioId(),
							organismo.getNombreMunicipio(),
							organismo.getNoraLocalidadId(),
							organismo.getNombreLocalidad(),
							organismo.getNoraCalleId(),
							organismo.getNombreCalle(),
							organismo.getNoraCpId(),
							organismo.getNombreCp(),
							organismo.getNoraPortalId(),
							organismo.getNombrePortal(),
							organismo.getCompleDirec(),
							organismo.getNoraPaisId(),
							organismo.getNombrePais(),
							organismo.getNombreCalle(),
							null,
							null,
							null,
							null,
							null,
							Y41aConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION,
							tramiteHechoDetalle.getHdcodigo(), null);

					// Comprobamos si existe, si existe lo modificamos, si no
					// existe lo
					// insertamos
					if (listIntervinientes != null
							&& listIntervinientes.size() > 0) {
						intervinientesAux4
								.setIdinterviniente(listIntervinientes.get(0)
										.getIdinterviniente());
						this.intervinientesDao.update(intervinientesAux4);
					} else {
						this.intervinientesDao.add(intervinientesAux4);
					}

					// modificacion expediente para traslado a KONBIDE
					this.hechoDenunciadoDao
							.updateExpedienteTrasladoKonbide(hechodenunciado);

					tratamientoBandejaSolicitudes(hechodenunciado);
				}

				if (organismo.getIskontsumonet()
						.equals(Y41aConstantes.VALOR_NO)) {

					decisionHechoDetalle.setHccoor(tramiteHechoDetalle
							.getCodOrgTraslado());
					decisionHechoDetalle.setHcfede(new Date());
					decisionHechoDetalle
							.setDecodigo(Y41aConstantes.DECISION_TRASLADO_ORGANISMOS_FUERA_CIAC);
					decisionHechoDetalle.setCodOrg(tramiteHechoDetalle
							.getCodOrg());

					this.updateDecisionHecho(decisionHechoDetalle);
				}
			} else if (tramiteHechoDetalle.getTrcodigo().equals(
					Y41aConstantes.TRAMITE_SOLICITUD_INSPECCION_PRESENCIAL)) {
				DenunciaRecib denunciaRecib = new DenunciaRecib(
						Y41aUIDGenerator.getInstance().generateId(
								Y41aConstantes.PK_SIZE),
						tramiteHechoDetalle.getCodOrg(), new Date(), null,
						Y41aConstantes.NUM_1, hechoDenunciado);

				this.denunciaRecibDao.add(denunciaRecib);
			}

			return tramiteHechoDetalle;

		} catch (SerialException e) {
			e.printStackTrace();
			throw new Y41aUDAException("error.solicitud.alta.tramite", true, e);
		} catch (SQLException e) {
			e.printStackTrace();
			throw new Y41aUDAException("error.solicitud.alta.tramite", true, e);
		} catch (IOException e) {
			e.printStackTrace();
			throw new Y41aUDAException("error.solicitud.alta.tramite", true, e);
		} catch (ParseException e) {
			e.printStackTrace();
			throw new Y41aUDAException("error.solicitud.alta.tramite", true, e);
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41aUDAException("error.solicitud.alta.tramite", true, e);
		}
	}

	/**
	 * Generar Tramite Automatico de Recepcion Traslado Konbide
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoKonbide
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHechoKonbide generarTramiteRecepcionTrasladoKonbide(
			TramiteHechoDetalle tramiteHechoDetalle) throws Exception {
		TramiteHechoKonbide tramitehecho = new TramiteHechoKonbide();
		tramitehecho.setEhcodigo(Y41aUIDGenerator.getInstance().generateId(
				Y41aConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteHechoDetalle.getHdcodigo());
		tramitehecho
				.setEhcotee(Y41aConstantes.TRAMITE_SOLICITUD_RECEPCION_TRASLADO_KONBIDE);
		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41aUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			ehhora = Y41aUtils.formatearDateToString(todayCalendar.getTime(),
					Y41aConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(today);
		tramitehecho.setEhcomoasignado(tramiteHechoDetalle.getMocodigo());
		tramitehecho.setEhcomo(tramiteHechoDetalle.getMocodigo());
		tramitehecho.setEhtexto("");

		tramitehecho
				.setEhestadotramite(Y41aConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoDao.addTramiteHechoKonbide(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Tratamiento para gestionar la bandeja de solicitudes.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void tratamientoBandejaSolicitudes(HechoDenunciado hechodenunciado) {
		// borrar los tramites del expediente en la bandeja
		BandejaSolicitudesKonbide bandejasolicitudes = new BandejaSolicitudesKonbide();
		bandejasolicitudes.setHdcodigo(hechodenunciado.getHdcodigo());

		this.bandejaSolicitudesDao
				.removeAllTramitesExpediente(bandejasolicitudes);

		// consultar los tramites no tramitados
		List<BandejaSolicitudesKonbide> listBandejaSolicitudes = this.bandejaSolicitudesDao
				.findAllTramitesPendientesSolicitudes(bandejasolicitudes, null);

		if (listBandejaSolicitudes != null && listBandejaSolicitudes.size() > 0) {
			// insertar los tramites no tramitados en la bandeja
			for (BandejaSolicitudesKonbide bandejaSolicitudesAux : listBandejaSolicitudes) {

				// insertar el ultimo tramite realizado
				this.bandejaSolicitudesDao.add(bandejaSolicitudesAux);
			}
		}
	}

	/**
	 * Complete information of the object PlantillaTramiteHechoDetalle.
	 * 
	 * @param plantillaTramiteHechoDetalle
	 *            PlantillaTramiteHechoDetalle
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return PlantillaTramiteHechoDetalle
	 */
	private PlantillaTramiteHechoDetalle completeInfoPlantillaTramiteHechoDetalle(
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle,
			TramiteHechoDetalle tramiteHechoDetalle) {

		try {
			// Formateamos las fecha a castellano e euskera
			plantillaTramiteHechoDetalle.setEhfechaTextoCas(Y41aUtils
					.formatearDateToString(
							plantillaTramiteHechoDetalle.getEhfecha(),
							Y41aConstantes.FORMATO_FULL_FECHA_ES,
							Y41aConstantes.CASTELLANO));
			plantillaTramiteHechoDetalle.setEhfechaTextoEus(Y41aUtils
					.formatearDateToStringEuskera(
							plantillaTramiteHechoDetalle.getEhfecha(),
							Y41aConstantes.FORMATO_FULL_FECHA_EU,
							Y41aConstantes.EUSKERA));

			plantillaTramiteHechoDetalle.setEhfechaCas(Y41aUtils
					.parseDateToString(tramiteHechoDetalle.getEhfecha(),
							Y41aConstantes.CASTELLANO));
			plantillaTramiteHechoDetalle.setEhfechaEus(Y41aUtils
					.parseDateToString(tramiteHechoDetalle.getEhfecha(),
							Y41aConstantes.EUSKERA));

			// Buscar el ultimo tramite 4
			// Formatear las fechas castellano y euskera
			TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
			tramiteHechoDetalleAux
					.setTrcodigo(Y41aConstantes.TRAMITE_SOLICITUD_SOLICITUD_ALEGACION);
			tramiteHechoDetalleAux.setHdcodigo(tramiteHechoDetalle
					.getHdcodigo());
			try {
				tramiteHechoDetalleAux = this.tramiteHechoDao
						.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);

				if (tramiteHechoDetalleAux.getEhfecha() != null) {
					plantillaTramiteHechoDetalle
							.setFechaSolicitudAlegacionCas(Y41aUtils.parseDateToString(
									tramiteHechoDetalleAux.getEhfecha(),
									Y41aConstantes.CASTELLANO));
					plantillaTramiteHechoDetalle
							.setFechaSolicitudAlegacionEus(Y41aUtils.parseDateToString(
									tramiteHechoDetalleAux.getEhfecha(),
									Y41aConstantes.EUSKERA));
				}
			} catch (Exception e) {
				tramiteHechoDetalleAux = new TramiteHechoDetalle();
			}

			// Buscar el ultimo tramite 7
			// Formatear las fechas castellano y euskera
			tramiteHechoDetalleAux
					.setTrcodigo(Y41aConstantes.TRAMITE_SOLICITUD_COMUNICACION_ALEGACIONES);
			tramiteHechoDetalleAux.setHdcodigo(tramiteHechoDetalle
					.getHdcodigo());
			try {
				tramiteHechoDetalleAux = this.tramiteHechoDao
						.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);

				if (tramiteHechoDetalleAux.getEhfecha() != null) {
					plantillaTramiteHechoDetalle
							.setFechacomunicacionAlegacionesCas(Y41aUtils.parseDateToString(
									tramiteHechoDetalleAux.getEhfecha(),
									Y41aConstantes.CASTELLANO));
					plantillaTramiteHechoDetalle
							.setFechacomunicacionAlegacionesEus(Y41aUtils.parseDateToString(
									tramiteHechoDetalleAux.getEhfecha(),
									Y41aConstantes.EUSKERA));
				}
			} catch (Exception e) {
				tramiteHechoDetalleAux = new TramiteHechoDetalle();
			}

			// Buscar el ultimo tramite 6
			// Formatear las fechas castellano y euskera
			tramiteHechoDetalleAux
					.setTrcodigo(Y41aConstantes.TRAMITE_SOLICITUD_RECEPCION_ALEGACIONES);
			tramiteHechoDetalleAux.setHdcodigo(tramiteHechoDetalle
					.getHdcodigo());
			try {
				tramiteHechoDetalleAux = this.tramiteHechoDao
						.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);

				if (tramiteHechoDetalleAux.getEhfecha() != null) {
					plantillaTramiteHechoDetalle
							.setFechaRecepcionalegacionesCas(Y41aUtils.parseDateToString(
									tramiteHechoDetalleAux.getEhfecha(),
									Y41aConstantes.CASTELLANO));
					plantillaTramiteHechoDetalle
							.setFechaRecepcionalegacionesEus(Y41aUtils.parseDateToString(
									tramiteHechoDetalleAux.getEhfecha(),
									Y41aConstantes.EUSKERA));
				}
			} catch (Exception e) {
				tramiteHechoDetalleAux = new TramiteHechoDetalle();
			}

			// Creamos el campo numero de expediente
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(plantillaTramiteHechoDetalle.getDecoor())
					.append("-")
					.append(plantillaTramiteHechoDetalle.getDenror())
					.append("-")
					.append(plantillaTramiteHechoDetalle.getDenran())
					.append("-")
					.append(plantillaTramiteHechoDetalle.getHdnror());

			plantillaTramiteHechoDetalle.setNumExpediente(numeroExpediente
					.toString());

			// Creamos el campo direccion del establecimiento
			StringBuffer direccionCompleta = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getEsnombreCalle() != null
					&& !plantillaTramiteHechoDetalle.getEsnombreCalle().equals(
							"")) {
				direccionCompleta.append(plantillaTramiteHechoDetalle
						.getEsnombreCalle());

				if (plantillaTramiteHechoDetalle.getEsnombrePortal() != null
						&& !plantillaTramiteHechoDetalle.getEsnombrePortal()
								.equals("")) {
					direccionCompleta.append(", ").append(
							plantillaTramiteHechoDetalle.getEsnombrePortal());
				}
				if (plantillaTramiteHechoDetalle.getEsnombrePiso() != null
						&& !plantillaTramiteHechoDetalle.getEsnombrePiso()
								.equals("")) {
					direccionCompleta.append(" ").append(
							plantillaTramiteHechoDetalle.getEsnombrePiso());
				}
			} else {
				if (plantillaTramiteHechoDetalle.getEsdireccion_nocapv() != null
						&& !plantillaTramiteHechoDetalle
								.getEsdireccion_nocapv().equals("")) {
					direccionCompleta.append(plantillaTramiteHechoDetalle
							.getEsdireccion_nocapv());
				} else {
					direccionCompleta.append(plantillaTramiteHechoDetalle
							.getEsnodir());
				}
			}

			plantillaTramiteHechoDetalle.setEsdireccion(direccionCompleta
					.toString());

			// Creamos el campo codigo postal y municipio del establecimiento
			StringBuffer cpMunicipio = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getEsnombreCp() != null
					&& !plantillaTramiteHechoDetalle.getEsnombreCp().equals("")) {
				cpMunicipio
						.append(plantillaTramiteHechoDetalle.getEsnombreCp());

				if (plantillaTramiteHechoDetalle.getEsnombreMunicipio() != null
						&& !plantillaTramiteHechoDetalle.getEsnombreMunicipio()
								.equals("")) {
					cpMunicipio.append(" ")
							.append(plantillaTramiteHechoDetalle
									.getEsnombreMunicipio());
				} else if (plantillaTramiteHechoDetalle.getEsextranjero() != null
						&& plantillaTramiteHechoDetalle.getEsextranjero()
								.equals("S")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteHechoDetalle.getEsnoraPaisNombre());
				}
			} else if (plantillaTramiteHechoDetalle.getEsnombreMunicipio() != null
					&& !plantillaTramiteHechoDetalle.getEsnombreMunicipio()
							.equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle
						.getEsnombreMunicipio());
			} else if (plantillaTramiteHechoDetalle.getEsextranjero() != null
					&& plantillaTramiteHechoDetalle.getEsextranjero().equals(
							"S")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle
						.getEsnoraPaisNombre());
			}

			plantillaTramiteHechoDetalle.setEscpMunicipio(cpMunicipio
					.toString());

			// Creamos el campo direccion del consumidor
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getDtnombreCalle() != null
					&& !plantillaTramiteHechoDetalle.getDtnombreCalle().equals(
							"")) {
				direccionCompleta.append(plantillaTramiteHechoDetalle
						.getDtnombreCalle());

				if (plantillaTramiteHechoDetalle.getDtnombrePortal() != null
						&& !plantillaTramiteHechoDetalle.getDtnombrePortal()
								.equals("")) {
					direccionCompleta.append(", ").append(
							plantillaTramiteHechoDetalle.getDtnombrePortal());
				}
				if (plantillaTramiteHechoDetalle.getDtnombrePiso() != null
						&& !plantillaTramiteHechoDetalle.getDtnombrePiso()
								.equals("")) {
					direccionCompleta.append(" ").append(
							plantillaTramiteHechoDetalle.getDtnombrePiso());
				}
			} else {
				if (plantillaTramiteHechoDetalle.getDtdireccion_nocapv() != null
						&& !plantillaTramiteHechoDetalle
								.getDtdireccion_nocapv().equals("")) {
					direccionCompleta.append(plantillaTramiteHechoDetalle
							.getDtdireccion_nocapv());
				} else {
					direccionCompleta.append(plantillaTramiteHechoDetalle
							.getDtnodir());
				}
			}

			plantillaTramiteHechoDetalle.setDtdireccion(direccionCompleta
					.toString());

			// Creamos el campo codigo postal y municipio del consumidor
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getDtnombreCp() != null
					&& !plantillaTramiteHechoDetalle.getDtnombreCp().equals("")) {
				cpMunicipio
						.append(plantillaTramiteHechoDetalle.getDtnombreCp());

				if (plantillaTramiteHechoDetalle.getDtnombreMunicipio() != null
						&& !plantillaTramiteHechoDetalle.getDtnombreMunicipio()
								.equals("")) {
					cpMunicipio.append(" ")
							.append(plantillaTramiteHechoDetalle
									.getDtnombreMunicipio());
				} else if (plantillaTramiteHechoDetalle.getDtextranjero() != null
						&& plantillaTramiteHechoDetalle.getDtextranjero()
								.equals("S")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteHechoDetalle.getDtnoraPaisNombre());
				}
			} else if (plantillaTramiteHechoDetalle.getDtnombreMunicipio() != null
					&& !plantillaTramiteHechoDetalle.getDtnombreMunicipio()
							.equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle
						.getDtnombreMunicipio());
			} else if (plantillaTramiteHechoDetalle.getDtextranjero() != null
					&& plantillaTramiteHechoDetalle.getDtextranjero().equals(
							"S")) {
				cpMunicipio.append(" ").append(
						plantillaTramiteHechoDetalle.getDtnoraPaisNombre());
			}

			plantillaTramiteHechoDetalle.setDtcpMunicipio(cpMunicipio
					.toString());

			// Creamos el campo direccion del organismo conectado
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCalle() != null
					&& !plantillaTramiteHechoDetalle.getNombreCalle()
							.equals("")) {
				direccionCompleta.append(plantillaTramiteHechoDetalle
						.getNombreCalle());

				if (plantillaTramiteHechoDetalle.getNombrePortal() != null
						&& !plantillaTramiteHechoDetalle.getNombrePortal()
								.equals("")) {
					direccionCompleta.append(", ").append(
							plantillaTramiteHechoDetalle.getNombrePortal());
				}
			}

			plantillaTramiteHechoDetalle
					.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCp() != null
					&& !plantillaTramiteHechoDetalle.getNombreCp().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getNombreCp());

				if (plantillaTramiteHechoDetalle.getNombreMunicipio() != null
						&& !plantillaTramiteHechoDetalle.getNombreMunicipio()
								.equals("")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteHechoDetalle.getNombreMunicipio());
				}
			} else if (plantillaTramiteHechoDetalle.getNombreMunicipio() != null
					&& !plantillaTramiteHechoDetalle.getNombreMunicipio()
							.equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle
						.getNombreMunicipio());
			}

			plantillaTramiteHechoDetalle.setCpMunicipioOrganismo(cpMunicipio
					.toString());

			// Creamos el campo direccion del organismo al que se traslada
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCalleTraslado() != null
					&& !plantillaTramiteHechoDetalle.getNombreCalleTraslado()
							.equals("")) {
				direccionCompleta.append(plantillaTramiteHechoDetalle
						.getNombreCalleTraslado());

				if (plantillaTramiteHechoDetalle.getNombrePortalTraslado() != null
						&& !plantillaTramiteHechoDetalle
								.getNombrePortalTraslado().equals("")) {
					direccionCompleta.append(", ").append(
							plantillaTramiteHechoDetalle
									.getNombrePortalTraslado());
				}
			}

			plantillaTramiteHechoDetalle.setDireccionTraslado(direccionCompleta
					.toString());

			// Creamos el campo codigo postal y municipio del organismo al que
			// se traslada
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCpTraslado() != null
					&& !plantillaTramiteHechoDetalle.getNombreCpTraslado()
							.equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle
						.getNombreCpTraslado());

				if (plantillaTramiteHechoDetalle.getNombreMunicipioTraslado() != null
						&& !plantillaTramiteHechoDetalle
								.getNombreMunicipioTraslado().equals("")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteHechoDetalle
									.getNombreMunicipioTraslado());
				}
			} else if (plantillaTramiteHechoDetalle
					.getNombreMunicipioTraslado() != null
					&& !plantillaTramiteHechoDetalle
							.getNombreMunicipioTraslado().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle
						.getNombreMunicipioTraslado());
			}

			plantillaTramiteHechoDetalle.setCpMunicipioTraslado(cpMunicipio
					.toString());

			return plantillaTramiteHechoDetalle;

		} catch (ParseException e) {
			throw new Y41aUDAException("error.solicitud.alta.tramite", true, e);
		}
	}

	/**
	 * Update a single row in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHechoDetalle updateTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle) {

		Tramite tramite = new Tramite();
		tramite.setTrcodigo(tramiteHechoDetalle.getTrcodigo());

		CensoMonitor censoMonitor = new CensoMonitor();
		censoMonitor.setMocodigo(tramiteHechoDetalle.getMocodigo());

		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setHdcodigo(tramiteHechoDetalle.getHdcodigo());

		TramiteHecho tramitehecho = new TramiteHecho(
				tramiteHechoDetalle.getEhcodigo(),
				tramiteHechoDetalle.getEhfecha(),
				tramiteHechoDetalle.getEhhora(),
				tramiteHechoDetalle.getEhcodpor(),
				tramiteHechoDetalle.getEhcodpde(),
				tramiteHechoDetalle.getEhtexto(),
				tramiteHechoDetalle.getEhcozs(),
				tramiteHechoDetalle.getEhcivihe(),
				tramiteHechoDetalle.getEhacuse(),
				tramiteHechoDetalle.getEhenviomail(),
				tramiteHechoDetalle.getEhdiremail(),
				tramiteHechoDetalle.getCodOrgTraslado(), null, tramite,
				censoMonitor, hechoDenunciado);

		// Modificacion de tramite hecho
		this.tramiteHechoDao.updateTramiteHecho(tramitehecho);

		return tramiteHechoDetalle;

	}

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalleMail
	 *            TramiteHechoDetalleMail
	 * @param censoMonitorUsuarioconectado
	 *            CensoMonitor
	 * @return TramiteHechoDetalleMail
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHechoDetalleMail enviarMail(
			TramiteHechoDetalleMail tramiteHechoDetalleMail) {

		Tramite tramite = new Tramite();
		tramite.setTrcodigo(Y41aConstantes.TRAMITE_SOLICITUD_EMAIL);

		CensoMonitor censoMonitor = new CensoMonitor();
		censoMonitor.setMocodigo(tramiteHechoDetalleMail.getMocodigo());

		// buscar monitor
		CensoMonitor censoMonitorMail = this.censoMonitorDao.find(censoMonitor);
		if (censoMonitorMail != null
				&& (censoMonitorMail.getMocoem() == null || censoMonitorMail
						.getMocoem().equals(""))) {
			throw new Y41aUDAException("error.mail.emailusuarioseleccionado",
					true, new Exception());
		}

		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setHdcodigo(tramiteHechoDetalleMail.getHdcodigo());

		TramiteHecho tramitehecho = new TramiteHecho(Y41aUIDGenerator
				.getInstance().generateId(Y41aConstantes.PK_SIZE),
				tramiteHechoDetalleMail.getEhfecha(),
				tramiteHechoDetalleMail.getEhhora(),
				tramiteHechoDetalleMail.getEhcodpor(),
				tramiteHechoDetalleMail.getEhcodpde(),
				tramiteHechoDetalleMail.getEhtexto(),
				tramiteHechoDetalleMail.getEhcozs(),
				tramiteHechoDetalleMail.getEhcivihe(),
				tramiteHechoDetalleMail.getEhacuse(),
				tramiteHechoDetalleMail.getEhenviomail(),
				tramiteHechoDetalleMail.getEhdiremail(),
				tramiteHechoDetalleMail.getCodOrgTraslado(), null, tramite,
				censoMonitor, hechoDenunciado);

		// Alta de tramite hecho
		this.tramiteHechoDao.add(tramitehecho);

		// Envio mail
		String destinatariosMail = tramiteHechoDetalleMail.getEhdiremail();
		String from = tramiteHechoDetalleMail.getMocoem();

		StringBuffer destinatarios = new StringBuffer();
		destinatarios.append(destinatariosMail);

		StringBuffer copiaoculta = new StringBuffer();
		copiaoculta.append(censoMonitorMail.getMocoem());

		Properties prop = Y41aConfig.loadProperties(Y41aConstantes.CONFIG_PATH);

		String smtpMail = (String) prop
				.getProperty("y41aVistaWar.mail.ejie.smtp");

		StringBuffer asunto = new StringBuffer();
		asunto.append(appMessageSource.getMessage("respuesta.mail.asunto",
				null, new Locale(Y41aConstantes.CASTELLANO)));

		StringBuffer numeroConsulta = new StringBuffer();

		numeroConsulta.append(tramiteHechoDetalleMail.getDecoor()).append("-")
				.append(tramiteHechoDetalleMail.getDenror()).append("-")
				.append(tramiteHechoDetalleMail.getDenran()).append("-")
				.append(tramiteHechoDetalleMail.getHdnror());

		asunto.append(" ").append(numeroConsulta).append(" / ");

		asunto.append(appMessageSource.getMessage("respuesta.mail.asunto",
				null, new Locale(Y41aConstantes.EUSKERA)));
		asunto.append(" ").append(numeroConsulta);

		StringBuffer texto = new StringBuffer();
		texto.append(tramiteHechoDetalleMail.getEhtexto());

		List<DocumentoHecho> listDocumentoHecho = tramiteHechoDetalleMail
				.getDocumentoHechosMail();
		ArrayList attachments = new ArrayList();

		for (DocumentoHecho docHecho : listDocumentoHecho) {
			AttachFile fileattach = new AttachFile();

			docHecho = this.documentoHechoDao.findDocumentoHecho(docHecho);

			fileattach.setContentType(docHecho.getQ5contenttypefile());
			fileattach.setNombre(docHecho.getQ5nofile());
			fileattach.setAdjunto(docHecho.getQ5datafile());

			attachments.add(fileattach);
		}

		// Envio mail
		boolean envio = Y41aUtils.sendMail(smtpMail, asunto.toString(),
				texto.toString(), from, destinatarios.toString(),
				copiaoculta.toString(), attachments);

		if (envio) {

			for (DocumentoHecho docHecho : listDocumentoHecho) {
				docHecho.setQ5indmail(Y41aConstantes.VALOR_SI);
				docHecho.setTramiteHechoByQ5trmail(tramitehecho);
				this.documentoHechoDao.updateDocumentoHechoMail(docHecho);
			}

		} else {
			throw new Y41aUDAException("error.denuncia.envioemail", true,
					new Exception());
		}

		return tramiteHechoDetalleMail;
	}

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeSolicitud(SolicitudDetalle solicitudDetalle) {

		DocumentoHecho documentohecho = new DocumentoHecho();
		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setHdcodigo(solicitudDetalle.getHdcodigo());
		Denuncia denuncia = new Denuncia();
		denuncia.setDecodigo(solicitudDetalle.getDecodigo());
		hechoDenunciado.setDenuncia(denuncia);
		documentohecho.setHechoDenunciado(hechoDenunciado);
		// Elimina los documentos
		this.documentoHechoDao.removeDocumentosSolicitud(documentohecho);

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setHechoDenunciado(hechoDenunciado);
		// Elimina los tramites
		this.tramiteHechoDao.removeTramitesSolicitud(tramitehecho);

		DecisionHecho decisionhecho = new DecisionHecho();
		decisionhecho.setHechoDenunciado(hechoDenunciado);
		// Elimina la decision
		this.decisionHechoDao.removeDecisionSolicitud(decisionhecho);

		// buscamos todos los hechos de una denuncia
		Long numHechos = this.hechoDenunciadoDao.findAllCount(hechoDenunciado);

		if (numHechos == 1) {
			// Elimina el hecho de la denuncia
			this.hechoDenunciadoDao.remove(hechoDenunciado);
			// Elimina la denuncia si solo tiene un hecho
			this.denunciaDao.remove(denuncia);
		} else {
			// Elimina el hecho de la denuncia
			this.hechoDenunciadoDao.remove(hechoDenunciado);
		}
	}

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeTramiteHecho(TramiteHechoDetalle tramiteHechoDetalle) {
		DocumentoHecho documentoHecho = new DocumentoHecho();
		TramiteHecho tramiteHecho = new TramiteHecho();
		tramiteHecho.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
		documentoHecho.setTramiteHechoByQ5tramite(tramiteHecho);

		try {
			tramiteHechoDetalle = this.tramiteHechoDao
					.findTramiteHecho(tramiteHechoDetalle);

			if (Y41aConstantes.TRAMITE_GENERICO_KONBIDE
					.equals(tramiteHechoDetalle.getTrcodigo())
					&& Y41aConstantes.VALOR_SI.equals(tramiteHechoDetalle
							.getEhautomatico())) {
				throw new Y41aUDAException(
						"error.eliminarTramite.isTramiteAutomaticoException",
						true, new Exception());
			}

			TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
			tramiteHechoDetalleAux.setHdcodigo(tramiteHechoDetalle
					.getHdcodigo());

			long contador = 0;
			contador = this.tramiteHechoDao
					.findAllTramiteHechoCount(tramiteHechoDetalleAux);
			if (contador <= 1) {
				throw new Y41aUDAException("error.validacion.ultimoTramite",
						true, new Exception());
			} else {
				// Eliminar el documento del tramite
				this.documentoHechoDao
						.removeDocumentoTramiteHecho(documentoHecho);
				// Eliminar el tramite
				this.tramiteHechoDao.remove(tramiteHecho);
			}
		} catch (DataIntegrityViolationException e) {
			throw new Y41aUDAException(
					"error.solicitud.tramitehechomail.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Obtiene los datos del detalle del trámite. Si es un trámite de traslado
	 * que se ha hecho efectivo se devuelve en el campo resumen el resultado del
	 * traslado: Aceptación o Motivo de denegación.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle filtro de trámite
	 * @return TramiteHechoDetalle datos del trámite
	 * @throws SQLException
	 *             SQLException si de produce algún error al recuperar los datos
	 * @throws IOException
	 *             IOException si se produce algún error al recuperar el mensaje
	 *             del motivo de rechazo
	 */
	public TramiteHechoDetalle findTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle) throws SQLException,
			IOException {
		tramiteHechoDetalle = this.tramiteHechoDao
				.findTramiteHecho(tramiteHechoDetalle);

		TramiteHechoDetalle tramiteHechoDetalleAux = this.tramiteHechoDao
				.findLobTablaTemporal(tramiteHechoDetalle);

		if (tramiteHechoDetalle.getTrcodigo().equals(
				Y41aConstantes.TRAMITE_SOLICITUD_RECEPCION_TRASLADO_KONBIDE)) {

			if (Y41aConstantes.RESPUESTA_TRASPASO_ACEPTADA
					.equals(tramiteHechoDetalle.getEhrespuestatraspaso())) {
				tramiteHechoDetalle.setEhtexto(this.appMessageSource
						.getMessage("traslado.aceptado", null,
								LocaleContextHolder.getLocale()));
			} else {
				TramiteHecho tramitehecho = new TramiteHecho();
				tramitehecho.setEhcodigo(tramiteHechoDetalle.getEhcodigo());

				TramiteHecho tramiteHechoAux = (TramiteHecho) this.tramiteHechoDao
						.findCLobsTabla(tramitehecho);
				tramiteHechoDetalle.setEhtexto(Y41aUtils
						.clobToString(tramiteHechoAux.getEhmotivorechazo()));
			}

		} else {
			tramiteHechoDetalle.setEhtexto(tramiteHechoDetalleAux.getEhtexto());
		}

		if (tramiteHechoDetalle.getTrcodigo().equals(
				Y41aConstantes.TRAMITE_GENERICO_KONBIDE)) {

			TramiteHechoDetalle tramiteHechoDetalleAux2 = this.tramiteHechoDao
					.findNombreTramiteGenericoTramiteHecho(tramiteHechoDetalle);

			StringBuffer texto = new StringBuffer();

			if (Y41aUtils
					.isFilled(tramiteHechoDetalleAux2.getEhnombretramite())) {
				texto = texto.append(tramiteHechoDetalleAux2
						.getEhnombretramite());
			}

			if (Y41aUtils.isFilled(tramiteHechoDetalleAux.getEhtexto())) {
				texto = texto.append("\n").append(
						tramiteHechoDetalleAux.getEhtexto());
			}

			tramiteHechoDetalle.setEhtexto(texto.toString());
		}

		return tramiteHechoDetalle;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param decisionHechoDetalle
	 *            DecisionHechoDetalle
	 * @return DecisionHechoDetalle
	 */
	public DecisionHechoDetalle findDecisionHecho(
			DecisionHechoDetalle decisionHechoDetalle) {
		return (DecisionHechoDetalle) this.decisionHechoDao
				.findDecisionHecho(decisionHechoDetalle);
	}

	/**
	 * Actualiza los datos de la decisión en la tabla de decisiones. Genera la
	 * plantilla para el trámite. Al grabar esta decisión también se actualizará
	 * el indicador de solicitado arbitraje HDINSOMA en la tabla HECDEN. En caso
	 * de traslado o inhibicion se guardar el código del organismo destino.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DecisionHechoDetalle updateDecisionHecho(
			DecisionHechoDetalle decisionHechoDetalle) {
		try {
			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(decisionHechoDetalle.getHdcodigo());

			if (decisionHechoDetalle != null
					&& decisionHechoDetalle.getDecodigo() != null
					&& decisionHechoDetalle
							.getDecodigo()
							.equals(Y41aConstantes.DECISION_TRASLADO_ORGANISMOS_FUERA_CIAC)) {
				TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();

				tramiteHechoDetalle
						.setTrcodigo(Y41aConstantes.TRAMITE_SOLICITUD_TRASLADO_SOLICITUD);
				tramiteHechoDetalle.setHdcodigo(decisionHechoDetalle
						.getHdcodigo());
			}

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(decisionHechoDetalle.getMocodigo());

			Decision decision = new Decision();
			decision.setDecodigo(decisionHechoDetalle.getDecodigo());

			DecisionHecho decisionHecho = new DecisionHecho(
					decisionHechoDetalle.getHccodigo(),
					decisionHechoDetalle.getHccoor(),
					decisionHechoDetalle.getHcfede(),
					decisionHechoDetalle.getHcfecode(),
					decisionHechoDetalle.getHccoorprop(),
					decisionHechoDetalle.getHccoortrasinhibi(),
					hechoDenunciado, decision);
			this.decisionHechoDao.updateDecision(decisionHecho);
			this.decisionHechoDao
					.updateOrganismoTrasladoInhibicion(decisionHecho);

			if (Y41aUtils.isFilled(decisionHechoDetalle.getDecodigo())) {
				PlantillaDecision plantillaDecision = new PlantillaDecision();
				plantillaDecision.setDecision(decision);
				plantillaDecision.setPdcoor(decisionHechoDetalle.getCodOrg());

				try {
					// Obtener la plantilla del tramite
					plantillaDecision = this.plantillaDecisionDao
							.findPlantillaDecision(plantillaDecision);
				} catch (Exception e) {
					throw new Y41aUDAException(
							"error.decisionhecho.organismonoinicializado",
							true, e);
				}

				if (plantillaDecision.getPdplantilla() != null) {

					// Obtener los datos de la solicitud
					PlantillaTramiteDecisionDetalle plantillaTramiteDecisionDetalle = new PlantillaTramiteDecisionDetalle();
					plantillaTramiteDecisionDetalle
							.setHccodigo(decisionHechoDetalle.getHccodigo());

					plantillaTramiteDecisionDetalle = this.decisionHechoDao
							.findPlantillaTramiteDecision(plantillaTramiteDecisionDetalle);

					plantillaTramiteDecisionDetalle = this
							.completeInfoPlantillaTramiteDecisionDetalle(
									plantillaTramiteDecisionDetalle,
									decisionHechoDetalle);

					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle.setHdcodigo(decisionHechoDetalle
							.getHdcodigo());

					SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao
							.findLobTablaTemporal(solicitudDetalle);
					plantillaTramiteDecisionDetalle.setHdte(solDetalleAux
							.getHdte());

					String q5nofile = null;
					Integer q5sizefile = null;
					String q5tedesfile = null;
					String q5contenttypefile = null;
					Blob q5datafile = null;

					q5nofile = plantillaDecision.getPdnofile();
					q5sizefile = plantillaDecision.getPdsizefile();
					q5tedesfile = plantillaDecision.getPdnombre();
					q5contenttypefile = plantillaDecision
							.getPdcontenttypefile();

					// Transformar el documento en castellano
					String plantilla = Y41aUtils.blobToString(plantillaDecision
							.getPdplantilla());

					Properties prop = Y41aConfig
							.loadProperties(Y41aConstantes.CONFIG_PATH);

					StringBuffer rutaPlantilla = new StringBuffer(
							prop.getProperty("y41aVistaWar.rutaxml.plantillas.word"));

					rutaPlantilla
							.append(Y41aConstantes.NOMBRE_PLANTILLA_XML_DECISION_CASTELLANO);

					String ficheroGenerado = Y41aGenerarDocumento
							.generarDocumentoWord(rutaPlantilla.toString(),
									plantillaTramiteDecisionDetalle, plantilla);

					q5datafile = new SerialBlob(ficheroGenerado.getBytes());

					DocumentoHecho documentoHecho = new DocumentoHecho(
							String.valueOf(this.documentoHechoDao.getNewPK()),
							q5nofile, q5datafile, q5sizefile, q5tedesfile,
							Y41aConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION,
							new Date(), null, q5contenttypefile, null, null,
							hechoDenunciado);

					// Guardarlo en la tabla de documentos hecho
					this.documentoHechoDao.add(documentoHecho);
				}

				if (decisionHechoDetalle.getDecodigo().equals(
						Y41aConstantes.DECISION_ARBITRAJE)) {

					// Comprobar si ya existe un arbitraje con esa solicitud
					// como
					// origen.
					Sanexprel sanexprel = new Sanexprel();
					sanexprel.setRlhdcodrel(decisionHechoDetalle.getHdcodigo());
					sanexprel
							.setRlesorig(Y41aConstantes.TIPO_SAN_EXPREL_ORIGEN);

					List<Sanexprel> solicitudConArbitraje = this.sanexprelDao
							.findAll(sanexprel, null);

					if (solicitudConArbitraje.size() > 0
							&& solicitudConArbitraje.get(0) != null
							&& solicitudConArbitraje.get(0).getRlhdcodrel() != null) {

						// Buscamos el codigo del arbitraje para mostrarlo en el
						// error.
						Solarb solarb = new Solarb();
						solarb.setSacohd(solicitudConArbitraje.get(0)
								.getExcodigo());

						List<Solarb> solarbs = this.solarbDao.findAll(solarb,
								null);

						String[] args = { solarbs.get(0).getSacoja() + "-"
								+ solarbs.get(0).getSanror() + "-"
								+ solarbs.get(0).getSanran() };

						String msgError = this.appMessageSource.getMessage(
								"error.solicitud.tieneArbitraje", args,
								LocaleContextHolder.getLocale());

						throw new Y41aUDAException(msgError, true,
								new Exception());
					}

					hechoDenunciado
							.setHdinsoma(Y41aConstantes.SOLICITUD_ARBITRAJE);

					this.hechoDenunciadoDao
							.updateIndicadorArbitraje(hechoDenunciado);

					Arbpropbandeja arbpropbandeja = new Arbpropbandeja();
					// Codigo del hecho denunciado
					arbpropbandeja.setBaprarbexcodigo(hechoDenunciado
							.getHdcodigo());

					// Num expediente
					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle.setHdcodigo(hechoDenunciado.getHdcodigo());
					SolicitudDetalle solDetalle = this.hechoDenunciadoDao
							.findSolicitud(solicitudDetalle);
					StringBuffer numeroExpediente = new StringBuffer();
					numeroExpediente.append(solDetalle.getDecoor()).append("-")
							.append(solDetalle.getDenror()).append("-")
							.append(solDetalle.getDenran()).append("-")
							.append(solDetalle.getHdnror());
					arbpropbandeja.setBaprarbexcodigocompleto(numeroExpediente
							.toString());
					// Procedimiento
					arbpropbandeja
							.setBaprarbpcodigo(Y41aConstantes.TIPO_PROC_SOLICITUDES);
					// Fecha registro
					// 20150401: Cambiamos a fecha del hecho, a la fecha del
					// hecho
					// denunciado
					arbpropbandeja.setBaprarbfec(solDetalle.getHdfehd());
					// Buscamos el Establecimiento (interviniente Denunciado)
					// Datos del establecimiento Ini

					Establecimiento establecimiento = new Establecimiento();
					establecimiento.setEscodigo(solDetalle.getEscodigo());

					establecimiento = this.establecimientoDao
							.find(establecimiento);

					if (establecimiento != null) {
						arbpropbandeja.setEstablecimiento(establecimiento);
						arbpropbandeja.setBaprarbmunic(establecimiento
								.getEsnoraMunicipioId());
						arbpropbandeja.setBaprarbprov(establecimiento
								.getEsnoraProvinciaId());
					}

					// Datos del establecimiento Fin
					// Responsable del expediente
					arbpropbandeja.setBaprarbrespexp(solDetalle.getMocodigo());

					arbpropbandeja = this.arbpropbandejaDao.add(arbpropbandeja);

				}
			}

			// como calcular la hora
			String ehhora = null;

			try {
				ehhora = Y41aUtils.formatearDateToString(new Date(),
						Y41aConstantes.FORMATO_HORA);
			} catch (ParseException e) {
				ehhora = null;
			}

			Tramite tramite = new Tramite();
			tramite.setTrcodigo(Y41aConstantes.TRAMITE_SOLICITUD_REGISTRO_DECISION);

			// Evita problemas con las fechas desde hasta
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41aUtils.parseDate(today, locale);

			String descripciones = "";
			if (Y41aUtils.isFilled(decisionHechoDetalle.getDecodigo())) {
				Decision decisionAux = this.decisionDao.find(decision);

				descripciones = decisionAux.getDenombree() + "\n"
						+ decisionAux.getDenombre();
			}

			TramiteHecho tramiteHecho = new TramiteHecho(Y41aUIDGenerator
					.getInstance().generateId(Y41aConstantes.PK_SIZE),
					todayWithZeroTime, ehhora, null, null, descripciones, null,
					null, null, null, null, null, null, tramite, censoMonitor,
					hechoDenunciado);

			// Da de alta un tramite de hecho
			this.tramiteHechoDao.add(tramiteHecho);

			return decisionHechoDetalle;
		} catch (SQLException e) {
			throw new Y41aUDAException("error.solicitud.modificar.decision",
					true, e);
		} catch (IOException e) {
			throw new Y41aUDAException("error.solicitud.modificar.decision",
					true, e);
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41aUDAException("error.solicitud.modificar.decision",
					true, e);
		}
	}

	/**
	 * Complete information of the object PlantillaTramiteDecisionDetalle.
	 * 
	 * @param plantillaTramiteDecisionDetalle
	 *            PlantillaTramiteDecisionDetalle
	 * @param decisionHechoDetalle
	 *            DecisionHechoDetalle
	 * @return PlantillaTramiteDecisionDetalle
	 */
	private PlantillaTramiteDecisionDetalle completeInfoPlantillaTramiteDecisionDetalle(
			PlantillaTramiteDecisionDetalle plantillaTramiteDecisionDetalle,
			DecisionHechoDetalle decisionHechoDetalle) {

		try {
			// Formateamos las fecha a castellano e euskera
			plantillaTramiteDecisionDetalle.setHcfedeTextoCas(Y41aUtils
					.formatearDateToString(
							plantillaTramiteDecisionDetalle.getHcfede(),
							Y41aConstantes.FORMATO_FULL_FECHA_ES,
							Y41aConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setHcfedeTextoEus(Y41aUtils
					.formatearDateToStringEuskera(
							plantillaTramiteDecisionDetalle.getHcfede(),
							Y41aConstantes.FORMATO_FULL_FECHA_EU,
							Y41aConstantes.EUSKERA));

			plantillaTramiteDecisionDetalle.setHcfedeCas(Y41aUtils
					.parseDateToString(
							plantillaTramiteDecisionDetalle.getHcfede(),
							Y41aConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setHcfedeEus(Y41aUtils
					.parseDateToString(
							plantillaTramiteDecisionDetalle.getHcfede(),
							Y41aConstantes.EUSKERA));

			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(decisionHechoDetalle.getHdcodigo());

			// Formatear las fechas castellano y euskera
			tramiteHechoDetalle
					.setTrcodigo(Y41aConstantes.TRAMITE_SOLICITUD_REQUERIR_SUBSANACION);
			try {
				tramiteHechoDetalle = this.tramiteHechoDao
						.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
			} catch (Exception e) {
			}

			plantillaTramiteDecisionDetalle
					.setFechaRequerirSubsanacionCas(Y41aUtils
							.parseDateToString(
									tramiteHechoDetalle.getEhfecha(),
									Y41aConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle
					.setFechaRequerirSubsanacionEus(Y41aUtils
							.parseDateToString(
									tramiteHechoDetalle.getEhfecha(),
									Y41aConstantes.EUSKERA));

			// Creamos el campo numero de expediente
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente
					.append(plantillaTramiteDecisionDetalle.getDecoor())
					.append("-")
					.append(plantillaTramiteDecisionDetalle.getDenror())
					.append("-")
					.append(plantillaTramiteDecisionDetalle.getDenran())
					.append("-")
					.append(plantillaTramiteDecisionDetalle.getHdnror());

			plantillaTramiteDecisionDetalle.setNumExpediente(numeroExpediente
					.toString());

			// Creamos el campo direccion del establecimiento
			StringBuffer direccionCompleta = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getEsnombreCalle() != null
					&& !plantillaTramiteDecisionDetalle.getEsnombreCalle()
							.equals("")) {
				direccionCompleta.append(plantillaTramiteDecisionDetalle
						.getEsnombreCalle());

				if (plantillaTramiteDecisionDetalle.getEsnombrePortal() != null
						&& !plantillaTramiteDecisionDetalle.getEsnombrePortal()
								.equals("")) {
					direccionCompleta.append(", ")
							.append(plantillaTramiteDecisionDetalle
									.getEsnombrePortal());
				}
				if (plantillaTramiteDecisionDetalle.getEsnombrePiso() != null
						&& !plantillaTramiteDecisionDetalle.getEsnombrePiso()
								.equals("")) {
					direccionCompleta.append(" ").append(
							plantillaTramiteDecisionDetalle.getEsnombrePiso());
				}
			} else {
				if (plantillaTramiteDecisionDetalle.getEsdireccion_nocapv() != null
						&& !plantillaTramiteDecisionDetalle
								.getEsdireccion_nocapv().equals("")) {
					direccionCompleta.append(plantillaTramiteDecisionDetalle
							.getEsdireccion_nocapv());
				} else {
					direccionCompleta.append(plantillaTramiteDecisionDetalle
							.getEsnodir());
				}
			}

			plantillaTramiteDecisionDetalle.setEsdireccion(direccionCompleta
					.toString());

			// Creamos el campo codigo postal y municipio del establecimiento
			StringBuffer cpMunicipio = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getEsnombreCp() != null
					&& !plantillaTramiteDecisionDetalle.getEsnombreCp().equals(
							"")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle
						.getEsnombreCp());

				if (plantillaTramiteDecisionDetalle.getEsnombreMunicipio() != null
						&& !plantillaTramiteDecisionDetalle
								.getEsnombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteDecisionDetalle
									.getEsnombreMunicipio());
				} else if (plantillaTramiteDecisionDetalle.getEsextranjero() != null
						&& plantillaTramiteDecisionDetalle.getEsextranjero()
								.equals("S")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteDecisionDetalle
									.getEsnoraPaisNombre());
				}
			} else if (plantillaTramiteDecisionDetalle.getEsnombreMunicipio() != null
					&& !plantillaTramiteDecisionDetalle.getEsnombreMunicipio()
							.equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle
						.getEsnombreMunicipio());
			} else if (plantillaTramiteDecisionDetalle.getEsextranjero() != null
					&& plantillaTramiteDecisionDetalle.getEsextranjero()
							.equals("S")) {
				cpMunicipio.append(" ").append(
						plantillaTramiteDecisionDetalle.getEsnoraPaisNombre());
			}

			plantillaTramiteDecisionDetalle.setEscpMunicipio(cpMunicipio
					.toString());

			// Creamos el campo direccion del consumidor
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getDtnombreCalle() != null
					&& !plantillaTramiteDecisionDetalle.getDtnombreCalle()
							.equals("")) {
				direccionCompleta.append(plantillaTramiteDecisionDetalle
						.getDtnombreCalle());

				if (plantillaTramiteDecisionDetalle.getDtnombrePortal() != null
						&& !plantillaTramiteDecisionDetalle.getDtnombrePortal()
								.equals("")) {
					direccionCompleta.append(", ")
							.append(plantillaTramiteDecisionDetalle
									.getDtnombrePortal());
				}
				if (plantillaTramiteDecisionDetalle.getDtnombrePiso() != null
						&& !plantillaTramiteDecisionDetalle.getDtnombrePiso()
								.equals("")) {
					direccionCompleta.append(" ").append(
							plantillaTramiteDecisionDetalle.getDtnombrePiso());
				}
			} else {
				if (plantillaTramiteDecisionDetalle.getDtdireccion_nocapv() != null
						&& !plantillaTramiteDecisionDetalle
								.getDtdireccion_nocapv().equals("")) {
					direccionCompleta.append(plantillaTramiteDecisionDetalle
							.getDtdireccion_nocapv());
				} else {
					direccionCompleta.append(plantillaTramiteDecisionDetalle
							.getDtnodir());
				}
			}

			plantillaTramiteDecisionDetalle.setDtdireccion(direccionCompleta
					.toString());

			// Creamos el campo codigo postal y municipio del consumidor
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getDtnombreCp() != null
					&& !plantillaTramiteDecisionDetalle.getDtnombreCp().equals(
							"")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle
						.getDtnombreCp());

				if (plantillaTramiteDecisionDetalle.getDtnombreMunicipio() != null
						&& !plantillaTramiteDecisionDetalle
								.getDtnombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteDecisionDetalle
									.getDtnombreMunicipio());
				} else if (plantillaTramiteDecisionDetalle.getDtextranjero() != null
						&& plantillaTramiteDecisionDetalle.getDtextranjero()
								.equals("S")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteDecisionDetalle
									.getDtnoraPaisNombre());
				}
			} else if (plantillaTramiteDecisionDetalle.getDtnombreMunicipio() != null
					&& !plantillaTramiteDecisionDetalle.getDtnombreMunicipio()
							.equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle
						.getDtnombreMunicipio());
			} else if (plantillaTramiteDecisionDetalle.getDtextranjero() != null
					&& plantillaTramiteDecisionDetalle.getDtextranjero()
							.equals("S")) {
				cpMunicipio.append(" ").append(
						plantillaTramiteDecisionDetalle.getDtnoraPaisNombre());
			}

			plantillaTramiteDecisionDetalle.setDtcpMunicipio(cpMunicipio
					.toString());

			// Creamos el campo direccion del organismo conectado
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getNombreCalle() != null
					&& !plantillaTramiteDecisionDetalle.getNombreCalle()
							.equals("")) {
				direccionCompleta.append(plantillaTramiteDecisionDetalle
						.getNombreCalle());

				if (plantillaTramiteDecisionDetalle.getNombrePortal() != null
						&& !plantillaTramiteDecisionDetalle.getNombrePortal()
								.equals("")) {
					direccionCompleta.append(", ").append(
							plantillaTramiteDecisionDetalle.getNombrePortal());
				}
			}

			plantillaTramiteDecisionDetalle
					.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getNombreCp() != null
					&& !plantillaTramiteDecisionDetalle.getNombreCp()
							.equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle
						.getNombreCp());

				if (plantillaTramiteDecisionDetalle.getNombreMunicipio() != null
						&& !plantillaTramiteDecisionDetalle
								.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteDecisionDetalle
									.getNombreMunicipio());
				}
			} else if (plantillaTramiteDecisionDetalle.getNombreMunicipio() != null
					&& !plantillaTramiteDecisionDetalle.getNombreMunicipio()
							.equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle
						.getNombreMunicipio());
			}

			plantillaTramiteDecisionDetalle.setCpMunicipioOrganismo(cpMunicipio
					.toString());

			// Creamos el campo direccion del organismo al que se traslada
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getNombreCalleTraslado() != null
					&& !plantillaTramiteDecisionDetalle
							.getNombreCalleTraslado().equals("")) {
				direccionCompleta.append(plantillaTramiteDecisionDetalle
						.getNombreCalleTraslado());

				if (plantillaTramiteDecisionDetalle.getNombrePortalTraslado() != null
						&& !plantillaTramiteDecisionDetalle
								.getNombrePortalTraslado().equals("")) {
					direccionCompleta.append(", ").append(
							plantillaTramiteDecisionDetalle
									.getNombrePortalTraslado());
				}
			}

			plantillaTramiteDecisionDetalle
					.setDireccionTraslado(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo al que
			// se traslada
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getNombreCpTraslado() != null
					&& !plantillaTramiteDecisionDetalle.getNombreCpTraslado()
							.equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle
						.getNombreCpTraslado());

				if (plantillaTramiteDecisionDetalle
						.getNombreMunicipioTraslado() != null
						&& !plantillaTramiteDecisionDetalle
								.getNombreMunicipioTraslado().equals("")) {
					cpMunicipio.append(" ").append(
							plantillaTramiteDecisionDetalle
									.getNombreMunicipioTraslado());
				}
			} else if (plantillaTramiteDecisionDetalle
					.getNombreMunicipioTraslado() != null
					&& !plantillaTramiteDecisionDetalle
							.getNombreMunicipioTraslado().equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle
						.getNombreMunicipioTraslado());
			}

			plantillaTramiteDecisionDetalle.setCpMunicipioTraslado(cpMunicipio
					.toString());

			if (plantillaTramiteDecisionDetalle.getEsinadar() != null
					&& plantillaTramiteDecisionDetalle.getEsinadar().equals(
							Y41aConstantes.VALOR_SI)) {

				// recuperar texto de properties
				plantillaTramiteDecisionDetalle
						.setTextoArbitrajeCas(appMessageSource.getMessage(
								"decision.texto.arbitraje", null, new Locale(
										Y41aConstantes.CASTELLANO)));
				plantillaTramiteDecisionDetalle
						.setTextoArbitrajeEus(appMessageSource.getMessage(
								"decision.texto.arbitraje", null, new Locale(
										Y41aConstantes.EUSKERA)));
			}

			return plantillaTramiteDecisionDetalle;

		} catch (ParseException e) {
			throw new Y41aUDAException("error.solicitud.alta.tramite", true, e);
		}
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoHechoDetalle> findAllDocumentoHecho(
			DocumentoHechoDetalle documentoHechoDetalle, Pagination pagination) {
		return (List<DocumentoHechoDetalle>) this.documentoHechoDao
				.findAllDocumentoHecho(documentoHechoDetalle, pagination);
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return Long
	 */
	public Long findAllDocumentoHechoCount(
			DocumentoHechoDetalle documentoHechoDetalle) {
		return this.documentoHechoDao
				.findAllDocumentoHechoCount(documentoHechoDetalle);
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentoHechoDetalle addDocumentoHecho(
			DocumentoHechoDetalle documentoHechoDetalle) {

		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setHdcodigo(documentoHechoDetalle.getHdcodigo());

		DocumentoHecho documentoHecho = new DocumentoHecho(
				String.valueOf(this.documentoHechoDao.getNewPK()),
				documentoHechoDetalle.getQ5nofile(),
				documentoHechoDetalle.getQ5datafile(),
				documentoHechoDetalle.getQ5sizefile(),
				documentoHechoDetalle.getQ5tedesfile(),
				documentoHechoDetalle.getQ5origen(),
				documentoHechoDetalle.getQ5fecha(),
				documentoHechoDetalle.getQ5indmail(),
				documentoHechoDetalle.getQ5contenttypefile(), null, null,
				hechoDenunciado);

		documentoHechoDetalle.setQ5codocumento(documentoHecho
				.getQ5codocumento());

		documentoHecho.setQ5idtipodoc(documentoHechoDetalle.getQ5idtipodoc());

		this.documentoHechoDao.add(documentoHecho);

		return documentoHechoDetalle;
	}

	/**
	 * Deletes a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeDocumentoHecho(DocumentoHechoDetalle documentoHechoDetalle) {
		DocumentoHecho documentoHecho = new DocumentoHecho();

		documentoHecho.setQ5codocumento(documentoHechoDetalle
				.getQ5codocumento());

		// Eliminar el documento
		this.documentoHechoDao.remove(documentoHecho);
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 */
	public DocumentoHechoDetalle findDocumentoHecho(
			DocumentoHechoDetalle documentoHechoDetalle) {
		DocumentoHecho documentoHecho = new DocumentoHecho();

		documentoHecho.setQ5codocumento(documentoHechoDetalle
				.getQ5codocumento());

		documentoHecho = this.documentoHechoDao
				.findDocumentoHecho(documentoHecho);

		documentoHechoDetalle = new DocumentoHechoDetalle(
				documentoHecho.getQ5codocumento(),
				documentoHecho.getQ5nofile(), documentoHecho.getQ5datafile(),
				documentoHecho.getQ5sizefile(),
				documentoHecho.getQ5tedesfile(), documentoHecho.getQ5origen(),
				documentoHecho.getQ5fecha(), documentoHecho.getQ5indmail(),
				documentoHecho.getQ5contenttypefile(), null, null, null, null,
				null, null, null, null, null, null, null, null, null, null);

		return documentoHechoDetalle;
	}

	/**
	 * Finds a single row in the SolicitudArbitraje table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 */
	public SolicitudArbitrajeDetalle findSolicitudArbitraje(
			SolicitudArbitrajeDetalle solicitudArbitrajeDetalle) {

		try {
			return this.solicitudArbitrajeDao
					.findSolicitudArbitraje(solicitudArbitrajeDetalle);
		} catch (EmptyResultDataAccessException e) {
			throw new Y41aUDAException(
					"error.solicitud.arbitraje.EmptyResultDataAccessException",
					true, e);
		}
	}

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Denuncia denuncia) {
		this.denunciaDao.remove(denuncia);
	}

	/**
	 * Deletes multiple rows in the Denuncia table.
	 * 
	 * @param denunciaList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Denuncia> denunciaList) {
		for (Denuncia denunciaAux : denunciaList) {
			this.denunciaDao.remove(denunciaAux);
		}
	}

	/**
	 * Getter method for DenunciaDao
	 * 
	 * @return DenunciaDao
	 */
	public DenunciaDao getDenunciaDao() {
		return this.denunciaDao;
	}

	/**
	 * Setter method for DenunciaDao.
	 * 
	 * @param denunciaDao
	 *            DenunciaDao
	 * @return
	 */
	public void setDenunciaDao(DenunciaDao denunciaDao) {
		logger.info("Setting Dependency " + denunciaDao);
		this.denunciaDao = denunciaDao;
	}

	/**
	 * Finds rows in the Hecho Denunciado table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstadisticasKontsumonetResultado> findAllSolicitudEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			Pagination pagination) {

		return (List<EstadisticasKontsumonetResultado>) this.estadisticasListadosKontsumonetDao
				.findAllSolicitudEstadisticasKontsumonet(
						estadisticasKontsumonetBusqueda, pagination);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisionMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaDecisionMunicipioEstablecimiento(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaDecisionMunicipioConsumidor(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSectoresMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaSectoresMunicipioEstablecimiento(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaMotivos(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaMotivos(solicitudesBusqueda,
						pagination, startsWith, defedeDesde, defedeHasta,
						defereDesde, defereHasta, hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisiones(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaDecisiones(solicitudesBusqueda,
						pagination, startsWith, defedeDesde, defedeHasta,
						defereDesde, defereHasta, hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaFormaPresentacionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaFormaPresentacionMunicipioConsumidor(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);
	}

	/**
	 * 0132627 Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaFormaVentaMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaFormaVentaMunicipioConsumidor(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSectoresMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaSectoresMunicipioConsumidor(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSexoEdad(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaSexoEdad(solicitudesBusqueda,
						pagination, startsWith, defedeDesde, defedeHasta,
						defereDesde, defereHasta, hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaPromedioTiempoResolverSolicitud(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaPromedioTiempoResolverSolicitud(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaProductoServicioMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaProductoServicioMunicipioEstablecimiento(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaProductoServicioMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		return (List<EstadisticasSolicitudesResultado>) this.estadisticasListadosSolicitudesDao
				.findAllSolicitudEstadisticaProductoServicioMunicipioConsumidor(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesProductoServicioMotivo(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.estadisticasListadosSolicitudesDao
				.findAllSolicitudListadoSolicitudesProductoServicioMotivo(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);

		return getDireccionCompleta(listListadoSolicitudResultado);
	}

	/**
	 * Obtain the direccion completa.
	 * 
	 * @param listListadoSolicitudResultado
	 *            List<ListadoSolicitudResultado
	 * @return List
	 */

	private static List<ListadoSolicitudResultado> getDireccionCompleta(
			List<ListadoSolicitudResultado> listListadoSolicitudResultado) {

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
			StringBuffer numeroSolicitud = new StringBuffer();

			numeroSolicitud.append(listadoSolicitudResultado.getDecoor())
					.append("-").append(listadoSolicitudResultado.getDenror())
					.append("-").append(listadoSolicitudResultado.getDenran());

			listadoSolicitudResultado.setNumSolicitud(numeroSolicitud
					.toString());

			StringBuffer direccionCompleta = new StringBuffer();

			if (listadoSolicitudResultado.getEsnombreCalle() != null
					&& !listadoSolicitudResultado.getEsnombreCalle().equals("")) {
				direccionCompleta.append(listadoSolicitudResultado
						.getEsnombreCalle());

				if (listadoSolicitudResultado.getEsnombrePortal() != null
						&& !listadoSolicitudResultado.getEsnombrePortal()
								.equals("")) {
					direccionCompleta.append(", ").append(
							listadoSolicitudResultado.getEsnombrePortal());
				}
			} else if (listadoSolicitudResultado.getEsdireccion_nocapv() != null
					&& !listadoSolicitudResultado.getEsdireccion_nocapv()
							.equals("")) {
				direccionCompleta.append(listadoSolicitudResultado
						.getEsdireccion_nocapv());
			} else if (listadoSolicitudResultado.getEsnodir() != null
					&& !listadoSolicitudResultado.getEsnodir().equals("")) {
				direccionCompleta
						.append(listadoSolicitudResultado.getEsnodir());
			}

			listadoSolicitudResultado.setEsdireccionCompleta(direccionCompleta
					.toString());
		}

		return listListadoSolicitudResultado;
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesEstablecimientos(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.estadisticasListadosSolicitudesDao
				.findAllSolicitudListadoSolicitudesEstablecimientos(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);

		return getDireccionCompleta(listListadoSolicitudResultado);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesProductoServicios(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.estadisticasListadosSolicitudesDao
				.findAllSolicitudListadoSolicitudesProductoServicios(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);

		return getDireccionCompleta(listListadoSolicitudResultado);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesSinDecision(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.estadisticasListadosSolicitudesDao
				.findAllSolicitudListadoSolicitudesSinDecision(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
			StringBuffer numeroSolicitud = new StringBuffer();

			numeroSolicitud.append(listadoSolicitudResultado.getDecoor())
					.append("-").append(listadoSolicitudResultado.getDenror())
					.append("-").append(listadoSolicitudResultado.getDenran())
					.append("-").append(listadoSolicitudResultado.getHdnror());

			listadoSolicitudResultado.setNumSolicitud(numeroSolicitud
					.toString());

		}

		return listListadoSolicitudResultado;
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesConDecision(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.estadisticasListadosSolicitudesDao
				.findAllSolicitudListadoSolicitudesConDecision(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);

		return getDireccionCompleta(listListadoSolicitudResultado);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoEstadoExpedientesCurso(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.estadisticasListadosSolicitudesDao
				.findAllSolicitudListadoEstadoExpedientesCurso(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
			StringBuffer numeroSolicitud = new StringBuffer();

			numeroSolicitud.append(listadoSolicitudResultado.getDecoor())
					.append("-").append(listadoSolicitudResultado.getDenror())
					.append("-").append(listadoSolicitudResultado.getDenran())
					.append("-").append(listadoSolicitudResultado.getHdnror());

			listadoSolicitudResultado.setNumSolicitud(numeroSolicitud
					.toString());

			StringBuffer direccionCompleta = new StringBuffer();

			if (listadoSolicitudResultado.getEsnombreCalle() != null
					&& !listadoSolicitudResultado.getEsnombreCalle().equals("")) {
				direccionCompleta.append(listadoSolicitudResultado
						.getEsnombreCalle());

				if (listadoSolicitudResultado.getEsnombrePortal() != null
						&& !listadoSolicitudResultado.getEsnombrePortal()
								.equals("")) {
					direccionCompleta.append(", ").append(
							listadoSolicitudResultado.getEsnombrePortal());
				}
			} else if (listadoSolicitudResultado.getEsdireccion_nocapv() != null
					&& !listadoSolicitudResultado.getEsdireccion_nocapv()
							.equals("")) {
				direccionCompleta.append(listadoSolicitudResultado
						.getEsdireccion_nocapv());
			} else if (listadoSolicitudResultado.getEsnodir() != null
					&& !listadoSolicitudResultado.getEsnodir().equals("")) {
				direccionCompleta
						.append(listadoSolicitudResultado.getEsnodir());
			}

			listadoSolicitudResultado.setEsdireccionCompleta(direccionCompleta
					.toString());
		}

		return listListadoSolicitudResultado;
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoTiempoTramitacion(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.estadisticasListadosSolicitudesDao
				.findAllSolicitudListadoTiempoTramitacion(solicitudesBusqueda,
						pagination, startsWith, defedeDesde, defedeHasta,
						defereDesde, defereHasta, hcfedeDesde, hcfedeHasta);

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
			StringBuffer numeroSolicitud = new StringBuffer();

			numeroSolicitud.append(listadoSolicitudResultado.getDecoor())
					.append("-").append(listadoSolicitudResultado.getDenror())
					.append("-").append(listadoSolicitudResultado.getDenran())
					.append("-").append(listadoSolicitudResultado.getHdnror());

			listadoSolicitudResultado.setNumSolicitud(numeroSolicitud
					.toString());

		}

		return listListadoSolicitudResultado;
	}

	// /
	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesGeneral(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.estadisticasListadosSolicitudesDao
				.findAllSolicitudListadoSolicitudesGeneral(solicitudesBusqueda,
						pagination, startsWith, defedeDesde, defedeHasta,
						defereDesde, defereHasta, hcfedeDesde, hcfedeHasta);

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
			StringBuffer numeroSolicitud = new StringBuffer();

			numeroSolicitud.append(listadoSolicitudResultado.getDecoor())
					.append("-").append(listadoSolicitudResultado.getDenror())
					.append("-").append(listadoSolicitudResultado.getDenran())
					.append("-").append(listadoSolicitudResultado.getHdnror());

			listadoSolicitudResultado.setNumSolicitud(numeroSolicitud
					.toString());

		}

		return listListadoSolicitudResultado;
	}

	// /

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoRelacionTiempoRealizacionPrimerTramite(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		List<ListadoSolicitudResultado> listListadoSolicitudResultado = this.estadisticasListadosSolicitudesDao
				.findAllSolicitudListadoTiempoRealizacionPrimerTramite(
						solicitudesBusqueda, pagination, startsWith,
						defedeDesde, defedeHasta, defereDesde, defereHasta,
						hcfedeDesde, hcfedeHasta);

		for (ListadoSolicitudResultado listadoSolicitudResultado : listListadoSolicitudResultado) {
			StringBuffer numeroSolicitud = new StringBuffer();

			numeroSolicitud.append(listadoSolicitudResultado.getDecoor())
					.append("-").append(listadoSolicitudResultado.getDenror())
					.append("-").append(listadoSolicitudResultado.getDenran())
					.append("-").append(listadoSolicitudResultado.getHdnror());

			listadoSolicitudResultado.setNumSolicitud(numeroSolicitud
					.toString());

		}

		return listListadoSolicitudResultado;
	}

	/**
	 * Obtiene los documentos asociados a un trámite
	 * 
	 * @param tramite
	 * @param pagination
	 * @return
	 */
	public List<DocumentoHecho> findAllDocumentosByTramite(
			TramiteHecho tramite, Pagination pagination) {

		return this.documentoHechoDao.findAllDocumentosByTramite(
				new TramiteComun(tramite.getEhcodigo(), null, null), null);
	}

	/**
	 * Obtiene los documentos asociados a un trámite
	 * 
	 * @param tramite
	 * @param pagination
	 * @return
	 */
	public Long findAllCountDocumentosByTramite(TramiteComun tramite,
			Pagination pagination) {
		return this.documentoHechoDao.findAllDocumentosByTramiteCount(tramite);
	}
}
