package com.ejie.y41a.service;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.DecisionHechoDetalle;
import com.ejie.y41a.model.Denuncia;
import com.ejie.y41a.model.DocumentoHecho;
import com.ejie.y41a.model.DocumentoHechoDetalle;
import com.ejie.y41a.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41a.model.EstadisticasKontsumonetResultado;
import com.ejie.y41a.model.EstadisticasSolicitudesResultado;
import com.ejie.y41a.model.ListadoSolicitudResultado;
import com.ejie.y41a.model.PlantillaSolicitudDetalle;
import com.ejie.y41a.model.SolicitudArbitrajeDetalle;
import com.ejie.y41a.model.SolicitudBusqueda;
import com.ejie.y41a.model.SolicitudDetalle;
import com.ejie.y41a.model.TramiteComun;
import com.ejie.y41a.model.TramiteHecho;
import com.ejie.y41a.model.TramiteHechoDetalle;
import com.ejie.y41a.model.TramiteHechoDetalleMail;

/**
 * * DenunciaService generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

public interface DenunciaService {

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia add(Denuncia denuncia);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle addSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle addNuevoHecho(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia update(Denuncia denuncia);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle updateSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia find(Denuncia denuncia);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle findSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return PlantillaSolicitudDetalle
	 */
	PlantillaSolicitudDetalle findPlantillaSolicitudDetalle(
			SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Denuncia> findAll(Denuncia denuncia, Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Long
	 */
	Long findAllCount(Denuncia denuncia);

	/**
	 * Finds rows in the Denuncia table using like.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Denuncia> findAllLike(Denuncia denuncia, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<SolicitudBusqueda> findAllLikeSolicitudes(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return Long
	 */
	Long findAllLikeSolicitudesCount(SolicitudBusqueda solicitudesBusqueda,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Busca los datos de los trámites asociados al hecho y los documentos de
	 * cada trámite. Si El trámite tiene un único documento se obtiene el
	 * documento para su descarga y si tiene mas de uno se marca como trámite
	 * multidocumento para abrir una ventana modal.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TramiteHechoDetalle> findAllTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle, Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	Long findAllTramiteHechoCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	TramiteHechoDetalle addTramiteHecho(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Update a single row in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	TramiteHechoDetalle updateTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalleMail
	 *            TramiteHechoDetalleMail
	 * @return TramiteHechoDetalleMail
	 */
	public TramiteHechoDetalleMail enviarMail(
			TramiteHechoDetalleMail tramiteHechoDetalleMail);

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return
	 */
	void removeTramiteHecho(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteHechoDetalle findTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle) throws SQLException,
			IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param decisionHechoDetalle
	 *            DecisionHechoDetalle
	 * @return DecisionHechoDetalle
	 */
	DecisionHechoDetalle findDecisionHecho(
			DecisionHechoDetalle decisionHechoDetalle);

	/**
	 * Updates a single row in the Decision Hecho table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	DecisionHechoDetalle updateDecisionHecho(
			DecisionHechoDetalle decisionHechoDetalle);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoHechoDetalle> findAllDocumentoHecho(
			DocumentoHechoDetalle documentoHechoDetalle, Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return Long
	 */
	Long findAllDocumentoHechoCount(DocumentoHechoDetalle documentoHechoDetalle);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 */
	DocumentoHechoDetalle addDocumentoHecho(
			DocumentoHechoDetalle documentoHechoDetalle);

	/**
	 * Deletes a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return
	 */
	void removeDocumentoHecho(DocumentoHechoDetalle documentoHechoDetalle);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 */
	DocumentoHechoDetalle findDocumentoHecho(
			DocumentoHechoDetalle documentoHechoDetalle);

	/**
	 * Finds a single row in the SolicitudArbitraje table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 */
	SolicitudArbitrajeDetalle findSolicitudArbitraje(
			SolicitudArbitrajeDetalle solicitudArbitrajeDetalle);

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return
	 */
	void remove(Denuncia denuncia);

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	void removeSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Deletes multiple rows in the Denuncia table.
	 * 
	 * @param denunciaList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Denuncia> denunciaList);

	/**
	 * Finds rows in the Hecho Denunciado table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstadisticasKontsumonetResultado> findAllSolicitudEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisionMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSectoresMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaMotivos(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisiones(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaFormaPresentacionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * 0132627 Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaFormaVentaMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSectoresMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSexoEdad(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaPromedioTiempoResolverSolicitud(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaProductoServicioMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaProductoServicioMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesProductoServicioMotivo(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesEstablecimientos(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesProductoServicios(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesSinDecision(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesConDecision(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoEstadoExpedientesCurso(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoTiempoTramitacion(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesGeneral(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoRelacionTiempoRealizacionPrimerTramite(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Obtiene los documentos asociados a un trámite
	 * 
	 * @param tramite
	 * @param pagination
	 * @return
	 */
	public List<DocumentoHecho> findAllDocumentosByTramite(
			TramiteHecho tramite, Pagination pagination);

	/**
	 * Obtiene los documentos asociados a un trámite
	 * 
	 * @param tramite
	 * @param pagination
	 * @return
	 */
	public Long findAllCountDocumentosByTramite(TramiteComun tramite,
			Pagination pagination);
}
