package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.DenunciaRecibDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.DenunciaRecib;

/**
 *  * DenunciaRecibServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "denunciaRecibService")
public  class DenunciaRecibServiceImpl implements DenunciaRecibService {

	private static final  Logger logger = LoggerFactory.getLogger(DenunciaRecibServiceImpl.class);
	@Autowired
	private DenunciaRecibDao denunciaRecibDao;

	/**
	 * Inserts a single row in the DenunciaRecib table.
	 *
	 * @param denunciaRecib DenunciaRecib
	 * @return DenunciaRecib
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DenunciaRecib add(DenunciaRecib denunciaRecib) {
		return this.denunciaRecibDao.add(denunciaRecib);
	}

	/**
	 * Updates a single row in the DenunciaRecib table.
	 *
	 * @param denunciaRecib DenunciaRecib
	 * @return DenunciaRecib
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DenunciaRecib update(DenunciaRecib denunciaRecib) {
		return this.denunciaRecibDao.update(denunciaRecib);
	 }

	/**
	 * Finds a single row in the DenunciaRecib table.
	 *
	 * @param denunciaRecib DenunciaRecib
	 * @return DenunciaRecib
	 */
	public DenunciaRecib find(DenunciaRecib denunciaRecib) {
		return (DenunciaRecib) this.denunciaRecibDao.find(denunciaRecib);
	}

	/**
	 * Finds a List of rows in the DenunciaRecib table.
	 *
	 * @param denunciaRecib DenunciaRecib
	 * @param pagination Pagination
	 * @return List
	 */
	public List<DenunciaRecib> findAll(DenunciaRecib denunciaRecib, Pagination pagination) {
		return (List<DenunciaRecib>) this.denunciaRecibDao.findAll(denunciaRecib, pagination);
	}
    
	/**
	 * Counts rows in the DenunciaRecib table.
	 *
	 * @param denunciaRecib DenunciaRecib
	 * @return Long
	 */
	public Long findAllCount(DenunciaRecib denunciaRecib) {        
		return  this.denunciaRecibDao.findAllCount(denunciaRecib);
	}

	/**
	 * Finds rows in the DenunciaRecib table using like.
	 *
	 * @param denunciaRecib DenunciaRecib
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<DenunciaRecib> findAllLike(DenunciaRecib denunciaRecib, Pagination pagination, Boolean startsWith) {
		return (List<DenunciaRecib>) this.denunciaRecibDao.findAllLike(denunciaRecib, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the DenunciaRecib table.
	 *
	 * @param denunciaRecib DenunciaRecib
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DenunciaRecib denunciaRecib) {
		this.denunciaRecibDao.remove(denunciaRecib);
	}
	
	/**
	 * Deletes multiple rows in the DenunciaRecib table.
	 *
	 * @param denunciaRecibList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<DenunciaRecib> denunciaRecibList) {
		for (DenunciaRecib  denunciaRecibAux:denunciaRecibList) {
			this.denunciaRecibDao.remove(denunciaRecibAux);
		}
	}


	/**
	 * Getter method for DenunciaRecibDao
	 *
	 * @return DenunciaRecibDao
	 */
	public DenunciaRecibDao getDenunciaRecibDao() {
		return this.denunciaRecibDao;
	}
    
	/**
	 * Setter method for DenunciaRecibDao.
	 *
	 * @param  denunciaRecibDao DenunciaRecibDao
	 * @return
	 */
	public void setDenunciaRecibDao(DenunciaRecibDao denunciaRecibDao) {
		logger.info("Setting Dependency "+denunciaRecibDao);
		this.denunciaRecibDao = denunciaRecibDao;
	}
}

