package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.DecisionDao;
import com.ejie.y41a.dao.PlantillaDecisionDao;
import com.ejie.y41a.model.Decision;
import com.ejie.y41a.model.PlantillaDecision;
import com.ejie.y41a.utils.Y41aUIDGenerator;

/**
 * * DecisionServiceImpl generated by UDA, 05-mar-2012 9:11:43.
 * 
 *  
 */

@Service(value = "decisionService")
public class DecisionServiceImpl implements DecisionService {

	private static final Logger logger = LoggerFactory
			.getLogger(DecisionServiceImpl.class);
	@Autowired
	private DecisionDao decisionDao;
	@Autowired
	private PlantillaDecisionDao plantillaDecisionDao;

	// @Autowired
	// private DecisionHechoService decisionHechoService;

	/**
	 * Inserts a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision add(Decision decision) {
		return this.decisionDao.add(decision);
	}

	/**
	 * Inserts a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision addDecision(Decision decision) {
		decision.setDecodigo(this.decisionDao.getNewPK().toString());
		this.decisionDao.add(decision);

		// buscar los diferentes codigos de organismo que tienen plantillas
		List<PlantillaDecision> listPlantillaDecision = this.plantillaDecisionDao
				.findAllOrganismos();

		for (PlantillaDecision plantDecision : listPlantillaDecision) {

			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcoor(plantDecision.getPdcoor());
			plantillaDecision.setDecision(decision);
			plantillaDecision.setPdcodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));

			// por cada organismo insertar una plantilla vacia.
			this.plantillaDecisionDao.add(plantillaDecision);
		}

		if (listPlantillaDecision.size() == 0) {
			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcoor(Y41aConstantes.CODIGO_ORGANISMO_LAKUA);
			plantillaDecision.setDecision(decision);
			plantillaDecision.setPdcodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));

			// por cada organismo insertar una plantilla vacia.
			this.plantillaDecisionDao.add(plantillaDecision);
		}

		return decision;
	}

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision update(Decision decision) {
		return this.decisionDao.update(decision);
	}

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision updateFecha(Decision decision) {
		// Decision decisionConsulta = new Decision();
		// decisionConsulta.setDecodigo(decision.getDecodigo());
		// long contador = 0;
		// DecisionHecho decisionHecho = new DecisionHecho();
		// decisionHecho.setDecision(decisionConsulta);
		// contador = this.decisionHechoService.findAllCount(decisionHecho);
		// if (contador > 0) {
		// throw new Y41aUDAException("error.validacion.decisionAsociado",
		// true, new Exception());
		// } else {
		return this.decisionDao.updateFecha(decision);
		// }
	}

	/**
	 * Finds a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	public Decision find(Decision decision) {
		return (Decision) this.decisionDao.find(decision);
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAll(Decision decision, Pagination pagination) {
		return (List<Decision>) this.decisionDao.findAll(decision, pagination);
	}

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Long
	 */
	public Long findAllCount(Decision decision) {
		return this.decisionDao.findAllCount(decision);
	}

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Decision> findAllLike(Decision decision, Pagination pagination,
			Boolean startsWith) {
		return (List<Decision>) this.decisionDao.findAllLike(decision,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Decision decision) {
		this.decisionDao.remove(decision);
	}

	/**
	 * Deletes multiple rows in the Decision table.
	 * 
	 * @param decisionList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Decision> decisionList) {
		for (Decision decisionAux : decisionList) {
			this.decisionDao.remove(decisionAux);
		}
	}

	/**
	 * Getter method for DecisionDao
	 * 
	 * @return DecisionDao
	 */
	public DecisionDao getDecisionDao() {
		return this.decisionDao;
	}

	/**
	 * Setter method for DecisionDao.
	 * 
	 * @param decisionDao
	 *            DecisionDao
	 * @return
	 */
	public void setDecisionDao(DecisionDao decisionDao) {
		logger.info("Setting Dependency " + decisionDao);
		this.decisionDao = decisionDao;
	}
}
