package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.DecisionHechoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.DecisionHecho;

/**
 *  * DecisionHechoServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 *  
 */

@Service(value = "decisionHechoService")
public  class DecisionHechoServiceImpl implements DecisionHechoService {

	private static final  Logger logger = LoggerFactory.getLogger(DecisionHechoServiceImpl.class);
	@Autowired
	private DecisionHechoDao decisionHechoDao;

	/**
	 * Inserts a single row in the DecisionHecho table.
	 *
	 * @param decisionHecho DecisionHecho
	 * @return DecisionHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DecisionHecho add(DecisionHecho decisionHecho) {
		return this.decisionHechoDao.add(decisionHecho);
	}

	/**
	 * Updates a single row in the DecisionHecho table.
	 *
	 * @param decisionHecho DecisionHecho
	 * @return DecisionHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DecisionHecho update(DecisionHecho decisionHecho) {
		return this.decisionHechoDao.update(decisionHecho);
	 }

	/**
	 * Finds a single row in the DecisionHecho table.
	 *
	 * @param decisionHecho DecisionHecho
	 * @return DecisionHecho
	 */
	public DecisionHecho find(DecisionHecho decisionHecho) {
		return (DecisionHecho) this.decisionHechoDao.find(decisionHecho);
	}

	/**
	 * Finds a List of rows in the DecisionHecho table.
	 *
	 * @param decisionHecho DecisionHecho
	 * @param pagination Pagination
	 * @return List
	 */
	public List<DecisionHecho> findAll(DecisionHecho decisionHecho, Pagination pagination) {
		return (List<DecisionHecho>) this.decisionHechoDao.findAll(decisionHecho, pagination);
	}
    
	/**
	 * Counts rows in the DecisionHecho table.
	 *
	 * @param decisionHecho DecisionHecho
	 * @return Long
	 */
	public Long findAllCount(DecisionHecho decisionHecho) {        
		return  this.decisionHechoDao.findAllCount(decisionHecho);
	}

	/**
	 * Finds rows in the DecisionHecho table using like.
	 *
	 * @param decisionHecho DecisionHecho
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<DecisionHecho> findAllLike(DecisionHecho decisionHecho, Pagination pagination, Boolean startsWith) {
		return (List<DecisionHecho>) this.decisionHechoDao.findAllLike(decisionHecho, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the DecisionHecho table.
	 *
	 * @param decisionHecho DecisionHecho
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DecisionHecho decisionHecho) {
		this.decisionHechoDao.remove(decisionHecho);
	}
	
	/**
	 * Deletes multiple rows in the DecisionHecho table.
	 *
	 * @param decisionHechoList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<DecisionHecho> decisionHechoList) {
		for (DecisionHecho  decisionHechoAux:decisionHechoList) {
			this.decisionHechoDao.remove(decisionHechoAux);
		}
	}


	/**
	 * Getter method for DecisionHechoDao
	 *
	 * @return DecisionHechoDao
	 */
	public DecisionHechoDao getDecisionHechoDao() {
		return this.decisionHechoDao;
	}
    
	/**
	 * Setter method for DecisionHechoDao.
	 *
	 * @param  decisionHechoDao DecisionHechoDao
	 * @return
	 */
	public void setDecisionHechoDao(DecisionHechoDao decisionHechoDao) {
		logger.info("Setting Dependency "+decisionHechoDao);
		this.decisionHechoDao = decisionHechoDao;
	}
}

