package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ConsumidorDao;
import com.ejie.y41a.dao.HechoDenunciadoDao;
import com.ejie.y41a.model.Consumidor;
import com.ejie.y41a.model.ConsumidorDetalle;
import com.ejie.y41a.model.ConsumidorReclamaciones;
import com.ejie.y41a.model.Denuncia;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * ConsumidorServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

@Service(value = "consumidorService")
public class ConsumidorServiceImpl implements ConsumidorService {

	private static final Logger logger = LoggerFactory
			.getLogger(ConsumidorServiceImpl.class);
	@Autowired
	private ConsumidorDao consumidorDao;
	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;

	/**
	 * Inserts a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Consumidor add(Consumidor consumidor) {
		return this.consumidorDao.add(consumidor);
	}

	/**
	 * Inserts a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Consumidor addConsumidor(Consumidor consumidor) {
		Consumidor consumidorAux = new Consumidor();
		consumidorAux.setDtnif(consumidor.getDtnif());

		List<Consumidor> listConsumidor = this.consumidorDao
				.findAllLikeConsumidor(consumidorAux, null, false);

		if (listConsumidor.size() > 0) {
			throw new Y41aUDAException("error.consumidores.NifDuplicado", true,
					new Exception());
		} else {
			consumidor.setDtcodigo(Y41aUIDGenerator.getInstance().generateId(
					Y41aConstantes.PK_SIZE));
			return this.consumidorDao.add(consumidor);
		}
	}

	/**
	 * Updates a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Consumidor update(Consumidor consumidor) {
		return this.consumidorDao.update(consumidor);
	}

	/**
	 * Updates a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Consumidor updateConsumidor(Consumidor consumidor) {
		return this.consumidorDao.update(consumidor);
	}

	/**
	 * Finds a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	public Consumidor find(Consumidor consumidor) {
		return this.consumidorDao.find(consumidor);
	}

	/**
	 * Finds a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	public ConsumidorDetalle findConsumidor(Consumidor consumidor) {
		Consumidor consu = (Consumidor) this.consumidorDao.find(consumidor);

		ConsumidorDetalle consumidorDetalle = new ConsumidorDetalle(
				consu.getDtcodigo(), consu.getCensoMonitor().getMocodigo(),
				consu.getCensoMonitor().getMonombre(), consu.getCensoMonitor()
						.getMousu(), consu.getRangoEdad().getRancod(), consu
						.getRangoEdad().getRandesc(), consu.getDtnombre(),
				consu.getDtapellido1(), consu.getDtapellido2(),
				consu.getDtnif(), consu.getDtnodir(), consu.getDtcolo(),
				consu.getDtnrcopo(), consu.getDtnrtel(), consu.getDtnrfax(),
				consu.getDtcopa(), consu.getDtnrdimu(), consu.getDttecoem(),
				consu.getDtnrtel2(), consu.getDtnrtel3(), consu.getDtcoidco(),
				consu.getDtinreco(), consu.getDtcoorac(), consu.getDtnoap1(),
				consu.getDtnoap2(), consu.getDtnrsoci(), consu.getDtnran(),
				consu.getDtcosx(), consu.getDtnorep(), consu.getDtnifrep(),
				consu.getDtfemod(), consu.getDtnolo(), consu.getDtcopv(),
				consu.getDtinrl(), consu.getDtnodirr(), consu.getDtcolor(),
				consu.getDtnrcopor(), consu.getDtcopvr(), consu.getDtnrtelr(),
				consu.getDtnrtel2r(), consu.getDtnrfaxr(), consu.getDtteemr(),
				consu.getDtintipid(), consu.getDtnoraPaisId(),
				consu.getDtnoraPaisNombre(), consu.getDtnoraProvinciaId(),
				consu.getDtnombreProvincia(), consu.getDtnoraMunicipioId(),
				consu.getDtnombreMunicipio(), consu.getDtnoraLocalidadId(),
				consu.getDtnombreLocalidad(), consu.getDtnoraCalleId(),
				consu.getDtnombreCalle(), consu.getDtnoraCpId(),
				consu.getDtnombreCp(), consu.getDtnoraPortalId(),
				consu.getDtnombrePortal(), consu.getDtnombrePiso(),
				consu.getDtdireccion_nocapv(), consu.getDtdireccionCompleta(),
				consu.getDtexpedientesAbiertos(), null, null,
				consu.getDtextranjero());

		HechoDenunciado hechodenunciado = new HechoDenunciado();
		Denuncia denunciaAux = new Denuncia();
		Consumidor consumidorAux = new Consumidor();
		consumidorAux.setDtcodigo(consumidor.getDtcodigo());
		denunciaAux.setConsumidor(consumidorAux);
		hechodenunciado.setDenuncia(denunciaAux);

		Long numExpedientesAbiertos = this.hechoDenunciadoDao
				.findAllExpedientesAbiertosCount(hechodenunciado);

		if (numExpedientesAbiertos > 0) {
			consumidorDetalle.setDtexpedientesAbiertos(Y41aConstantes.VALOR_SI);
		} else {
			consumidorDetalle.setDtexpedientesAbiertos(Y41aConstantes.VALOR_NO);
		}

		Long numReclamaciones = this.hechoDenunciadoDao
				.findAllCount(hechodenunciado);

		consumidorDetalle.setDtnumReclamaciones(numReclamaciones.toString());

		StringBuffer direccionAntiguaCompleta = new StringBuffer();

		String dtcopv = (consu.getDtcopv() == null) ? "" : consu.getDtcopv();
		String dtnolo = (consu.getDtnolo() == null) ? "" : consu.getDtnolo();
		String dtnodir = (consu.getDtnodir() == null) ? "" : consu.getDtnodir();
		String dtnrcopor = (consu.getDtnrcopor() == null) ? "" : consu
				.getDtnrcopor();

		direccionAntiguaCompleta.append(dtcopv).append(" ").append(dtnolo)
				.append(" ").append(dtnodir).append(" ").append(dtnrcopor);

		consumidorDetalle.setDireccionAntiguaCompleta(direccionAntiguaCompleta
				.toString());

		return consumidorDetalle;
	}

	/**
	 * Finds a List of rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Consumidor> findAll(Consumidor consumidor, Pagination pagination) {
		return (List<Consumidor>) this.consumidorDao.findAll(consumidor,
				pagination);
	}

	/**
	 * Counts rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Long
	 */
	public Long findAllCount(Consumidor consumidor) {
		return this.consumidorDao.findAllCount(consumidor);
	}

	/**
	 * Finds rows in the Consumidor table using like.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Consumidor> findAllLike(Consumidor consumidor,
			Pagination pagination, Boolean startsWith) {
		return (List<Consumidor>) this.consumidorDao.findAllLike(consumidor,
				pagination, startsWith);
	}

	/**
	 * Finds rows in the Consumidor table using like.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Consumidor> findAllLikeConsumidor(Consumidor consumidor,
			Pagination pagination, Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("dtdireccionCompleta")) {
				pagination.setSort("DTNOMBRE_CALLE, DTNOMBRE_PORTAL");
			}
		}

		List<Consumidor> listConsumidor = this.consumidorDao
				.findAllLikeConsumidor(consumidor, pagination, startsWith);

		for (Consumidor consum : listConsumidor) {
			StringBuffer direccionCompleta = new StringBuffer();

			if (consum.getDtnombreCalle() != null
					&& !consum.getDtnombreCalle().equals("")) {
				direccionCompleta.append(consum.getDtnombreCalle());

				if (consum.getDtnombrePortal() != null
						&& !consum.getDtnombrePortal().equals("")) {
					direccionCompleta.append(", ").append(
							consum.getDtnombrePortal());
				}
			} else if (consum.getDtdireccion_nocapv() != null
					&& !consum.getDtdireccion_nocapv().equals("")) {
				direccionCompleta.append(consum.getDtdireccion_nocapv());
			} else if (consum.getDtnodir() != null
					&& !consum.getDtnodir().equals("")) {
				direccionCompleta.append(consum.getDtnodir());
			}

			consum.setDtdireccionCompleta(direccionCompleta.toString());

			// Aadir si se tiene direccin completa o no
			if (consum.getDtextranjero() == "S") {
				if (consum.getDtnoraPaisNombre() != null
						&& consum.getDtnoraPaisNombre() != ""
						&& consum.getDtdireccion_nocapv() != null
						&& consum.getDtdireccion_nocapv() != "") {
					consum.setDtdirCompleta(true);
				} else {
					consum.setDtdirCompleta(false);
				}
			} else {// si no es extranjero
					// si es de capv
				if (consum.getDtnombreProvincia() != null
						&& consum.getDtnombreProvincia() != ""
						&& consum.getDtnombreMunicipio() != null
						&& consum.getDtnombreMunicipio() != ""
						&& consum.getDtnombreCalle() != null
						&& consum.getDtnombreCalle() != "") {
					// && data.dtnombrePortal!=null && data.dtnombrePortal!=''
					consum.setDtdirCompleta(true);
					// si NO es de capv
				} else if (consum.getDtdireccion_nocapv() != null
						&& consum.getDtdireccion_nocapv() != "") {
					consum.setDtdirCompleta(true);
				} else {
					consum.setDtdirCompleta(false);
				}
			}

		}

		return listConsumidor;
	}

	/**
	 * Counts rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeConsumidorCount(Consumidor consumidor,
			Boolean startsWith) {
		return this.consumidorDao.findAllLikeConsumidorCount(consumidor,
				startsWith);
	}

	/**
	 * Deletes a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Consumidor consumidor) {
		this.consumidorDao.remove(consumidor);
	}

	/**
	 * Deletes a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeConsumidor(Consumidor consumidor) {

		try {
			this.consumidorDao.remove(consumidor);
		} catch (DataIntegrityViolationException e) {
			throw new Y41aUDAException(
					"error.consumidor.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Deletes multiple rows in the Consumidor table.
	 * 
	 * @param consumidorList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Consumidor> consumidorList) {
		for (Consumidor consumidorAux : consumidorList) {
			this.consumidorDao.remove(consumidorAux);
		}
	}

	/**
	 * Getter method for ConsumidorDao
	 * 
	 * @return ConsumidorDao
	 */
	public ConsumidorDao getConsumidorDao() {
		return this.consumidorDao;
	}

	/**
	 * Setter method for ConsumidorDao.
	 * 
	 * @param consumidorDao
	 *            ConsumidorDao
	 * @return
	 */
	public void setConsumidorDao(ConsumidorDao consumidorDao) {
		logger.info("Setting Dependency " + consumidorDao);
		this.consumidorDao = consumidorDao;
	}

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por año.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ConsumidorReclamaciones> findAllConsumidorReclamaciones(
			Consumidor consumidor, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numeroConsulta")) {
				pagination.setSort("decoor, denror, denran, hdnror ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("numeroConsulta")) {
				pagination
						.setSort("decoor DESC, denror DESC, denran DESC, hdnror ");
			}
		}

		HechoDenunciado hechodenunciado = new HechoDenunciado();
		Denuncia denunciaAux = new Denuncia();
		Consumidor consumidorAux = new Consumidor();
		consumidorAux.setDtcodigo(consumidor.getDtcodigo());
		denunciaAux.setConsumidor(consumidorAux);
		hechodenunciado.setDenuncia(denunciaAux);

		List<ConsumidorReclamaciones> listConsumidorReclamaciones = this.hechoDenunciadoDao
				.findAllConsumidorReclamaciones(hechodenunciado, pagination);

		for (ConsumidorReclamaciones consumReclam : listConsumidorReclamaciones) {

			StringBuffer numeroConsulta = new StringBuffer();

			numeroConsulta.append(consumReclam.getDecoor()).append("-")
					.append(consumReclam.getDenror()).append("-")
					.append(consumReclam.getDenran()).append("-")
					.append(consumReclam.getHdnror());

			consumReclam.setNumeroConsulta(numeroConsulta.toString());
		}

		return listConsumidorReclamaciones;
	}

	/**
	 * Counts rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Long
	 */
	public Long findAllConsumidorReclamacionesCount(Consumidor consumidor) {
		HechoDenunciado hechodenunciado = new HechoDenunciado();
		Denuncia denunciaAux = new Denuncia();
		Consumidor consumidorAux = new Consumidor();
		consumidorAux.setDtcodigo(consumidor.getDtcodigo());
		denunciaAux.setConsumidor(consumidorAux);
		hechodenunciado.setDenuncia(denunciaAux);
		return this.hechoDenunciadoDao
				.findAllConsumidorReclamacionesCount(hechodenunciado);
	}
}
