package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ComunicacionDao;
import com.ejie.y41a.dao.ComunicacionFileDao;
import com.ejie.y41a.dao.DestComunicacionDao;
import com.ejie.y41a.dao.EstadisticasListadosKontsumonetDao;
import com.ejie.y41a.model.Comunicacion;
import com.ejie.y41a.model.ComunicacionBusqueda;
import com.ejie.y41a.model.ComunicacionDetalle;
import com.ejie.y41a.model.ComunicacionFile;
import com.ejie.y41a.model.DestComunicacion;
import com.ejie.y41a.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41a.model.EstadisticasKontsumonetResultado;

/**
 * * ComunicacionServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

@Service(value = "comunicacionService")
public class ComunicacionServiceImpl implements ComunicacionService {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunicacionServiceImpl.class);
	@Autowired
	private ComunicacionDao comunicacionDao;

	@Autowired
	private ComunicacionFileDao comunicacionFileDao;

	@Autowired
	private DestComunicacionDao destComunicacionDao;

	@Autowired
	private EstadisticasListadosKontsumonetDao estadisticasListadosKontsumonetDao;

	/**
	 * Inserts a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Comunicacion add(Comunicacion comunicacion) {
		return this.comunicacionDao.add(comunicacion);
	}

	/**
	 * Inserts a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Comunicacion addComunicacion(Comunicacion comunicacion) {
		comunicacion.setM4cocomu(this.comunicacionDao.getNewPK());
		this.comunicacionDao.add(comunicacion);

		List<DestComunicacion> listDestComunicacion = comunicacion
				.getDestComunicacions();

		for (DestComunicacion dest : listDestComunicacion) {
			dest.setComunicacion(comunicacion);
			// insertar destinatarios
			this.destComunicacionDao.add(dest);
		}

		// insertar documentos
		/*
		 * List<ComunicacionFile> listComunicacionFile = comunicacion
		 * .getComunicacionFiles();
		 * 
		 * for (ComunicacionFile comFile : listComunicacionFile) {
		 * comFile.setComunicacion(comunicacion);
		 * comFile.setM3cofile(this.comunicacionFileDao.getNewPK());
		 * this.comunicacionFileDao.add(comFile); }
		 */
		return comunicacion;
	}

	/**
	 * Updates a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Comunicacion update(Comunicacion comunicacion) {
		return this.comunicacionDao.update(comunicacion);
	}

	/**
	 * Finds a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	public Comunicacion find(Comunicacion comunicacion) {
		return (Comunicacion) this.comunicacionDao.find(comunicacion);
	}

	/**
	 * Finds a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return ComunicacionDetalle
	 */
	public ComunicacionDetalle findComunicacion(Comunicacion comunicacion) {
		Comunicacion com = (Comunicacion) this.comunicacionDao
				.find(comunicacion);

		ComunicacionDetalle comunicacionDetalle = new ComunicacionDetalle();
		comunicacionDetalle.setM4cocomu(com.getM4cocomu());
		comunicacionDetalle.setM4feenv(com.getM4feenv());
		comunicacionDetalle
				.setM6codigo(com.getTipoComunicacion().getM6codigo());
		comunicacionDetalle
				.setM6tetipo(com.getTipoComunicacion().getM6tetipo());
		comunicacionDetalle
				.setM6notipo(com.getTipoComunicacion().getM6notipo());
		comunicacionDetalle.setM6notipoe(com.getTipoComunicacion()
				.getM6notipoe());
		comunicacionDetalle.setM4noremi(com.getM4noremi());
		comunicacionDetalle.setM4tesubject(com.getM4tesubject());
		comunicacionDetalle.setM4tecomu(com.getM4tecomu());

		return comunicacionDetalle;

	}

	/**
	 * Finds a List of rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Comunicacion> findAll(Comunicacion comunicacion,
			Pagination pagination) {
		return (List<Comunicacion>) this.comunicacionDao.findAll(comunicacion,
				pagination);
	}

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Long
	 */
	public Long findAllCount(Comunicacion comunicacion) {
		return this.comunicacionDao.findAllCount(comunicacion);
	}

	/**
	 * Finds rows in the Comunicacion table using like.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Comunicacion> findAllLike(Comunicacion comunicacion,
			Pagination pagination, Boolean startsWith) {
		return (List<Comunicacion>) this.comunicacionDao.findAllLike(
				comunicacion, pagination, startsWith);
	}

	/**
	 * Finds rows in the Comunicacion table using like.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return List
	 */
	public List<ComunicacionBusqueda> findAllLikeComunicacionEnvio(
			Comunicacion comunicacion, Pagination pagination,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta) {

		List<ComunicacionBusqueda> listComunicacionBusqueda = new ArrayList<ComunicacionBusqueda>();

		List<Comunicacion> listComunicacion = this.comunicacionDao
				.findAllLikeComunicacionEnvio(comunicacion, pagination,
						startsWith, codOrgDestino, fechaEnvioDesde,
						fechaEnvioHasta);

		for (Comunicacion com : listComunicacion) {
			ComunicacionFile comunicacionFile = new ComunicacionFile();
			Comunicacion comunicacionAux = new Comunicacion();
			comunicacionAux.setM4cocomu(com.getM4cocomu());
			comunicacionFile.setComunicacion(comunicacionAux);

			Long numFicheros = this.comunicacionFileDao
					.findAllCount(comunicacionFile);

			// Indicador de ficheros adjuntos
			StringBuffer indAdjuntos = new StringBuffer();
			if (numFicheros > 0) {
				indAdjuntos.append(Y41aConstantes.VALOR_SI);
			} else {
				indAdjuntos.append(Y41aConstantes.VALOR_NO);
			}

			DestComunicacion destComunicacion = new DestComunicacion();
			destComunicacion.setComunicacion(comunicacionAux);
			List<DestComunicacion> listDestComunicacion = this.destComunicacionDao
					.findAll(destComunicacion, null);
			StringBuffer destinatarios = new StringBuffer();
			StringBuffer destinatariose = new StringBuffer();

			// numero de destinatarios totales
			Long numDestinatarios = new Long(listDestComunicacion.size());

			for (DestComunicacion dest : listDestComunicacion) {
				destinatarios.append(dest.getOrganismo().getNombreEs()).append(
						";");
				destinatariose.append(dest.getOrganismo().getNombreEu())
						.append(";");
			}
			String destinatarios_ = destinatarios.toString();
			String destinatariose_ = destinatariose.toString();

			// Quita e punto y coma del final
			if (destinatarios_.length() > 0) {
				destinatarios_ = destinatarios_.substring(0,
						destinatarios_.length() - 1);
			}

			if (destinatariose_.length() > 0) {
				destinatariose_ = destinatariose_.substring(0,
						destinatariose_.length() - 1);
			}

			/*
			 * if (destinatarios_.length() > Y41aConstantes.NUM_16) {
			 * destinatarios_ = destinatarios_.substring(0,
			 * Y41aConstantes.NUM_16) + "..."; }
			 */

			/*
			 * if (destinatariose_.length() > Y41aConstantes.NUM_16) {
			 * destinatariose_ = destinatariose_.substring(0,
			 * Y41aConstantes.NUM_16) + "..."; }
			 */

			// numero de destinatarios que han leido la comunicacion
			Long numDestinatariosLeidos = this.destComunicacionDao
					.findAllLeidoCount(destComunicacion);

			StringBuffer leidos = new StringBuffer();
			leidos.append(numDestinatariosLeidos).append("/")
					.append(numDestinatarios);

			listComunicacionBusqueda.add(new ComunicacionBusqueda(com
					.getM4cocomu(), com.getM4feenv(), com.getM4noremi(), com
					.getOrganismo().getCodOrg(), com.getOrganismo()
					.getNombreEs(), com.getOrganismo().getNombreEu(), com
					.getM4tesubject(), com.getTipoComunicacion().getM6codigo(),
					com.getTipoComunicacion().getM6notipo(), com
							.getTipoComunicacion().getM6tetipo(), com
							.getTipoComunicacion().getM6notipoe(),
					destinatarios_, destinatariose_, leidos.toString(),
					indAdjuntos.toString()));

		}

		return listComunicacionBusqueda;
	}

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return Long
	 */
	public Long findAllLikeComunicacionEnvioCount(Comunicacion comunicacion,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta) {
		return this.comunicacionDao.findAllLikeComunicacionEnvioCount(
				comunicacion, startsWith, codOrgDestino, fechaEnvioDesde,
				fechaEnvioHasta);
	}

	/**
	 * Finds rows in the Comunicacion table using like.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return List
	 */
	public List<ComunicacionBusqueda> findAllLikeComunicacionRecepcion(
			Comunicacion comunicacion, Pagination pagination,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta) {

		List<ComunicacionBusqueda> listComunicacionBusqueda = new ArrayList<ComunicacionBusqueda>();

		List<Comunicacion> listComunicacion = this.comunicacionDao
				.findAllLikeComunicacionRecepcion(comunicacion, pagination,
						startsWith, codOrgDestino, fechaEnvioDesde,
						fechaEnvioHasta);

		for (Comunicacion com : listComunicacion) {
			ComunicacionFile comunicacionFile = new ComunicacionFile();
			Comunicacion comunicacionAux = new Comunicacion();
			comunicacionAux.setM4cocomu(com.getM4cocomu());
			comunicacionFile.setComunicacion(comunicacionAux);

			Long numFicheros = this.comunicacionFileDao
					.findAllCount(comunicacionFile);

			// Indicador de ficheros adjuntos
			StringBuffer indAdjuntos = new StringBuffer();
			if (numFicheros > 0) {
				indAdjuntos.append(Y41aConstantes.VALOR_SI);
			} else {
				indAdjuntos.append(Y41aConstantes.VALOR_NO);
			}

			listComunicacionBusqueda.add(new ComunicacionBusqueda(com
					.getM4cocomu(), com.getM4feenv(), com.getM4noremi(), com
					.getOrganismo().getCodOrg(), com.getOrganismo()
					.getNombreEs(), com.getOrganismo().getNombreEu(), com
					.getM4tesubject(), com.getTipoComunicacion().getM6codigo(),
					com.getTipoComunicacion().getM6notipo(), com
							.getTipoComunicacion().getM6tetipo(), com
							.getTipoComunicacion().getM6notipoe(), null, null,
					null, indAdjuntos.toString()));
		}

		return listComunicacionBusqueda;
	}

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return Long
	 */
	public Long findAllLikeComunicacionRecepcionCount(
			Comunicacion comunicacion, Boolean startsWith,
			String codOrgDestino, Date fechaEnvioDesde, Date fechaEnvioHasta) {
		return this.comunicacionDao.findAllLikeComunicacionRecepcionCount(
				comunicacion, startsWith, codOrgDestino, fechaEnvioDesde,
				fechaEnvioHasta);
	}

	/**
	 * Deletes a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Comunicacion comunicacion) {
		this.comunicacionDao.remove(comunicacion);
	}

	/**
	 * Deletes multiple rows in the Comunicacion table.
	 * 
	 * @param comunicacionList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Comunicacion> comunicacionList) {
		for (Comunicacion comunicacionAux : comunicacionList) {
			this.comunicacionDao.remove(comunicacionAux);
		}
	}

	/**
	 * Getter method for ComunicacionDao
	 * 
	 * @return ComunicacionDao
	 */
	public ComunicacionDao getComunicacionDao() {
		return this.comunicacionDao;
	}

	/**
	 * Setter method for ComunicacionDao.
	 * 
	 * @param comunicacionDao
	 *            ComunicacionDao
	 * @return
	 */
	public void setComunicacionDao(ComunicacionDao comunicacionDao) {
		logger.info("Setting Dependency " + comunicacionDao);
		this.comunicacionDao = comunicacionDao;
	}

	/**
	 * Finds rows in the comunicacion table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstadisticasKontsumonetResultado> findAllComunicacionEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			Pagination pagination) {

		return (List<EstadisticasKontsumonetResultado>) this.estadisticasListadosKontsumonetDao
				.findAllComunicacionEstadisticasKontsumonet(
						estadisticasKontsumonetBusqueda, pagination);
	}
}
