package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.y41a.model.Comunicacion;
import com.ejie.y41a.model.ComunicacionBusqueda;
import com.ejie.y41a.model.ComunicacionDetalle;
import com.ejie.y41a.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41a.model.EstadisticasKontsumonetResultado;

/**
 * * ComunicacionService generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

public interface ComunicacionService {

	/**
	 * Inserts a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	Comunicacion add(Comunicacion comunicacion);

	/**
	 * Inserts a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	Comunicacion addComunicacion(Comunicacion comunicacion);

	/**
	 * Updates a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	Comunicacion update(Comunicacion comunicacion);

	/**
	 * Finds a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	Comunicacion find(Comunicacion comunicacion);

	/**
	 * Finds a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return ComunicacionDetalle
	 */
	ComunicacionDetalle findComunicacion(Comunicacion comunicacion);

	/**
	 * Finds a List of rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Comunicacion> findAll(Comunicacion comunicacion, Pagination pagination);

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Long
	 */
	Long findAllCount(Comunicacion comunicacion);

	/**
	 * Finds rows in the Comunicacion table using like.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Comunicacion> findAllLike(Comunicacion comunicacion,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Comunicacion table using like.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return List
	 */
	List<ComunicacionBusqueda> findAllLikeComunicacionEnvio(
			Comunicacion comunicacion, Pagination pagination,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta);

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return Long
	 */
	Long findAllLikeComunicacionEnvioCount(Comunicacion comunicacion,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta);

	/**
	 * Finds rows in the Comunicacion table using like.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return List
	 */
	List<ComunicacionBusqueda> findAllLikeComunicacionRecepcion(
			Comunicacion comunicacion, Pagination pagination,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta);

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return Long
	 */
	Long findAllLikeComunicacionRecepcionCount(Comunicacion comunicacion,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta);

	/**
	 * Deletes a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return
	 */
	void remove(Comunicacion comunicacion);

	/**
	 * Deletes multiple rows in the Comunicacion table.
	 * 
	 * @param comunicacionList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Comunicacion> comunicacionList);

	/**
	 * Finds rows in the comunicacion table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstadisticasKontsumonetResultado> findAllComunicacionEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			Pagination pagination);

}
