package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.ComunicacionFileDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.ComunicacionFile;

/**
 * * ComunicacionFileServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

@Service(value = "comunicacionFileService")
public class ComunicacionFileServiceImpl implements ComunicacionFileService {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunicacionFileServiceImpl.class);
	@Autowired
	private ComunicacionFileDao comunicacionFileDao;

	/**
	 * Inserts a single row in the ComunicacionFile table.
	 * 
	 * @param comunicacionFile
	 *            ComunicacionFile
	 * @return ComunicacionFile
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionFile add(ComunicacionFile comunicacionFile) {
		comunicacionFile.setM3cofile(this.comunicacionFileDao.getNewPK());
		return this.comunicacionFileDao.add(comunicacionFile);
	}

	/**
	 * Updates a single row in the ComunicacionFile table.
	 * 
	 * @param comunicacionFile
	 *            ComunicacionFile
	 * @return ComunicacionFile
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionFile update(ComunicacionFile comunicacionFile) {
		return this.comunicacionFileDao.update(comunicacionFile);
	}

	/**
	 * Finds a single row in the ComunicacionFile table.
	 * 
	 * @param comunicacionFile
	 *            ComunicacionFile
	 * @return ComunicacionFile
	 */
	public ComunicacionFile find(ComunicacionFile comunicacionFile) {
		return (ComunicacionFile) this.comunicacionFileDao
				.find(comunicacionFile);
	}

	/**
	 * Finds a List of rows in the ComunicacionFile table.
	 * 
	 * @param comunicacionFile
	 *            ComunicacionFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ComunicacionFile> findAll(ComunicacionFile comunicacionFile,
			Pagination pagination) {
		return (List<ComunicacionFile>) this.comunicacionFileDao.findAll(
				comunicacionFile, pagination);
	}

	/**
	 * Counts rows in the ComunicacionFile table.
	 * 
	 * @param comunicacionFile
	 *            ComunicacionFile
	 * @return Long
	 */
	public Long findAllCount(ComunicacionFile comunicacionFile) {
		return this.comunicacionFileDao.findAllCount(comunicacionFile);
	}

	/**
	 * Finds rows in the ComunicacionFile table using like.
	 * 
	 * @param comunicacionFile
	 *            ComunicacionFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ComunicacionFile> findAllLike(
			ComunicacionFile comunicacionFile, Pagination pagination,
			Boolean startsWith) {
		return (List<ComunicacionFile>) this.comunicacionFileDao.findAllLike(
				comunicacionFile, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the ComunicacionFile table.
	 * 
	 * @param comunicacionFile
	 *            ComunicacionFile
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ComunicacionFile comunicacionFile) {
		this.comunicacionFileDao.remove(comunicacionFile);
	}

	/**
	 * Deletes multiple rows in the ComunicacionFile table.
	 * 
	 * @param comunicacionFileList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<ComunicacionFile> comunicacionFileList) {
		for (ComunicacionFile comunicacionFileAux : comunicacionFileList) {
			this.comunicacionFileDao.remove(comunicacionFileAux);
		}
	}

	/**
	 * Getter method for ComunicacionFileDao
	 * 
	 * @return ComunicacionFileDao
	 */
	public ComunicacionFileDao getComunicacionFileDao() {
		return this.comunicacionFileDao;
	}

	/**
	 * Setter method for ComunicacionFileDao.
	 * 
	 * @param comunicacionFileDao
	 *            ComunicacionFileDao
	 * @return
	 */
	public void setComunicacionFileDao(ComunicacionFileDao comunicacionFileDao) {
		logger.info("Setting Dependency " + comunicacionFileDao);
		this.comunicacionFileDao = comunicacionFileDao;
	}
}
