package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.ComautDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Comaut;

/**
 *  * ComautServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "comautService")
public  class ComautServiceImpl implements ComautService {

	private static final  Logger logger = LoggerFactory.getLogger(ComautServiceImpl.class);
	@Autowired
	private ComautDao comautDao;

	/**
	 * Inserts a single row in the Comaut table.
	 *
	 * @param comaut Comaut
	 * @return Comaut
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Comaut add(Comaut comaut) {
		return this.comautDao.add(comaut);
	}

	/**
	 * Updates a single row in the Comaut table.
	 *
	 * @param comaut Comaut
	 * @return Comaut
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Comaut update(Comaut comaut) {
		return this.comautDao.update(comaut);
	 }

	/**
	 * Finds a single row in the Comaut table.
	 *
	 * @param comaut Comaut
	 * @return Comaut
	 */
	public Comaut find(Comaut comaut) {
		return (Comaut) this.comautDao.find(comaut);
	}

	/**
	 * Finds a List of rows in the Comaut table.
	 *
	 * @param comaut Comaut
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Comaut> findAll(Comaut comaut, Pagination pagination) {
		return (List<Comaut>) this.comautDao.findAll(comaut, pagination);
	}
    
	/**
	 * Counts rows in the Comaut table.
	 *
	 * @param comaut Comaut
	 * @return Long
	 */
	public Long findAllCount(Comaut comaut) {        
		return  this.comautDao.findAllCount(comaut);
	}

	/**
	 * Finds rows in the Comaut table using like.
	 *
	 * @param comaut Comaut
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Comaut> findAllLike(Comaut comaut, Pagination pagination, Boolean startsWith) {
		return (List<Comaut>) this.comautDao.findAllLike(comaut, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the Comaut table.
	 *
	 * @param comaut Comaut
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Comaut comaut) {
		this.comautDao.remove(comaut);
	}
	
	/**
	 * Deletes multiple rows in the Comaut table.
	 *
	 * @param comautList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Comaut> comautList) {
		for (Comaut  comautAux:comautList) {
			this.comautDao.remove(comautAux);
		}
	}


	/**
	 * Getter method for ComautDao
	 *
	 * @return ComautDao
	 */
	public ComautDao getComautDao() {
		return this.comautDao;
	}
    
	/**
	 * Setter method for ComautDao.
	 *
	 * @param  comautDao ComautDao
	 * @return
	 */
	public void setComautDao(ComautDao comautDao) {
		logger.info("Setting Dependency "+comautDao);
		this.comautDao = comautDao;
	}
}

