package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.CensoMonitorDao;
import com.ejie.y41a.dao.PlantillaDecisionDao;
import com.ejie.y41a.dao.PlantillaInsDao;
import com.ejie.y41a.dao.PlantillaTramiteDao;
import com.ejie.y41a.dao.PlantillasFichasSolicitudesDao;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.model.PlantillaDecision;
import com.ejie.y41a.model.PlantillaIns;
import com.ejie.y41a.model.PlantillaTramite;
import com.ejie.y41a.model.PlantillasFichasSolicitudes;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * CensoMonitorServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

@Service(value = "censoMonitorService")
public class CensoMonitorServiceImpl implements CensoMonitorService {

	private static final Logger logger = LoggerFactory
			.getLogger(CensoMonitorServiceImpl.class);
	@Autowired
	private CensoMonitorDao censoMonitorDao;
	@Autowired
	private PlantillaTramiteDao plantillaTramiteDao;
	@Autowired
	private PlantillaDecisionDao plantillaDecisionDao;
	@Autowired
	private PlantillaInsDao plantillaInsDao;
	@Autowired
	private PlantillasFichasSolicitudesDao plantillasFichasSolicitudesDao;

	/**
	 * Inserts a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CensoMonitor add(CensoMonitor censoMonitor) {
		try {
			if (this.censoMonitorDao.findUsuarioCensoMonitorCount(censoMonitor) > 0) {
				throw new Y41aUDAException(
						"error.censomonitor.userExistException", true,
						new Exception());
			} else {
				return this.censoMonitorDao.add(censoMonitor);
			}
		} catch (DuplicateKeyException e) {
			throw new Y41aUDAException(
					"error.censomonitor.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CensoMonitor update(CensoMonitor censoMonitor) {
		if (this.censoMonitorDao.findUsuarioCensoMonitorCount(censoMonitor) > 0) {
			throw new Y41aUDAException("error.censomonitor.userExistException",
					true, new Exception());
		} else {
			this.censoMonitorDao.update(censoMonitor);
		}
		CensoMonitor censoMonitorConsulta = new CensoMonitor();
		Organismo organismo = new Organismo();
		organismo.setCodOrg(censoMonitor.getOrganismo().getCodOrg());
		censoMonitorConsulta.setOrganismo(organismo);
		censoMonitorConsulta.setMoadmin(Y41aConstantes.VALOR_SI);
		long contador = this.censoMonitorDao.findAllCount(censoMonitorConsulta);
		if (contador <= 0) {
			throw new Y41aUDAException("error.validacion.unAdministrador",
					true, new Exception());
		}
		return censoMonitor;
	}

	/**
	 * Cambia el password y copia los tramites y decisiones para el organismo la
	 * primera vez que entra el organismo.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void inicializarOrganismo(CensoMonitor censoMonitor) {

		PlantillaTramite plantillaTramite = new PlantillaTramite();
		plantillaTramite.setPtcoor(censoMonitor.getOrganismo().getCodOrg());

		// Se obtiene el numero de plantillas de tramites que tiene el organismo
		Long numPlantillasTramite = this.plantillaTramiteDao
				.findAllCount(plantillaTramite);

		// Si no tiene ninguna plantilla
		if (numPlantillasTramite == 0) {
			plantillaTramite.setPtcoor(Y41aConstantes.CODIGO_ORGANISMO_LAKUA);

			// Se obtienen las plantillas del organismo 01A106 (LAKUA)
			List<PlantillaTramite> listPlantillaTramite = this.plantillaTramiteDao
					.findAll(plantillaTramite, null);

			for (PlantillaTramite plantiTramite : listPlantillaTramite) {

				plantiTramite
						.setPtcoor(censoMonitor.getOrganismo().getCodOrg());
				plantiTramite.setPtcodigo(Y41aUIDGenerator.getInstance()
						.generateId(Y41aConstantes.PK_SIZE));

				// Se insertan para el organismo actual
				this.plantillaTramiteDao.add(plantiTramite);
			}
		}

		PlantillaDecision plantillaDecision = new PlantillaDecision();
		plantillaDecision.setPdcoor(censoMonitor.getOrganismo().getCodOrg());

		// Se obtiene el numero de plantillas de decision que tiene el organismo
		Long numPlantillasDecision = this.plantillaDecisionDao
				.findAllCount(plantillaDecision);

		// Si no tiene ninguna plantilla
		if (numPlantillasDecision == 0) {
			plantillaDecision.setPdcoor(Y41aConstantes.CODIGO_ORGANISMO_LAKUA);

			// Se obtienen las plantillas del organismo 01A106 (LAKUA)
			List<PlantillaDecision> listPlantillaDecision = this.plantillaDecisionDao
					.findAll(plantillaDecision, null);

			for (PlantillaDecision plantiDecision : listPlantillaDecision) {
				plantiDecision.setPdcoor(censoMonitor.getOrganismo()
						.getCodOrg());
				plantiDecision.setPdcodigo(Y41aUIDGenerator.getInstance()
						.generateId(Y41aConstantes.PK_SIZE));

				// Se insertan para el organismo actual
				this.plantillaDecisionDao.add(plantiDecision);
			}
		}

		PlantillaIns plantillaIns = new PlantillaIns();
		plantillaIns.setPlinscoor(censoMonitor.getOrganismo().getCodOrg());

		// Se obtiene el numero de plantillas de inspeccion que tiene el
		// organismo
		Long numPlantillasInc = this.plantillaInsDao.findAllCount(plantillaIns);

		// Si no tiene ninguna plantilla
		if (numPlantillasInc == 0) {
			plantillaIns.setPlinscoor(Y41aConstantes.CODIGO_ORGANISMO_LAKUA);

			// Se obtienen las plantillas del organismo 01A106 (LAKUA)
			List<PlantillaIns> listPlantillaIns = this.plantillaInsDao.findAll(
					plantillaIns, null);

			for (PlantillaIns plantiIns : listPlantillaIns) {
				plantiIns.setPlinscoor(censoMonitor.getOrganismo().getCodOrg());
				plantiIns.setPlinscodigo(Y41aUIDGenerator.getInstance()
						.generateId(Y41aConstantes.PK_SIZE));

				// Se insertan para el organismo actual
				this.plantillaInsDao.add(plantiIns);
			}
		}

		// Modifica el password, quitando la marca de primera vez
		censoMonitor.setMoprimera(null);
		this.censoMonitorDao.updatePassword(censoMonitor);
	}

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	public CensoMonitor find(CensoMonitor censoMonitor) {
		return (CensoMonitor) this.censoMonitorDao.find(censoMonitor);
	}

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	public CensoMonitor findCensoMonitorUser(CensoMonitor censoMonitor) {
		return (CensoMonitor) this.censoMonitorDao
				.findCensoMonitorUser(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CensoMonitor> findAll(CensoMonitor censoMonitor,
			Pagination pagination) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAll(censoMonitor,
				pagination);
	}

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCount(CensoMonitor censoMonitor) {
		return this.censoMonitorDao.findAllCount(censoMonitor);
	}

	/**
	 * Finds rows in the CensoMonitor table using like.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CensoMonitor> findAllLike(CensoMonitor censoMonitor,
			Pagination pagination, Boolean startsWith) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllLike(
				censoMonitor, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CensoMonitor censoMonitor) {
		try {
			censoMonitor = (CensoMonitor) this.censoMonitorDao
					.find(censoMonitor);

			this.censoMonitorDao.remove(censoMonitor);

			CensoMonitor censoMonitorConsulta = new CensoMonitor();
			Organismo organismo = new Organismo();
			organismo.setCodOrg(censoMonitor.getOrganismo().getCodOrg());
			censoMonitorConsulta.setOrganismo(organismo);
			censoMonitorConsulta.setMoadmin(Y41aConstantes.VALOR_SI);
			long contador = this.censoMonitorDao
					.findAllCount(censoMonitorConsulta);
			if (contador <= 0) {
				throw new Y41aUDAException("error.validacion.unAdministrador",
						true, new Exception());
			}
		} catch (DataIntegrityViolationException e) {
			throw new Y41aUDAException(
					"error.censomonitor.DataIntegrityViolationException", true,
					e);
		}
	}

	/**
	 * Deletes multiple rows in the CensoMonitor table.
	 * 
	 * @param censoMonitorList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<CensoMonitor> censoMonitorList) {
		for (CensoMonitor censoMonitorAux : censoMonitorList) {
			this.censoMonitorDao.remove(censoMonitorAux);
		}
	}

	/**
	 * Copia las plantillas genéricas para el organismo si no existen
	 * 
	 * @param censoMonitor
	 *            CensoMonitor datos del usuario conectado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void inicializarPlantillasFichas(CensoMonitor censoMonitor) {

		PlantillasFichasSolicitudes plantillasFichasSolicitudes = new PlantillasFichasSolicitudes();
		plantillasFichasSolicitudes.setPfcoor(censoMonitor.getOrganismo()
				.getCodOrg());

		// Se obtiene el numero de plantillas de fichas que tiene el organismo
		Long numPlantillasFichas = this.plantillasFichasSolicitudesDao
				.findAllCount(plantillasFichasSolicitudes);

		// Si no tiene ninguna plantilla
		if (numPlantillasFichas.equals(Long.valueOf(0))) {
			plantillasFichasSolicitudes
					.setPfcoor(Y41aConstantes.CODIGO_ORGANISMO_LAKUA);

			// Se obtienen las plantillas del organismo 01A106 (LAKUA)
			List<PlantillasFichasSolicitudes> listPlantillasFichasSolicitudes = this.plantillasFichasSolicitudesDao
					.findAll(plantillasFichasSolicitudes, null);

			for (PlantillasFichasSolicitudes plantilla : listPlantillasFichasSolicitudes) {

				plantilla.setPfcoor(censoMonitor.getOrganismo().getCodOrg());
				plantilla.setPfcodigo(Y41aUIDGenerator.getInstance()
						.generateId(Y41aConstantes.PK_SIZE));

				// Se insertan para el organismo actual
				this.plantillasFichasSolicitudesDao.add(plantilla);
			}
		}
	}

	/**
	 * Getter method for CensoMonitorDao
	 * 
	 * @return CensoMonitorDao
	 */
	public CensoMonitorDao getCensoMonitorDao() {
		return this.censoMonitorDao;
	}

	/**
	 * Setter method for CensoMonitorDao.
	 * 
	 * @param censoMonitorDao
	 *            CensoMonitorDao
	 * @return
	 */
	public void setCensoMonitorDao(CensoMonitorDao censoMonitorDao) {
		logger.info("Setting Dependency " + censoMonitorDao);
		this.censoMonitorDao = censoMonitorDao;
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CensoMonitor> findAllLikeFilter(CensoMonitor censoMonitor,
			Pagination pagination, Boolean startsWith) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllLikeFilter(
				censoMonitor, pagination, startsWith);
	}

	/**
	 * Counts rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCountFilter(CensoMonitor censoMonitor,
			Boolean startsWith) {
		return this.censoMonitorDao.findAllLikeCountFilter(censoMonitor,
				startsWith);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAlta(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao
				.findAllCensoMonitorAlta(censoMonitor);
	}
}
