package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.CensoMonitor;

/**
 * * CensoMonitorService generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

public interface CensoMonitorService {

	/**
	 * Inserts a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor add(CensoMonitor censoMonitor);

	/**
	 * Updates a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor update(CensoMonitor censoMonitor);

	/**
	 * Cambia el password y copia los tramites y decisiones para el organismo la
	 * primera vez que entra el organismo.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 */
	void inicializarOrganismo(CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor find(CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor findCensoMonitorUser(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CensoMonitor> findAll(CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	Long findAllCount(CensoMonitor censoMonitor);

	/**
	 * Finds rows in the CensoMonitor table using like.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllLike(CensoMonitor censoMonitor,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 */
	void remove(CensoMonitor censoMonitor);

	/**
	 * Deletes multiple rows in the CensoMonitor table.
	 * 
	 * @param censoMonitorList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<CensoMonitor> censoMonitorList);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllLikeFilter(CensoMonitor censoMonitor,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCountFilter(CensoMonitor censoMonitor, Boolean startsWith);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	List<CensoMonitor> findAllCensoMonitorAlta(CensoMonitor censoMonitor);

	/**
	 * Copia las plantillas genéricas para el organismo si no existen
	 * 
	 * @param censoMonitor
	 *            CensoMonitor datos del usuario conectado
	 */
	void inicializarPlantillasFichas(CensoMonitor censoMonitor);

}
