package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.CaracterAlertaDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.CaracterAlerta;

/**
 *  * CaracterAlertaServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "caracterAlertaService")
public  class CaracterAlertaServiceImpl implements CaracterAlertaService {

	private static final  Logger logger = LoggerFactory.getLogger(CaracterAlertaServiceImpl.class);
	@Autowired
	private CaracterAlertaDao caracterAlertaDao;

	/**
	 * Inserts a single row in the CaracterAlerta table.
	 *
	 * @param caracterAlerta CaracterAlerta
	 * @return CaracterAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CaracterAlerta add(CaracterAlerta caracterAlerta) {
		return this.caracterAlertaDao.add(caracterAlerta);
	}

	/**
	 * Updates a single row in the CaracterAlerta table.
	 *
	 * @param caracterAlerta CaracterAlerta
	 * @return CaracterAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CaracterAlerta update(CaracterAlerta caracterAlerta) {
		return this.caracterAlertaDao.update(caracterAlerta);
	 }

	/**
	 * Finds a single row in the CaracterAlerta table.
	 *
	 * @param caracterAlerta CaracterAlerta
	 * @return CaracterAlerta
	 */
	public CaracterAlerta find(CaracterAlerta caracterAlerta) {
		return (CaracterAlerta) this.caracterAlertaDao.find(caracterAlerta);
	}

	/**
	 * Finds a List of rows in the CaracterAlerta table.
	 *
	 * @param caracterAlerta CaracterAlerta
	 * @param pagination Pagination
	 * @return List
	 */
	public List<CaracterAlerta> findAll(CaracterAlerta caracterAlerta, Pagination pagination) {
		return (List<CaracterAlerta>) this.caracterAlertaDao.findAll(caracterAlerta, pagination);
	}
    
	/**
	 * Counts rows in the CaracterAlerta table.
	 *
	 * @param caracterAlerta CaracterAlerta
	 * @return Long
	 */
	public Long findAllCount(CaracterAlerta caracterAlerta) {        
		return  this.caracterAlertaDao.findAllCount(caracterAlerta);
	}

	/**
	 * Finds rows in the CaracterAlerta table using like.
	 *
	 * @param caracterAlerta CaracterAlerta
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<CaracterAlerta> findAllLike(CaracterAlerta caracterAlerta, Pagination pagination, Boolean startsWith) {
		return (List<CaracterAlerta>) this.caracterAlertaDao.findAllLike(caracterAlerta, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the CaracterAlerta table.
	 *
	 * @param caracterAlerta CaracterAlerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CaracterAlerta caracterAlerta) {
		this.caracterAlertaDao.remove(caracterAlerta);
	}
	
	/**
	 * Deletes multiple rows in the CaracterAlerta table.
	 *
	 * @param caracterAlertaList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<CaracterAlerta> caracterAlertaList) {
		for (CaracterAlerta  caracterAlertaAux:caracterAlertaList) {
			this.caracterAlertaDao.remove(caracterAlertaAux);
		}
	}


	/**
	 * Getter method for CaracterAlertaDao
	 *
	 * @return CaracterAlertaDao
	 */
	public CaracterAlertaDao getCaracterAlertaDao() {
		return this.caracterAlertaDao;
	}
    
	/**
	 * Setter method for CaracterAlertaDao.
	 *
	 * @param  caracterAlertaDao CaracterAlertaDao
	 * @return
	 */
	public void setCaracterAlertaDao(CaracterAlertaDao caracterAlertaDao) {
		logger.info("Setting Dependency "+caracterAlertaDao);
		this.caracterAlertaDao = caracterAlertaDao;
	}
}

