package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.CampanhaDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Campanha;

/**
 *  * CampanhaServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "campanhaService")
public  class CampanhaServiceImpl implements CampanhaService {

	private static final  Logger logger = LoggerFactory.getLogger(CampanhaServiceImpl.class);
	@Autowired
	private CampanhaDao campanhaDao;

	/**
	 * Inserts a single row in the Campanha table.
	 *
	 * @param campanha Campanha
	 * @return Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Campanha add(Campanha campanha) {
		return this.campanhaDao.add(campanha);
	}

	/**
	 * Updates a single row in the Campanha table.
	 *
	 * @param campanha Campanha
	 * @return Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Campanha update(Campanha campanha) {
		return this.campanhaDao.update(campanha);
	 }

	/**
	 * Finds a single row in the Campanha table.
	 *
	 * @param campanha Campanha
	 * @return Campanha
	 */
	public Campanha find(Campanha campanha) {
		return (Campanha) this.campanhaDao.find(campanha);
	}

	/**
	 * Finds a List of rows in the Campanha table.
	 *
	 * @param campanha Campanha
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Campanha> findAll(Campanha campanha, Pagination pagination) {
		return (List<Campanha>) this.campanhaDao.findAll(campanha, pagination);
	}
    
	/**
	 * Counts rows in the Campanha table.
	 *
	 * @param campanha Campanha
	 * @return Long
	 */
	public Long findAllCount(Campanha campanha) {        
		return  this.campanhaDao.findAllCount(campanha);
	}

	/**
	 * Finds rows in the Campanha table using like.
	 *
	 * @param campanha Campanha
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Campanha> findAllLike(Campanha campanha, Pagination pagination, Boolean startsWith) {
		return (List<Campanha>) this.campanhaDao.findAllLike(campanha, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the Campanha table.
	 *
	 * @param campanha Campanha
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Campanha campanha) {
		this.campanhaDao.remove(campanha);
	}
	
	/**
	 * Deletes multiple rows in the Campanha table.
	 *
	 * @param campanhaList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Campanha> campanhaList) {
		for (Campanha  campanhaAux:campanhaList) {
			this.campanhaDao.remove(campanhaAux);
		}
	}


	/**
	 * Getter method for CampanhaDao
	 *
	 * @return CampanhaDao
	 */
	public CampanhaDao getCampanhaDao() {
		return this.campanhaDao;
	}
    
	/**
	 * Setter method for CampanhaDao.
	 *
	 * @param  campanhaDao CampanhaDao
	 * @return
	 */
	public void setCampanhaDao(CampanhaDao campanhaDao) {
		logger.info("Setting Dependency "+campanhaDao);
		this.campanhaDao = campanhaDao;
	}
}

