package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.CampanhaProdDao;
import com.ejie.y41a.model.CampanhaProd;
import com.ejie.y41a.model.CampanhaProdBusqueda;

/**
 * * CampanhaProdServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "campanhaProdService")
public class CampanhaProdServiceImpl implements CampanhaProdService {

	private static final Logger logger = LoggerFactory
			.getLogger(CampanhaProdServiceImpl.class);
	@Autowired
	private CampanhaProdDao campanhaProdDao;

	/**
	 * Inserts a single row in the CampanhaProd table.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @return CampanhaProd
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaProd add(CampanhaProd campanhaProd) {
		return this.campanhaProdDao.add(campanhaProd);
	}

	/**
	 * Updates a single row in the CampanhaProd table.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @return CampanhaProd
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaProd update(CampanhaProd campanhaProd) {
		return this.campanhaProdDao.update(campanhaProd);
	}

	/**
	 * Finds a single row in the CampanhaProd table.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @return CampanhaProd
	 */
	public CampanhaProd find(CampanhaProd campanhaProd) {
		return (CampanhaProd) this.campanhaProdDao.find(campanhaProd);
	}

	/**
	 * Finds a List of rows in the CampanhaProd table.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CampanhaProd> findAll(CampanhaProd campanhaProd,
			Pagination pagination) {
		return (List<CampanhaProd>) this.campanhaProdDao.findAll(campanhaProd,
				pagination);
	}

	/**
	 * Finds a List of rows in the CampanhaProd table.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CampanhaProdBusqueda> findAllCampanhaProd(
			CampanhaProd campanhaProd, Pagination pagination) {

		List<CampanhaProdBusqueda> listCampanhaProdBusqueda = new ArrayList<CampanhaProdBusqueda>();
		List<CampanhaProd> listCampanhaProd = this.campanhaProdDao.findAll(
				campanhaProd, pagination);

		for (CampanhaProd campaProd : listCampanhaProd) {

			listCampanhaProdBusqueda.add(new CampanhaProdBusqueda(campaProd
					.getProducto().getPscodigo(), campaProd.getProducto()
					.getPsnoco(), campaProd.getProducto().getPsnocoe(),
					campaProd.getCpnops()));
		}

		return listCampanhaProdBusqueda;
	}

	/**
	 * Counts rows in the CampanhaProd table.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @return Long
	 */
	public Long findAllCount(CampanhaProd campanhaProd) {
		return this.campanhaProdDao.findAllCount(campanhaProd);
	}

	/**
	 * Finds rows in the CampanhaProd table using like.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CampanhaProd> findAllLike(CampanhaProd campanhaProd,
			Pagination pagination, Boolean startsWith) {
		return (List<CampanhaProd>) this.campanhaProdDao.findAllLike(
				campanhaProd, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the CampanhaProd table.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CampanhaProd campanhaProd) {
		this.campanhaProdDao.remove(campanhaProd);
	}

	/**
	 * Deletes multiple rows in the CampanhaProd table.
	 * 
	 * @param campanhaProdList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<CampanhaProd> campanhaProdList) {
		for (CampanhaProd campanhaProdAux : campanhaProdList) {
			this.campanhaProdDao.remove(campanhaProdAux);
		}
	}

	/**
	 * Getter method for CampanhaProdDao
	 * 
	 * @return CampanhaProdDao
	 */
	public CampanhaProdDao getCampanhaProdDao() {
		return this.campanhaProdDao;
	}

	/**
	 * Setter method for CampanhaProdDao.
	 * 
	 * @param campanhaProdDao
	 *            CampanhaProdDao
	 * @return
	 */
	public void setCampanhaProdDao(CampanhaProdDao campanhaProdDao) {
		logger.info("Setting Dependency " + campanhaProdDao);
		this.campanhaProdDao = campanhaProdDao;
	}
}
