package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ActuacionDao;
import com.ejie.y41a.dao.AlertaRecibDao;
import com.ejie.y41a.dao.CampahnaRecibDao;
import com.ejie.y41a.dao.DenunciaRecibDao;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.AlertaRecib;
import com.ejie.y41a.model.CampahnaRecib;
import com.ejie.y41a.model.CampahnaRecibBusqueda;
import com.ejie.y41a.model.DenunciaRecib;

/**
 * * CampahnaRecibServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "campahnaRecibService")
public class CampahnaRecibServiceImpl implements CampahnaRecibService {

	private static final Logger logger = LoggerFactory
			.getLogger(CampahnaRecibServiceImpl.class);
	@Autowired
	private CampahnaRecibDao campahnaRecibDao;
	@Autowired
	private AlertaRecibDao alertaRecibDao;
	@Autowired
	private DenunciaRecibDao denunciaRecibDao;

	@Autowired
	private ActuacionDao actuacionDao;

	/**
	 * Inserts a single row in the CampahnaRecib table.
	 * 
	 * @param campahnaRecib
	 *            CampahnaRecib
	 * @return CampahnaRecib
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampahnaRecib add(CampahnaRecib campahnaRecib) {
		return this.campahnaRecibDao.add(campahnaRecib);
	}

	/**
	 * Updates a single row in the CampahnaRecib table.
	 * 
	 * @param campahnaRecib
	 *            CampahnaRecib
	 * @return CampahnaRecib
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampahnaRecib update(CampahnaRecib campahnaRecib) {
		return this.campahnaRecibDao.update(campahnaRecib);
	}

	/**
	 * Updates a single row in the CampahnaRecib table.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @return CampahnaRecibBusqueda
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampahnaRecibBusqueda updateCampahna(
			CampahnaRecibBusqueda campahnaRecibBusqueda) {
		if (campahnaRecibBusqueda.getTipo()
				.equals(Y41aConstantes.TIPO_CAMPAHNA)) {
			this.campahnaRecibDao.updateFinalizada(campahnaRecibBusqueda);

		} else if (campahnaRecibBusqueda.getTipo().equals(
				Y41aConstantes.TIPO_ALERTA)) {
			this.alertaRecibDao.updateFinalizada(campahnaRecibBusqueda);

		} else if (campahnaRecibBusqueda.getTipo().equals(
				Y41aConstantes.TIPO_DENUNCIA)) {
			this.denunciaRecibDao.updateFinalizada(campahnaRecibBusqueda);
		}

		return campahnaRecibBusqueda;
	}

	/**
	 * Finds a single row in the CampahnaRecib table.
	 * 
	 * @param campahnaRecib
	 *            CampahnaRecib
	 * @return CampahnaRecib
	 */
	public CampahnaRecib find(CampahnaRecib campahnaRecib) {
		return (CampahnaRecib) this.campahnaRecibDao.find(campahnaRecib);
	}

	/**
	 * Finds a List of rows in the CampahnaRecib table.
	 * 
	 * @param campahnaRecib
	 *            CampahnaRecib
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CampahnaRecib> findAll(CampahnaRecib campahnaRecib,
			Pagination pagination) {
		return (List<CampahnaRecib>) this.campahnaRecibDao.findAll(
				campahnaRecib, pagination);
	}

	/**
	 * Counts rows in the CampahnaRecib table.
	 * 
	 * @param campahnaRecib
	 *            CampahnaRecib
	 * @return Long
	 */
	public Long findAllCount(CampahnaRecib campahnaRecib) {
		return this.campahnaRecibDao.findAllCount(campahnaRecib);
	}

	/**
	 * Finds rows in the CampahnaRecib table using like.
	 * 
	 * @param campahnaRecib
	 *            CampahnaRecib
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CampahnaRecib> findAllLike(CampahnaRecib campahnaRecib,
			Pagination pagination, Boolean startsWith) {
		return (List<CampahnaRecib>) this.campahnaRecibDao.findAllLike(
				campahnaRecib, pagination, startsWith);
	}

	/**
	 * Finds rows in the CampahnaRecib table using like.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CampahnaRecibBusqueda> findAllLikeCampahna(
			CampahnaRecibBusqueda campahnaRecibBusqueda, Pagination pagination,
			Boolean startsWith) {
		List<CampahnaRecibBusqueda> listCampahnaRecibBusqueda = this.campahnaRecibDao
				.findAllLikeCampahna(campahnaRecibBusqueda, pagination,
						startsWith);

		for (CampahnaRecibBusqueda campRecibBusqueda : listCampahnaRecibBusqueda) {
			if (campRecibBusqueda.getTipo()
					.equals(Y41aConstantes.TIPO_CAMPAHNA)) {
				if (campRecibBusqueda.getFecfinalizacion() != null) {
					campRecibBusqueda
							.setSituacion(Y41aConstantes.CAMPAHNA_FINALIZADA);
				} else {
					Actuacion actuacion = new Actuacion();
					CampahnaRecib campahnaRecib = new CampahnaRecib();
					campahnaRecib.setS4codigo(campRecibBusqueda
							.getCodigoRecibida());
					actuacion.setCampahnaRecib(campahnaRecib);

					Long numActuaciones = this.actuacionDao
							.findAllCount(actuacion);

					if (numActuaciones > 0) {
						campRecibBusqueda
								.setSituacion(Y41aConstantes.CAMPAHNA_CON_ACTUACION);
					} else {
						campRecibBusqueda
								.setSituacion(Y41aConstantes.CAMPAHNA_SIN_ACTUACION);
					}
				}

			} else if (campRecibBusqueda.getTipo().equals(
					Y41aConstantes.TIPO_ALERTA)) {
				if (campRecibBusqueda.getFecfinalizacion() != null) {
					campRecibBusqueda
							.setSituacion(Y41aConstantes.CAMPAHNA_FINALIZADA);
				} else {
					Actuacion actuacion = new Actuacion();
					AlertaRecib alertaRecib = new AlertaRecib();
					alertaRecib.setS5codigo(campRecibBusqueda
							.getCodigoRecibida());
					actuacion.setAlertaRecib(alertaRecib);

					Long numActuaciones = this.actuacionDao
							.findAllCount(actuacion);

					if (numActuaciones > 0) {
						campRecibBusqueda
								.setSituacion(Y41aConstantes.CAMPAHNA_CON_ACTUACION);
					} else {
						campRecibBusqueda
								.setSituacion(Y41aConstantes.CAMPAHNA_SIN_ACTUACION);
					}
				}

			} else if (campRecibBusqueda.getTipo().equals(
					Y41aConstantes.TIPO_DENUNCIA)) {
				if (campRecibBusqueda.getFecfinalizacion() != null) {
					campRecibBusqueda
							.setSituacion(Y41aConstantes.CAMPAHNA_FINALIZADA);
				} else {
					Actuacion actuacion = new Actuacion();
					DenunciaRecib denunciaRecib = new DenunciaRecib();
					denunciaRecib.setS6codigo(campRecibBusqueda
							.getCodigoRecibida());
					actuacion.setDenunciaRecib(denunciaRecib);

					Long numActuaciones = this.actuacionDao
							.findAllCount(actuacion);

					if (numActuaciones > 0) {
						campRecibBusqueda
								.setSituacion(Y41aConstantes.CAMPAHNA_CON_ACTUACION);
					} else {
						campRecibBusqueda
								.setSituacion(Y41aConstantes.CAMPAHNA_SIN_ACTUACION);
					}
				}
			}
		}

		return listCampahnaRecibBusqueda;
	}

	/**
	 * Counts rows in the CampahnaRecib table.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCampahnaCount(
			CampahnaRecibBusqueda campahnaRecibBusqueda, Boolean startsWith) {
		return this.campahnaRecibDao.findAllLikeCampahnaCount(
				campahnaRecibBusqueda, startsWith);
	}

	/**
	 * Finds rows in the CampahnaRecib table using like.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CampahnaRecibBusqueda> findAllLikeCampahnaSinActuaciones(
			CampahnaRecibBusqueda campahnaRecibBusqueda, Pagination pagination) {
		List<CampahnaRecibBusqueda> listCampahnaRecibBusqueda = this.campahnaRecibDao
				.findAllLikeCampahna(campahnaRecibBusqueda, pagination, false);

		List<CampahnaRecibBusqueda> listCampahnaRecibBusquedaSinActuaciones = new ArrayList<CampahnaRecibBusqueda>();

		for (CampahnaRecibBusqueda campRecibBusqueda : listCampahnaRecibBusqueda) {
			if (campRecibBusqueda.getTipo()
					.equals(Y41aConstantes.TIPO_CAMPAHNA)) {
				if (campRecibBusqueda.getFecfinalizacion() == null) {
					Actuacion actuacion = new Actuacion();
					CampahnaRecib campahnaRecib = new CampahnaRecib();
					campahnaRecib.setS4codigo(campRecibBusqueda
							.getCodigoRecibida());
					actuacion.setCampahnaRecib(campahnaRecib);

					Long numActuaciones = this.actuacionDao
							.findAllCount(actuacion);

					if (numActuaciones == 0) {
						listCampahnaRecibBusquedaSinActuaciones
								.add(campRecibBusqueda);
					}
				}

			} else if (campRecibBusqueda.getTipo().equals(
					Y41aConstantes.TIPO_ALERTA)) {
				if (campRecibBusqueda.getFecfinalizacion() == null) {
					Actuacion actuacion = new Actuacion();
					AlertaRecib alertaRecib = new AlertaRecib();
					alertaRecib.setS5codigo(campRecibBusqueda
							.getCodigoRecibida());
					actuacion.setAlertaRecib(alertaRecib);

					Long numActuaciones = this.actuacionDao
							.findAllCount(actuacion);

					if (numActuaciones == 0) {
						listCampahnaRecibBusquedaSinActuaciones
								.add(campRecibBusqueda);
					}
				}

			} else if (campRecibBusqueda.getTipo().equals(
					Y41aConstantes.TIPO_DENUNCIA)) {
				if (campRecibBusqueda.getFecfinalizacion() == null) {
					Actuacion actuacion = new Actuacion();
					DenunciaRecib denunciaRecib = new DenunciaRecib();
					denunciaRecib.setS6codigo(campRecibBusqueda
							.getCodigoRecibida());
					actuacion.setDenunciaRecib(denunciaRecib);

					Long numActuaciones = this.actuacionDao
							.findAllCount(actuacion);

					if (numActuaciones == 0) {
						listCampahnaRecibBusquedaSinActuaciones
								.add(campRecibBusqueda);
					}
				}
			}
		}

		return listCampahnaRecibBusquedaSinActuaciones;
	}

	/**
	 * Deletes a single row in the CampahnaRecib table.
	 * 
	 * @param campahnaRecib
	 *            CampahnaRecib
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CampahnaRecib campahnaRecib) {
		this.campahnaRecibDao.remove(campahnaRecib);
	}

	/**
	 * Deletes multiple rows in the CampahnaRecib table.
	 * 
	 * @param campahnaRecibList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<CampahnaRecib> campahnaRecibList) {
		for (CampahnaRecib campahnaRecibAux : campahnaRecibList) {
			this.campahnaRecibDao.remove(campahnaRecibAux);
		}
	}

	/**
	 * Getter method for CampahnaRecibDao
	 * 
	 * @return CampahnaRecibDao
	 */
	public CampahnaRecibDao getCampahnaRecibDao() {
		return this.campahnaRecibDao;
	}

	/**
	 * Setter method for CampahnaRecibDao.
	 * 
	 * @param campahnaRecibDao
	 *            CampahnaRecibDao
	 * @return
	 */
	public void setCampahnaRecibDao(CampahnaRecibDao campahnaRecibDao) {
		logger.info("Setting Dependency " + campahnaRecibDao);
		this.campahnaRecibDao = campahnaRecibDao;
	}
}
