package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.GrupoOrganismoDao;
import com.ejie.y41a.model.Y41aArbolOrganismos;
import com.ejie.y41a.model.Y41aGrupoOrganismoTree;
import com.ejie.y41a.model.Y41aOrganismoTree;

/**
 * ArbolOrganismosServiceImpl generated by UDA 1.0, 08-jun-2011 12:15:13.
 * 
 *  
 */
@Service(value = "arbolOrganismosService")
public class ArbolOrganismosServiceImpl implements ArbolOrganismosService {

	@Autowired()
	private GrupoOrganismoDao gruposDao;

	@Override()
	public Y41aArbolOrganismos obtenerArbol(boolean mostrarNoActivas,
			String codOrgConectado, Pagination pagination) {

		List<Y41aGrupoOrganismoTree> lstArbolGrupos = new ArrayList<Y41aGrupoOrganismoTree>();

		Y41aGrupoOrganismoTree grupoFiltro = new Y41aGrupoOrganismoTree();
		// grupoFiltro.setGrupoId(Y41aConstantes.GRUPO_RAIZ_ID);
		// grupoFiltro.setPadreId(null);

		// Get root
		// Y41aGrupoOrganismoTree rootGrupo = this.gruposDao.find(grupoFiltro);

		// Obtenemos los grupos
		grupoFiltro.setGrupoId(null);
		grupoFiltro.setPadreId(null);
		grupoFiltro.setActiva(Y41aConstantes.VALOR_SI);

		List<Y41aGrupoOrganismoTree> lstGrupo = this.gruposDao.findAll(
				grupoFiltro, null);
		// lstGrupo.add(0, rootGrupo);

		for (Y41aGrupoOrganismoTree gr : lstGrupo) {

			if (this.tieneEntidadesKontsumonet(gr, mostrarNoActivas, pagination)) {
				gr = this.obtieneGrupo(gr, mostrarNoActivas, codOrgConectado,
						pagination);
				lstArbolGrupos.add(gr);
			}
		}

		Y41aArbolOrganismos tree = new Y41aArbolOrganismos();
		tree.setLstGrupos(lstArbolGrupos);

		return tree;
	}

	/**
	 * 
	 * @param grupoFiltro
	 *            Y41aGrupoOrganismoTree
	 * @param mostrarNoActivas
	 *            boolean
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return Y41aGrupoOrganismoTree
	 */
	private Y41aGrupoOrganismoTree obtieneGrupo(
			Y41aGrupoOrganismoTree grupoFiltro, boolean mostrarNoActivas,
			String codOrgConectado, Pagination pagination) {
		List<Y41aGrupoOrganismoTree> lstGrupoChildren = this.gruposDao
				.findAllChildren(grupoFiltro);

		if (lstGrupoChildren.size() > 0) {
			List<Object> lstGrupos = new ArrayList();
			for (Y41aGrupoOrganismoTree gr : lstGrupoChildren) {
				if (this.tieneEntidadesKontsumonet(gr, mostrarNoActivas,
						pagination)) {
					gr = this.obtieneGrupo(gr, mostrarNoActivas,
							codOrgConectado, pagination);
					lstGrupos.add(gr);
				}
			}

			List<Y41aOrganismoTree> lstOrganismo = this.obtieneOrganismos(
					grupoFiltro, mostrarNoActivas, codOrgConectado, pagination);

			for (Y41aOrganismoTree ent : lstOrganismo) {
				lstGrupos.add(ent);
			}

			grupoFiltro.setLstChildren(lstGrupos);

		} else {
			grupoFiltro.setLstChildren(this.obtieneOrganismos(grupoFiltro,
					mostrarNoActivas, codOrgConectado, pagination));
		}

		return grupoFiltro;
	}

	/**
	 * 
	 * @param gr
	 *            Y41aGrupoOrganismoTree
	 * @param mostrarNoActivas
	 *            boolean
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List<Y41aOrganismoTree>
	 */
	private List<Y41aOrganismoTree> obtieneOrganismos(
			Y41aGrupoOrganismoTree gr, boolean mostrarNoActivas,
			String codOrgConectado, Pagination pagination) {

		Y41aOrganismoTree y41aOrganismoTreeKey = new Y41aOrganismoTree();
		if (mostrarNoActivas) {
			y41aOrganismoTreeKey.setActiva(null); // Muestra todas
		} else {
			y41aOrganismoTreeKey.setActiva(Y41aConstantes.VALOR_SI);
		}

		y41aOrganismoTreeKey.setCodOrg(codOrgConectado);

		Y41aGrupoOrganismoTree fGr = this.gruposDao.findGrupoEntidad(gr,
				y41aOrganismoTreeKey, pagination);
		return fGr.getEntidads();

	}

	/**
	 * 
	 * @param y40aGrupoTreeFiltro
	 *            Y40aGrupoTree
	 * @param mostrarNoActivas
	 *            boolean
	 * @param pagination
	 *            Pagination
	 * @return boolean
	 */
	private boolean tieneEntidadesKontsumonet(
			Y41aGrupoOrganismoTree y41aGrupoOrganismoTree,
			boolean mostrarNoActivas, Pagination pagination) {

		// comprobar si tiene entidades de kontsumonet
		// Si tiene return true:
		// Si no tiene se buscan sus hijos y por cada hijo se mira si tiene
		// entidades de kontsumonet
		// si no tiene ninguno return false.

		boolean entidadesKontsumonet = false;

		Long numEntidades = this.gruposDao
				.countEntidadesKontsumonet(y41aGrupoOrganismoTree);

		if (numEntidades > 0) {
			return true;
		} else {
			List<Y41aGrupoOrganismoTree> lstGrupoChildren = this.gruposDao
					.findAllChildren(y41aGrupoOrganismoTree);

			if (lstGrupoChildren.size() > 0) {
				for (Y41aGrupoOrganismoTree gr : lstGrupoChildren) {
					entidadesKontsumonet = this.tieneEntidadesKontsumonet(gr,
							mostrarNoActivas, pagination);
					if (entidadesKontsumonet) {
						return entidadesKontsumonet;
					}
				}
				return false;
			} else {
				return false;
			}
		}
	}

}
