package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ActuacionDao;
import com.ejie.y41a.dao.AnalisisDao;
import com.ejie.y41a.dao.CampahnaRecibDao;
import com.ejie.y41a.model.ActaActuacionAlta;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.Analisis;
import com.ejie.y41a.model.AnalisisDetalle;
import com.ejie.y41a.model.CampahnaRecibBusqueda;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * AnalisisServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "analisisService")
public class AnalisisServiceImpl implements AnalisisService {

	private static final Logger logger = LoggerFactory
			.getLogger(AnalisisServiceImpl.class);
	@Autowired
	private AnalisisDao analisisDao;
	@Autowired
	private CampahnaRecibDao campahnaRecibDao;
	@Autowired
	private ActuacionDao actuacionDao;

	/**
	 * Inserts a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Analisis
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Analisis add(Analisis analisis) {
		return this.analisisDao.add(analisis);
	}

	/**
	 * Updates a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Analisis
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Analisis update(Analisis analisis) {
		return this.analisisDao.update(analisis);
	}

	/**
	 * Registra una muestra en la tabla de Analisis.
	 * 
	 * @param analisisDetalle
	 *            AnalisisDetalle
	 * @return AnalisisDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AnalisisDetalle registerMuestra(AnalisisDetalle analisisDetalle) {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(analisisDetalle.getAtcodigo());

		ActaActuacionAlta actaActuacionAlta = this.actuacionDao
				.findActuacion(actuacion);

		if (Y41aUtils.isFilled(actaActuacionAlta.getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS4codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.campahna.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.alerta.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.denuncia.CerradaException",
						true, new Exception());
			}
		}

		if (Y41aUtils.isFilled(analisisDetalle.getAncodigo())) {
			this.analisisDao.updateMuestra(analisisDetalle);
		} else {
			analisisDetalle.setAncodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));
			this.analisisDao.addMuestra(analisisDetalle);
		}
		return analisisDetalle;
	}

	/**
	 * Finds a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Analisis
	 */
	public Analisis find(Analisis analisis) {
		return (Analisis) this.analisisDao.find(analisis);
	}

	/**
	 * Finds a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return AnalisisDetalle
	 */
	public AnalisisDetalle findMuestra(Analisis analisis) {
		AnalisisDetalle analisisDetalle = null;
		try {
			Analisis analisisAux = (Analisis) this.analisisDao.find(analisis);

			analisisDetalle = new AnalisisDetalle(analisisAux.getAncodigo(),
					analisisAux.getAnnrmu(), analisisAux.getAnnran(),
					analisisAux.getAncoor(), analisisAux.getAnteestm(),
					analisisAux.getAncaptpm(), analisisAux.getActuacion()
							.getAtcodigo(), analisisAux.getOriProdAlerta()
							.getTomcodigo(), analisisAux.getOriProdAlerta()
							.getTomnombre(), analisisAux.getTipCaracMuestra()
							.getTctcodigo(), analisisAux.getTipCaracMuestra()
							.getTctnombre(), analisisAux.getTipDepoMuestra()
							.getTdmcodigo(), analisisAux.getTipDepoMuestra()
							.getTdmnombre());
		} catch (EmptyResultDataAccessException e) {
			analisisDetalle = new AnalisisDetalle();
		}
		return analisisDetalle;
	}

	/**
	 * Finds a List of rows in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Analisis> findAll(Analisis analisis, Pagination pagination) {
		return (List<Analisis>) this.analisisDao.findAll(analisis, pagination);
	}

	/**
	 * Counts rows in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Long
	 */
	public Long findAllCount(Analisis analisis) {
		return this.analisisDao.findAllCount(analisis);
	}

	/**
	 * Finds rows in the Analisis table using like.
	 * 
	 * @param analisis
	 *            Analisis
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Analisis> findAllLike(Analisis analisis, Pagination pagination,
			Boolean startsWith) {
		return (List<Analisis>) this.analisisDao.findAllLike(analisis,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Analisis analisis) {
		this.analisisDao.remove(analisis);
	}

	/**
	 * Deletes multiple rows in the Analisis table.
	 * 
	 * @param analisisList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Analisis> analisisList) {
		for (Analisis analisisAux : analisisList) {
			this.analisisDao.remove(analisisAux);
		}
	}

	/**
	 * Getter method for AnalisisDao
	 * 
	 * @return AnalisisDao
	 */
	public AnalisisDao getAnalisisDao() {
		return this.analisisDao;
	}

	/**
	 * Setter method for AnalisisDao.
	 * 
	 * @param analisisDao
	 *            AnalisisDao
	 * @return
	 */
	public void setAnalisisDao(AnalisisDao analisisDao) {
		logger.info("Setting Dependency " + analisisDao);
		this.analisisDao = analisisDao;
	}
}
