package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Analisis;
import com.ejie.y41a.model.AnalisisDetalle;

/**
 * * AnalisisService generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

public interface AnalisisService {

	/**
	 * Inserts a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Analisis
	 */
	Analisis add(Analisis analisis);

	/**
	 * Updates a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Analisis
	 */
	Analisis update(Analisis analisis);

	/**
	 * Registra una muestra en la tabla de Analisis.
	 * 
	 * @param analisisDetalle
	 *            AnalisisDetalle
	 * @return AnalisisDetalle
	 */
	AnalisisDetalle registerMuestra(AnalisisDetalle analisisDetalle);

	/**
	 * Finds a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Analisis
	 */
	Analisis find(Analisis analisis);

	/**
	 * Finds a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return AnalisisDetalle
	 */
	AnalisisDetalle findMuestra(Analisis analisis);

	/**
	 * Finds a List of rows in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Analisis> findAll(Analisis analisis, Pagination pagination);

	/**
	 * Counts rows in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Long
	 */
	Long findAllCount(Analisis analisis);

	/**
	 * Finds rows in the Analisis table using like.
	 * 
	 * @param analisis
	 *            Analisis
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Analisis> findAllLike(Analisis analisis, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return
	 */
	void remove(Analisis analisis);

	/**
	 * Deletes multiple rows in the Analisis table.
	 * 
	 * @param analisisList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Analisis> analisisList);

}
