package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.AlertaDao;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.AlertaDetalle;

/**
 * * AlertaServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "alertaService")
public class AlertaServiceImpl implements AlertaService {

	private static final Logger logger = LoggerFactory
			.getLogger(AlertaServiceImpl.class);
	@Autowired
	private AlertaDao alertaDao;

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Alerta add(Alerta alerta) {
		return this.alertaDao.add(alerta);
	}

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Alerta update(Alerta alerta) {
		return this.alertaDao.update(alerta);
	}

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	public Alerta find(Alerta alerta) {
		return (Alerta) this.alertaDao.find(alerta);
	}

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	public AlertaDetalle findAlerta(Alerta alerta) {
		return (AlertaDetalle) this.alertaDao.findAlerta(alerta);
	}

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Alerta> findAll(Alerta alerta, Pagination pagination) {
		return (List<Alerta>) this.alertaDao.findAll(alerta, pagination);
	}

	/**
	 * Counts rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Long
	 */
	public Long findAllCount(Alerta alerta) {
		return this.alertaDao.findAllCount(alerta);
	}

	/**
	 * Finds rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Alerta> findAllLike(Alerta alerta, Pagination pagination,
			Boolean startsWith) {
		return (List<Alerta>) this.alertaDao.findAllLike(alerta, pagination,
				startsWith);
	}

	/**
	 * Deletes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Alerta alerta) {
		this.alertaDao.remove(alerta);
	}

	/**
	 * Deletes multiple rows in the Alerta table.
	 * 
	 * @param alertaList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Alerta> alertaList) {
		for (Alerta alertaAux : alertaList) {
			this.alertaDao.remove(alertaAux);
		}
	}

	/**
	 * Getter method for AlertaDao
	 * 
	 * @return AlertaDao
	 */
	public AlertaDao getAlertaDao() {
		return this.alertaDao;
	}

	/**
	 * Setter method for AlertaDao.
	 * 
	 * @param alertaDao
	 *            AlertaDao
	 * @return
	 */
	public void setAlertaDao(AlertaDao alertaDao) {
		logger.info("Setting Dependency " + alertaDao);
		this.alertaDao = alertaDao;
	}
}
