package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.AlertaDetalle;

/**
 * * AlertaService generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

public interface AlertaService {

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta add(Alerta alerta);

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta update(Alerta alerta);

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta find(Alerta alerta);

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	AlertaDetalle findAlerta(Alerta alerta);

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Alerta> findAll(Alerta alerta, Pagination pagination);

	/**
	 * Counts rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Long
	 */
	Long findAllCount(Alerta alerta);

	/**
	 * Finds rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Alerta> findAllLike(Alerta alerta, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	void remove(Alerta alerta);

	/**
	 * Deletes multiple rows in the Alerta table.
	 * 
	 * @param alertaList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Alerta> alertaList);

}
