package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.AlertaRecibDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.AlertaRecib;

/**
 * * AlertaRecibServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "alertaRecibService")
public class AlertaRecibServiceImpl implements AlertaRecibService {

	private static final Logger logger = LoggerFactory
			.getLogger(AlertaRecibServiceImpl.class);
	@Autowired
	private AlertaRecibDao alertaRecibDao;

	/**
	 * Inserts a single row in the AlertaRecib table.
	 * 
	 * @param alertaRecib
	 *            AlertaRecib
	 * @return AlertaRecib
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AlertaRecib add(AlertaRecib alertaRecib) {
		return this.alertaRecibDao.add(alertaRecib);
	}

	/**
	 * Updates a single row in the AlertaRecib table.
	 * 
	 * @param alertaRecib
	 *            AlertaRecib
	 * @return AlertaRecib
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AlertaRecib update(AlertaRecib alertaRecib) {
		return this.alertaRecibDao.update(alertaRecib);
	}

	/**
	 * Finds a single row in the AlertaRecib table.
	 * 
	 * @param alertaRecib
	 *            AlertaRecib
	 * @return AlertaRecib
	 */
	public AlertaRecib find(AlertaRecib alertaRecib) {
		return (AlertaRecib) this.alertaRecibDao.find(alertaRecib);
	}

	/**
	 * Finds a List of rows in the AlertaRecib table.
	 * 
	 * @param alertaRecib
	 *            AlertaRecib
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AlertaRecib> findAll(AlertaRecib alertaRecib,
			Pagination pagination) {
		return (List<AlertaRecib>) this.alertaRecibDao.findAll(alertaRecib,
				pagination);
	}

	/**
	 * Counts rows in the AlertaRecib table.
	 * 
	 * @param alertaRecib
	 *            AlertaRecib
	 * @return Long
	 */
	public Long findAllCount(AlertaRecib alertaRecib) {
		return this.alertaRecibDao.findAllCount(alertaRecib);
	}

	/**
	 * Finds rows in the AlertaRecib table using like.
	 * 
	 * @param alertaRecib
	 *            AlertaRecib
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AlertaRecib> findAllLike(AlertaRecib alertaRecib,
			Pagination pagination, Boolean startsWith) {
		return (List<AlertaRecib>) this.alertaRecibDao.findAllLike(alertaRecib,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the AlertaRecib table.
	 * 
	 * @param alertaRecib
	 *            AlertaRecib
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AlertaRecib alertaRecib) {
		this.alertaRecibDao.remove(alertaRecib);
	}

	/**
	 * Deletes multiple rows in the AlertaRecib table.
	 * 
	 * @param alertaRecibList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<AlertaRecib> alertaRecibList) {
		for (AlertaRecib alertaRecibAux : alertaRecibList) {
			this.alertaRecibDao.remove(alertaRecibAux);
		}
	}

	/**
	 * Getter method for AlertaRecibDao
	 * 
	 * @return AlertaRecibDao
	 */
	public AlertaRecibDao getAlertaRecibDao() {
		return this.alertaRecibDao;
	}

	/**
	 * Setter method for AlertaRecibDao.
	 * 
	 * @param alertaRecibDao
	 *            AlertaRecibDao
	 * @return
	 */
	public void setAlertaRecibDao(AlertaRecibDao alertaRecibDao) {
		logger.info("Setting Dependency " + alertaRecibDao);
		this.alertaRecibDao = alertaRecibDao;
	}
}
