package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ActaDao;
import com.ejie.y41a.dao.ActaInfraccionDao;
import com.ejie.y41a.dao.ActuacionDao;
import com.ejie.y41a.dao.CampahnaRecibDao;
import com.ejie.y41a.dao.InfracAlertaDao;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.ActaActuacionAlta;
import com.ejie.y41a.model.ActaInfraccion;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.ActuacionBusqueda;
import com.ejie.y41a.model.ActuacionDetalle;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.AlertaRecib;
import com.ejie.y41a.model.CampahnaActuacionBusqueda;
import com.ejie.y41a.model.CampahnaRecib;
import com.ejie.y41a.model.CampahnaRecibBusqueda;
import com.ejie.y41a.model.DenunciaRecib;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.InfracAlerta;
import com.ejie.y41a.model.Inspector;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.TipActuacion;
import com.ejie.y41a.model.TipReqNormativo;
import com.ejie.y41a.model.TipmotActuacion;
import com.ejie.y41a.model.Tipodoc;
import com.ejie.y41a.model.VisitaDetalle;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * ActuacionServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "actuacionService")
public class ActuacionServiceImpl implements ActuacionService {

	private static final Logger logger = LoggerFactory
			.getLogger(ActuacionServiceImpl.class);
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private ActaDao actaDao;
	@Autowired
	private CampahnaRecibDao campahnaRecibDao;
	@Autowired
	private InfracAlertaDao infracAlertaDao;
	@Autowired
	private ActaInfraccionDao actaInfraccionDao;

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actuacion add(Actuacion actuacion) {
		return this.actuacionDao.add(actuacion);
	}

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacionDetalle
	 *            ActaActuacionAlta
	 * @return ActaActuacionAlta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaActuacionAlta addActaActuacion(ActaActuacionAlta actuacionDetalle) {
		try {
			actuacionDetalle.setAccodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));

			Acta acta = new Acta(actuacionDetalle.getAccodigo(),
					actuacionDetalle.getAccoor(), actuacionDetalle.getAcnror(),
					actuacionDetalle.getAcnran(), actuacionDetalle.getAcfele(),
					actuacionDetalle.getAcfere(), null, null, null, null,
					actuacionDetalle.getAcnoco(),
					actuacionDetalle.getAcape1co(),
					actuacionDetalle.getAcape2co(),
					actuacionDetalle.getAcdnico(),
					actuacionDetalle.getAccoco(),
					actuacionDetalle.getAcdirco(),
					actuacionDetalle.getAccoloco(),
					actuacionDetalle.getAcnrcpco(),
					actuacionDetalle.getAcnrtfco(),
					actuacionDetalle.getAcnoraPaisId(),
					actuacionDetalle.getAcnoraPaisNombre(),
					actuacionDetalle.getAcnoraProvinciaId(),
					actuacionDetalle.getAcnombreProvincia(),
					actuacionDetalle.getAcnoraMunicipioId(),
					actuacionDetalle.getAcnombreMunicipio(),
					actuacionDetalle.getAcnoraLocalidadId(),
					actuacionDetalle.getAcnombreLocalidad(),
					actuacionDetalle.getAcnoraCalleId(),
					actuacionDetalle.getAcnombreCalle(),
					actuacionDetalle.getAcnoraCpId(),
					actuacionDetalle.getAcnombreCp(),
					actuacionDetalle.getAcnoraPortalId(),
					actuacionDetalle.getAcnombrePortal(),
					actuacionDetalle.getAcnombrePiso(),
					actuacionDetalle.getAcdireccion_nocapv(), new Inspector(
							actuacionDetalle.getAccoindo(), null, null),
					new Inspector(actuacionDetalle.getAccoinun(), null, null),
					new Tipodoc(actuacionDetalle.getTdcodigo(), null),
					new Establecimiento(actuacionDetalle.getEscodigoVisita(),
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null));

			this.actaDao.add(acta);

			actuacionDetalle.setAtcodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));

			Actuacion actuacion = new Actuacion(actuacionDetalle.getAtcodigo(),
					actuacionDetalle.getAtnror(), null, null,
					actuacionDetalle.getAtnoprse(),
					actuacionDetalle.getAtnomaps(),
					actuacionDetalle.getAtnomops(),
					actuacionDetalle.getAtnrlops(),
					actuacionDetalle.getAtfedumi(),
					actuacionDetalle.getAtinprse(),
					actuacionDetalle.getAtcaunep(),
					actuacionDetalle.getAtteinfo(), null, null, acta,
					new CampahnaRecib(actuacionDetalle.getS4codigo(), null,
							null, null, null, null), new Establecimiento(
							actuacionDetalle.getEscodigoActuacion(), null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null), new Producto(
							actuacionDetalle.getPscodigoActuacion(), null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null), new DenunciaRecib(
							actuacionDetalle.getS6codigo(), null, null, null,
							null, null), new AlertaRecib(
							actuacionDetalle.getS5codigo(), null, null, null,
							null, null, null), new TipActuacion(
							actuacionDetalle.getTtacodigo(), null),
					new TipmotActuacion(actuacionDetalle.getTmacodigo(), null));

			this.actuacionDao.addActuacion(actuacion);

			if (Y41aUtils.isFilled(actuacionDetalle.getS4codigo())) {
				CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
				campahnaRecibBusqueda.setCodOrganismo(actuacionDetalle
						.getAccoor());
				campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
				campahnaRecibBusqueda.setCodigoRecibida(actuacionDetalle
						.getS4codigo());

				campahnaRecibBusqueda = this.campahnaRecibDao
						.findCampahnaRecib(campahnaRecibBusqueda);

				if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
					throw new Y41aUDAException(
							"error.campahna.CerradaException", true,
							new Exception());
				}
			} else if (Y41aUtils.isFilled(actuacionDetalle.getS5codigo())) {
				CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
				campahnaRecibBusqueda.setCodOrganismo(actuacionDetalle
						.getAccoor());
				campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
				campahnaRecibBusqueda.setCodigoRecibida(actuacionDetalle
						.getS5codigo());

				campahnaRecibBusqueda = this.campahnaRecibDao
						.findCampahnaRecib(campahnaRecibBusqueda);

				if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
					throw new Y41aUDAException("error.alerta.CerradaException",
							true, new Exception());
				}

				InfracAlerta infracalerta = new InfracAlerta();
				Alerta alerta = new Alerta();
				alerta.setAlcodigo(campahnaRecibBusqueda.getCodigoDetalle());
				infracalerta.setAlerta(alerta);

				List<InfracAlerta> listInfracAlerta = this.infracAlertaDao
						.findAll(infracalerta, null);

				for (InfracAlerta infracAlertaAux : listInfracAlerta) {

					ActaInfraccion actaInfraccion = new ActaInfraccion();
					Actuacion actuacionAux = new Actuacion();
					actuacionAux.setAtcodigo(actuacionDetalle.getAtcodigo());

					TipReqNormativo tipReqNormativoAux = new TipReqNormativo();
					tipReqNormativoAux.setTticodigo(infracAlertaAux
							.getTipReqNormativo().getTticodigo());

					actaInfraccion.setActuacion(actuacionAux);
					actaInfraccion.setTipReqNormativo(tipReqNormativoAux);
					actaInfraccion.setAicodigo(Y41aUIDGenerator.getInstance()
							.generateId(Y41aConstantes.PK_SIZE));
					actaInfraccion.setAiinexii(Y41aConstantes.VALOR_SI);
					this.actaInfraccionDao.add(actaInfraccion);
				}
			} else if (Y41aUtils.isFilled(actuacionDetalle.getS6codigo())) {
				CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
				campahnaRecibBusqueda.setCodOrganismo(actuacionDetalle
						.getAccoor());
				campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
				campahnaRecibBusqueda.setCodigoRecibida(actuacionDetalle
						.getS6codigo());

				campahnaRecibBusqueda = this.campahnaRecibDao
						.findCampahnaRecib(campahnaRecibBusqueda);

				if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
					throw new Y41aUDAException(
							"error.denuncia.CerradaException", true,
							new Exception());
				}
			}

			return actuacionDetalle;
		} catch (DuplicateKeyException e) {
			throw new Y41aUDAException("error.acta.DuplicateKeyException",
					true, e);
		}
	}

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacionDetalle
	 *            ActuacionDetalle
	 * @return ActuacionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaActuacionAlta addActuacion(ActaActuacionAlta actuacionDetalle) {

		Acta acta = new Acta(actuacionDetalle.getAccodigo(),
				actuacionDetalle.getAccoor(), actuacionDetalle.getAcnror(),
				actuacionDetalle.getAcnran(), actuacionDetalle.getAcfele(),
				actuacionDetalle.getAcfere(), null, null, null, null,
				actuacionDetalle.getAcnoco(), actuacionDetalle.getAcape1co(),
				actuacionDetalle.getAcape2co(), actuacionDetalle.getAcdnico(),
				actuacionDetalle.getAccoco(), actuacionDetalle.getAcdirco(),
				actuacionDetalle.getAccoloco(), actuacionDetalle.getAcnrcpco(),
				actuacionDetalle.getAcnrtfco(),
				actuacionDetalle.getAcnoraPaisId(),
				actuacionDetalle.getAcnoraPaisNombre(),
				actuacionDetalle.getAcnoraProvinciaId(),
				actuacionDetalle.getAcnombreProvincia(),
				actuacionDetalle.getAcnoraMunicipioId(),
				actuacionDetalle.getAcnombreMunicipio(),
				actuacionDetalle.getAcnoraLocalidadId(),
				actuacionDetalle.getAcnombreLocalidad(),
				actuacionDetalle.getAcnoraCalleId(),
				actuacionDetalle.getAcnombreCalle(),
				actuacionDetalle.getAcnoraCpId(),
				actuacionDetalle.getAcnombreCp(),
				actuacionDetalle.getAcnoraPortalId(),
				actuacionDetalle.getAcnombrePortal(),
				actuacionDetalle.getAcnombrePiso(),
				actuacionDetalle.getAcdireccion_nocapv(), new Inspector(
						actuacionDetalle.getAccoindo(), null, null),
				new Inspector(actuacionDetalle.getAccoinun(), null, null),
				new Tipodoc(actuacionDetalle.getTdcodigo(), null),
				new Establecimiento(actuacionDetalle.getEscodigoVisita(), null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null));

		this.actaDao.update(acta);

		actuacionDetalle.setAtcodigo(Y41aUIDGenerator.getInstance().generateId(
				Y41aConstantes.PK_SIZE));

		Actuacion actuacion = new Actuacion(actuacionDetalle.getAtcodigo(),
				actuacionDetalle.getAtnror(), null, null,
				actuacionDetalle.getAtnoprse(), actuacionDetalle.getAtnomaps(),
				actuacionDetalle.getAtnomops(), actuacionDetalle.getAtnrlops(),
				actuacionDetalle.getAtfedumi(), actuacionDetalle.getAtinprse(),
				actuacionDetalle.getAtcaunep(), actuacionDetalle.getAtteinfo(),
				null, null, new Acta(actuacionDetalle.getAccodigo(), null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null), new CampahnaRecib(
						actuacionDetalle.getS4codigo(), null, null, null, null,
						null), new Establecimiento(
						actuacionDetalle.getEscodigoActuacion(), null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null), new Producto(
						actuacionDetalle.getPscodigoActuacion(), null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null),
				new DenunciaRecib(actuacionDetalle.getS6codigo(), null, null,
						null, null, null), new AlertaRecib(
						actuacionDetalle.getS5codigo(), null, null, null, null,
						null, null), new TipActuacion(
						actuacionDetalle.getTtacodigo(), null),
				new TipmotActuacion(actuacionDetalle.getTmacodigo(), null));

		this.actuacionDao.addActuacion(actuacion);

		if (Y41aUtils.isFilled(actuacionDetalle.getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(actuacionDetalle.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacionDetalle
					.getS4codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.campahna.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actuacionDetalle.getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(actuacionDetalle.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacionDetalle
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.alerta.CerradaException",
						true, new Exception());
			}

			InfracAlerta infracalerta = new InfracAlerta();
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(campahnaRecibBusqueda.getCodigoDetalle());
			infracalerta.setAlerta(alerta);

			List<InfracAlerta> listInfracAlerta = this.infracAlertaDao.findAll(
					infracalerta, null);

			for (InfracAlerta infracAlertaAux : listInfracAlerta) {

				ActaInfraccion actaInfraccion = new ActaInfraccion();
				Actuacion actuacionAux = new Actuacion();
				actuacionAux.setAtcodigo(actuacionDetalle.getAtcodigo());

				TipReqNormativo tipReqNormativoAux = new TipReqNormativo();
				tipReqNormativoAux.setTticodigo(infracAlertaAux
						.getTipReqNormativo().getTticodigo());

				actaInfraccion.setActuacion(actuacionAux);
				actaInfraccion.setTipReqNormativo(tipReqNormativoAux);
				actaInfraccion.setAicodigo(Y41aUIDGenerator.getInstance()
						.generateId(Y41aConstantes.PK_SIZE));
				actaInfraccion.setAiinexii(Y41aConstantes.VALOR_SI);
				this.actaInfraccionDao.add(actaInfraccion);
			}
		} else if (Y41aUtils.isFilled(actuacionDetalle.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(actuacionDetalle.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacionDetalle
					.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.denuncia.CerradaException",
						true, new Exception());
			}
		}

		return actuacionDetalle;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actuacion update(Actuacion actuacion) {
		return this.actuacionDao.update(actuacion);
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param visitaDetalle
	 *            VisitaDetalle
	 * @return VisitaDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VisitaDetalle updateActa(VisitaDetalle visitaDetalle) {

		Acta acta = new Acta(visitaDetalle.getAccodigo(),
				visitaDetalle.getAccoor(), visitaDetalle.getAcnror(),
				visitaDetalle.getAcnran(), visitaDetalle.getAcfele(),
				visitaDetalle.getAcfere(), null, null, null, null,
				visitaDetalle.getAcnoco(), visitaDetalle.getAcape1co(),
				visitaDetalle.getAcape2co(), visitaDetalle.getAcdnico(),
				visitaDetalle.getAccoco(), visitaDetalle.getAcdirco(),
				visitaDetalle.getAccoloco(), visitaDetalle.getAcnrcpco(),
				visitaDetalle.getAcnrtfco(), visitaDetalle.getAcnoraPaisId(),
				visitaDetalle.getAcnoraPaisNombre(),
				visitaDetalle.getAcnoraProvinciaId(),
				visitaDetalle.getAcnombreProvincia(),
				visitaDetalle.getAcnoraMunicipioId(),
				visitaDetalle.getAcnombreMunicipio(),
				visitaDetalle.getAcnoraLocalidadId(),
				visitaDetalle.getAcnombreLocalidad(),
				visitaDetalle.getAcnoraCalleId(),
				visitaDetalle.getAcnombreCalle(),
				visitaDetalle.getAcnoraCpId(), visitaDetalle.getAcnombreCp(),
				visitaDetalle.getAcnoraPortalId(),
				visitaDetalle.getAcnombrePortal(),
				visitaDetalle.getAcnombrePiso(),
				visitaDetalle.getAcdireccion_nocapv(), new Inspector(
						visitaDetalle.getAccoindo(), null, null),
				new Inspector(visitaDetalle.getAccoinun(), null, null),
				new Tipodoc(visitaDetalle.getTdcodigo(), null),
				new Establecimiento(visitaDetalle.getEscodigoVisita(), null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null));

		this.actaDao.update(acta);

		if (Y41aUtils.isFilled(visitaDetalle.getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(visitaDetalle.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda
					.setCodigoRecibida(visitaDetalle.getS4codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.campahna.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(visitaDetalle.getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(visitaDetalle.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda
					.setCodigoRecibida(visitaDetalle.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.alerta.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(visitaDetalle.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(visitaDetalle.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda
					.setCodigoRecibida(visitaDetalle.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.denuncia.CerradaException",
						true, new Exception());
			}
		}

		return visitaDetalle;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacionDetalle
	 *            ActuacionDetalle
	 * @return ActuacionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActuacionDetalle updateActuacion(ActuacionDetalle actuacionDetalle) {

		Acta acta = new Acta();
		acta.setAccodigo(actuacionDetalle.getAccodigo());

		Actuacion actuacion = new Actuacion(actuacionDetalle.getAtcodigo(),
				actuacionDetalle.getAtnror(), null, null,
				actuacionDetalle.getAtnoprse(), actuacionDetalle.getAtnomaps(),
				actuacionDetalle.getAtnomops(), actuacionDetalle.getAtnrlops(),
				actuacionDetalle.getAtfedumi(), actuacionDetalle.getAtinprse(),
				actuacionDetalle.getAtcaunep(), actuacionDetalle.getAtteinfo(),
				null, null, acta, new CampahnaRecib(
						actuacionDetalle.getS4codigo(), null, null, null, null,
						null), new Establecimiento(
						actuacionDetalle.getEscodigoActuacion(), null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null), new Producto(
						actuacionDetalle.getPscodigoActuacion(), null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null),
				new DenunciaRecib(actuacionDetalle.getS6codigo(), null, null,
						null, null, null), new AlertaRecib(
						actuacionDetalle.getS5codigo(), null, null, null, null,
						null, null), new TipActuacion(
						actuacionDetalle.getTtacodigo(), null),
				new TipmotActuacion(actuacionDetalle.getTmacodigo(), null));

		this.actuacionDao.update(actuacion);

		if (Y41aUtils.isFilled(actuacionDetalle.getS4codigo())) {
			ActaActuacionAlta actaActuacionAlta = this.actuacionDao
					.findActuacion(actuacion);
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacionDetalle
					.getS4codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.campahna.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actuacionDetalle.getS5codigo())) {
			ActaActuacionAlta actaActuacionAlta = this.actuacionDao
					.findActuacion(actuacion);
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacionDetalle
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.alerta.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actuacionDetalle.getS6codigo())) {
			ActaActuacionAlta actaActuacionAlta = this.actuacionDao
					.findActuacion(actuacion);
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacionDetalle
					.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.denuncia.CerradaException",
						true, new Exception());
			}
		}

		return actuacionDetalle;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion find(Actuacion actuacion) {
		return (Actuacion) this.actuacionDao.find(actuacion);
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return ActuacionDetalle
	 */
	public VisitaDetalle findActa(Actuacion actuacion) {
		ActaActuacionAlta actaActuacionAlta = this.actuacionDao
				.findActuacion(actuacion);

		if (Y41aUtils.isFilled(actaActuacionAlta.getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS4codigo());
			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			actaActuacionAlta.setTipo(campahnaRecibBusqueda.getTipo());
			actaActuacionAlta.setCodigo(campahnaRecibBusqueda.getCodigo());
			actaActuacionAlta.setDescripcion(campahnaRecibBusqueda
					.getDescripcion());

		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			actaActuacionAlta.setTipo(campahnaRecibBusqueda.getTipo());
			actaActuacionAlta.setCodigo(campahnaRecibBusqueda.getCodigo());
			actaActuacionAlta.setDescripcion(campahnaRecibBusqueda
					.getDescripcion());
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			actaActuacionAlta.setTipo(campahnaRecibBusqueda.getTipo());
			actaActuacionAlta.setCodigo(campahnaRecibBusqueda.getCodigo());
			actaActuacionAlta.setDescripcion(campahnaRecibBusqueda
					.getDescripcion());
		}

		VisitaDetalle visitaDetalle = new VisitaDetalle(
				actaActuacionAlta.getTipo(), actaActuacionAlta.getCodigo(),
				actaActuacionAlta.getDescripcion(),
				actaActuacionAlta.getAccodigo(), actaActuacionAlta.getAccoor(),
				actaActuacionAlta.getAcnror(), actaActuacionAlta.getAcnran(),
				actaActuacionAlta.getAcfele(), actaActuacionAlta.getAcfere(),
				actaActuacionAlta.getAccoinun(),
				actaActuacionAlta.getAccoindo(),
				actaActuacionAlta.getTdcodigo(),
				actaActuacionAlta.getTdnombre(), actaActuacionAlta.getAcnoco(),
				actaActuacionAlta.getAcape1co(),
				actaActuacionAlta.getAcape2co(),
				actaActuacionAlta.getAcdnico(), actaActuacionAlta.getAccoco(),
				actaActuacionAlta.getAcdirco(),
				actaActuacionAlta.getAccoloco(),
				actaActuacionAlta.getAcnrcpco(),
				actaActuacionAlta.getAcnrtfco(),
				actaActuacionAlta.getAcnoraPaisId(),
				actaActuacionAlta.getAcnoraPaisNombre(),
				actaActuacionAlta.getAcnoraProvinciaId(),
				actaActuacionAlta.getAcnombreProvincia(),
				actaActuacionAlta.getAcnoraMunicipioId(),
				actaActuacionAlta.getAcnombreMunicipio(),
				actaActuacionAlta.getAcnoraLocalidadId(),
				actaActuacionAlta.getAcnombreLocalidad(),
				actaActuacionAlta.getAcnoraCalleId(),
				actaActuacionAlta.getAcnombreCalle(),
				actaActuacionAlta.getAcnoraCpId(),
				actaActuacionAlta.getAcnombreCp(),
				actaActuacionAlta.getAcnoraPortalId(),
				actaActuacionAlta.getAcnombrePortal(),
				actaActuacionAlta.getAcnombrePiso(),
				actaActuacionAlta.getAcdireccion_nocapv(),
				actaActuacionAlta.getDirAntiguaCompletaCompareciente(),
				actaActuacionAlta.getEscodigoVisita(),
				actaActuacionAlta.getEsnombreVisita(),
				actaActuacionAlta.getEsnifVisita(),
				actaActuacionAlta.getEsnocoVisita(),
				actaActuacionAlta.getEsnodirVisita(),
				actaActuacionAlta.getEscoloVisita(),
				actaActuacionAlta.getEsnrcopoVisita(),
				actaActuacionAlta.getEsnrtelVisita(),
				actaActuacionAlta.getEsnrfaxVisita(),
				actaActuacionAlta.getEscopaVisita(),
				actaActuacionAlta.getEsinadarVisita(),
				actaActuacionAlta.getEsfeadarVisita(),
				actaActuacionAlta.getEscoemVisita(),
				actaActuacionAlta.getEsnrtel2Visita(),
				actaActuacionAlta.getEsfebaVisita(),
				actaActuacionAlta.getEsnoloVisita(),
				actaActuacionAlta.getEscomapvVisita(),
				actaActuacionAlta.getEscocaVisita(),
				actaActuacionAlta.getEsnomuVisita(),
				actaActuacionAlta.getEsteurlVisita(),
				actaActuacionAlta.getEsnoraPaisIdVisita(),
				actaActuacionAlta.getEsnoraPaisNombreVisita(),
				actaActuacionAlta.getProvinciaIdVisita(),
				actaActuacionAlta.getEsnombreProvinciaVisita(),
				actaActuacionAlta.getMunicipioIdVisita(),
				actaActuacionAlta.getEsnombreMunicipioVisita(),
				actaActuacionAlta.getLocalidadIdVisita(),
				actaActuacionAlta.getEsnombreLocalidadVisita(),
				actaActuacionAlta.getCalleIdVisita(),
				actaActuacionAlta.getCalleId_labelVisita(),
				actaActuacionAlta.getCpIdVisita(),
				actaActuacionAlta.getEsnombreCpVisita(),
				actaActuacionAlta.getPortalIdVisita(),
				actaActuacionAlta.getEsnombrePortalVisita(),
				actaActuacionAlta.getEsnombrePisoVisita(),
				actaActuacionAlta.getEsdireccion_nocapvVisita(),
				actaActuacionAlta.getEacodigoVisita(),
				actaActuacionAlta.getAvcodigoVisita(),
				actaActuacionAlta.getAvnombreVisita(),
				actaActuacionAlta.getAvnombreeVisita(),
				actaActuacionAlta.getSecodigoVisita(),
				actaActuacionAlta.getSenombreVisita(),
				actaActuacionAlta.getSenombreeVisita(),
				actaActuacionAlta.getEainprseVisita(),
				actaActuacionAlta.getDireccionAntiguaCompletaVisita(),
				actaActuacionAlta.getAtcodigo(), actaActuacionAlta.getAtnror(),
				actaActuacionAlta.getS4codigo(),
				actaActuacionAlta.getS5codigo(),
				actaActuacionAlta.getS6codigo());

		return visitaDetalle;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return ActuacionDetalle
	 */
	public ActuacionDetalle findActuacion(Actuacion actuacion) {
		ActaActuacionAlta actaActuacionAlta = this.actuacionDao
				.findActuacion(actuacion);

		if (Y41aUtils.isFilled(actaActuacionAlta.getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS4codigo());
			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			actaActuacionAlta.setTipo(campahnaRecibBusqueda.getTipo());
			actaActuacionAlta.setCodigo(campahnaRecibBusqueda.getCodigo());
			actaActuacionAlta.setDescripcion(campahnaRecibBusqueda
					.getDescripcion());

		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			actaActuacionAlta.setTipo(campahnaRecibBusqueda.getTipo());
			actaActuacionAlta.setCodigo(campahnaRecibBusqueda.getCodigo());
			actaActuacionAlta.setDescripcion(campahnaRecibBusqueda
					.getDescripcion());
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			actaActuacionAlta.setTipo(campahnaRecibBusqueda.getTipo());
			actaActuacionAlta.setCodigo(campahnaRecibBusqueda.getCodigo());
			actaActuacionAlta.setDescripcion(campahnaRecibBusqueda
					.getDescripcion());
		}

		ActuacionDetalle actuacionDetalle = new ActuacionDetalle(
				actaActuacionAlta.getTipo(), actaActuacionAlta.getCodigo(),
				actaActuacionAlta.getDescripcion(),
				actaActuacionAlta.getAccodigo(),
				actaActuacionAlta.getAtcodigo(), actaActuacionAlta.getAtnror(),
				actaActuacionAlta.getAtcotp(), actaActuacionAlta.getAtteinfo(),
				actaActuacionAlta.getTtacodigo(),
				actaActuacionAlta.getTtanombre(),
				actaActuacionAlta.getTmacodigo(),
				actaActuacionAlta.getTmanombre(),
				actaActuacionAlta.getEscodigoActuacion(),
				actaActuacionAlta.getEsnombreActuacion(),
				actaActuacionAlta.getEsnifActuacion(),
				actaActuacionAlta.getEsnocoActuacion(),
				actaActuacionAlta.getEsnodirActuacion(),
				actaActuacionAlta.getEscoloActuacion(),
				actaActuacionAlta.getEsnrcopoActuacion(),
				actaActuacionAlta.getEsnrtelActuacion(),
				actaActuacionAlta.getEsnrfaxActuacion(),
				actaActuacionAlta.getEscopaActuacion(),
				actaActuacionAlta.getEsinadarActuacion(),
				actaActuacionAlta.getEsfeadarActuacion(),
				actaActuacionAlta.getEscoemActuacion(),
				actaActuacionAlta.getEsnrtel2Actuacion(),
				actaActuacionAlta.getEsfebaActuacion(),
				actaActuacionAlta.getEsnoloActuacion(),
				actaActuacionAlta.getEscomapvActuacion(),
				actaActuacionAlta.getEscocaActuacion(),
				actaActuacionAlta.getEsnomuActuacion(),
				actaActuacionAlta.getEsteurlActuacion(),
				actaActuacionAlta.getEsnoraPaisIdActuacion(),
				actaActuacionAlta.getEsnoraPaisNombreActuacion(),
				actaActuacionAlta.getProvinciaIdActuacion(),
				actaActuacionAlta.getEsnombreProvinciaActuacion(),
				actaActuacionAlta.getMunicipioIdActuacion(),
				actaActuacionAlta.getEsnombreMunicipioActuacion(),
				actaActuacionAlta.getLocalidadIdActuacion(),
				actaActuacionAlta.getEsnombreLocalidadActuacion(),
				actaActuacionAlta.getCalleIdActuacion(),
				actaActuacionAlta.getCalleId_labelActuacion(),
				actaActuacionAlta.getCpIdActuacion(),
				actaActuacionAlta.getEsnombreCpActuacion(),
				actaActuacionAlta.getPortalIdActuacion(),
				actaActuacionAlta.getEsnombrePortalActuacion(),
				actaActuacionAlta.getEsnombrePisoActuacion(),
				actaActuacionAlta.getEsdireccion_nocapvActuacion(),
				actaActuacionAlta.getEacodigoActuacion(),
				actaActuacionAlta.getAvcodigoActuacion(),
				actaActuacionAlta.getAvnombreActuacion(),
				actaActuacionAlta.getAvnombreeActuacion(),
				actaActuacionAlta.getSecodigoActuacion(),
				actaActuacionAlta.getSenombreActuacion(),
				actaActuacionAlta.getSenombreeActuacion(),
				actaActuacionAlta.getEainprseActuacion(),
				actaActuacionAlta.getDireccionAntiguaCompletaActuacion(),
				actaActuacionAlta.getPscodigoActuacion(),
				actaActuacionAlta.getPsnombreActuacion(),
				actaActuacionAlta.getPsnombreeActuacion(),
				actaActuacionAlta.getAtnoprse(),
				actaActuacionAlta.getAtnomaps(),
				actaActuacionAlta.getAtnomops(),
				actaActuacionAlta.getAtnrlops(),
				actaActuacionAlta.getAtfedumi(),
				actaActuacionAlta.getS4codigo(),
				actaActuacionAlta.getS5codigo(),
				actaActuacionAlta.getS6codigo(),
				actaActuacionAlta.getAtinprse(),
				actaActuacionAlta.getAtcaunep());

		return actuacionDetalle;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return ActuacionDetalle
	 */
	public ActaActuacionAlta findActaActuacion(Actuacion actuacion) {
		ActaActuacionAlta actaActuacionAlta = this.actuacionDao
				.findActuacion(actuacion);

		if (Y41aUtils.isFilled(actaActuacionAlta.getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS4codigo());
			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			actaActuacionAlta.setTipo(campahnaRecibBusqueda.getTipo());
			actaActuacionAlta.setCodigo(campahnaRecibBusqueda.getCodigo());
			actaActuacionAlta.setDescripcion(campahnaRecibBusqueda
					.getDescripcion());

		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			actaActuacionAlta.setTipo(campahnaRecibBusqueda.getTipo());
			actaActuacionAlta.setCodigo(campahnaRecibBusqueda.getCodigo());
			actaActuacionAlta.setDescripcion(campahnaRecibBusqueda
					.getDescripcion());
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			actaActuacionAlta.setTipo(campahnaRecibBusqueda.getTipo());
			actaActuacionAlta.setCodigo(campahnaRecibBusqueda.getCodigo());
			actaActuacionAlta.setDescripcion(campahnaRecibBusqueda
					.getDescripcion());
		}

		return actaActuacionAlta;
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Actuacion> findAll(Actuacion actuacion, Pagination pagination) {
		return (List<Actuacion>) this.actuacionDao.findAll(actuacion,
				pagination);
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllCount(Actuacion actuacion) {
		return this.actuacionDao.findAllCount(actuacion);
	}

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Actuacion> findAllLike(Actuacion actuacion,
			Pagination pagination, Boolean startsWith) {
		return (List<Actuacion>) this.actuacionDao.findAllLike(actuacion,
				pagination, startsWith);
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param campahnaActuacionBusqueda
	 *            CampahnaActuacionBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CampahnaActuacionBusqueda> findAllCampahnaActuacion(
			CampahnaActuacionBusqueda campahnaActuacionBusqueda,
			Pagination pagination) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("numeroActa")) {
				pagination.setSort("accoor, acnran, acnror");
			}
		}

		List<CampahnaActuacionBusqueda> listCampahnaActuacionBusqueda = this.actuacionDao
				.findAllCampahnaActuacion(campahnaActuacionBusqueda, pagination);

		for (CampahnaActuacionBusqueda campahnaActuacionBusquedaAux : listCampahnaActuacionBusqueda) {
			StringBuffer numeroActa = new StringBuffer();

			numeroActa.append(campahnaActuacionBusquedaAux.getAccoor())
					.append("-")
					.append(campahnaActuacionBusquedaAux.getAcnror())
					.append("-")
					.append(campahnaActuacionBusquedaAux.getAcnran());

			campahnaActuacionBusquedaAux.setNumeroActa(numeroActa.toString());
		}

		return listCampahnaActuacionBusqueda;
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param campahnaActuacionBusqueda
	 *            CampahnaActuacionBusqueda
	 * @return Long
	 */
	public Long findAllCampahnaActuacionCount(
			CampahnaActuacionBusqueda campahnaActuacionBusqueda) {
		return this.actuacionDao
				.findAllCampahnaActuacionCount(campahnaActuacionBusqueda);
	}

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacionBusqueda
	 *            ActuacionBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ActuacionBusqueda> findAllLikeActuacion(
			ActuacionBusqueda actuacionBusqueda, Pagination pagination,
			Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("numeroActuacion")) {
				pagination.setSort("accoor, acnran, acnror");
			}
		}

		List<ActuacionBusqueda> listActuacionBusqueda = this.actuacionDao
				.findAllLikeActuacion(actuacionBusqueda, pagination, startsWith);

		for (ActuacionBusqueda actuacionBusquedaAux : listActuacionBusqueda) {
			StringBuffer numeroActuacion = new StringBuffer();

			numeroActuacion.append(actuacionBusquedaAux.getAccoor())
					.append("-").append(actuacionBusquedaAux.getAcnror())
					.append("-").append(actuacionBusquedaAux.getAcnran());

			actuacionBusquedaAux.setNumeroActuacion(numeroActuacion.toString());

			if (Y41aUtils.isFilled(actuacionBusquedaAux.getAtcocm())) {
				actuacionBusquedaAux
						.setTipoExpediente(Y41aConstantes.TIPO_CAMPAHNA);
			} else if (Y41aUtils.isFilled(actuacionBusquedaAux.getAtcoal())) {
				actuacionBusquedaAux
						.setTipoExpediente(Y41aConstantes.TIPO_ALERTA);
			} else if (Y41aUtils.isFilled(actuacionBusquedaAux.getAtcohd())) {
				actuacionBusquedaAux
						.setTipoExpediente(Y41aConstantes.TIPO_DENUNCIA);
			}
		}

		return listActuacionBusqueda;
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacionBusqueda
	 *            ActuacionBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeActuacionCount(ActuacionBusqueda actuacionBusqueda,
			Boolean startsWith) {
		return this.actuacionDao.findAllLikeActuacionCount(actuacionBusqueda,
				startsWith);
	}

	/**
	 * Deletes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Actuacion actuacion) {
		this.actuacionDao.remove(actuacion);
	}

	/**
	 * Deletes multiple rows in the Actuacion table.
	 * 
	 * @param actuacionList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Actuacion> actuacionList) {
		for (Actuacion actuacionAux : actuacionList) {
			this.actuacionDao.remove(actuacionAux);
		}
	}

	/**
	 * Getter method for ActuacionDao
	 * 
	 * @return ActuacionDao
	 */
	public ActuacionDao getActuacionDao() {
		return this.actuacionDao;
	}

	/**
	 * Setter method for ActuacionDao.
	 * 
	 * @param actuacionDao
	 *            ActuacionDao
	 * @return
	 */
	public void setActuacionDao(ActuacionDao actuacionDao) {
		logger.info("Setting Dependency " + actuacionDao);
		this.actuacionDao = actuacionDao;
	}
}
