package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.ActaActuacionAlta;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.ActuacionBusqueda;
import com.ejie.y41a.model.ActuacionDetalle;
import com.ejie.y41a.model.CampahnaActuacionBusqueda;
import com.ejie.y41a.model.VisitaDetalle;

/**
 * * ActuacionService generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

public interface ActuacionService {

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion add(Actuacion actuacion);

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacionDetalle
	 *            ActaActuacionAlta
	 * @return ActaActuacionAlta
	 */
	ActaActuacionAlta addActaActuacion(ActaActuacionAlta actuacionDetalle);

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacionDetalle
	 *            ActuacionDetalle
	 * @return ActuacionDetalle
	 */
	ActaActuacionAlta addActuacion(ActaActuacionAlta actuacionDetalle);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion update(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param visitaDetalle
	 *            VisitaDetalle
	 * @return VisitaDetalle
	 */
	VisitaDetalle updateActa(VisitaDetalle visitaDetalle);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacionDetalle
	 *            ActuacionDetalle
	 * @return ActuacionDetalle
	 */
	ActuacionDetalle updateActuacion(ActuacionDetalle actuacionDetalle);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion find(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return ActuacionDetalle
	 */
	VisitaDetalle findActa(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return ActuacionDetalle
	 */
	ActuacionDetalle findActuacion(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return ActuacionDetalle
	 */
	ActaActuacionAlta findActaActuacion(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Actuacion> findAll(Actuacion actuacion, Pagination pagination);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findAllCount(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param campahnaActuacionBusqueda
	 *            CampahnaActuacionBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CampahnaActuacionBusqueda> findAllCampahnaActuacion(
			CampahnaActuacionBusqueda campahnaActuacionBusqueda,
			Pagination pagination);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param campahnaActuacionBusqueda
	 *            CampahnaActuacionBusqueda
	 * @return Long
	 */
	Long findAllCampahnaActuacionCount(
			CampahnaActuacionBusqueda campahnaActuacionBusqueda);

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Actuacion> findAllLike(Actuacion actuacion, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacionBusqueda
	 *            ActuacionBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ActuacionBusqueda> findAllLikeActuacion(
			ActuacionBusqueda actuacionBusqueda, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacionBusqueda
	 *            ActuacionBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeActuacionCount(ActuacionBusqueda actuacionBusqueda,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	void remove(Actuacion actuacion);

	/**
	 * Deletes multiple rows in the Actuacion table.
	 * 
	 * @param actuacionList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Actuacion> actuacionList);

}
