package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.ActividadDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Actividad;

/**
 *  * ActividadServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 *  
 */

@Service(value = "actividadService")
public  class ActividadServiceImpl implements ActividadService {

	private static final  Logger logger = LoggerFactory.getLogger(ActividadServiceImpl.class);
	@Autowired
	private ActividadDao actividadDao;

	/**
	 * Inserts a single row in the Actividad table.
	 *
	 * @param actividad Actividad
	 * @return Actividad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actividad add(Actividad actividad) {
		return this.actividadDao.add(actividad);
	}

	/**
	 * Updates a single row in the Actividad table.
	 *
	 * @param actividad Actividad
	 * @return Actividad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actividad update(Actividad actividad) {
		return this.actividadDao.update(actividad);
	 }

	/**
	 * Finds a single row in the Actividad table.
	 *
	 * @param actividad Actividad
	 * @return Actividad
	 */
	public Actividad find(Actividad actividad) {
		return (Actividad) this.actividadDao.find(actividad);
	}

	/**
	 * Finds a List of rows in the Actividad table.
	 *
	 * @param actividad Actividad
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Actividad> findAll(Actividad actividad, Pagination pagination) {
		return (List<Actividad>) this.actividadDao.findAll(actividad, pagination);
	}
    
	/**
	 * Counts rows in the Actividad table.
	 *
	 * @param actividad Actividad
	 * @return Long
	 */
	public Long findAllCount(Actividad actividad) {        
		return  this.actividadDao.findAllCount(actividad);
	}

	/**
	 * Finds rows in the Actividad table using like.
	 *
	 * @param actividad Actividad
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Actividad> findAllLike(Actividad actividad, Pagination pagination, Boolean startsWith) {
		return (List<Actividad>) this.actividadDao.findAllLike(actividad, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the Actividad table.
	 *
	 * @param actividad Actividad
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Actividad actividad) {
		this.actividadDao.remove(actividad);
	}
	
	/**
	 * Deletes multiple rows in the Actividad table.
	 *
	 * @param actividadList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Actividad> actividadList) {
		for (Actividad  actividadAux:actividadList) {
			this.actividadDao.remove(actividadAux);
		}
	}


	/**
	 * Getter method for ActividadDao
	 *
	 * @return ActividadDao
	 */
	public ActividadDao getActividadDao() {
		return this.actividadDao;
	}
    
	/**
	 * Setter method for ActividadDao.
	 *
	 * @param  actividadDao ActividadDao
	 * @return
	 */
	public void setActividadDao(ActividadDao actividadDao) {
		logger.info("Setting Dependency "+actividadDao);
		this.actividadDao = actividadDao;
	}
}

