package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.ActaDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Acta;

/**
 *  * ActaServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "actaService")
public  class ActaServiceImpl implements ActaService {

	private static final  Logger logger = LoggerFactory.getLogger(ActaServiceImpl.class);
	@Autowired
	private ActaDao actaDao;

	/**
	 * Inserts a single row in the Acta table.
	 *
	 * @param acta Acta
	 * @return Acta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Acta add(Acta acta) {
		return this.actaDao.add(acta);
	}

	/**
	 * Updates a single row in the Acta table.
	 *
	 * @param acta Acta
	 * @return Acta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Acta update(Acta acta) {
		return this.actaDao.update(acta);
	 }

	/**
	 * Finds a single row in the Acta table.
	 *
	 * @param acta Acta
	 * @return Acta
	 */
	public Acta find(Acta acta) {
		return (Acta) this.actaDao.find(acta);
	}

	/**
	 * Finds a List of rows in the Acta table.
	 *
	 * @param acta Acta
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Acta> findAll(Acta acta, Pagination pagination) {
		return (List<Acta>) this.actaDao.findAll(acta, pagination);
	}
    
	/**
	 * Counts rows in the Acta table.
	 *
	 * @param acta Acta
	 * @return Long
	 */
	public Long findAllCount(Acta acta) {        
		return  this.actaDao.findAllCount(acta);
	}

	/**
	 * Finds rows in the Acta table using like.
	 *
	 * @param acta Acta
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Acta> findAllLike(Acta acta, Pagination pagination, Boolean startsWith) {
		return (List<Acta>) this.actaDao.findAllLike(acta, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the Acta table.
	 *
	 * @param acta Acta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Acta acta) {
		this.actaDao.remove(acta);
	}
	
	/**
	 * Deletes multiple rows in the Acta table.
	 *
	 * @param actaList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Acta> actaList) {
		for (Acta  actaAux:actaList) {
			this.actaDao.remove(actaAux);
		}
	}


	/**
	 * Getter method for ActaDao
	 *
	 * @return ActaDao
	 */
	public ActaDao getActaDao() {
		return this.actaDao;
	}
    
	/**
	 * Setter method for ActaDao.
	 *
	 * @param  actaDao ActaDao
	 * @return
	 */
	public void setActaDao(ActaDao actaDao) {
		logger.info("Setting Dependency "+actaDao);
		this.actaDao = actaDao;
	}
}

