package com.ejie.y41a.service;


import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41a.model.Acta;

/**
 *  * ActaService generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

public interface ActaService {

	/**
	 * Inserts a single row in the Acta table.
	 *
	 * @param acta Acta
	 * @return Acta
	 */
    Acta add(Acta acta);

	/**
	 * Updates a single row in the Acta table.
	 *
	 * @param acta Acta
	 * @return Acta
	 */
	Acta update(Acta acta);

	/**
	 * Finds a single row in the Acta table.
	 *
	 * @param acta Acta
	 * @return Acta
	 */
	Acta find(Acta acta);

	/**
	 * Finds a List of rows in the Acta table.
	 *
	 * @param acta Acta
	 * @param pagination Pagination
	 * @return List
	 */
	List<Acta> findAll(Acta acta, Pagination pagination);

	/**
	 * Counts rows in the Acta table.
	 *
	 * @param acta Acta
	 * @return Long
	 */
	Long findAllCount(Acta acta);
	
	/**
	 * Finds rows in the Acta table using like.
	 *
	 * @param acta Acta
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Acta> findAllLike(Acta acta, Pagination pagination, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Acta table.
	 *
	 * @param acta Acta
	 * @return 
	 */
	void remove(Acta acta);
	
	/**
	 * Deletes multiple rows in the Acta table.
	 *
	 * @param actaList  ArrayList
	 * @return 
	 */	
	void removeMultiple(ArrayList<Acta> actaList);
    
}


