package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ActaInfraccionDao;
import com.ejie.y41a.dao.ActuacionDao;
import com.ejie.y41a.dao.CampahnaRecibDao;
import com.ejie.y41a.model.ActaActuacionAlta;
import com.ejie.y41a.model.ActaInfraccion;
import com.ejie.y41a.model.ActaInfraccionBusqueda;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.CampahnaRecibBusqueda;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * ActaInfraccionServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "actaInfraccionService")
public class ActaInfraccionServiceImpl implements ActaInfraccionService {

	private static final Logger logger = LoggerFactory
			.getLogger(ActaInfraccionServiceImpl.class);
	@Autowired
	private ActaInfraccionDao actaInfraccionDao;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private CampahnaRecibDao campahnaRecibDao;

	/**
	 * Inserts a single row in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaInfraccion add(ActaInfraccion actaInfraccion) {
		return this.actaInfraccionDao.add(actaInfraccion);
	}

	/**
	 * Inserts a single row in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaInfraccion addConstatacion(ActaInfraccion actaInfraccion) {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(actaInfraccion.getActuacion().getAtcodigo());

		ActaActuacionAlta actaActuacionAlta = this.actuacionDao
				.findActuacion(actuacion);

		if (Y41aUtils.isFilled(actaActuacionAlta.getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS4codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.campahna.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.alerta.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.denuncia.CerradaException",
						true, new Exception());
			}
		}

		ActaInfraccion actaInfraccionAux = new ActaInfraccion();
		actaInfraccionAux.setActuacion(actaInfraccion.getActuacion());
		actaInfraccionAux.setTipReqNormativo(actaInfraccion
				.getTipReqNormativo());

		List<ActaInfraccionBusqueda> listActaInfraccionBusqueda = this.actaInfraccionDao
				.findAllConstatacion(actaInfraccionAux, null);
		if (listActaInfraccionBusqueda.size() > 0) {
			throw new Y41aUDAException(
					"error.actaInfraccion.DuplicateInfraccionException", true,
					new Exception());
		} else {
			actaInfraccion.setAicodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));
			actaInfraccion.setAiinexii(Y41aConstantes.VALOR_SI);
			return this.actaInfraccionDao.add(actaInfraccion);
		}
	}

	/**
	 * Updates a single row in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaInfraccion update(ActaInfraccion actaInfraccion) {
		return this.actaInfraccionDao.update(actaInfraccion);
	}

	/**
	 * Updates a single row in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaInfraccion updateConstatacion(ActaInfraccion actaInfraccion) {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(actaInfraccion.getActuacion().getAtcodigo());

		ActaActuacionAlta actaActuacionAlta = this.actuacionDao
				.findActuacion(actuacion);

		if (Y41aUtils.isFilled(actaActuacionAlta.getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS4codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.campahna.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.alerta.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.denuncia.CerradaException",
						true, new Exception());
			}
		}
		return this.actaInfraccionDao.updateConstatacion(actaInfraccion);
	}

	/**
	 * Updates a single row in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateConstatacionMultiple(
			ArrayList<ActaInfraccion> actaInfraccionList) {
		for (ActaInfraccion actaInfraccionAux : actaInfraccionList) {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(actaInfraccionAux.getActuacion()
					.getAtcodigo());

			ActaActuacionAlta actaActuacionAlta = this.actuacionDao
					.findActuacion(actuacion);

			if (Y41aUtils.isFilled(actaActuacionAlta.getS4codigo())) {
				CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
				campahnaRecibBusqueda.setCodOrganismo(actaActuacionAlta
						.getAccoor());
				campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
				campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
						.getS4codigo());

				campahnaRecibBusqueda = this.campahnaRecibDao
						.findCampahnaRecib(campahnaRecibBusqueda);

				if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
					throw new Y41aUDAException(
							"error.campahna.CerradaException", true,
							new Exception());
				}
			} else if (Y41aUtils.isFilled(actaActuacionAlta.getS5codigo())) {
				CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
				campahnaRecibBusqueda.setCodOrganismo(actaActuacionAlta
						.getAccoor());
				campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
				campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
						.getS5codigo());

				campahnaRecibBusqueda = this.campahnaRecibDao
						.findCampahnaRecib(campahnaRecibBusqueda);

				if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
					throw new Y41aUDAException("error.alerta.CerradaException",
							true, new Exception());
				}
			} else if (Y41aUtils.isFilled(actaActuacionAlta.getS6codigo())) {
				CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
				campahnaRecibBusqueda.setCodOrganismo(actaActuacionAlta
						.getAccoor());
				campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
				campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
						.getS6codigo());

				campahnaRecibBusqueda = this.campahnaRecibDao
						.findCampahnaRecib(campahnaRecibBusqueda);

				if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
					throw new Y41aUDAException(
							"error.denuncia.CerradaException", true,
							new Exception());
				}
			}
			this.actaInfraccionDao.updateConstatacion(actaInfraccionAux);
		}
	}

	/**
	 * Finds a single row in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	public ActaInfraccion find(ActaInfraccion actaInfraccion) {
		return (ActaInfraccion) this.actaInfraccionDao.find(actaInfraccion);
	}

	/**
	 * Finds a List of rows in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ActaInfraccion> findAll(ActaInfraccion actaInfraccion,
			Pagination pagination) {
		return (List<ActaInfraccion>) this.actaInfraccionDao.findAll(
				actaInfraccion, pagination);
	}

	/**
	 * Finds a List of rows in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ActaInfraccionBusqueda> findAllConstatacion(
			ActaInfraccion actaInfraccion, Pagination pagination) {

		return (List<ActaInfraccionBusqueda>) this.actaInfraccionDao
				.findAllConstatacion(actaInfraccion, pagination);
	}

	/**
	 * Counts rows in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return Long
	 */
	public Long findAllCount(ActaInfraccion actaInfraccion) {
		return this.actaInfraccionDao.findAllCount(actaInfraccion);
	}

	/**
	 * Finds rows in the ActaInfraccion table using like.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ActaInfraccion> findAllLike(ActaInfraccion actaInfraccion,
			Pagination pagination, Boolean startsWith) {
		return (List<ActaInfraccion>) this.actaInfraccionDao.findAllLike(
				actaInfraccion, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ActaInfraccion actaInfraccion) {
		this.actaInfraccionDao.remove(actaInfraccion);
	}

	/**
	 * Deletes a single row in the ActaInfraccion table.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeActaInfraccion(ActaInfraccion actaInfraccion) {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(actaInfraccion.getActuacion().getAtcodigo());

		ActaActuacionAlta actaActuacionAlta = this.actuacionDao
				.findActuacion(actuacion);

		if (Y41aUtils.isFilled(actaActuacionAlta.getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS4codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.campahna.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.alerta.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actaActuacionAlta.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda
					.setCodOrganismo(actaActuacionAlta.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
					.getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.denuncia.CerradaException",
						true, new Exception());
			}
		}

		this.actaInfraccionDao.remove(actaInfraccion);
	}

	/**
	 * Deletes multiple rows in the ActaInfraccion table.
	 * 
	 * @param actaInfraccionList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<ActaInfraccion> actaInfraccionList) {
		for (ActaInfraccion actaInfraccionAux : actaInfraccionList) {
			this.actaInfraccionDao.remove(actaInfraccionAux);
		}
	}

	/**
	 * Getter method for ActaInfraccionDao
	 * 
	 * @return ActaInfraccionDao
	 */
	public ActaInfraccionDao getActaInfraccionDao() {
		return this.actaInfraccionDao;
	}

	/**
	 * Setter method for ActaInfraccionDao.
	 * 
	 * @param actaInfraccionDao
	 *            ActaInfraccionDao
	 * @return
	 */
	public void setActaInfraccionDao(ActaInfraccionDao actaInfraccionDao) {
		logger.info("Setting Dependency " + actaInfraccionDao);
		this.actaInfraccionDao = actaInfraccionDao;
	}
}
