package com.ejie.y41a.service;

import java.io.IOException;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ActaFileDao;
import com.ejie.y41a.dao.ActuacionDao;
import com.ejie.y41a.dao.CampahnaRecibDao;
import com.ejie.y41a.dao.PlantillaInsDao;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.ActaFile;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.CampahnaRecibBusqueda;
import com.ejie.y41a.model.Inspecciones;
import com.ejie.y41a.model.PlantillaCartaInspeccionDetalle;
import com.ejie.y41a.model.PlantillaIns;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.config.Y41aConfig;
import com.ejie.y41a.utils.documentos.Y41aGenerarDocumento;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * ActaFileServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "actaFileService")
public class ActaFileServiceImpl implements ActaFileService {

	private static final Logger logger = LoggerFactory
			.getLogger(ActaFileServiceImpl.class);
	@Autowired
	private ActaFileDao actaFileDao;
	@Autowired
	private PlantillaInsDao plantillaInsDao;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private CampahnaRecibDao campahnaRecibDao;

	/**
	 * Inserts a single row in the ActaFile table.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @return ActaFile
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaFile add(ActaFile actaFile) {
		return this.actaFileDao.add(actaFile);
	}

	/**
	 * Inserts a single row in the ActaFile table.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @return ActaFile
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaFile addActaFile(ActaFile actaFile) {
		Actuacion actuacion = new Actuacion();
		Acta acta = new Acta();
		acta.setAccodigo(actaFile.getActa().getAccodigo());
		actuacion.setActa(acta);

		List<Actuacion> listActuacion = this.actuacionDao.findAll(actuacion,
				null);

		if (listActuacion != null && listActuacion.size() > 0) {
			actuacion = listActuacion.get(0);
		}
		if (Y41aUtils.isFilled(actuacion.getCampahnaRecib().getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(actuacion.getActa()
					.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacion
					.getCampahnaRecib().getS4codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.campahna.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actuacion.getAlertaRecib().getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(actuacion.getActa()
					.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacion.getAlertaRecib()
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.alerta.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actuacion.getDenunciaRecib()
				.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(actuacion.getActa()
					.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacion
					.getDenunciaRecib().getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.denuncia.CerradaException",
						true, new Exception());
			}
		}

		actaFile.setS3codocumento(Y41aUIDGenerator.getInstance().generateId(
				Y41aConstantes.PK_SIZE));
		return this.actaFileDao.add(actaFile);
	}

	/**
	 * Inserts a single row in the ActaFile table.
	 * 
	 * @param plantillaCartaInspeccion
	 *            PlantillaCartaInspeccionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarCartasInspecciones(
			PlantillaCartaInspeccionDetalle plantillaCartaInspeccionDetalle) {

		try {
			// Obtener la plantilla de inspecciones
			Inspecciones inspecciones = new Inspecciones();
			inspecciones.setInscodcarta(plantillaCartaInspeccionDetalle
					.getInscodcarta());
			PlantillaIns plantillaIns = new PlantillaIns();
			plantillaIns.setInspecciones(inspecciones);
			plantillaIns.setPlinscoor(plantillaCartaInspeccionDetalle
					.getCodOrg());

			// Obtener la plantilla del tramite
			plantillaIns = this.plantillaInsDao.findPlantillaIns(plantillaIns);

			if (plantillaIns.getPlinsplantilla() != null) {

				// Obtener los datos de la inspeccion (los datos a incluir en
				// las
				// cartas)
				plantillaCartaInspeccionDetalle = this.actuacionDao
						.findPlantillaCartaInspeccion(plantillaCartaInspeccionDetalle);

				plantillaCartaInspeccionDetalle = this
						.completeInfoPlantillaCartaInspeccionDetalle(plantillaCartaInspeccionDetalle);

				String s3nomfile = null;
				Integer s3sizefile = null;
				String s3desfile = null;
				String s3contenttype = null;
				Blob s3datafile = null;

				s3nomfile = plantillaIns.getPlinsnofile();
				s3sizefile = plantillaIns.getPlinssizefile();
				s3desfile = plantillaIns.getPlinsnombre();
				s3contenttype = plantillaIns.getPlinscontenttypefile();

				// Transformar el documento en castellano
				String plantilla = Y41aUtils.blobToString(plantillaIns
						.getPlinsplantilla());

				Properties prop = Y41aConfig
						.loadProperties(Y41aConstantes.CONFIG_PATH);

				StringBuffer rutaPlantilla = new StringBuffer(
						prop.getProperty("y41aVistaWar.rutaxml.plantillas.word"));

				rutaPlantilla
						.append(Y41aConstantes.NOMBRE_PLANTILLA_XML_INSPECCIONES_CASTELLANO);

				String ficheroGenerado = Y41aGenerarDocumento
						.generarDocumentoWord(rutaPlantilla.toString(),
								plantillaCartaInspeccionDetalle, plantilla);

				s3datafile = new SerialBlob(ficheroGenerado.getBytes());

				Acta acta = new Acta();
				acta.setAccodigo(plantillaCartaInspeccionDetalle.getAccodigo());

				ActaFile actaFile = new ActaFile(null, s3nomfile, s3datafile,
						s3sizefile, s3desfile, new Date(),
						Y41aConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION,
						s3contenttype, acta);

				// Dar de alta el documento
				this.addActaFile(actaFile);

			}

		} catch (SerialException e) {
			throw new Y41aUDAException("error.inspecciones.alta.carta", true, e);
		} catch (SQLException e) {
			throw new Y41aUDAException("error.inspecciones.alta.carta", true, e);
		} catch (IOException e) {
			throw new Y41aUDAException("error.inspecciones.alta.carta", true, e);
		}
	}

	/**
	 * Complete information of the object PlantillaCartaInspeccionDetalle.
	 * 
	 * @param plantillaCartaInspeccionDetalle
	 *            PlantillaCartaInspeccionDetalle
	 * @return PlantillaCartaInspeccionDetalle
	 */
	private PlantillaCartaInspeccionDetalle completeInfoPlantillaCartaInspeccionDetalle(
			PlantillaCartaInspeccionDetalle plantillaCartaInspeccionDetalle) {
		try {
			// Formateamos las fecha a castellano e euskera
			plantillaCartaInspeccionDetalle.setFechaActualTextoCas(Y41aUtils
					.formatearDateToString(new Date(),
							Y41aConstantes.FORMATO_FULL_FECHA_ES,
							Y41aConstantes.CASTELLANO));
			plantillaCartaInspeccionDetalle.setFechaActualTextoEus(Y41aUtils
					.formatearDateToStringEuskera(new Date(),
							Y41aConstantes.FORMATO_FULL_FECHA_EU,
							Y41aConstantes.EUSKERA));

			plantillaCartaInspeccionDetalle.setAcfeleCas(Y41aUtils
					.parseDateToString(
							plantillaCartaInspeccionDetalle.getAcfele(),
							Y41aConstantes.CASTELLANO));
			plantillaCartaInspeccionDetalle.setAcfeleEus(Y41aUtils
					.parseDateToString(
							plantillaCartaInspeccionDetalle.getAcfele(),
							Y41aConstantes.EUSKERA));

			// Creamos el campo numero de expediente
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente
					.append(plantillaCartaInspeccionDetalle.getAccoor())
					.append("-")
					.append(plantillaCartaInspeccionDetalle.getAcnror())
					.append("-")
					.append(plantillaCartaInspeccionDetalle.getAcnran())
					.append("-")
					.append(plantillaCartaInspeccionDetalle.getAtnror());

			plantillaCartaInspeccionDetalle.setNumExpediente(numeroExpediente
					.toString());

			// Creamos el campo direccion del establecimiento Visita
			StringBuffer direccionCompleta = new StringBuffer();

			if (plantillaCartaInspeccionDetalle.getCalleId_labelVisita() != null
					&& !plantillaCartaInspeccionDetalle
							.getCalleId_labelVisita().equals("")) {
				direccionCompleta.append(plantillaCartaInspeccionDetalle
						.getCalleId_labelVisita());

				if (plantillaCartaInspeccionDetalle.getEsnombrePortalVisita() != null
						&& !plantillaCartaInspeccionDetalle
								.getEsnombrePortalVisita().equals("")) {
					direccionCompleta.append(", ").append(
							plantillaCartaInspeccionDetalle
									.getEsnombrePortalVisita());
				}
				if (plantillaCartaInspeccionDetalle.getEsnombrePisoVisita() != null
						&& !plantillaCartaInspeccionDetalle
								.getEsnombrePisoVisita().equals("")) {
					direccionCompleta.append(" ").append(
							plantillaCartaInspeccionDetalle
									.getEsnombrePisoVisita());
				}
			} else {
				if (plantillaCartaInspeccionDetalle
						.getEsdireccion_nocapvVisita() != null
						&& !plantillaCartaInspeccionDetalle
								.getEsdireccion_nocapvVisita().equals("")) {
					direccionCompleta.append(plantillaCartaInspeccionDetalle
							.getEsdireccion_nocapvVisita());
				} else {
					direccionCompleta.append(plantillaCartaInspeccionDetalle
							.getEsnodirVisita());
				}
			}

			plantillaCartaInspeccionDetalle
					.setEsdireccionVisita(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del establecimiento
			// Visita
			StringBuffer cpMunicipio = new StringBuffer();

			if (plantillaCartaInspeccionDetalle.getEsnombreCpVisita() != null
					&& !plantillaCartaInspeccionDetalle.getEsnombreCpVisita()
							.equals("")) {
				cpMunicipio.append(plantillaCartaInspeccionDetalle
						.getEsnombreCpVisita());

				if (plantillaCartaInspeccionDetalle
						.getEsnombreMunicipioVisita() != null
						&& !plantillaCartaInspeccionDetalle
								.getEsnombreMunicipioVisita().equals("")) {
					cpMunicipio.append(" ").append(
							plantillaCartaInspeccionDetalle
									.getEsnombreMunicipioVisita());
				}
			} else if (plantillaCartaInspeccionDetalle
					.getEsnombreMunicipioVisita() != null
					&& !plantillaCartaInspeccionDetalle
							.getEsnombreMunicipioVisita().equals("")) {
				cpMunicipio.append(plantillaCartaInspeccionDetalle
						.getEsnombreMunicipioVisita());
			}

			plantillaCartaInspeccionDetalle.setEscpMunicipioVisita(cpMunicipio
					.toString());

			// Creamos el campo direccion del establecimiento Actuacion
			direccionCompleta = new StringBuffer();

			if (plantillaCartaInspeccionDetalle.getCalleId_labelActuacion() != null
					&& !plantillaCartaInspeccionDetalle
							.getCalleId_labelActuacion().equals("")) {
				direccionCompleta.append(plantillaCartaInspeccionDetalle
						.getCalleId_labelActuacion());

				if (plantillaCartaInspeccionDetalle
						.getEsnombrePortalActuacion() != null
						&& !plantillaCartaInspeccionDetalle
								.getEsnombrePortalActuacion().equals("")) {
					direccionCompleta.append(", ").append(
							plantillaCartaInspeccionDetalle
									.getEsnombrePortalActuacion());
				}

				if (plantillaCartaInspeccionDetalle.getEsnombrePisoActuacion() != null
						&& !plantillaCartaInspeccionDetalle
								.getEsnombrePisoActuacion().equals("")) {
					direccionCompleta.append(" ").append(
							plantillaCartaInspeccionDetalle
									.getEsnombrePisoActuacion());
				}
			} else {
				if (plantillaCartaInspeccionDetalle
						.getEsdireccion_nocapvActuacion() != null
						&& !plantillaCartaInspeccionDetalle
								.getEsdireccion_nocapvActuacion().equals("")) {
					direccionCompleta.append(plantillaCartaInspeccionDetalle
							.getEsdireccion_nocapvActuacion());
				} else {
					direccionCompleta.append(plantillaCartaInspeccionDetalle
							.getEsnodirActuacion());
				}
			}

			plantillaCartaInspeccionDetalle
					.setEsdireccionActuacion(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del establecimiento
			// Actuacion
			cpMunicipio = new StringBuffer();

			if (plantillaCartaInspeccionDetalle.getEsnombreCpActuacion() != null
					&& !plantillaCartaInspeccionDetalle
							.getEsnombreCpActuacion().equals("")) {
				cpMunicipio.append(plantillaCartaInspeccionDetalle
						.getEsnombreCpActuacion());

				if (plantillaCartaInspeccionDetalle
						.getEsnombreMunicipioActuacion() != null
						&& !plantillaCartaInspeccionDetalle
								.getEsnombreMunicipioActuacion().equals("")) {
					cpMunicipio.append(" ").append(
							plantillaCartaInspeccionDetalle
									.getEsnombreMunicipioActuacion());
				}
			} else if (plantillaCartaInspeccionDetalle
					.getEsnombreMunicipioActuacion() != null
					&& !plantillaCartaInspeccionDetalle
							.getEsnombreMunicipioActuacion().equals("")) {
				cpMunicipio.append(plantillaCartaInspeccionDetalle
						.getEsnombreMunicipioActuacion());
			}

			plantillaCartaInspeccionDetalle
					.setEscpMunicipioActuacion(cpMunicipio.toString());

			// Creamos el campo direccion del organismo conectado
			direccionCompleta = new StringBuffer();

			if (plantillaCartaInspeccionDetalle.getNombreCalle() != null
					&& !plantillaCartaInspeccionDetalle.getNombreCalle()
							.equals("")) {
				direccionCompleta.append(plantillaCartaInspeccionDetalle
						.getNombreCalle());

				if (plantillaCartaInspeccionDetalle.getNombrePortal() != null
						&& !plantillaCartaInspeccionDetalle.getNombrePortal()
								.equals("")) {
					direccionCompleta.append(", ").append(
							plantillaCartaInspeccionDetalle.getNombrePortal());
				}
			}

			plantillaCartaInspeccionDetalle
					.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			cpMunicipio = new StringBuffer();

			if (plantillaCartaInspeccionDetalle.getNombreCp() != null
					&& !plantillaCartaInspeccionDetalle.getNombreCp()
							.equals("")) {
				cpMunicipio.append(plantillaCartaInspeccionDetalle
						.getNombreCp());

				if (plantillaCartaInspeccionDetalle.getNombreMunicipio() != null
						&& !plantillaCartaInspeccionDetalle
								.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(
							plantillaCartaInspeccionDetalle
									.getNombreMunicipio());
				}
			} else if (plantillaCartaInspeccionDetalle.getNombreMunicipio() != null
					&& !plantillaCartaInspeccionDetalle.getNombreMunicipio()
							.equals("")) {
				cpMunicipio.append(plantillaCartaInspeccionDetalle
						.getNombreMunicipio());
			}

			plantillaCartaInspeccionDetalle.setCpMunicipioOrganismo(cpMunicipio
					.toString());

			return plantillaCartaInspeccionDetalle;

		} catch (ParseException e) {
			throw new Y41aUDAException("error.inspecciones.alta.carta", true, e);
		}
	}

	/**
	 * Updates a single row in the ActaFile table.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @return ActaFile
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaFile update(ActaFile actaFile) {
		return this.actaFileDao.update(actaFile);
	}

	/**
	 * Finds a single row in the ActaFile table.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @return ActaFile
	 */
	public ActaFile find(ActaFile actaFile) {
		actaFile = this.actaFileDao.find(actaFile);

		return actaFile;
	}

	/**
	 * Finds a List of rows in the ActaFile table.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ActaFile> findAll(ActaFile actaFile, Pagination pagination) {
		return (List<ActaFile>) this.actaFileDao.findAll(actaFile, pagination);
	}

	/**
	 * Counts rows in the ActaFile table.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @return Long
	 */
	public Long findAllCount(ActaFile actaFile) {
		return this.actaFileDao.findAllCount(actaFile);
	}

	/**
	 * Finds rows in the ActaFile table using like.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ActaFile> findAllLike(ActaFile actaFile, Pagination pagination,
			Boolean startsWith) {
		return (List<ActaFile>) this.actaFileDao.findAllLike(actaFile,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the ActaFile table.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ActaFile actaFile) {
		Actuacion actuacion = new Actuacion();
		Acta acta = new Acta();
		acta.setAccodigo(actaFile.getActa().getAccodigo());
		actuacion.setActa(acta);

		List<Actuacion> listActuacion = this.actuacionDao.findAll(actuacion,
				null);

		if (listActuacion != null && listActuacion.size() > 0) {
			actuacion = listActuacion.get(0);
		}
		if (Y41aUtils.isFilled(actuacion.getCampahnaRecib().getS4codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(actuacion.getActa()
					.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacion
					.getCampahnaRecib().getS4codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.campahna.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actuacion.getAlertaRecib().getS5codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(actuacion.getActa()
					.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacion.getAlertaRecib()
					.getS5codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.alerta.CerradaException",
						true, new Exception());
			}
		} else if (Y41aUtils.isFilled(actuacion.getDenunciaRecib()
				.getS6codigo())) {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodOrganismo(actuacion.getActa()
					.getAccoor());
			campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
			campahnaRecibBusqueda.setCodigoRecibida(actuacion
					.getDenunciaRecib().getS6codigo());

			campahnaRecibBusqueda = this.campahnaRecibDao
					.findCampahnaRecib(campahnaRecibBusqueda);

			if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
				throw new Y41aUDAException("error.denuncia.CerradaException",
						true, new Exception());
			}
		}

		this.actaFileDao.remove(actaFile);
	}

	/**
	 * Deletes multiple rows in the ActaFile table.
	 * 
	 * @param actaFileList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<ActaFile> actaFileList) {
		for (ActaFile actaFileAux : actaFileList) {
			this.actaFileDao.remove(actaFileAux);
		}
	}

	/**
	 * Getter method for ActaFileDao
	 * 
	 * @return ActaFileDao
	 */
	public ActaFileDao getActaFileDao() {
		return this.actaFileDao;
	}

	/**
	 * Setter method for ActaFileDao.
	 * 
	 * @param actaFileDao
	 *            ActaFileDao
	 * @return
	 */
	public void setActaFileDao(ActaFileDao actaFileDao) {
		logger.info("Setting Dependency " + actaFileDao);
		this.actaFileDao = actaFileDao;
	}
}
