package com.ejie.y41a.security;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.web.filter.GenericFilterBean;

import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.service.CensoMonitorService;

/**
 * * Filtro que se ejecuta despues de que un usuario se autentique con Spring
 * Security
 * 
 *  
 */

public class PostAuthenticateProcessingFilter extends GenericFilterBean {

	@Autowired
	private CensoMonitorService censoMonitorService;

	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {

		if (request instanceof HttpServletRequest) {
			HttpServletRequest httpRequest = (HttpServletRequest) request;

			HttpSession httpSession = httpRequest.getSession(false);

			Authentication authentication = SecurityContextHolder.getContext()
					.getAuthentication();

			if (null != authentication) {
				if (authentication.getPrincipal() instanceof User) {
					try {
						User user = (User) authentication.getPrincipal();
						String username = (String) user.getUsername();

						CensoMonitor censoMonitor = new CensoMonitor();
						censoMonitor.setMousu(username);

						censoMonitor = censoMonitorService
								.findCensoMonitorUser(censoMonitor);
						httpSession.setAttribute(
								Y41aConstantes.SESSIONCENSOMONITORCONNECTED,
								censoMonitor);
					} catch (EmptyResultDataAccessException e) {
					}
				}
			}
		}

		chain.doFilter(request, response);

		// Pantalla nueva de fichas y plantillas
		this.cargaDeDatos(request);

	}

	/**
	 * Precarga de los datos en las tablas que puedan faltar para el organismo
	 * al que pertenece el usuario conectado.
	 */
	private void cargaDeDatos(ServletRequest servletRequest) {
		if (servletRequest instanceof HttpServletRequest) {
			HttpServletRequest httpRequest = (HttpServletRequest) servletRequest;

			HttpSession httpSession = httpRequest.getSession(false);
			if (httpSession
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED) != null) {
				CensoMonitor censoMonitor = (CensoMonitor) httpSession
						.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);
				this.censoMonitorService
						.inicializarPlantillasFichas(censoMonitor);
			}

		}
	}
}
